/*
 * Decompiled with CFR 0.152.
 */
package weblogic.servlet.jsp;

import java.util.Enumeration;
import weblogic.utils.classloaders.ChangeAwareClassLoader;
import weblogic.utils.classloaders.ClassFinder;
import weblogic.utils.enumerations.EmptyEnumerator;

public class TagFileClassLoader
extends ChangeAwareClassLoader {
    private static final boolean debug = false;
    private final long creationTime = this.getLastChecked();

    public TagFileClassLoader(ClassFinder classFinder, ClassLoader classLoader) {
        super(classFinder, false, classLoader);
    }

    public Class loadClass(String string) throws ClassNotFoundException {
        return this.findClass(string);
    }

    public Class findClass(String string) throws ClassNotFoundException {
        if (this.isTagFileClass(string)) {
            return super.findClass(string);
        }
        return this.getParent().loadClass(string);
    }

    public Enumeration findResources(String string) {
        return new EmptyEnumerator();
    }

    public final long getCreationTime() {
        return this.creationTime;
    }

    private boolean isTagFileClass(String string) {
        return string.indexOf("_tags") > 0 && (string.endsWith("_tag") || string.indexOf("_tag$") > 0);
    }
}

