/*
 * Decompiled with CFR 0.152.
 */
package weblogic.servlet.jsp;

import weblogic.servlet.internal.WebAppServletContext;
import weblogic.servlet.jsp.TagFileClassLoader;
import weblogic.utils.classloaders.ClassFinder;
import weblogic.utils.classloaders.ClasspathClassFinder2;

public class TagFileHelper {
    private static final boolean debug = false;
    private WebAppServletContext context;
    private TagFileClassLoader tagFileClassLoader;
    private long creationTime;
    private String jspWorkingDir;

    public TagFileHelper(WebAppServletContext webAppServletContext) {
        this.context = webAppServletContext;
    }

    public void initClassLoader(ClassFinder classFinder, ClassLoader classLoader) {
        this.initClassLoader(classFinder, classLoader, false);
    }

    private void initClassLoader(ClassFinder classFinder, ClassLoader classLoader, boolean bl) {
        this.tagFileClassLoader = new TagFileClassLoader(classFinder, classLoader);
        if (!bl) {
            this.addWorkingDirFinder(this.tagFileClassLoader);
        }
        this.creationTime = this.tagFileClassLoader.getCreationTime();
    }

    public TagFileClassLoader getTagFileClassLoader() {
        return this.tagFileClassLoader;
    }

    long getCLCreationTime() {
        return this.creationTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void reloadIfNecessary(long l) {
        if (l < 0L) {
            return;
        }
        if (this.checkReloadTimeout(l)) {
            TagFileHelper tagFileHelper = this;
            synchronized (tagFileHelper) {
                if (this.checkReloadTimeout(l) && this.needToReloadCL()) {
                    this.reloadTagFileClassLoader();
                }
            }
        }
    }

    private boolean checkReloadTimeout(long l) {
        if (l < 0L) {
            return false;
        }
        long l2 = l * 1000L;
        return System.currentTimeMillis() - l2 > this.tagFileClassLoader.getLastChecked();
    }

    private boolean needToReloadCL() {
        return !this.tagFileClassLoader.upToDate();
    }

    private void reloadTagFileClassLoader() {
        ClassFinder classFinder = this.context.getWarInstance().getClassFinder();
        ClassLoader classLoader = this.context.getServletClassLoader();
        this.initClassLoader(classFinder, classLoader, false);
    }

    private void addWorkingDirFinder(TagFileClassLoader tagFileClassLoader) {
        if (this.jspWorkingDir == null) {
            this.jspWorkingDir = this.context.getJSPManager().getJSPWorkingDir();
        }
        tagFileClassLoader.addClassFinderFirst((ClassFinder)new ClasspathClassFinder2(this.jspWorkingDir));
    }

    public void close() {
        this.tagFileClassLoader = null;
    }
}

