/*
 * Decompiled with CFR 0.152.
 */
package weblogic.servlet.jsp.dd;

import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import weblogic.servlet.HTTPLogger;
import weblogic.servlet.jsp.dd.JspcLogErrHandler;
import weblogic.servlet.jsp.dd.StderrHandler;
import weblogic.servlet.jsp.dd.TLDDescriptor;
import weblogic.servlet.jsp.dd.TagDescriptor;
import weblogic.xml.dom.DOMProcessingException;
import weblogic.xml.dom.ResourceEntityResolver;
import weblogic.xml.jaxp.WebLogicDocumentBuilderFactory;

public final class JSPEntityResolver
extends ResourceEntityResolver
implements ErrorHandler {
    public static final String TLD_PUBLIC_ID_11 = "-//Sun Microsystems, Inc.//DTD JSP Tag Library 1.1//EN";
    public static final String TLD_PUBLIC_ID_12 = "-//Sun Microsystems, Inc.//DTD JSP Tag Library 1.2//EN";
    public boolean is12;

    public JSPEntityResolver() {
        this.addEntityResource(TLD_PUBLIC_ID_12, "taglib-1_2.dtd", this.getClass());
        this.addEntityResource(TLD_PUBLIC_ID_11, "taglib.dtd", this.getClass());
    }

    public void warning(SAXParseException sAXParseException) throws SAXParseException {
    }

    public void error(SAXParseException sAXParseException) throws SAXParseException {
        HTTPLogger.logMalformedWebDescriptor((String)sAXParseException.toString(), (Throwable)sAXParseException);
    }

    public void fatalError(SAXParseException sAXParseException) throws SAXParseException {
        HTTPLogger.logMalformedWebDescriptor((String)sAXParseException.toString(), (Throwable)sAXParseException);
        throw sAXParseException;
    }

    public InputSource resolveEntity(String string, String string2) throws SAXException, IOException {
        if (string == null) {
            return null;
        }
        if (string.equals(TLD_PUBLIC_ID_12)) {
            this.is12 = true;
        } else if (!string.equals(TLD_PUBLIC_ID_11)) {
            throw new IOException("Invalid DTD for taglib: cannot resolve '" + string + "'");
        }
        return super.resolveEntity(string, string2);
    }

    public static TLDDescriptor load(Reader reader, ErrorHandler errorHandler) throws IOException, ParserConfigurationException, SAXException, DOMProcessingException {
        WebLogicDocumentBuilderFactory webLogicDocumentBuilderFactory = new WebLogicDocumentBuilderFactory();
        ((DocumentBuilderFactory)webLogicDocumentBuilderFactory).setValidating(true);
        DocumentBuilder documentBuilder = ((DocumentBuilderFactory)webLogicDocumentBuilderFactory).newDocumentBuilder();
        JSPEntityResolver jSPEntityResolver = new JSPEntityResolver();
        documentBuilder.setEntityResolver(jSPEntityResolver);
        if (errorHandler == null) {
            errorHandler = jSPEntityResolver;
        }
        documentBuilder.setErrorHandler(errorHandler);
        InputSource inputSource = new InputSource(reader);
        Document document = documentBuilder.parse(inputSource);
        TLDDescriptor tLDDescriptor = new TLDDescriptor(document);
        return tLDDescriptor;
    }

    public static TLDDescriptor load(Reader reader) throws IOException, ParserConfigurationException, SAXException, DOMProcessingException {
        return JSPEntityResolver.load(reader, null);
    }

    public static TLDDescriptor load(Reader reader, String string, String string2) throws IOException, ParserConfigurationException, SAXException, DOMProcessingException {
        JspcLogErrHandler jspcLogErrHandler = new JspcLogErrHandler(string, string2);
        return JSPEntityResolver.load(reader, jspcLogErrHandler);
    }

    public static void main(String[] stringArray) throws Exception {
        TLDDescriptor tLDDescriptor = JSPEntityResolver.load(new FileReader(stringArray[0]), new StderrHandler());
        TagDescriptor[] tagDescriptorArray = (TagDescriptor[])tLDDescriptor.getTags();
        System.err.println("contains " + tagDescriptorArray.length + " tags:");
        for (int i = 0; i < tagDescriptorArray.length; ++i) {
            System.err.println(" " + tagDescriptorArray[i]);
        }
    }
}

