/*
 * Decompiled with CFR 0.152.
 */
package weblogic.servlet.jsp.dd;

import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import weblogic.management.descriptors.webapp.ListenerMBean;
import weblogic.management.descriptors.webapp.TLDMBean;
import weblogic.management.descriptors.webapp.TagMBean;
import weblogic.management.descriptors.webapp.UIMBean;
import weblogic.management.descriptors.webapp.ValidatorMBean;
import weblogic.servlet.internal.dd.BaseServletDescriptor;
import weblogic.servlet.internal.dd.ListenerDescriptor;
import weblogic.servlet.internal.dd.ToXML;
import weblogic.servlet.jsp.dd.TagDescriptor;
import weblogic.servlet.jsp.dd.ValidatorDescriptor;
import weblogic.utils.io.XMLWriter;
import weblogic.xml.dom.DOMProcessingException;
import weblogic.xml.dom.DOMUtils;

public final class TLDDescriptor
extends BaseServletDescriptor
implements ToXML,
TLDMBean,
UIMBean {
    static final long serialVersionUID = 8049213100848306898L;
    private String taglibVersion;
    private String jspVersion;
    private String shortName;
    private String uri;
    private String displayName;
    private String smallIcon;
    private String largeIcon;
    private String description;
    private ValidatorDescriptor validator;
    private ListenerMBean[] listeners;
    private TagMBean[] tags;
    private boolean _12;
    private static final String ID_11 = "<!DOCTYPE taglib PUBLIC \"-//Sun Microsystems, Inc.//DTD JSP Tag Library 1.1//EN\"\n\"http://java.sun.com/j2ee/dtds/web-jsptaglibrary_1_1.dtd\">\n";
    private static final String ID_12 = "<!DOCTYPE taglib PUBLIC \"-//Sun Microsystems, Inc.//DTD JSP Tag Library 1.2//EN\"\n\"http://java.sun.com/dtd/web-jsptaglibrary_1_2.dtd\">\n";
    static final String CDATA_BEGIN = "<![CDATA[";
    static final String CDATA_END = "]]>";

    static void p(String string) {
        System.err.println("[TLDDescriptor]: " + string);
    }

    private String getTlibVersionName() {
        return this.is12() ? "tlib-version" : "tlibversion";
    }

    private String getJspVersionName() {
        return this.is12() ? "jsp-version" : "jspversion";
    }

    private String getShortNameName() {
        return this.is12() ? "short-name" : "shortname";
    }

    public TLDDescriptor() {
        this._12 = true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public TLDDescriptor(Document document) throws DOMProcessingException {
        Object object;
        if (document.getDoctype() != null) {
            object = document.getDoctype().getPublicId();
            if ("-//Sun Microsystems, Inc.//DTD JSP Tag Library 1.2//EN".equals(object)) {
                this._12 = true;
            } else {
                if (!"-//Sun Microsystems, Inc.//DTD JSP Tag Library 1.1//EN".equals(object)) throw new DOMProcessingException("Invalid DTD for taglib: cannot resolve '" + (String)object + "'");
                this._12 = false;
            }
        } else {
            this._12 = true;
        }
        object = null;
        Element element = document.getDocumentElement();
        object = DOMUtils.getOptionalElementByTagName(element, this.getTlibVersionName());
        this.taglibVersion = object != null ? DOMUtils.getTextData((Node)object) : "1.0";
        object = DOMUtils.getOptionalElementByTagName(element, this.getJspVersionName());
        if (object != null) {
            this.jspVersion = DOMUtils.getTextData((Node)object);
        }
        this.shortName = (object = DOMUtils.getOptionalElementByTagName(element, this.getShortNameName())) != null ? DOMUtils.getTextData((Node)object) : "";
        object = DOMUtils.getOptionalElementByTagName(element, "uri");
        if (object != null) {
            this.uri = DOMUtils.getTextData((Node)object);
        }
        if ((object = DOMUtils.getOptionalElementByTagName(element, "display-name")) != null) {
            this.displayName = DOMUtils.getTextData((Node)object);
        }
        if ((object = DOMUtils.getOptionalElementByTagName(element, "small-icon")) != null) {
            this.smallIcon = DOMUtils.getTextData((Node)object);
        }
        if ((object = DOMUtils.getOptionalElementByTagName(element, "large-icon")) != null) {
            this.largeIcon = DOMUtils.getTextData((Node)object);
        }
        if ((object = DOMUtils.getOptionalElementByTagName(element, "description")) != null) {
            this.description = DOMUtils.getTextData((Node)object);
        }
        List list = null;
        Iterator iterator = null;
        ArrayList<BaseServletDescriptor> arrayList = new ArrayList<BaseServletDescriptor>();
        if (this.is12()) {
            object = DOMUtils.getOptionalElementByTagName(element, "validator");
            if (object != null) {
                this.validator = new ValidatorDescriptor((Element)object);
            }
            list = DOMUtils.getOptionalElementsByTagName(element, "listener");
            iterator = list.iterator();
            arrayList.clear();
            while (iterator.hasNext()) {
                ListenerDescriptor listenerDescriptor = new ListenerDescriptor((Element)iterator.next());
                arrayList.add(listenerDescriptor);
            }
            this.listeners = new ListenerMBean[arrayList.size()];
            arrayList.toArray(this.listeners);
        }
        list = DOMUtils.getOptionalElementsByTagName(element, "tag");
        iterator = list.iterator();
        arrayList.clear();
        while (iterator.hasNext()) {
            arrayList.add(new TagDescriptor((Element)iterator.next(), this.is12()));
        }
        this.tags = new TagMBean[arrayList.size()];
        arrayList.toArray(this.tags);
        this.set12(true);
    }

    public boolean is12() {
        return this._12;
    }

    public void set12(boolean bl) {
        if (this._12 == bl) {
            return;
        }
        this._12 = bl;
        TagMBean[] tagMBeanArray = this.getTags();
        for (int i = 0; tagMBeanArray != null && i < tagMBeanArray.length; ++i) {
            if (!(tagMBeanArray[i] instanceof TagDescriptor)) continue;
            TagDescriptor tagDescriptor = (TagDescriptor)tagMBeanArray[i];
            tagDescriptor.set12(this._12);
        }
    }

    public String getTaglibVersion() {
        return this.taglibVersion;
    }

    public void setTaglibVersion(String string) {
        String string2 = this.taglibVersion;
        this.taglibVersion = string;
        if (!TLDDescriptor.comp(string2, string)) {
            this.firePropertyChange("taglibVersion", string2, string);
        }
    }

    public String getJspVersion() {
        return this.jspVersion;
    }

    public void setJspVersion(String string) {
        String string2 = this.jspVersion;
        this.jspVersion = string;
        if (!TLDDescriptor.comp(string2, string)) {
            this.firePropertyChange("jspVersion", string2, string);
        }
    }

    public String getShortName() {
        return this.shortName;
    }

    public void setShortName(String string) {
        String string2 = this.shortName;
        this.shortName = string;
        if (!TLDDescriptor.comp(string2, string)) {
            this.firePropertyChange("shortName", string2, string);
        }
    }

    public String getURI() {
        return this.uri;
    }

    public void setURI(String string) {
        String string2 = this.uri;
        this.uri = string;
        if (!TLDDescriptor.comp(string2, string)) {
            this.firePropertyChange("uri", string2, string);
        }
    }

    public void setLargeIconFileName(String string) {
        this.setLargeIcon(string);
    }

    public String getLargeIconFileName() {
        return this.getLargeIcon();
    }

    public void setSmallIconFileName(String string) {
        this.setSmallIcon(string);
    }

    public String getSmallIconFileName() {
        return this.getSmallIcon();
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String string) {
        String string2 = this.displayName;
        this.displayName = string;
        if (!TLDDescriptor.comp(string2, string)) {
            this.firePropertyChange("displayName", string2, string);
        }
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String string) {
        String string2 = this.description;
        this.description = string;
        if (!TLDDescriptor.comp(string2, string)) {
            this.firePropertyChange("description", string2, string);
        }
    }

    public String getSmallIcon() {
        return this.smallIcon;
    }

    public void setSmallIcon(String string) {
        String string2 = this.smallIcon;
        this.smallIcon = string;
        if (!TLDDescriptor.comp(string2, string)) {
            this.firePropertyChange("smallIcon", string2, string);
        }
    }

    public String getLargeIcon() {
        return this.largeIcon;
    }

    public void setLargeIcon(String string) {
        String string2 = this.largeIcon;
        this.largeIcon = string;
        if (!TLDDescriptor.comp(string2, string)) {
            this.firePropertyChange("largeIcon", string2, string);
        }
    }

    public ValidatorMBean getValidator() {
        return this.validator;
    }

    public void setValidator(ValidatorMBean validatorMBean) {
        this.validator = (ValidatorDescriptor)validatorMBean;
    }

    public TagMBean[] getTags() {
        if (this.tags == null) {
            this.tags = new TagMBean[0];
        }
        return (TagMBean[])this.tags.clone();
    }

    public void setTags(TagMBean[] tagMBeanArray) {
        TagMBean[] tagMBeanArray2 = this.tags;
        if (tagMBeanArray == null) {
            return;
        }
        this.tags = (TagMBean[])tagMBeanArray.clone();
        if (!TLDDescriptor.comp(tagMBeanArray2, tagMBeanArray)) {
            this.firePropertyChange("tags", tagMBeanArray2, tagMBeanArray);
        }
    }

    public ListenerMBean[] getListeners() {
        if (this.listeners == null) {
            this.listeners = new ListenerMBean[0];
        }
        return (ListenerMBean[])this.listeners.clone();
    }

    public void setListeners(ListenerMBean[] listenerMBeanArray) {
        ListenerMBean[] listenerMBeanArray2 = this.listeners;
        if (listenerMBeanArray == null) {
            this.listeners = new ListenerMBean[0];
        }
        this.listeners = (ListenerMBean[])listenerMBeanArray.clone();
        if (!TLDDescriptor.comp(listenerMBeanArray2, listenerMBeanArray)) {
            this.firePropertyChange("listeners", listenerMBeanArray2, listenerMBeanArray);
        }
    }

    public void validate() {
        throw new Error("NYI");
    }

    private String getPreamble() {
        return this.is12() ? ID_12 : ID_11;
    }

    public void toXML(XMLWriter xMLWriter) {
        BaseServletDescriptor baseServletDescriptor;
        int n;
        Object object;
        xMLWriter.println(this.getPreamble());
        xMLWriter.println("<taglib>");
        xMLWriter.incrIndent();
        xMLWriter.println("<" + this.getTlibVersionName() + ">" + this.getTaglibVersion() + "</" + this.getTlibVersionName() + ">");
        if (this.jspVersion != null) {
            xMLWriter.println("<" + this.getJspVersionName() + ">" + this.getJspVersion() + "</" + this.getJspVersionName() + ">");
        }
        xMLWriter.println("<" + this.getShortNameName() + ">" + this.getShortName() + "</" + this.getShortNameName() + ">");
        if (this.getURI() != null) {
            xMLWriter.println("<uri>" + this.getURI() + "</uri>");
        }
        if (this.is12()) {
            if (this.getDisplayName() != null) {
                xMLWriter.println("<display-name>" + this.getDisplayName() + "</display-name>");
            }
            if (this.getSmallIcon() != null) {
                xMLWriter.println("<small-icon>" + this.getSmallIcon() + "</small-icon>");
            }
            if (this.getLargeIcon() != null) {
                xMLWriter.println("<large-icon>" + this.getLargeIcon() + "</large-icon>");
            }
            if (this.getDescription() != null) {
                xMLWriter.println("<description>" + TLDDescriptor.cdata(this.getDescription()) + "</description>");
            }
            if (this.getValidator() != null) {
                object = (ValidatorDescriptor)this.getValidator();
                ((ValidatorDescriptor)object).toXML(xMLWriter);
            }
            object = this.getListeners();
            for (n = 0; object != null && n < ((Object)object).length; ++n) {
                baseServletDescriptor = (ListenerDescriptor)object[n];
                baseServletDescriptor.toXML(xMLWriter);
            }
        } else if (this.getDescription() != null) {
            xMLWriter.println("<info>" + TLDDescriptor.cdata(this.getDescription()) + "</info>");
        }
        object = this.getTags();
        for (n = 0; object != null && n < ((TagMBean[])object).length; ++n) {
            baseServletDescriptor = (TagDescriptor)object[n];
            ((TagDescriptor)baseServletDescriptor).toXML(xMLWriter);
        }
        xMLWriter.decrIndent();
        xMLWriter.println("</taglib>");
    }

    public static String toXML(ToXML toXML, int n) {
        StringWriter stringWriter = new StringWriter();
        XMLWriter xMLWriter = new XMLWriter((Writer)stringWriter);
        toXML.toXML(xMLWriter);
        xMLWriter.flush();
        return stringWriter.toString();
    }

    public String toXML(int n) {
        return TLDDescriptor.toXML(this, n);
    }
}

