/*
 * Decompiled with CFR 0.152.
 */
package weblogic.servlet.jsp.dd;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.w3c.dom.Element;
import weblogic.management.descriptors.WebElementMBean;
import weblogic.management.descriptors.webapp.AttributeMBean;
import weblogic.management.descriptors.webapp.TagMBean;
import weblogic.management.descriptors.webapp.VariableMBean;
import weblogic.servlet.internal.dd.BaseServletDescriptor;
import weblogic.servlet.internal.dd.ToXML;
import weblogic.servlet.jsp.dd.AttributeDescriptor;
import weblogic.servlet.jsp.dd.TLDDescriptor;
import weblogic.servlet.jsp.dd.VariableDescriptor;
import weblogic.utils.io.XMLWriter;
import weblogic.xml.dom.DOMProcessingException;
import weblogic.xml.dom.DOMUtils;

public final class TagDescriptor
extends BaseServletDescriptor
implements TagMBean,
ToXML {
    private String name;
    private String classname;
    private String extraInfoClassname;
    private String bodyContent;
    private String description;
    AttributeMBean[] atts;
    VariableMBean[] vars;
    private boolean _12;

    private String getTEIDTDName() {
        return this.is12() ? "tei-class" : "teiclass";
    }

    private String getTagClassDTDName() {
        return this.is12() ? "tag-class" : "tagclass";
    }

    private String getBodyContentDTDName() {
        return this.is12() ? "body-content" : "bodycontent";
    }

    private String getDescriptionDTDName() {
        return this.is12() ? "description" : "info";
    }

    public TagDescriptor() {
        this._12 = true;
    }

    public TagDescriptor(Element element, boolean bl) throws DOMProcessingException {
        this._12 = bl;
        Element element2 = DOMUtils.getElementByTagName(element, "name");
        this.name = DOMUtils.getTextData(element2);
        element2 = DOMUtils.getElementByTagName(element, this.getTagClassDTDName());
        this.classname = DOMUtils.getTextData(element2);
        element2 = DOMUtils.getOptionalElementByTagName(element, this.getTEIDTDName());
        if (element2 != null) {
            this.extraInfoClassname = DOMUtils.getTextData(element2);
        }
        if ((element2 = DOMUtils.getOptionalElementByTagName(element, this.getBodyContentDTDName())) != null) {
            this.bodyContent = DOMUtils.getTextData(element2);
        }
        if ((element2 = DOMUtils.getOptionalElementByTagName(element, this.getDescriptionDTDName())) != null) {
            this.description = DOMUtils.getTextData(element2);
        }
        List list = DOMUtils.getOptionalElementsByTagName(element, "variable");
        ArrayList<BaseServletDescriptor> arrayList = new ArrayList<BaseServletDescriptor>();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            arrayList.add(new VariableDescriptor((Element)iterator.next()));
        }
        this.vars = new VariableMBean[arrayList.size()];
        arrayList.toArray(this.vars);
        list = DOMUtils.getOptionalElementsByTagName(element, "attribute");
        arrayList.clear();
        iterator = list.iterator();
        while (iterator.hasNext()) {
            arrayList.add(new AttributeDescriptor((Element)iterator.next(), this.is12()));
        }
        this.atts = new AttributeMBean[arrayList.size()];
        arrayList.toArray(this.atts);
    }

    public boolean is12() {
        return this._12;
    }

    public void set12(boolean bl) {
        this._12 = bl;
        AttributeMBean[] attributeMBeanArray = this.getAtts();
        for (int i = 0; attributeMBeanArray != null && i < attributeMBeanArray.length; ++i) {
            if (!(attributeMBeanArray[i] instanceof AttributeDescriptor)) continue;
            AttributeDescriptor attributeDescriptor = (AttributeDescriptor)attributeMBeanArray[i];
            attributeDescriptor.set12(this._12);
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        String string2 = this.name;
        this.name = string;
        if (!TagDescriptor.comp(string2, string)) {
            this.firePropertyChange("name", string2, string);
        }
    }

    public String getClassname() {
        return this.classname;
    }

    public void setClassname(String string) {
        String string2 = this.classname;
        this.classname = string;
        if (!TagDescriptor.comp(string2, string)) {
            this.firePropertyChange("classname", string2, string);
        }
    }

    public String getExtraInfoClassname() {
        return this.extraInfoClassname;
    }

    public void setExtraInfoClassname(String string) {
        String string2 = this.extraInfoClassname;
        this.extraInfoClassname = string;
        if (!TagDescriptor.comp(string2, string)) {
            this.firePropertyChange("extraInfoClassname", string2, string);
        }
    }

    public String getBodyContent() {
        return this.bodyContent;
    }

    public void setBodyContent(String string) {
        String string2 = this.bodyContent;
        this.bodyContent = string;
        if (!TagDescriptor.comp(string2, string)) {
            this.firePropertyChange("bodyContent", string2, string);
        }
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String string) {
        String string2 = this.description;
        this.description = string;
        if (!TagDescriptor.comp(string2, string)) {
            this.firePropertyChange("description", string2, string);
        }
    }

    public VariableMBean[] getVars() {
        if (this.vars == null) {
            this.vars = new VariableMBean[0];
        }
        return (VariableMBean[])this.vars.clone();
    }

    public void setVars(VariableMBean[] variableMBeanArray) {
        VariableMBean[] variableMBeanArray2 = this.vars;
        if (variableMBeanArray == null) {
            return;
        }
        this.vars = (VariableMBean[])variableMBeanArray.clone();
        if (!TagDescriptor.comp(variableMBeanArray2, variableMBeanArray)) {
            this.firePropertyChange("vars", variableMBeanArray2, variableMBeanArray);
        }
    }

    public AttributeMBean[] getAtts() {
        if (this.atts == null) {
            this.atts = new AttributeMBean[0];
        }
        return (AttributeMBean[])this.atts.clone();
    }

    public void setAtts(AttributeMBean[] attributeMBeanArray) {
        AttributeMBean[] attributeMBeanArray2 = this.atts;
        if (attributeMBeanArray == null) {
            return;
        }
        this.atts = (AttributeMBean[])attributeMBeanArray.clone();
        if (!TagDescriptor.comp(attributeMBeanArray2, attributeMBeanArray)) {
            this.firePropertyChange("atts", attributeMBeanArray2, attributeMBeanArray);
        }
    }

    public String toString() {
        return "[TagDesc: name=" + this.getName() + " classname=" + this.getClassname() + " TEI=" + this.getExtraInfoClassname() + " bc=" + this.getBodyContent() + " desc=" + this.getDescription() + " #vars=" + this.getVars().length + " #atts=" + this.getAtts().length + "]";
    }

    public void validate() {
        throw new Error("NYI");
    }

    public void toXML(XMLWriter xMLWriter) {
        BaseServletDescriptor baseServletDescriptor;
        int n;
        WebElementMBean[] webElementMBeanArray;
        this.set12(this.is12());
        xMLWriter.println("<tag>");
        xMLWriter.incrIndent();
        xMLWriter.println("<name>" + this.getName() + "</name>");
        xMLWriter.println("<" + this.getTagClassDTDName() + ">" + this.getClassname() + "</" + this.getTagClassDTDName() + ">");
        if (this.getExtraInfoClassname() != null) {
            xMLWriter.println("<" + this.getTEIDTDName() + ">" + this.getExtraInfoClassname() + "</" + this.getTEIDTDName() + ">");
        }
        if (this.getBodyContent() != null) {
            xMLWriter.println("<" + this.getBodyContentDTDName() + ">" + this.getBodyContent() + "</" + this.getBodyContentDTDName() + ">");
        }
        if (this.getDescription() != null) {
            xMLWriter.println("<" + this.getDescriptionDTDName() + ">" + TagDescriptor.cdata(this.getDescription()) + "</" + this.getDescriptionDTDName() + ">");
        }
        if (this.is12()) {
            webElementMBeanArray = this.getVars();
            for (n = 0; webElementMBeanArray != null && n < webElementMBeanArray.length; ++n) {
                baseServletDescriptor = (VariableDescriptor)webElementMBeanArray[n];
                ((VariableDescriptor)baseServletDescriptor).toXML(xMLWriter);
            }
        }
        webElementMBeanArray = this.getAtts();
        for (n = 0; webElementMBeanArray != null && n < webElementMBeanArray.length; ++n) {
            baseServletDescriptor = (AttributeDescriptor)webElementMBeanArray[n];
            ((AttributeDescriptor)baseServletDescriptor).toXML(xMLWriter);
        }
        xMLWriter.decrIndent();
        xMLWriter.println("</tag>");
    }

    public String toXML(int n) {
        return TLDDescriptor.toXML(this, n);
    }
}

