/*
 * Decompiled with CFR 0.152.
 */
package weblogic.servlet.jsp.dd;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.w3c.dom.Element;
import weblogic.management.descriptors.webapp.ParameterMBean;
import weblogic.management.descriptors.webapp.ValidatorMBean;
import weblogic.servlet.internal.dd.BaseServletDescriptor;
import weblogic.servlet.internal.dd.ParameterDescriptor;
import weblogic.servlet.internal.dd.ToXML;
import weblogic.servlet.jsp.dd.TLDDescriptor;
import weblogic.utils.io.XMLWriter;
import weblogic.xml.dom.DOMProcessingException;
import weblogic.xml.dom.DOMUtils;

public final class ValidatorDescriptor
extends BaseServletDescriptor
implements ValidatorMBean,
ToXML {
    private String classname;
    private ParameterMBean[] params;

    public ValidatorDescriptor() {
    }

    public ValidatorDescriptor(Element element) throws DOMProcessingException {
        Element element2 = DOMUtils.getElementByTagName(element, "validator-class");
        this.classname = DOMUtils.getTextData(element2);
        List list = DOMUtils.getOptionalElementsByTagName(element, "init-param");
        ArrayList<ParameterDescriptor> arrayList = new ArrayList<ParameterDescriptor>();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            arrayList.add(new ParameterDescriptor((Element)iterator.next()));
        }
        this.params = new ParameterMBean[arrayList.size()];
        arrayList.toArray(this.params);
    }

    public String getClassname() {
        return this.classname;
    }

    public void setClassname(String string) {
        String string2 = this.classname;
        this.classname = string;
        if (!ValidatorDescriptor.comp(string2, string)) {
            this.firePropertyChange("classname", string2, string);
        }
    }

    public ParameterMBean[] getParams() {
        if (this.params == null) {
            this.params = new ParameterMBean[0];
        }
        return (ParameterMBean[])this.params.clone();
    }

    public void setParams(ParameterMBean[] parameterMBeanArray) {
        ParameterMBean[] parameterMBeanArray2 = this.params;
        if (parameterMBeanArray == null) {
            return;
        }
        this.params = (ParameterMBean[])parameterMBeanArray.clone();
        if (!ValidatorDescriptor.comp(parameterMBeanArray2, parameterMBeanArray)) {
            this.firePropertyChange("params", parameterMBeanArray2, parameterMBeanArray);
        }
    }

    public void validate() {
        throw new Error("NYI");
    }

    public void toXML(XMLWriter xMLWriter) {
        if (this.getClassname() == null || this.getClassname().trim().length() == 0) {
            return;
        }
        xMLWriter.println("<validator>");
        xMLWriter.incrIndent();
        xMLWriter.println("<validator-class>" + this.getClassname().trim() + "</validator-class>");
        ParameterMBean[] parameterMBeanArray = this.getParams();
        for (int i = 0; parameterMBeanArray != null && i < parameterMBeanArray.length; ++i) {
            ParameterDescriptor parameterDescriptor = (ParameterDescriptor)parameterMBeanArray[i];
            xMLWriter.println("<init-param>");
            xMLWriter.incrIndent();
            String string = parameterDescriptor.getParamName();
            String string2 = parameterDescriptor.getParamValue();
            String string3 = parameterDescriptor.getDescription();
            xMLWriter.println("<param-name>" + string + "</param-name>");
            xMLWriter.println("<param-value>" + string2 + "</param-value>");
            if (string3 != null && (string3 = string3.trim()).length() > 0) {
                string3 = ValidatorDescriptor.cdata(string3);
                xMLWriter.println("<description>" + string3 + "</description>");
            }
            xMLWriter.decrIndent();
            xMLWriter.println("</init-param>");
        }
        xMLWriter.decrIndent();
        xMLWriter.println("</validator>");
    }

    public String toXML(int n) {
        return TLDDescriptor.toXML(this, n);
    }
}

