/*
 * Decompiled with CFR 0.152.
 */
package weblogic.servlet.jsp.dd;

import org.w3c.dom.Element;
import weblogic.management.descriptors.webapp.VariableMBean;
import weblogic.servlet.internal.dd.BaseServletDescriptor;
import weblogic.servlet.internal.dd.ToXML;
import weblogic.servlet.jsp.dd.TLDDescriptor;
import weblogic.utils.io.XMLWriter;
import weblogic.xml.dom.DOMProcessingException;
import weblogic.xml.dom.DOMUtils;

public final class VariableDescriptor
extends BaseServletDescriptor
implements VariableMBean,
ToXML {
    private String name;
    private String type;
    private String description;
    boolean nameFromAttribute;
    int scope;
    boolean declare = true;

    public VariableDescriptor() {
    }

    public VariableDescriptor(Element element) throws DOMProcessingException {
        String string;
        Element element2 = null;
        element2 = DOMUtils.getOptionalElementByTagName(element, "name-given");
        if (element2 != null) {
            this.name = DOMUtils.getTextData(element2);
            this.nameFromAttribute = false;
        } else {
            element2 = DOMUtils.getOptionalElementByTagName(element, "name-from-attribute");
            this.name = DOMUtils.getTextData(element2);
            this.nameFromAttribute = true;
        }
        this.type = "java.lang.String";
        element2 = DOMUtils.getOptionalElementByTagName(element, "variable-class");
        if (element2 != null) {
            this.type = DOMUtils.getTextData(element2);
        }
        this.declare = true;
        element2 = DOMUtils.getOptionalElementByTagName(element, "declare");
        if (element2 != null) {
            string = DOMUtils.getTextData(element2);
            this.declare = "true".equalsIgnoreCase(string) || "yes".equalsIgnoreCase(string);
        }
        this.scope = 0;
        element2 = DOMUtils.getOptionalElementByTagName(element, "scope");
        if (element2 != null) {
            string = DOMUtils.getTextData(element2);
            if ("AT_BEGIN".equalsIgnoreCase(string)) {
                this.scope = 1;
            } else if ("AT_END".equalsIgnoreCase(string)) {
                this.scope = 2;
            }
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        String string2 = this.name;
        this.name = string;
        if (!VariableDescriptor.comp(string2, this.name)) {
            this.firePropertyChange("name", string2, this.name);
        }
    }

    public String getType() {
        return this.type;
    }

    public void setType(String string) {
        String string2 = this.type;
        this.type = string;
        if (!VariableDescriptor.comp(string2, string)) {
            this.firePropertyChange("type", string2, string);
        }
    }

    public boolean getNameFromAttribute() {
        return this.nameFromAttribute;
    }

    public void setNameFromAttribute(boolean bl) {
        if (this.nameFromAttribute != bl) {
            this.nameFromAttribute = bl;
            this.firePropertyChange("nameFromAttribute", new Boolean(!bl), new Boolean(bl));
        }
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String string) {
        String string2 = this.description;
        this.description = string;
        if (!VariableDescriptor.comp(string2, string)) {
            this.firePropertyChange("description", string2, string);
        }
    }

    public boolean getDeclare() {
        return this.declare;
    }

    public void setDeclare(boolean bl) {
        if (this.declare != bl) {
            this.declare = bl;
            this.firePropertyChange("declare", new Boolean(!bl), new Boolean(bl));
        }
    }

    public int getScope() {
        return this.scope;
    }

    public void setScope(int n) {
        int n2 = this.scope;
        this.scope = n;
        if (this.scope != n) {
            this.firePropertyChange("scope", new Integer(n2), new Integer(n));
        }
    }

    public void setScopeStr(String string) {
        String string2 = this.getScopeStr();
        if (string == null) {
            return;
        }
        if (string.equalsIgnoreCase("AT_BEGIN")) {
            this.scope = 1;
        } else if (string.equalsIgnoreCase("AT_END")) {
            this.scope = 2;
        } else if (string.equalsIgnoreCase("NESTED")) {
            this.scope = 0;
        }
        if (!VariableDescriptor.comp(string2, this.getScopeStr())) {
            this.firePropertyChange("scopeStr", string2, this.getScopeStr());
        }
    }

    public String getScopeStr() {
        if (this.scope == 1) {
            return "AT_BEGIN";
        }
        if (this.scope == 2) {
            return "AT_END";
        }
        return "NESTED";
    }

    public void validate() {
        throw new Error("NYI");
    }

    public void toXML(XMLWriter xMLWriter) {
        xMLWriter.println("<variable>");
        xMLWriter.incrIndent();
        if (this.getNameFromAttribute()) {
            xMLWriter.println("<name-from-attribute>" + this.getName() + "</name-from-attribute>");
        } else {
            xMLWriter.println("<name-given>" + this.getName() + "</name-given>");
        }
        xMLWriter.println("<variable-class>" + this.getType() + "</variable-class>");
        xMLWriter.println("<declare>" + this.getDeclare() + "</declare>");
        xMLWriter.println("<scope>" + this.getScopeStr() + "</scope>");
        if (this.description != null && (this.description = this.description.trim()).length() > 0) {
            xMLWriter.println("<description>" + VariableDescriptor.cdata(this.description) + "</description>");
        }
        xMLWriter.decrIndent();
        xMLWriter.println("</variable>");
    }

    public String toXML(int n) {
        return TLDDescriptor.toXML(this, n);
    }
}

