/*
 * Decompiled with CFR 0.152.
 */
package weblogic.servlet.jsp;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import weblogic.descriptor.DescriptorException;
import weblogic.j2ee.descriptor.WebAppBean;
import weblogic.j2ee.descriptor.wl.WeblogicWebAppBean;
import weblogic.servlet.JSPServlet;
import weblogic.servlet.internal.JSPManager;
import weblogic.servlet.internal.WebAppDescriptor;
import weblogic.servlet.jsp.CompilationException;
import weblogic.servlet.jsp.JspCLLManager;
import weblogic.servlet.jsp.JspCompilerContext;
import weblogic.servlet.jsp.JspConfig;
import weblogic.servlet.jsp.JspStub;
import weblogic.servlet.jsp.JspcInvoker;
import weblogic.servlet.jsp.StaleChecker;
import weblogic.utils.BadOptionException;
import weblogic.utils.FileUtils;
import weblogic.utils.Getopt2;
import weblogic.utils.classloaders.ClassFinder;
import weblogic.utils.classloaders.ClasspathClassFinder2;
import weblogic.utils.classloaders.GenericClassLoader;
import weblogic.utils.classloaders.Source;
import weblogic.utils.compiler.CompilerInvoker;
import weblogic.utils.compiler.Tool;
import weblogic.utils.compiler.ToolFailureException;
import weblogic.utils.enumerations.ResourceEnumerator;
import weblogic.utils.jars.JarFileUtils;
import weblogic.utils.jars.VirtualJarFactory;
import weblogic.utils.jars.VirtualJarFile;
import weblogic.version;

public final class jspc20
extends Tool
implements StaleChecker,
JspcInvoker.IJspc {
    private static final String WEBLOGIC_EXTENSION_DIRS = "weblogic.ext.dirs";
    private static final boolean debug = false;
    private boolean verbose;
    private static final int DEFAULT_MAX_FILES = 2000;
    private static String DEFAULT_TARGET_DIR = File.separator + "WEB-INF" + File.separator + "classes";
    private ClassFinder resourceFinder;
    private ClassFinder classFinder;
    private GenericClassLoader classLoader;
    private File outputDir;
    private WebAppBean webBean;
    private WeblogicWebAppBean wlWebBean;
    private String[] args;
    private boolean isStrictStaleCheck;
    private static final boolean useUniqueJSPCL = Boolean.getBoolean("weblogic.jspc.useUniqueJspClassLoader");

    public jspc20(String[] stringArray) {
        super(stringArray);
        this.opts.setUsageArgs("<jsp files>...");
        this.opts.addOption("webapp", "dir", "Directory to be considered as the document root for resolving relative files.");
        this.opts.addAlias("docroot", "webapp");
        this.opts.addFlag("verboseJspc", "whether JSP Compiler runs in verbose mode (default is false)");
        this.opts.addAdvancedOption("compileFlags", "flags", "Use this to specify non-standard options to the java compiler (those other than -g -nowarn, etc).  E.g, -compileFlags \"+E -otherOpt +P\"");
        this.opts.addAdvancedFlag("verboseJavac", "whether to invoke java compiler with -verbose (default false, use -verbose also)");
        this.opts.addAdvancedFlag("linenumbers", "add jsp line numbers to generated class files to aid debugging");
        this.opts.addAlias("debug", "linenumbers");
        this.opts.addAdvancedFlag("k", "continue compiling files, even when some fail");
        this.opts.addAdvancedFlag("noTryBlocks", "disable use of try/finally blocks for BodyTag extensions. Improves code for deeply-nested tags.");
        this.opts.addAdvancedFlag("noImplicitTlds", "disable search and registration of implicit Tlds. ");
        this.opts.addAdvancedFlag("noPrintNulls", "show \"null\" in jsp expressions as \"\" ");
        this.opts.addAlias("docRoot", "webapp");
        this.opts.addAdvancedFlag("backwardcompatible", "Backward compatibility option.");
        this.opts.addAdvancedOption("charsetMap", "charsetMapString", "specify mapping of IANA or unofficial charset names used in JSP contentType directives to java charset names.  E.g., '-charsetMap x-sjis=Shift_JIS,x-big5=Big5'  The most common mappings are built-in to jspc.  Use this option only if a desired charset mapping isn't recognized.");
        this.opts.addAdvancedOption("maxfiles", "int", "Maximum number of generated java files to be compiled at one time.");
        this.opts.addAdvancedFlag("skipJavac", "Skip compilation of generated servlet code.");
        this.opts.addAdvancedFlag("forceGeneration", "Force generation of JSP classes. Without this flag, the classes may not be generated if it is determined to be unnecessary.");
        this.opts.addAdvancedFlag("compressHtmlTemplate", "Remove additional white spaces in html template. Without this flag, html template will be output as is.");
        this.opts.addAdvancedFlag("optimizeJavaExpression", "Optimize string concatenation in Java expression. Without this flag, Java expression will be output as is.");
        this.opts.addAdvancedFlag("useByteBuffer", "Generate source codes of jsp files to use NIO ByteBuffer for static contents.");
        this.opts.addFlag("moreVerbose", "yet some more verbose");
        this.opts.markPrivate("moreVerbose");
        this.opts.addFlag("compileAll", "compile all .jsp files below the directory specified by -webapp");
        this.opts.markPrivate("compileAll");
        this.opts.addFlag("depend", "only compile files that are out of date (source .jsp file(s) newer than generated .class file)");
        this.opts.markPrivate("depend");
        new CompilerInvoker(this.opts);
        this.opts.addAdvancedOption("encoding", "options", "Valid args are \"default\" to use the default character encoding of JDK, or named character encoding, like \"8859_1\". If the -encoding flag is not present,  an array of bytes is used.");
        this.opts.addAdvancedOption("compilerSupportsEncoding", "options", "Set to \"true\" if the java compiler supports the -encoding flag, or \"false\" if it does not. ");
        this.opts.addAdvancedOption("package", "packageName", "The package into which the .jsp files should be placed");
        this.opts.addAdvancedOption("superclass", "superclass", "The class name of the superclass which this servlet should extend.");
        this.opts.markPrivate("nowrite");
        this.opts.markPrivate("nowarn");
        this.opts.markPrivate("verbose");
        this.opts.markPrivate("deprecation");
        this.opts.markPrivate("commentary");
        this.opts.markPrivate("O");
        this.opts.markPrivate("J");
        this.opts.markPrivate("normi");
        this.opts.markPrivate("g");
        this.opts.markPrivate("compiler");
        this.opts.markPrivate("compilerclass");
        this.opts.markPrivate("compilerSupportsEncoding");
        this.opts.markPrivate("verboseJavac");
        this.opts.markPrivate("compileFlags");
        this.opts.markPrivate("skipJavac");
        this.opts.markPrivate("source");
        this.opts.markPrivate("linenumbers");
        this.opts.markPrivate("noImplicitTlds");
        this.opts.markPrivate("noTryBlocks");
        this.opts.addOption("jsps", "jsps", "Comma-separated list of jsp files, specifies jsps that need to be compiled. All jsps of the app will be compiled if the option is not passed into.");
        this.opts.markPrivate("jsps");
        this.opts.addFlag("compileAllTagFiles", "Compile all JSP tag files");
        this.opts.markPrivate("compileAllTagFiles");
        this.opts.markPrivate("useByteBuffer");
        this.args = stringArray;
    }

    public void prepare() {
        this.setRequireExtraArgs(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runJspc(GenericClassLoader genericClassLoader, ClassFinder classFinder, VirtualJarFile virtualJarFile) throws Exception {
        this.prepare();
        this.opts.grok(this.args);
        this.resourceFinder = classFinder;
        this.init(genericClassLoader, virtualJarFile);
        assert (virtualJarFile.isDirectory());
        try {
            boolean bl = true;
            String[] stringArray = new String[]{};
            if (this.opts.hasOption("jsps") && !"*".equals(this.opts.getOption("jsps")) && !"\"*\"".equals(this.opts.getOption("jsps")) && !"'*'".equals(this.opts.getOption("jsps"))) {
                stringArray = this.opts.getOption("jsps").split(",");
                bl = false;
            }
            this.runBodyInternal(virtualJarFile, bl, stringArray);
        }
        finally {
            try {
                if (virtualJarFile != null) {
                    virtualJarFile.close();
                }
                if (classFinder != null) {
                    classFinder.close();
                }
                if (this.classFinder != null) {
                    this.classFinder.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runBody() throws Exception {
        String string;
        File file;
        VirtualJarFile virtualJarFile;
        this.validateToolInput(this.opts);
        long l = 0L;
        boolean bl = this.opts.getBooleanOption("moreVerbose");
        if (bl) {
            l = System.currentTimeMillis();
        }
        boolean bl2 = !(virtualJarFile = VirtualJarFactory.createVirtualJar((File)(file = new File(string = this.opts.getOption("webapp", ".").replace('/', File.separatorChar))))).isDirectory();
        boolean bl3 = bl2 && this.opts.getOption("d") == null;
        virtualJarFile = this.getVirtualJarFile(virtualJarFile);
        this.init(null, virtualJarFile);
        this.initDescriptors(virtualJarFile);
        try {
            this.runBodyInternal(virtualJarFile, false, this.opts.args());
        }
        finally {
            try {
                if (virtualJarFile != null) {
                    virtualJarFile.close();
                }
                if (this.resourceFinder != null) {
                    this.resourceFinder.close();
                }
                if (this.classFinder != null) {
                    this.classFinder.close();
                }
            }
            catch (IOException iOException) {}
            if (bl) {
                jspc20.say("Total time elapsed : " + (System.currentTimeMillis() - l));
            }
        }
        if (bl2) {
            String string2 = this.opts.getOption("webapp");
            File file2 = new File(string2);
            if (bl3) {
                jspc20.say(" Creating jar file " + string + " w/ compiled jsps");
                JarFileUtils.createJarFileFromDirectory((String)string, (File)file2);
            }
            FileUtils.remove((File)file2);
        }
    }

    public void setWebBean(WebAppBean webAppBean) {
        this.webBean = webAppBean;
    }

    public void setWlWebBean(WeblogicWebAppBean weblogicWebAppBean) {
        this.wlWebBean = weblogicWebAppBean;
    }

    private void runBodyInternal(VirtualJarFile virtualJarFile, boolean bl, String[] stringArray) throws Exception {
        int n;
        Object object;
        String[] stringArray2;
        Object object2;
        Object object3;
        GenericClassLoader genericClassLoader;
        String[] stringArray3;
        JspConfig jspConfig = this.mergeOptions(this.opts);
        HashSet<String> hashSet = null;
        if (this.webBean != null) {
            hashSet = JSPManager.getJspConfigPatterns(this.webBean.getJspConfigs());
        }
        this.verbose = this.opts.getBooleanOption("verboseJspc", false);
        this.isStrictStaleCheck = jspConfig.isStrictStaleCheck();
        boolean bl2 = this.opts.getBooleanOption("keepgenerated", false);
        boolean bl3 = this.opts.getBooleanOption("k", false);
        boolean bl4 = bl;
        if (!bl4) {
            bl4 = this.opts.getOption("webapp") != null && stringArray.length == 0 || this.opts.getBooleanOption("compileAll");
        }
        boolean bl5 = this.opts.getBooleanOption("compileAllTagFiles", false);
        File[] fileArray = virtualJarFile.getRootFiles();
        assert (fileArray != null);
        Object object4 = null;
        if (bl4) {
            Object object5;
            if (this.verbose) {
                object5 = this.opts.getBooleanOption("compileAll") ? "-compileAll specified, " : " -webapp specified, ";
                jspc20.say((String)object5 + "searching " + this.opts.getOption("webapp", ".") + " for JSPs");
            }
            object5 = new ArrayList();
            if (hashSet == null) {
                hashSet = new HashSet<String>();
            }
            if (bl5) {
                hashSet.add("/WEB-INF/tags/*.tag");
                hashSet.add("/WEB-INF/tags/*.tagx");
            }
            hashSet.add("*.jsp");
            hashSet.add("*.jspx");
            stringArray3 = hashSet.toArray(new String[0]);
            for (int i = 0; i < fileArray.length; ++i) {
                if (!fileArray[i].exists()) {
                    if (!this.verbose) continue;
                    jspc20.say("Ignoring non-existent web-root " + fileArray[i].getAbsolutePath());
                    continue;
                }
                genericClassLoader = ResourceEnumerator.makeInstance((File)fileArray[i], (String[])new String[0], (String[])stringArray3);
                object3 = null;
                while ((object3 = genericClassLoader.getNextURI()) != null) {
                    object5.add(object3);
                }
                genericClassLoader.close();
            }
            object4 = object5;
        } else if (stringArray != null && stringArray.length > 0) {
            object4 = new ArrayList<String>(stringArray.length);
            for (int i = 0; i < stringArray.length; ++i) {
                stringArray3 = new File(stringArray[i].replace('/', File.separatorChar));
                object4.add(jspc20.determineURI(fileArray[0], (File)stringArray3, stringArray[i]));
            }
        }
        if (object4 == null || object4.size() == 0) {
            jspc20.say("No jsp files found, nothing to do");
            return;
        }
        boolean bl6 = this.opts.getBooleanOption("forceGeneration", false);
        boolean bl7 = this.opts.getBooleanOption("depend", false);
        ClassFinder classFinder = this.classLoader.getClassFinder();
        genericClassLoader = this.classLoader;
        if (!bl6 || bl7) {
            object3 = this.opts.getOption("package", "jsp_servlet");
            object2 = object4.iterator();
            while (object2.hasNext()) {
                stringArray2 = (String[])object2.next();
                if (useUniqueJSPCL) {
                    object = JSPServlet.uri2classname((String)object3, (String)stringArray2);
                    genericClassLoader = JspcInvoker.getJspClassLoader((ClassLoader)this.classLoader, classFinder, (String)object);
                }
                if (this.classIsStale((String)object3, (String)stringArray2, (ClassLoader)genericClassLoader)) continue;
                object2.remove();
                if (!this.verbose) continue;
                jspc20.say("skipping " + (String)stringArray2 + ", it is up to date.");
            }
        }
        object3 = new JspCompilerContext("[jspc]");
        ((JspCompilerContext)object3).setVerbose(this.verbose);
        ((JspCompilerContext)object3).setClassLoader(genericClassLoader);
        ((JspCompilerContext)object3).setResourceFinder(this.resourceFinder);
        ((JspCompilerContext)object3).setJspConfig(jspConfig);
        object2 = this.resourceFinder.getClassPath();
        stringArray2 = ((String)object2).split(File.pathSeparator);
        if (stringArray2 != null) {
            object = new ArrayList(stringArray2.length);
            for (n = 0; n < stringArray2.length; ++n) {
                File file = new File(stringArray2[n]);
                if (!file.exists()) continue;
                object.add(stringArray2[n]);
            }
            ((JspCompilerContext)object3).setSourcePaths(object.toArray(new String[0]));
        }
        ((JspCompilerContext)object3).setWebAppBean(this.webBean);
        ((JspCompilerContext)object3).setWlWebAppBean(this.wlWebBean);
        int n2 = this.opts.getIntegerOption("maxfiles", 2000);
        n = object4.size();
        if (n < n2) {
            n2 = n;
        }
        boolean bl8 = false;
        int n3 = n2;
        for (int i = 0; i < n; i += n3) {
            int n4 = Math.min(n3, n - i);
            int n5 = i;
            int n6 = i + n4;
            List list = object4.subList(n5, n6);
            boolean bl9 = false;
            try {
                bl9 = JspCLLManager.compileJsps(list, (JspCLLManager.IJSPCompilerContext)object3);
            }
            catch (CompilationException compilationException) {
                if (!bl3) {
                    throw new ToolFailureException("jspc failed with errors :" + compilationException);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
                throw new ToolFailureException("Unexpected exception while compiling jsps :" + exception);
            }
            bl8 |= !bl9;
        }
        if (!bl3 && bl8) {
            throw new ToolFailureException("[jspc] compiler failed with errors");
        }
    }

    private void init(GenericClassLoader genericClassLoader, VirtualJarFile virtualJarFile) {
        if (this.resourceFinder == null) {
            this.resourceFinder = jspc20.buildResourceFinder(virtualJarFile);
        }
        this.classLoader = genericClassLoader;
        this.outputDir = new File(this.opts.getOption("d", "."));
        this.outputDir.mkdirs();
        if (this.classLoader == null) {
            this.classFinder = jspc20.buildClassFinder(this.opts, this.outputDir, virtualJarFile);
            this.classLoader = new GenericClassLoader(this.classFinder);
        } else {
            String string = jspc20.buildExtClassPath();
            StringBuilder stringBuilder = new StringBuilder();
            if (string != null) {
                stringBuilder.append(string);
                stringBuilder.append(File.pathSeparator);
            }
            stringBuilder.append(this.outputDir.getAbsolutePath());
            this.classLoader.addClassFinder((ClassFinder)new ClasspathClassFinder2(stringBuilder.toString()));
        }
    }

    private void initDescriptors(VirtualJarFile virtualJarFile) throws ToolFailureException {
        boolean bl;
        boolean bl2 = bl = virtualJarFile.getEntry("WEB-INF/web.xml") != null;
        if (!bl) {
            jspc20.say("warning: expected file /WEB-INF/web.xml  not found, tag libraries cannot be resolved.");
        }
        boolean bl3 = virtualJarFile.getEntry("WEB-INF/weblogic.xml") != null;
        WebAppDescriptor webAppDescriptor = new WebAppDescriptor(virtualJarFile);
        if (bl && this.webBean == null) {
            try {
                this.webBean = webAppDescriptor.getWebAppBean();
            }
            catch (XMLStreamException xMLStreamException) {
            }
            catch (DescriptorException descriptorException) {
                String string = null;
                if (descriptorException.getCause() != null) {
                    string = descriptorException.getCause().getMessage();
                }
                jspc20.say("Warning: Error occured while parsing WEB-INF/web.xml, tag libraries will not be resolved " + (string == null ? "" : string));
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (bl3 && this.wlWebBean == null) {
            try {
                this.wlWebBean = webAppDescriptor.getWeblogicWebAppBean();
            }
            catch (XMLStreamException xMLStreamException) {
                throw new ToolFailureException("Error occured while parsing /WEB-INF/weblogic.xml : " + xMLStreamException);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public boolean isResourceStale(String string, long l, String string2, String string3) {
        Source source;
        boolean bl = Boolean.getBoolean("weblogic.jspc.skipVersionCheck");
        if (!bl && !version.getReleaseBuildVersion().equals(string2)) {
            if (this.verbose) {
                jspc20.say("Resource '" + string + "' is being considered new, its server version '" + string2 + "' does not match the current server version '" + version.getReleaseBuildVersion() + "'");
            }
            return true;
        }
        if (bl && this.verbose) {
            jspc20.say("found System property 'weblogic.jspc.skipVersionCheck=true', skipping server version check ");
        }
        if ((source = this.resourceFinder.getSource(string)) == null) {
            return true;
        }
        long l2 = source.lastModified();
        if (!this.isStrictStaleCheck) {
            jspc20.say("using none strick stale check");
            return l != l2 + 2000L;
        }
        return l < l2;
    }

    private VirtualJarFile getVirtualJarFile(VirtualJarFile virtualJarFile) throws IOException {
        File file;
        block7: {
            block6: {
                if (virtualJarFile.isDirectory()) {
                    return virtualJarFile;
                }
                file = JspcInvoker.getJspcTempDir();
                JarFileUtils.extract((VirtualJarFile)virtualJarFile, (File)file);
                try {
                    this.opts.setOption("webapp", file.getAbsolutePath());
                }
                catch (BadOptionException badOptionException) {
                    if ($assertionsDisabled) break block6;
                    throw new AssertionError();
                }
            }
            File file2 = new File(file, DEFAULT_TARGET_DIR);
            if (this.opts.getOption("d") == null) {
                try {
                    this.opts.setOption("d", file2.getAbsolutePath());
                }
                catch (BadOptionException badOptionException) {
                    if ($assertionsDisabled) break block7;
                    throw new AssertionError();
                }
            }
        }
        virtualJarFile.close();
        return VirtualJarFactory.createVirtualJar((File)file);
    }

    private JspConfig mergeOptions(Getopt2 getopt2) {
        Map map = null;
        map = this.wlWebBean == null ? JspcInvoker.makeDefaultDescriptorMap() : JspcInvoker.makeDescriptorMap(this.wlWebBean, null);
        map.put("workingDir", this.outputDir.getAbsolutePath());
        map.put("compiler", getopt2.getOption("compiler"));
        for (String string : map.keySet()) {
            String string2 = this.getToolOptionName(string);
            String string3 = null;
            if (string2 == null || (string3 = getopt2.getOption(string2)) == null) continue;
            if ("printNulls".equals(string)) {
                string3 = "false".equals(string3) ? "true" : "false";
            } else {
                jspc20.say("Overriding " + (this.wlWebBean == null ? " default " : "") + "descriptor option '" + string + "'" + (string2.equals(string) ? "" : " (alias '" + string2 + "')") + " with value specified on command-line '" + string3 + "' ");
            }
            map.put(string, string3);
        }
        map.put("useByteBuffer", Boolean.toString(getopt2.getBooleanOption("useByteBuffer")));
        return new JspConfig(map);
    }

    private boolean classIsStale(String string, String string2, ClassLoader classLoader) {
        String string3 = JSPServlet.uri2classname(string, string2);
        try {
            Class<?> clazz = classLoader.loadClass(string3);
            return JspStub.isJSPClassStale(clazz, this);
        }
        catch (ThreadDeath threadDeath) {
            throw threadDeath;
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            if (this.verbose) {
                jspc20.say("WARN: precompiled servlet class " + string3 + "'s dependent class " + noClassDefFoundError.getMessage().replace('/', '.') + " cannot be found!, so jsp check stale fails and " + string2 + " will be recompiled!");
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return true;
    }

    private static String buildExtClassPath() {
        return System.getProperty(WEBLOGIC_EXTENSION_DIRS);
    }

    private static ClassFinder buildClassFinder(Getopt2 getopt2, File file, VirtualJarFile virtualJarFile) {
        String string;
        String string2;
        String string3 = getopt2.getOption("classpath", null);
        String string4 = System.getProperty("java.class.path");
        if (string3 != null) {
            string4 = string4 + File.pathSeparator + string3;
        }
        if ((string2 = jspc20.buildExtClassPath()) != null) {
            string4 = string2 + File.pathSeparator + string4;
        }
        if ((string = JspcInvoker.determineWebAppClasspath(virtualJarFile, new HashMap())) != null) {
            string4 = string + File.pathSeparator + string4;
        }
        if (file != null) {
            string4 = file.getAbsolutePath() + File.pathSeparator + string4;
        }
        return new ClasspathClassFinder2(string4);
    }

    private static String determineURI(File file, File file2, String string) throws FileNotFoundException {
        String string2;
        String string3 = file.getAbsolutePath();
        int n = string3.length();
        if (string3.endsWith(".")) {
            string3 = string3.substring(0, --n);
        }
        if (string3.endsWith(File.separator)) {
            string3 = string3.substring(0, --n);
        }
        if (!(string2 = file2.getAbsolutePath()).startsWith(string3.substring(1), 1) || !string2.substring(0, 1).equalsIgnoreCase(string3.substring(0, 1))) {
            File file3 = new File(string3, string.replace('/', File.separatorChar));
            if (!file3.exists()) {
                throw new FileNotFoundException("ERROR: Source file '" + string + "' can not be found in the docroot '" + string3 + "'. Put the source in the docroot or specify the correct docroot" + " with jspc option \"-webapp\".");
            }
            return string.replace(File.separatorChar, '/');
        }
        String string4 = string2.substring(n).replace(File.separatorChar, '/');
        return string4;
    }

    private static ClassFinder buildResourceFinder(VirtualJarFile virtualJarFile) {
        if (virtualJarFile == null) {
            return null;
        }
        String string = "";
        File[] fileArray = virtualJarFile.getRootFiles();
        if (fileArray != null) {
            for (int i = 0; i < fileArray.length; ++i) {
                string = fileArray[i].getAbsolutePath() + File.pathSeparator + string;
            }
            return new ClasspathClassFinder2(string);
        }
        return null;
    }

    protected String getToolOptionName(String string) {
        if (string.equals("printNulls")) {
            return "noPrintNulls";
        }
        if (string.equals("precompileContinue")) {
            return "k";
        }
        if (string.equals("compileCommand")) {
            return "compiler";
        }
        if (string.equals("packagePrefix")) {
            return "package";
        }
        if (string.equals("debug")) {
            return "linenumbers";
        }
        if (string.equals("encoding") || string.equals("compilerclass") || string.equals("compileFlags") || string.equals("keepgenerated") || string.equals("compilerSupportsEncoding") || string.equals("superclass") || string.equals("compressHtmlTemplate") || string.equals("optimizeJavaExpression") || string.equals("noTryBlocks")) {
            return string;
        }
        return null;
    }

    private void validateToolInput(Getopt2 getopt2) throws ToolFailureException {
        boolean bl = getopt2.getBooleanOption("compileAll");
        boolean bl2 = getopt2.getOption("webapp") != null;
        String string = getopt2.getOption("package", "jsp_servlet");
        if (!bl && !bl2 && getopt2.args().length == 0) {
            if (getopt2.hasOptions()) {
                getopt2.usageError("weblogic.jspc");
                throw new ToolFailureException("Only options were given, additional arguments are required ");
            }
            getopt2.usageError("weblogic.jspc");
            throw new ToolFailureException("No arguments were given, there is nothing to do.");
        }
        if ("".equals(string.trim())) {
            throw new IllegalArgumentException("Bad -package option value, please specify a valid value for this option");
        }
    }

    private static void say(String string) {
        System.out.println("[jspc] " + string);
    }

    private static void sayError(String string) {
        System.err.println("Error: " + string);
    }

    static void p(String string) {
        System.out.println("[jspc20]" + string);
    }

    public static void main(String[] stringArray) throws Exception {
        new jspc20(stringArray).run();
    }
}

