/*
 * Decompiled with CFR 0.152.
 */
package weblogic.servlet.logging;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.security.AccessController;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import weblogic.management.configuration.WebServerMBean;
import weblogic.management.provider.ManagementService;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.servlet.internal.ServletRequestImpl;
import weblogic.servlet.internal.ServletResponseImpl;
import weblogic.servlet.logging.FormatStringBuffer;
import weblogic.servlet.logging.LogManagerHttp;
import weblogic.servlet.logging.Logger;
import weblogic.utils.PlatformConstants;
import weblogic.utils.string.SimpleCachingDateFormat;

public final class CLFLogger
implements Logger {
    private final byte[] LINE_SEP = PlatformConstants.EOL.getBytes();
    private static final AuthenticatedSubject kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
    private final CLFDateFormat format = new CLFDateFormat();
    private final CLFDateFormatWithMillis formatWithMillis = new CLFDateFormatWithMillis();
    private final LogManagerHttp logManager;
    private boolean logMillis;

    public CLFLogger(LogManagerHttp logManagerHttp, WebServerMBean webServerMBean) {
        this.logManager = logManagerHttp;
        this.logMillis = webServerMBean.getWebServerLog().isLogMilliSeconds();
    }

    public int log(ServletRequestImpl servletRequestImpl, ServletResponseImpl servletResponseImpl) {
        Object object;
        FormatStringBuffer formatStringBuffer = new FormatStringBuffer(128);
        if (ManagementService.getRuntimeAccess(kernelId).getServer().isReverseDNSAllowed()) {
            formatStringBuffer.appendValueOrDash(servletRequestImpl.getRemoteHost());
        } else {
            formatStringBuffer.appendValueOrDash(servletRequestImpl.getRemoteAddr());
        }
        formatStringBuffer.appendSpaceDashSpace();
        formatStringBuffer.appendValueOrDash(servletRequestImpl.getHttpAccountingInfo().getRemoteUser());
        formatStringBuffer.append(' ');
        if (this.logMillis) {
            formatStringBuffer.append(this.formatWithMillis.getDateAsBytes(servletRequestImpl));
            formatStringBuffer.append(' ');
        } else {
            formatStringBuffer.append(this.format.getDateAsBytes(servletRequestImpl));
            formatStringBuffer.append(' ');
        }
        formatStringBuffer.append('\"');
        try {
            object = servletRequestImpl.getInputHelper().getRequestParser();
            ByteBuffer byteBuffer = object.getFullRequrestUriBytes();
            formatStringBuffer.append(byteBuffer.array(), byteBuffer.position(), byteBuffer.limit() - byteBuffer.position());
        }
        catch (Exception exception) {
            formatStringBuffer.append(servletRequestImpl.getRequestURI());
        }
        formatStringBuffer.append('\"');
        formatStringBuffer.append(' ');
        formatStringBuffer.appendStatusCode(servletResponseImpl.getStatus()).append(' ');
        formatStringBuffer.append(servletResponseImpl.getContentLength());
        formatStringBuffer.append(' ');
        formatStringBuffer.append(this.LINE_SEP);
        object = this.logManager.getLogStream();
        try {
            ((OutputStream)object).write(formatStringBuffer.getBytes(), 0, formatStringBuffer.size());
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return formatStringBuffer.size();
    }

    public void markRotated() {
    }

    private static class CLFDateFormatWithMillis {
        private Date date = new Date();
        private SimpleDateFormat format = new SimpleDateFormat("[dd/MMM/yyyy:HH:mm:ss.SSS Z]");

        CLFDateFormatWithMillis() {
            this.format.setTimeZone(TimeZone.getDefault());
        }

        byte[] getDateAsBytes(ServletRequestImpl servletRequestImpl) {
            long l = servletRequestImpl.getHttpAccountingInfo().getInvokeTime();
            this.date.setTime(l);
            return this.format.format(this.date).getBytes();
        }
    }

    private static class CLFDateFormat
    extends SimpleCachingDateFormat {
        private byte[] cachedBytes;
        private String cachedString;

        CLFDateFormat() {
            super("[dd/MMM/yyyy:HH:mm:ss Z]");
        }

        byte[] getDateAsBytes(ServletRequestImpl servletRequestImpl) {
            long l = servletRequestImpl.getHttpAccountingInfo().getInvokeTime();
            String string = super.getDate(l);
            if (string != this.cachedString) {
                this.cachedBytes = string.getBytes();
                this.cachedString = string;
            }
            return this.cachedBytes;
        }
    }
}

