/*
 * Decompiled with CFR 0.152.
 */
package weblogic.servlet.logging;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import weblogic.diagnostics.debug.DebugLogger;
import weblogic.management.configuration.WebServerMBean;
import weblogic.servlet.HTTPLogger;
import weblogic.servlet.internal.ServletRequestImpl;
import weblogic.servlet.internal.ServletResponseImpl;
import weblogic.servlet.logging.FormatStringBuffer;
import weblogic.servlet.logging.HttpAccountingInfoImpl;
import weblogic.servlet.logging.LogFormat;
import weblogic.servlet.logging.LogManagerHttp;
import weblogic.servlet.logging.Logger;
import weblogic.utils.StringUtils;

public final class ELFLogger
implements Logger {
    private static final String LINE_SEP = System.getProperty("line.separator");
    private static final String ELF_HEADERS_0 = "#Version:\t1.0" + LINE_SEP + "#Fields:\t";
    private static final String ELF_HEADERS_2 = LINE_SEP + "#Software:\tWebLogic" + LINE_SEP + "#Start-Date:\t";
    private static final String ELF_HEADERS_4 = "\t";
    private static final String ELF_HEADERS_6 = LINE_SEP;
    private static final String[] ELF_HEADERS = new String[]{ELF_HEADERS_0, null, ELF_HEADERS_2, null, "\t", null, ELF_HEADERS_6};
    private final String fieldsDirective;
    private final LogFormat logFormat;
    private final boolean logTimeInGMT;
    private final LogManagerHttp logManager;
    private static final DebugLogger DEBUG_LOGGING = DebugLogger.getDebugLogger((String)"DebugHttpLogging");
    private volatile boolean needToWriteELFHeaders;
    private boolean logMillis;

    public ELFLogger(LogManagerHttp logManagerHttp, WebServerMBean webServerMBean) {
        this.logManager = logManagerHttp;
        this.logTimeInGMT = webServerMBean.getWebServerLog().isLogTimeInGMT();
        this.logMillis = webServerMBean.getWebServerLog().isLogMilliSeconds();
        this.fieldsDirective = this.findFieldsDirective(webServerMBean);
        this.logFormat = new LogFormat(this.fieldsDirective);
        if (webServerMBean.getWebServerLog().getRotateLogOnStartup()) {
            this.needToWriteELFHeaders = true;
        }
    }

    private String findFieldsDirective(WebServerMBean webServerMBean) {
        try {
            String[] stringArray = ELFLogger.readELFFields(webServerMBean.getWebServerLog().computeLogFilePath());
            if (stringArray == null) {
                if (DEBUG_LOGGING.isDebugEnabled()) {
                    DEBUG_LOGGING.debug("No previous access.log for webserver: " + webServerMBean.getName());
                }
                this.needToWriteELFHeaders = true;
                return webServerMBean.getWebServerLog().getELFFields();
            }
            if (stringArray[0] != null && !stringArray[0].startsWith("1.0")) {
                HTTPLogger.logELFLogNotFormattedProperly();
            } else if (stringArray[1] != null && stringArray[1].length() > 0) {
                if (stringArray[1].equals(webServerMBean.getWebServerLog().getELFFields())) {
                    if (DEBUG_LOGGING.isDebugEnabled()) {
                        DEBUG_LOGGING.debug("Fields in access.log match with webserver: " + webServerMBean.getName());
                    }
                    return stringArray[1];
                }
                if (!webServerMBean.getWebServerLog().isSet("ELFFields")) {
                    if (DEBUG_LOGGING.isDebugEnabled()) {
                        DEBUG_LOGGING.debug("Found modified fields: " + stringArray[1] + " in access.log for webserver: " + webServerMBean.getName());
                    }
                    return stringArray[1];
                }
                if (DEBUG_LOGGING.isDebugEnabled()) {
                    DEBUG_LOGGING.debug("WebServerMBean's ELF-Fields have been modified for : " + webServerMBean.getName() + " access.log will be rotated");
                }
                HTTPLogger.logELFFieldsChanged((String)webServerMBean.getName(), (String)stringArray[1], (String)webServerMBean.getWebServerLog().getELFFields());
                this.logManager.rotateLog();
                this.needToWriteELFHeaders = true;
                return webServerMBean.getWebServerLog().getELFFields();
            }
        }
        catch (IOException iOException) {
            HTTPLogger.logELFReadHeadersException((Throwable)iOException);
        }
        if (DEBUG_LOGGING.isDebugEnabled()) {
            DEBUG_LOGGING.debug("Rotating access.log for : " + webServerMBean.getName() + " since the old format doesn't seem to ELF");
        }
        try {
            this.logManager.rotateLog();
        }
        catch (IOException iOException) {
            HTTPLogger.logFailedToRollLogFile((String)webServerMBean.getName(), (Throwable)iOException);
        }
        this.needToWriteELFHeaders = true;
        return webServerMBean.getWebServerLog().getELFFields();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static String[] readELFFields(String string) throws IOException {
        BufferedReader bufferedReader = ELFLogger.getLogReader(string);
        if (bufferedReader == null) {
            return null;
        }
        String[] stringArray = new String[2];
        try {
            String string2;
            while ((string2 = bufferedReader.readLine()) != null && string2.startsWith("#")) {
                String[] stringArray2 = StringUtils.split((String)string2.substring(1), (char)':');
                stringArray2[0] = stringArray2[0].trim();
                if ("Version".equals(stringArray2[0])) {
                    stringArray[0] = stringArray2[1].trim();
                    continue;
                }
                if (!"Fields".equals(stringArray2[0])) continue;
                stringArray[1] = stringArray2[1].trim();
            }
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            bufferedReader.close();
            throw throwable;
        }
        bufferedReader.close();
        return stringArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int log(ServletRequestImpl servletRequestImpl, ServletResponseImpl servletResponseImpl) {
        Object object;
        if (this.needToWriteELFHeaders) {
            object = this.logManager.getLogStream();
            OutputStream outputStream = object;
            synchronized (outputStream) {
                this.writeELFHeaders((OutputStream)object);
            }
        }
        object = new FormatStringBuffer(128);
        ((FormatStringBuffer)object).setUseGMT(this.logTimeInGMT);
        ((FormatStringBuffer)object).setLogMillis(this.logMillis);
        int n = this.logFormat.countFields();
        HttpAccountingInfoImpl httpAccountingInfoImpl = servletRequestImpl.getHttpAccountingInfo();
        for (int i = 0; i < n; ++i) {
            this.logFormat.getFieldAt(i).logField(httpAccountingInfoImpl, (FormatStringBuffer)object);
            if (i == n - 1) continue;
            ((FormatStringBuffer)object).append('\t');
        }
        ((FormatStringBuffer)object).append(LINE_SEP);
        OutputStream outputStream = this.logManager.getLogStream();
        try {
            outputStream.write(((FormatStringBuffer)object).getBytes(), 0, ((FormatStringBuffer)object).size());
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return ((FormatStringBuffer)object).size();
    }

    private static BufferedReader getLogReader(String string) {
        BufferedReader bufferedReader;
        File file = null;
        try {
            File file2;
            if (string == null) {
                return null;
            }
            file = new File(string);
            String string2 = file.getParent();
            if (string2 != null && !(file2 = new File(string2)).exists()) {
                file2.mkdirs();
            }
            bufferedReader = new BufferedReader(new FileReader(file));
        }
        catch (IOException iOException) {
            return null;
        }
        return bufferedReader;
    }

    private String getELFHeaders() {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < ELF_HEADERS.length; ++i) {
            if (ELF_HEADERS[i] == null) {
                switch (i) {
                    case 1: {
                        stringBuffer.append(this.fieldsDirective);
                        break;
                    }
                    case 3: {
                        FormatStringBuffer formatStringBuffer = new FormatStringBuffer().appendDate();
                        stringBuffer.append(new String(formatStringBuffer.getBytes(), 0, formatStringBuffer.size()));
                        break;
                    }
                    case 5: {
                        FormatStringBuffer formatStringBuffer = new FormatStringBuffer().appendTime();
                        stringBuffer.append(new String(formatStringBuffer.getBytes(), 0, formatStringBuffer.size()));
                        break;
                    }
                }
                continue;
            }
            stringBuffer.append(ELF_HEADERS[i]);
        }
        return stringBuffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void markRotated() {
        OutputStream outputStream;
        OutputStream outputStream2 = outputStream = this.logManager.getLogStream();
        synchronized (outputStream2) {
            this.needToWriteELFHeaders = true;
            this.writeELFHeaders(outputStream);
        }
    }

    private void writeELFHeaders(OutputStream outputStream) {
        if (!this.needToWriteELFHeaders) {
            return;
        }
        byte[] byArray = this.getELFHeaders().getBytes();
        try {
            outputStream.write(byArray, 0, byArray.length);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.needToWriteELFHeaders = false;
    }
}

