/*
 * Decompiled with CFR 0.152.
 */
package weblogic.servlet.logging;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import weblogic.utils.string.SimpleCachingDateFormat;

public final class FormatStringBuffer {
    private static final TimeZone GMT = TimeZone.getTimeZone("GMT");
    private static final byte[][] monthNames = new byte[][]{"Jan".getBytes(), "Feb".getBytes(), "Mar".getBytes(), "Apr".getBytes(), "May".getBytes(), "Jun".getBytes(), "Jul".getBytes(), "Aug".getBytes(), "Sep".getBytes(), "Oct".getBytes(), "Nov".getBytes(), "Dec".getBytes()};
    private static final byte[][] twoDigits = new byte[][]{"00".getBytes(), "01".getBytes(), "02".getBytes(), "03".getBytes(), "04".getBytes(), "05".getBytes(), "06".getBytes(), "07".getBytes(), "08".getBytes(), "09".getBytes(), "10".getBytes(), "11".getBytes(), "12".getBytes(), "13".getBytes(), "14".getBytes(), "15".getBytes(), "16".getBytes(), "17".getBytes(), "18".getBytes(), "19".getBytes(), "20".getBytes(), "21".getBytes(), "22".getBytes(), "23".getBytes(), "24".getBytes(), "25".getBytes(), "26".getBytes(), "27".getBytes(), "28".getBytes(), "29".getBytes(), "30".getBytes(), "31".getBytes(), "32".getBytes(), "33".getBytes(), "34".getBytes(), "35".getBytes(), "36".getBytes(), "37".getBytes(), "38".getBytes(), "39".getBytes(), "40".getBytes(), "41".getBytes(), "42".getBytes(), "43".getBytes(), "44".getBytes(), "45".getBytes(), "46".getBytes(), "47".getBytes(), "48".getBytes(), "49".getBytes(), "50".getBytes(), "51".getBytes(), "52".getBytes(), "53".getBytes(), "54".getBytes(), "55".getBytes(), "56".getBytes(), "57".getBytes(), "58".getBytes(), "59".getBytes(), "60".getBytes(), "61".getBytes(), "62".getBytes(), "63".getBytes(), "64".getBytes(), "65".getBytes(), "66".getBytes(), "67".getBytes(), "68".getBytes(), "69".getBytes(), "70".getBytes(), "71".getBytes(), "72".getBytes(), "73".getBytes(), "74".getBytes(), "75".getBytes(), "76".getBytes(), "77".getBytes(), "78".getBytes(), "79".getBytes(), "80".getBytes(), "81".getBytes(), "82".getBytes(), "83".getBytes(), "84".getBytes(), "85".getBytes(), "86".getBytes(), "87".getBytes(), "88".getBytes(), "89".getBytes(), "90".getBytes(), "91".getBytes(), "92".getBytes(), "93".getBytes(), "94".getBytes(), "95".getBytes(), "96".getBytes(), "97".getBytes(), "98".getBytes(), "99".getBytes()};
    private static final byte[] ERROR_CODE_100 = "100".getBytes();
    private static final byte[] ERROR_CODE_200 = "200".getBytes();
    private static final byte[] ERROR_CODE_302 = "302".getBytes();
    private static final byte[] ERROR_CODE_304 = "304".getBytes();
    private static final byte[] ERROR_CODE_400 = "400".getBytes();
    private static final byte[] ERROR_CODE_401 = "401".getBytes();
    private static final byte[] ERROR_CODE_404 = "404".getBytes();
    private static final byte[] ERROR_CODE_500 = "500".getBytes();
    private static final byte[] SPACE_DASH_SPACE = " - ".getBytes();
    private static final DateOnlyDateFormat dateFormat = new DateOnlyDateFormat();
    private static final DateOnlyDateFormat gmtDateFormat = new DateOnlyDateFormat(GMT);
    private static final TimeOnlyDateFormat timeFormat = new TimeOnlyDateFormat();
    private static final TimeOnlyDateFormat gmtTimeFormat = new TimeOnlyDateFormat(GMT);
    private static final TimeFormatWithMillis millisTimeFormat = new TimeFormatWithMillis();
    private static final TimeFormatWithMillis gmtMillisTimeFormat = new TimeFormatWithMillis(GMT);
    private byte[] value;
    private int size = 0;
    private int capacity;
    private boolean useGMT = false;
    private boolean logMillis = false;

    public FormatStringBuffer() {
        this(128);
    }

    public FormatStringBuffer(int n) {
        this.value = new byte[n];
        this.capacity = n;
    }

    public void setUseGMT(boolean bl) {
        this.useGMT = bl;
    }

    public void setLogMillis(boolean bl) {
        this.logMillis = bl;
    }

    public FormatStringBuffer append(String string) {
        if (string == null || string.length() == 0) {
            return this;
        }
        byte[] byArray = string.getBytes();
        int n = this.size + byArray.length;
        this.ensureCapacity(n);
        System.arraycopy(byArray, 0, this.value, this.size, byArray.length);
        this.size = n;
        return this;
    }

    public FormatStringBuffer append(int n) {
        this.ensureCapacity(this.size + 11);
        if (n < 0) {
            this.value[this.size++] = 45;
        }
        if (n == 0) {
            this.value[this.size++] = 48;
        }
        if (n > 0) {
            n = -n;
        }
        for (int i = 1000000000; i > 0; i /= 10) {
            int n2 = n / i;
            if (n2 == 0) continue;
            int n3 = -(n2 % 10);
            this.value[this.size++] = (byte)(48 + n3);
        }
        return this;
    }

    public FormatStringBuffer append(byte by) {
        int n = this.size + 1;
        this.ensureCapacity(n);
        this.value[this.size] = by;
        this.size = n;
        return this;
    }

    public FormatStringBuffer append(byte[] byArray) {
        return this.append(byArray, 0, byArray.length);
    }

    public FormatStringBuffer append(byte[] byArray, int n, int n2) {
        int n3 = this.size + n2;
        this.ensureCapacity(n3);
        System.arraycopy(byArray, n, this.value, this.size, n2);
        this.size = n3;
        return this;
    }

    private void appendInLoop(byte[] byArray) {
        int n = byArray.length;
        int n2 = this.size + n;
        this.ensureCapacity(n2);
        for (int i = 0; i < n; ++i) {
            this.value[this.size + i] = byArray[i];
        }
        this.size = n2;
    }

    public FormatStringBuffer appendValueOrEmpty(String string) {
        if (string != null) {
            return this.append(string);
        }
        return this;
    }

    public FormatStringBuffer appendTwoDigits(int n) {
        this.appendInLoop(twoDigits[n]);
        return this;
    }

    public FormatStringBuffer appendValueOrDash(String string) {
        if (string != null) {
            return this.append(string);
        }
        return this.append('-');
    }

    public FormatStringBuffer append(char c) {
        return this.append((byte)c);
    }

    public FormatStringBuffer appendSpaceDashSpace() {
        this.appendInLoop(SPACE_DASH_SPACE);
        return this;
    }

    public FormatStringBuffer appendQuotedValueOrDash(String string) {
        if (string != null) {
            return this.append('\"').append(string).append('\"');
        }
        return this.append('-');
    }

    public FormatStringBuffer appendStatusCode(int n) {
        switch (n) {
            case 100: {
                this.appendInLoop(ERROR_CODE_100);
                break;
            }
            case 200: {
                this.appendInLoop(ERROR_CODE_200);
                break;
            }
            case 302: {
                this.appendInLoop(ERROR_CODE_302);
                break;
            }
            case 304: {
                this.appendInLoop(ERROR_CODE_304);
                break;
            }
            case 400: {
                this.appendInLoop(ERROR_CODE_400);
                break;
            }
            case 401: {
                this.appendInLoop(ERROR_CODE_401);
                break;
            }
            case 404: {
                this.appendInLoop(ERROR_CODE_404);
                break;
            }
            case 500: {
                this.appendInLoop(ERROR_CODE_500);
                break;
            }
            default: {
                this.append(n);
            }
        }
        return this;
    }

    public byte[] getBytes() {
        return this.value;
    }

    public int size() {
        return this.size;
    }

    public FormatStringBuffer appendMonth(int n) {
        this.appendInLoop(monthNames[n]);
        return this;
    }

    public FormatStringBuffer appendYear(int n) {
        if (n >= 100) {
            this.appendInLoop(twoDigits[20]);
            this.appendInLoop(twoDigits[n % 100]);
        } else {
            this.appendInLoop(twoDigits[19]);
            this.appendInLoop(twoDigits[n]);
        }
        return this;
    }

    public FormatStringBuffer appendDate() {
        if (this.useGMT) {
            this.appendInLoop(gmtDateFormat.getDateAsBytes(System.currentTimeMillis()));
        } else {
            this.appendInLoop(dateFormat.getDateAsBytes(System.currentTimeMillis()));
        }
        return this;
    }

    public FormatStringBuffer appendTime() {
        if (this.useGMT) {
            if (this.logMillis) {
                this.appendInLoop(gmtMillisTimeFormat.getDateAsBytes(System.currentTimeMillis()));
            } else {
                this.appendInLoop(gmtTimeFormat.getDateAsBytes(System.currentTimeMillis()));
            }
        } else if (this.logMillis) {
            this.appendInLoop(millisTimeFormat.getDateAsBytes(System.currentTimeMillis()));
        } else {
            this.appendInLoop(timeFormat.getDateAsBytes(System.currentTimeMillis()));
        }
        return this;
    }

    private void ensureCapacity(int n) {
        if (this.capacity >= n) {
            return;
        }
        int n2 = this.capacity * 2;
        if (n > n2) {
            n2 = n;
        }
        byte[] byArray = new byte[n2];
        System.arraycopy(this.value, 0, byArray, 0, this.size);
        this.value = byArray;
        this.capacity = n2;
    }

    private static class TimeFormatWithMillis {
        private Date date = new Date();
        private SimpleDateFormat format = new SimpleDateFormat("HH:mm:ss.SSS");

        TimeFormatWithMillis() {
            this(TimeZone.getDefault());
        }

        TimeFormatWithMillis(TimeZone timeZone) {
            this.format.setTimeZone(timeZone);
        }

        byte[] getDateAsBytes(long l) {
            this.date.setTime(l);
            return this.format.format(this.date).getBytes();
        }
    }

    private static class TimeOnlyDateFormat
    extends SimpleCachingDateFormat {
        private final byte[] cachedBytes = new byte[8];
        private String cachedString;

        TimeOnlyDateFormat() {
            super("HH:mm:ss");
        }

        TimeOnlyDateFormat(TimeZone timeZone) {
            super("HH:mm:ss", timeZone);
        }

        byte[] getDateAsBytes(long l) {
            String string = super.getDate(l);
            if (string != this.cachedString) {
                this.cachedString = string;
                string.getBytes(0, 8, this.cachedBytes, 0);
            }
            return this.cachedBytes;
        }
    }

    private static class DateOnlyDateFormat
    extends SimpleCachingDateFormat {
        private final byte[] cachedBytes = new byte[10];
        private String cachedString;

        DateOnlyDateFormat() {
            super("yyyy-MM-dd");
        }

        DateOnlyDateFormat(TimeZone timeZone) {
            super("yyyy-MM-dd", timeZone);
        }

        byte[] getDateAsBytes(long l) {
            String string = super.getDate(l);
            if (string != this.cachedString) {
                this.cachedString = string;
                string.getBytes(0, 10, this.cachedBytes, 0);
            }
            return this.cachedBytes;
        }
    }
}

