/*
 * Decompiled with CFR 0.152.
 */
package weblogic.servlet.logging;

import weblogic.protocol.ServerChannel;
import weblogic.servlet.logging.FormatStringBuffer;
import weblogic.servlet.logging.HttpAccountingInfo;
import weblogic.servlet.logging.LogField;

public final class HostLogField
implements LogField {
    private int type;
    private int prefix;

    HostLogField(String string, String string2) {
        this.type = "ip".equals(string2) ? 5 : ("dns".equals(string2) ? 6 : 0);
        this.prefix = "c".equals(string) ? 1 : ("s".equals(string) ? 2 : 0);
    }

    public void logField(HttpAccountingInfo httpAccountingInfo, FormatStringBuffer formatStringBuffer) {
        ServerChannel serverChannel = httpAccountingInfo.getServerChannel();
        String string = serverChannel.getInetAddress().getHostName();
        String string2 = serverChannel.getAddress() + ":" + serverChannel.getPublicPort();
        if (this.type == 0 || this.prefix == 0) {
            formatStringBuffer.appendValueOrDash(null);
        }
        if (this.prefix == 1) {
            switch (this.type) {
                case 5: {
                    formatStringBuffer.appendValueOrDash(httpAccountingInfo.getRemoteAddr());
                    return;
                }
                case 6: {
                    formatStringBuffer.appendValueOrDash(httpAccountingInfo.getRemoteHost());
                    return;
                }
            }
        } else if (this.prefix == 2) {
            switch (this.type) {
                case 5: {
                    formatStringBuffer.appendValueOrDash(string2);
                    return;
                }
                case 6: {
                    formatStringBuffer.appendValueOrDash(string);
                    return;
                }
            }
        }
        formatStringBuffer.appendValueOrDash(null);
    }
}

