/*
 * Decompiled with CFR 0.152.
 */
package weblogic.servlet.logging;

import com.bea.logging.LogFileConfigBean;
import com.bea.logging.RotatingFileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import weblogic.diagnostics.debug.DebugLogger;
import weblogic.logging.LogFileConfigUtil;
import weblogic.management.configuration.WebServerMBean;
import weblogic.servlet.HTTPLogger;
import weblogic.servlet.internal.ServletRequestImpl;
import weblogic.servlet.internal.ServletResponseImpl;
import weblogic.servlet.logging.CLFLogger;
import weblogic.servlet.logging.ELFLogger;
import weblogic.servlet.logging.Logger;

public final class LogManagerHttp {
    private static final DebugLogger DEBUG_LOGGING = DebugLogger.getDebugLogger((String)"DebugHttpLogging");
    private final WebServerMBean mbean;
    private HttpRotatingFileOutputStream outputStream;
    private Logger logger;
    private boolean isExtendedFormat = false;
    private boolean rotateLog = false;
    private boolean logInternalAppAccess = Boolean.getBoolean("weblogic.servlet.logging.LogInternalAppAccess");

    public LogManagerHttp(WebServerMBean webServerMBean) {
        this.mbean = webServerMBean;
        if (!this.mbean.getWebServerLog().isLoggingEnabled()) {
            HTTPLogger.logHttpLoggingDisabled((String)this.mbean.getName());
            return;
        }
    }

    private HttpRotatingFileOutputStream getLogOutputStream() {
        try {
            return new HttpRotatingFileOutputStream(LogFileConfigUtil.getLogFileConfig(this.mbean.getWebServerLog()));
        }
        catch (IOException iOException) {
            if (DEBUG_LOGGING.isDebugEnabled()) {
                DEBUG_LOGGING.debug("Failed to create HttpRotatingFileOutputStream for the webserver: " + this.mbean.getName(), (Throwable)iOException);
            }
            iOException.printStackTrace();
            return null;
        }
    }

    public void start() {
        this.initLoggers();
    }

    private void initLoggers() {
        if (!"extended".equals(this.mbean.getWebServerLog().getLogFileFormat())) {
            if (DEBUG_LOGGING.isDebugEnabled()) {
                DEBUG_LOGGING.debug("Creating CLFLogger for the webserver: " + this.mbean.getName());
            }
            this.logger = new CLFLogger(this, this.mbean);
        } else {
            if (DEBUG_LOGGING.isDebugEnabled()) {
                DEBUG_LOGGING.debug("Creating ELFLogger for the webserver: " + this.mbean.getName());
            }
            this.isExtendedFormat = true;
            this.logger = new ELFLogger(this, this.mbean);
        }
        this.outputStream = this.getLogOutputStream();
        this.outputStream.setLogger(this.logger);
        this.mbean.getWebServerLog().setOutputStream((OutputStream)((Object)this.outputStream));
        try {
            if (this.rotateLog) {
                this.outputStream.forceRotation();
                this.rotateLog = false;
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    protected void rotateLog() throws IOException {
        this.rotateLog = true;
    }

    public void close() {
        try {
            if (this.outputStream != null) {
                this.outputStream.close();
            }
        }
        catch (IOException iOException) {
            if (DEBUG_LOGGING.isDebugEnabled()) {
                DEBUG_LOGGING.debug("Failed to close HttpRotatingFileOutputStream for the webserver: " + this.mbean.getName(), (Throwable)iOException);
            }
            iOException.printStackTrace();
        }
    }

    public void log(ServletRequestImpl servletRequestImpl, ServletResponseImpl servletResponseImpl) {
        if (!this.mbean.getWebServerLog().isLoggingEnabled() || this.logger == null || this.outputStream == null || servletRequestImpl.getContext() != null && servletRequestImpl.getContext().getConfigManager().isAccessLoggingDisabled() && !this.logInternalAppAccess) {
            return;
        }
        this.logger.log(servletRequestImpl, servletResponseImpl);
    }

    OutputStream getLogStream() {
        return this.outputStream;
    }

    public boolean isExtendedFormat() {
        return this.isExtendedFormat;
    }

    class HttpRotatingFileOutputStream
    extends RotatingFileOutputStream {
        private Logger logger;

        HttpRotatingFileOutputStream(LogFileConfigBean logFileConfigBean) throws IOException {
            super(logFileConfigBean);
            this.logger = null;
        }

        void setLogger(Logger logger) {
            this.logger = logger;
        }

        public synchronized void forceRotation() throws IOException {
            super.forceRotation();
            this.logger.markRotated();
        }
    }
}

