/*
 * Decompiled with CFR 0.152.
 */
package weblogic.servlet.logging;

import java.io.File;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.management.InvalidAttributeValueException;
import weblogic.management.DistributedManagementException;
import weblogic.management.DomainDir;
import weblogic.management.configuration.DomainMBean;
import weblogic.management.configuration.ServerMBean;
import weblogic.management.configuration.VirtualHostMBean;
import weblogic.management.configuration.WebServerLogMBean;
import weblogic.management.configuration.WebServerMBean;
import weblogic.management.provider.ConfigurationProcessor;
import weblogic.management.provider.UpdateException;
import weblogic.servlet.logging.ELFLogger;

public final class LogMigrationProcessor
implements ConfigurationProcessor {
    private static final SimpleDateFormat OLD_FORMAT = new SimpleDateFormat("MM-dd-yyyy-k:mm:ss");
    private static final SimpleDateFormat NEW_FORMAT = new SimpleDateFormat("H:mm");

    public void updateConfiguration(DomainMBean domainMBean) throws UpdateException {
        VirtualHostMBean[] virtualHostMBeanArray;
        ServerMBean[] serverMBeanArray = domainMBean.getServers();
        if (serverMBeanArray != null && serverMBeanArray.length > 0) {
            for (int i = 0; i < serverMBeanArray.length; ++i) {
                try {
                    this.upgradeConfig(serverMBeanArray[i].getWebServer());
                    continue;
                }
                catch (InvalidAttributeValueException invalidAttributeValueException) {
                    throw new UpdateException(invalidAttributeValueException);
                }
                catch (DistributedManagementException distributedManagementException) {
                    throw new UpdateException(distributedManagementException);
                }
            }
        }
        if ((virtualHostMBeanArray = domainMBean.getVirtualHosts()) != null && virtualHostMBeanArray.length > 0) {
            for (int i = 0; i < virtualHostMBeanArray.length; ++i) {
                try {
                    this.upgradeConfig(virtualHostMBeanArray[i]);
                    continue;
                }
                catch (InvalidAttributeValueException invalidAttributeValueException) {
                    throw new UpdateException(invalidAttributeValueException);
                }
                catch (DistributedManagementException distributedManagementException) {
                    throw new UpdateException(distributedManagementException);
                }
            }
        }
    }

    private void upgradeConfig(WebServerMBean webServerMBean) throws InvalidAttributeValueException, DistributedManagementException {
        String[] stringArray;
        Object object;
        WebServerLogMBean webServerLogMBean = webServerMBean.getWebServerLog();
        if (webServerMBean.isSet("LoggingEnabled")) {
            webServerLogMBean.setLoggingEnabled(webServerMBean.isLoggingEnabled());
        }
        if (webServerMBean.isSet("LogFileFormat")) {
            webServerLogMBean.setLogFileFormat(webServerMBean.getLogFileFormat());
        }
        if (webServerMBean.isSet("LogTimeInGMT")) {
            webServerLogMBean.setLogTimeInGMT(webServerMBean.getLogTimeInGMT());
        }
        if (webServerMBean.isSet("LogFileName")) {
            webServerLogMBean.setFileName(webServerMBean.getLogFileName());
        }
        if (webServerMBean.isSet("LogRotationType")) {
            object = webServerMBean.getLogRotationType();
            if (object == null || ((String)object).equalsIgnoreCase("size")) {
                object = "bySize";
            } else if (((String)object).equalsIgnoreCase("date")) {
                object = "byTime";
            }
            webServerLogMBean.setRotationType((String)object);
        }
        if (webServerMBean.isSet("LogRotationTimeBegin")) {
            try {
                object = webServerMBean.getLogRotationTimeBegin();
                if (object != null || ((String)object).length() > 0) {
                    stringArray = LogMigrationProcessor.convertLogRotationTimeBegin((String)object);
                    webServerLogMBean.setRotationTime((String)stringArray);
                }
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        if (webServerMBean.isSet("LogRotationPeriodMins")) {
            webServerLogMBean.setFileTimeSpan(webServerMBean.getLogRotationPeriodMins() / 60);
        }
        if (webServerMBean.isSet("LogFileLimitEnabled")) {
            webServerLogMBean.setNumberOfFilesLimited(webServerMBean.isLogFileLimitEnabled());
        }
        if (webServerMBean.isSet("LogFileCount")) {
            webServerLogMBean.setFileCount(webServerMBean.getLogFileCount());
        }
        if (webServerMBean.isSet("MaxLogFileSizeKBytes")) {
            if (webServerMBean.getMaxLogFileSizeKBytes() == 0) {
                webServerLogMBean.setRotationType("none");
            } else {
                webServerLogMBean.setFileMinSize(webServerMBean.getMaxLogFileSizeKBytes());
            }
        }
        if (webServerLogMBean.getFileMinSize() < 1) {
            webServerLogMBean.setRotationType("none");
        }
        try {
            object = new File(DomainDir.getRootDir() + File.separatorChar + webServerMBean.getLogFileName());
            if (!webServerMBean.isSet("LogFileName") && !((File)(object = new File(DomainDir.getRootDir() + File.separatorChar + webServerMBean.getName() + File.separatorChar + "access.log"))).exists()) {
                object = new File(DomainDir.getRootDir() + File.separatorChar + "access.log");
            }
            if ("extended".equals(webServerMBean.getLogFileFormat()) && ((File)object).exists() && (stringArray = ELFLogger.readELFFields(((File)object).getPath())) != null && stringArray[1] != null) {
                webServerLogMBean.setELFFields(stringArray[1]);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static final String convertLogRotationTimeBegin(String string) throws ParseException {
        Date date = OLD_FORMAT.parse(string);
        return NEW_FORMAT.format(date);
    }
}

