/*
 * Decompiled with CFR 0.152.
 */
package weblogic.servlet.logging;

import weblogic.servlet.logging.FormatStringBuffer;
import weblogic.servlet.logging.HttpAccountingInfo;
import weblogic.servlet.logging.LogField;

public final class TimeLogField
implements LogField {
    private int type;

    TimeLogField(String string) {
        this.type = "time".equals(string) ? 1 : ("time-taken".equals(string) ? 2 : ("date".equals(string) ? 3 : ("bytes".equals(string) ? 4 : 0)));
    }

    public void logField(HttpAccountingInfo httpAccountingInfo, FormatStringBuffer formatStringBuffer) {
        switch (this.type) {
            case 0: {
                formatStringBuffer.appendValueOrDash(null);
                return;
            }
            case 2: {
                long l = System.currentTimeMillis() - httpAccountingInfo.getInvokeTime();
                Float f = new Float((double)l / 1000.0);
                formatStringBuffer.append(f.toString());
                return;
            }
            case 4: {
                formatStringBuffer.append(httpAccountingInfo.getResponseContentLength());
                return;
            }
            case 1: {
                formatStringBuffer.appendTime();
                return;
            }
            case 3: {
                formatStringBuffer.appendDate();
                return;
            }
        }
    }
}

