/*
 * Decompiled with CFR 0.152.
 */
package weblogic.servlet.logging;

import java.nio.ByteBuffer;
import weblogic.servlet.logging.FormatStringBuffer;
import weblogic.servlet.logging.HttpAccountingInfo;
import weblogic.servlet.logging.LogField;
import weblogic.utils.http.HttpReasonPhraseCoder;

public final class URILogField
implements LogField {
    private int type;

    URILogField(String string, String string2) {
        this.type = "uri".equals(string2) ? 9 : ("uri-stem".equals(string2) ? 10 : ("uri-query".equals(string2) ? 11 : ("method".equals(string2) ? 8 : ("status".equals(string2) ? 7 : ("comment".equals(string2) ? 12 : 0)))));
    }

    public void logField(HttpAccountingInfo httpAccountingInfo, FormatStringBuffer formatStringBuffer) {
        switch (this.type) {
            case 0: {
                formatStringBuffer.appendValueOrDash(null);
                break;
            }
            case 9: {
                ByteBuffer byteBuffer = httpAccountingInfo.getURIAsBytes();
                int n = byteBuffer.position();
                int n2 = byteBuffer.limit() - byteBuffer.position();
                if (byteBuffer != null) {
                    formatStringBuffer.append(byteBuffer.array(), n, n2);
                    break;
                }
                formatStringBuffer.append("-");
                break;
            }
            case 11: {
                formatStringBuffer.appendValueOrDash(httpAccountingInfo.getQueryString());
                break;
            }
            case 10: {
                if (httpAccountingInfo.getRequestURI() != null) {
                    formatStringBuffer.append(httpAccountingInfo.getRequestURI());
                    break;
                }
                formatStringBuffer.append("-");
                break;
            }
            case 8: {
                formatStringBuffer.appendValueOrDash(httpAccountingInfo.getMethod());
                break;
            }
            case 7: {
                formatStringBuffer.appendValueOrDash(String.valueOf(httpAccountingInfo.getResponseStatusCode()));
                break;
            }
            case 12: {
                formatStringBuffer.appendQuotedValueOrDash(HttpReasonPhraseCoder.getReasonPhrase((int)httpAccountingInfo.getResponseStatusCode()));
                break;
            }
        }
    }
}

