/*
 * Decompiled with CFR 0.152.
 */
package weblogic.servlet.proxy;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.CharArrayWriter;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.net.Socket;
import java.net.SocketException;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Properties;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import weblogic.security.SSL.SSLContext;
import weblogic.security.SSL.SSLSocketFactory;
import weblogic.security.internal.SerializedSystemIni;
import weblogic.security.internal.encryption.ClearOrEncryptedService;
import weblogic.security.internal.encryption.EncryptionService;
import weblogic.servlet.internal.ChunkInput;
import weblogic.servlet.internal.NakedTimerListenerBase;
import weblogic.servlet.internal.ServletRequestImpl;
import weblogic.servlet.internal.ServletResponseImpl;
import weblogic.servlet.internal.WebAppServletContext;
import weblogic.servlet.proxy.HalfOpenSocketRetryException;
import weblogic.servlet.proxy.WriteClientIOException;
import weblogic.timers.Timer;
import weblogic.timers.TimerListener;
import weblogic.utils.StringUtils;
import weblogic.utils.encoders.BASE64Encoder;
import weblogic.utils.io.Chunk;
import weblogic.version;

abstract class GenericProxyServlet
extends HttpServlet {
    public static final String EOL = "\r\n";
    private static final String HEADER_SEPARATOR = ": ";
    private static final String HEADER_KEEP_ALIVE = "Connection: Keep-Alive\r\n";
    public static final String WEBLOGIC_BRIDGE_CONFIG_INFO = "__WebLogicBridgeConfig";
    private WebAppServletContext servletContext;
    public static final int MAX_POST_IN_MEMORY = Chunk.CHUNK_SIZE;
    protected String destHost;
    protected int destPort;
    protected String pathTrim;
    protected String pathPrepend;
    protected String defaultFileName;
    protected String trimExt;
    protected boolean verbose;
    protected boolean debugConfigInfo;
    protected boolean keepAliveEnabled;
    protected int keepAliveSecs;
    protected boolean isSecureProxy;
    protected String keyStore;
    protected String keyStoreType;
    protected String privateKeyAlias;
    protected String keyStorePasswordProperties;
    protected int socketTimeout;
    protected int maxPostSize = -1;
    protected boolean wlProxySSL;
    protected boolean wlProxySSLPassThrough = false;
    protected boolean wlProxyPassThrough = false;
    protected String cookieName;
    protected String wlCookieName;
    protected String logFileName;
    protected String httpVersion;
    protected boolean fileCaching;
    protected ProxyConnectionPool connPool;
    protected boolean inited = false;
    protected Object syncObj = new Object();
    private PrintStream out;
    private EncryptionService es = null;
    private ClearOrEncryptedService ces = null;
    private String encryptedKeyStorePasswd = null;
    private String encryptedPrivateKeyPasswd = null;

    GenericProxyServlet() {
    }

    public void init(ServletConfig servletConfig) throws ServletException {
        Object object;
        Object object2;
        if (this.inited) {
            return;
        }
        super.init(servletConfig);
        this.servletContext = (WebAppServletContext)servletConfig.getServletContext();
        this.destHost = this.getInitParameter("WebLogicHost");
        String string = this.getInitParameter("WebLogicPort");
        if (string != null) {
            this.destPort = Integer.parseInt(string);
        }
        this.pathTrim = this.getInitParameter("PathTrim");
        if (this.pathTrim == null) {
            this.pathTrim = this.getInitParameter("pathTrim");
        }
        if (this.pathTrim != null && this.pathTrim.charAt(0) != '/') {
            this.pathTrim = "/" + this.pathTrim;
        }
        this.defaultFileName = this.getInitParameter("DefaultFileName");
        if (this.defaultFileName != null && this.defaultFileName.charAt(0) != '/') {
            this.defaultFileName = "/" + this.defaultFileName;
        }
        this.pathPrepend = this.getInitParameter("PathPrepend");
        if (this.pathPrepend == null) {
            this.pathPrepend = this.getInitParameter("pathPrepend");
        }
        if (this.pathPrepend != null && this.pathPrepend.charAt(0) != '/') {
            this.pathPrepend = "/" + this.pathPrepend;
        }
        this.trimExt = this.getInitParameter("trimExt");
        if (this.trimExt == null) {
            this.trimExt = this.getInitParameter("TrimExt");
        }
        if (this.trimExt != null && this.trimExt.charAt(0) != '.') {
            this.trimExt = "." + this.trimExt;
        }
        string = this.getInitParameter("FileCaching");
        this.fileCaching = GenericProxyServlet.isTrue(string, true);
        string = this.getInitParameter("Debug");
        if (string == null) {
            string = this.getInitParameter("verbose");
        }
        this.verbose = GenericProxyServlet.isTrue(string, false);
        string = this.getInitParameter("DebugConfigInfo");
        this.debugConfigInfo = GenericProxyServlet.isTrue(string, false);
        string = this.getInitParameter("KeepAliveEnabled");
        this.keepAliveEnabled = GenericProxyServlet.isTrue(string, true);
        string = this.getInitParameter("KeepAliveSecs");
        this.keepAliveSecs = string == null ? 20 : Integer.parseInt(string);
        string = this.getInitParameter("WLIOTimeoutSecs");
        this.socketTimeout = string == null ? 300 : Integer.parseInt(string);
        if (string == null && (string = this.getInitParameter("HungServerRecoverSecs")) != null) {
            this.socketTimeout = Integer.parseInt(string);
        }
        string = this.getInitParameter("SecureProxy");
        this.isSecureProxy = GenericProxyServlet.isTrue(string, false);
        if (this.isSecureProxy) {
            this.keyStore = this.getInitParameter("KeyStore");
            this.keyStoreType = this.getInitParameter("KeyStoreType");
            this.privateKeyAlias = this.getInitParameter("PrivateKeyAlias");
            this.keyStorePasswordProperties = this.getInitParameter("KeyStorePasswordProperties");
            if (this.keyStorePasswordProperties != null) {
                this.es = SerializedSystemIni.getExistingEncryptionService();
                this.ces = new ClearOrEncryptedService(this.es);
                object2 = this.servletContext.getResourceAsStream(this.keyStorePasswordProperties);
                try {
                    object = new Properties();
                    ((Properties)object).load((InputStream)object2);
                    this.encryptedKeyStorePasswd = ((Properties)object).getProperty("KeyStorePassword");
                    this.encryptedPrivateKeyPasswd = ((Properties)object).getProperty("PrivateKeyPassword");
                }
                catch (IOException iOException) {
                    throw new ServletException("Cannot load keyStorePasswordProperties");
                }
            }
        }
        if ((string = this.getInitParameter("MaxPostSize")) != null) {
            this.maxPostSize = Integer.parseInt(string);
        }
        this.cookieName = this.getInitParameter("CookieName");
        if (this.cookieName == null) {
            this.cookieName = this.getInitParameter("cookieName");
        }
        this.wlCookieName = this.getInitParameter("WLCookieName");
        if (this.wlCookieName == null) {
            this.wlCookieName = this.cookieName;
        }
        if (this.wlCookieName == null) {
            this.wlCookieName = "JSESSIONID";
        }
        this.logFileName = this.getInitParameter("WLLogFile");
        if (this.logFileName != null) {
            object2 = new File(this.logFileName);
        } else {
            object = System.getProperty("os.name");
            object2 = object != null && ((String)object).startsWith("Windows") ? new File("c:/temp/wlproxy.log") : new File("/tmp/wlproxy.log");
            ((File)object2).getParentFile().mkdirs();
        }
        try {
            this.out = new PrintStream(new FileOutputStream((File)object2, true));
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new ServletException("Cannot open file: " + ((File)object2).getAbsolutePath(), (Throwable)fileNotFoundException);
        }
        string = this.getInitParameter("WLProxySSL");
        this.wlProxySSL = GenericProxyServlet.isTrue(string, false);
        string = this.getInitParameter("WLProxySSLPassThrough");
        this.wlProxySSLPassThrough = GenericProxyServlet.isTrue(string, false);
        string = this.getInitParameter("WLProxyPassThrough");
        this.wlProxyPassThrough = GenericProxyServlet.isTrue(string, false);
        this.initConnectionPool();
        if (this.cookieName != null) {
            this.trace("Warning: CookieName is deprecated and replaced by WLCookieName");
        }
        if (this.verbose) {
            this.trace("GenericProxyServelt: init()");
        }
        this.inited = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void service(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        String string = httpServletRequest.getQueryString();
        if (string != null && this.debugConfigInfo && string.equals(WEBLOGIC_BRIDGE_CONFIG_INFO)) {
            this.printConfigInfo(httpServletResponse.getWriter());
            return;
        }
        int n = 1;
        ProxyConnection proxyConnection = null;
        PostDataCache postDataCache = new PostDataCache();
        postDataCache.readPostData(httpServletRequest);
        if (postDataCache.error) {
            if (this.verbose) {
                this.trace("Failed to read the post data.");
            }
            postDataCache.release();
            throw new IOException("Invalid Post");
        }
        try {
            while (true) {
                CharArrayWriter charArrayWriter;
                try {
                    proxyConnection = n != 0 ? this.connPool.getProxyConnection(this.destHost, this.destPort, this.isSecureProxy, this.socketTimeout) : this.connPool.getNewProxyConnection(this.destHost, this.destPort, this.isSecureProxy, this.socketTimeout);
                    this.sendRequest(httpServletRequest, proxyConnection, postDataCache);
                    this.sendResponse(httpServletRequest, httpServletResponse, proxyConnection);
                    this.connPool.requeue(proxyConnection);
                }
                catch (HalfOpenSocketRetryException halfOpenSocketRetryException) {
                    this.connPool.remove(proxyConnection);
                    if (this.verbose) {
                        charArrayWriter = new CharArrayWriter();
                        halfOpenSocketRetryException.printStackTrace(new PrintWriter(charArrayWriter));
                        this.trace(charArrayWriter.toString());
                    }
                    if (n-- > 0) {
                        if (!this.verbose) continue;
                        this.trace("Doing retry.");
                        continue;
                    }
                    if (!httpServletResponse.isCommitted()) {
                        httpServletResponse.sendError(503, "Unable to connect to server");
                    }
                }
                catch (WriteClientIOException writeClientIOException) {
                    this.connPool.remove(proxyConnection);
                }
                catch (IOException iOException) {
                    if (proxyConnection != null) {
                        this.connPool.remove(proxyConnection);
                        if (!httpServletResponse.isCommitted()) {
                            httpServletResponse.sendError(500, "Internal Server Error");
                        }
                    } else {
                        httpServletResponse.sendError(503, "Unable to connect to server");
                    }
                    if (this.verbose) {
                        charArrayWriter = new CharArrayWriter();
                        iOException.printStackTrace(new PrintWriter(charArrayWriter));
                        this.trace(charArrayWriter.toString());
                    }
                }
                break;
            }
        }
        finally {
            postDataCache.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        if (this.connPool == null) {
            return;
        }
        Object object = this.syncObj;
        synchronized (object) {
            if (this.connPool == null) {
                return;
            }
            this.connPool.destroy();
            this.connPool = null;
        }
    }

    protected static boolean isTrue(String string, boolean bl) {
        if (string == null) {
            return bl;
        }
        return string.equalsIgnoreCase("ON") || string.equalsIgnoreCase("true");
    }

    protected void trace(String string) {
        StringBuilder stringBuilder = new StringBuilder(512);
        Date date = new Date(System.currentTimeMillis());
        stringBuilder.append("<");
        stringBuilder.append(date.toString());
        stringBuilder.append(">");
        stringBuilder.append(' ').append('<');
        stringBuilder.append(Thread.currentThread().getName());
        stringBuilder.append('>');
        stringBuilder.append(HEADER_SEPARATOR);
        stringBuilder.append(string);
        String string2 = stringBuilder.toString();
        this.out.println(string2);
        this.out.flush();
    }

    protected void printConfigInfo(PrintWriter printWriter) {
        printWriter.write("<HTML><TITLE>WEBLOGIC PROXY DEBUG INFO</TITLE>");
        printWriter.write("<FONT FACE=\"Tahoma\">");
        printWriter.write("<BODY>Query String: __WebLogicBridgeConfig");
        printWriter.write("<BR><BR><B>WebLogicHost:</B> <FONT COLOR=\"#0000ff\">" + this.destHost + "</FONT>");
        printWriter.write("<BR><B>WebLogicPort:</B> <FONT COLOR=\"#0000ff\">" + this.destPort + "</FONT>");
        if (this.cookieName != null) {
            printWriter.write("<BR><B>CookieName: </B><font color=#0000ff> deprecated</font>");
        }
        printWriter.write("<BR><B>WLCookieName: </B>" + this.wlCookieName);
        printWriter.write("<BR><B>Debug: </B>" + this.verbose);
        printWriter.write("<BR><B>DebugConfigInfo: </B>" + this.debugConfigInfo);
        printWriter.write("<BR><B>DefaultFileName: </B>" + this.defaultFileName);
        printWriter.write("<BR><B>FileCaching: </B>" + this.fileCaching);
        printWriter.write("<BR><B>WLIOTimeoutSecs: </B>" + this.socketTimeout);
        printWriter.write("<BR><B>KeepAliveEnabled: </B>" + this.keepAliveEnabled);
        printWriter.write("<BR><B>KeepAliveSecs: </B>" + this.keepAliveSecs);
        printWriter.write("<BR><B>MaxPostSize: </B>" + this.maxPostSize);
        printWriter.write("<BR><B>PathPrepend: </B>" + this.pathPrepend);
        printWriter.write("<BR><B>PathTrim: </B>" + this.pathTrim);
        printWriter.write("<BR><B>TrimExt: </B>" + this.trimExt);
        printWriter.write("<BR><B>SecureProxy: </B>" + this.isSecureProxy);
        if (this.isSecureProxy) {
            printWriter.write("<BR><B>KeyStore: </B>" + this.keyStore);
            printWriter.write("<BR><B>KeyStoreType: </B>" + this.keyStoreType);
            printWriter.write("<BR><B>PrivateKeyAlias: </B>" + this.privateKeyAlias);
            printWriter.write("<BR><B>KeyStorePasswordProperties: </B>" + this.keyStorePasswordProperties);
        }
        printWriter.write("<BR><B>WLLogFile: </B>" + this.logFileName);
        printWriter.write("<BR><B>WLProxySSL: </B>" + this.wlProxySSL);
        printWriter.write("<BR><B>WLProxySSLPassThrough: </B>" + this.wlProxySSLPassThrough);
        printWriter.write("<BR><B>WLProxyPassThrough: </B>" + this.wlProxyPassThrough);
        printWriter.write("<BR>_____________________________________________________");
        printWriter.write("<BR><BR>Last Modified: " + version.getBuildVersion());
        printWriter.write("</BODY></HTML>");
        printWriter.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initConnectionPool() {
        if (this.connPool != null) {
            return;
        }
        Object object = this.syncObj;
        synchronized (object) {
            if (this.connPool != null) {
                return;
            }
            this.connPool = new ProxyConnectionPool(50);
        }
    }

    public void sendRequest(HttpServletRequest httpServletRequest, ProxyConnection proxyConnection) throws IOException {
        this.sendRequest(httpServletRequest, proxyConnection, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendRequest(HttpServletRequest httpServletRequest, ProxyConnection proxyConnection, PostDataCache postDataCache) throws IOException {
        InputStream inputStream;
        block19: {
            String string = this.resolveRequest(httpServletRequest);
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(proxyConnection.getSocket().getOutputStream());
            PrintStream printStream = new PrintStream(bufferedOutputStream);
            inputStream = null;
            if (postDataCache != null) {
                inputStream = postDataCache.getInputStream();
            }
            Chunk chunk = null;
            try {
                String string2;
                InputStream inputStream2;
                printStream.print(string);
                this.sendRequestHeaders(httpServletRequest, printStream, null, null);
                int n = httpServletRequest.getContentLength();
                InputStream inputStream3 = inputStream2 = inputStream != null ? inputStream : httpServletRequest.getInputStream();
                if (n > 0) {
                    int n2;
                    chunk = Chunk.getChunk();
                    while ((n2 = inputStream2.read(chunk.buf, 0, chunk.buf.length)) != -1) {
                        try {
                            bufferedOutputStream.write(chunk.buf, 0, n2);
                            bufferedOutputStream.flush();
                        }
                        catch (SocketException socketException) {
                            if (postDataCache != null && postDataCache.type != 0) {
                                throw new HalfOpenSocketRetryException(socketException);
                            }
                        }
                        catch (IOException iOException) {
                            throw iOException;
                        }
                        if ((n -= n2) >= 1) continue;
                    }
                    if (n != 0) {
                        throw new IOException("Failed to read " + httpServletRequest.getContentLength() + " bytes from the inputStream");
                    }
                } else if (n == -1 && (string2 = httpServletRequest.getHeader("Transfer-Encoding")) != null && string2.equalsIgnoreCase("Chunked")) {
                    throw new IOException("Can't process chunked request.");
                }
                if (chunk == null) break block19;
            }
            catch (Throwable throwable) {
                if (chunk != null) {
                    Chunk.releaseChunk(chunk);
                }
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
            Chunk.releaseChunk((Chunk)chunk);
        }
        if (inputStream != null) {
            try {
                inputStream.close();
            }
            catch (IOException iOException) {}
        }
    }

    protected void sendRequestHeaders(HttpServletRequest httpServletRequest, PrintStream printStream, Object object, Object object2) {
        if (this.verbose) {
            this.trace("In-bound headers: ");
        }
        StringBuilder stringBuilder = new StringBuilder(256);
        Enumeration enumeration = httpServletRequest.getHeaderNames();
        HashSet<String> hashSet = new HashSet<String>();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            if (this.ignoreHeader(string) || hashSet.contains(string)) continue;
            hashSet.add(string);
            Enumeration enumeration2 = httpServletRequest.getHeaders(string);
            while (enumeration2.hasMoreElements()) {
                stringBuilder.append(string).append(HEADER_SEPARATOR).append((String)enumeration2.nextElement());
                if (this.verbose) {
                    this.trace(stringBuilder.toString());
                }
                stringBuilder.append(EOL);
                printStream.print(stringBuilder.toString());
                stringBuilder.delete(0, stringBuilder.length());
            }
        }
        printStream.print(HEADER_KEEP_ALIVE);
        this.addRequestHeaders(httpServletRequest, printStream, object, object2);
        printStream.print(EOL);
        printStream.flush();
    }

    private boolean ignoreHeader(String string) {
        if ("Expect".equalsIgnoreCase(string)) {
            return true;
        }
        if ("Transfer-Encoding".equalsIgnoreCase(string)) {
            return true;
        }
        if ("Connection".equalsIgnoreCase(string)) {
            return true;
        }
        if (("Proxy-Remote-User".equalsIgnoreCase(string) || "Proxy-Auth-Type".equalsIgnoreCase(string)) && !this.wlProxyPassThrough) {
            return true;
        }
        return "WL-Proxy-SSL".equalsIgnoreCase(string);
    }

    protected void addRequestHeaders(HttpServletRequest httpServletRequest, PrintStream printStream, Object object, Object object2) {
        X509Certificate[] x509CertificateArray;
        StringBuilder stringBuilder = new StringBuilder(21);
        stringBuilder.append("WL-Proxy-SSL").append(HEADER_SEPARATOR);
        if ("https".equalsIgnoreCase(httpServletRequest.getScheme())) {
            stringBuilder.append("true");
        } else if (this.wlProxySSLPassThrough) {
            x509CertificateArray = httpServletRequest.getHeader("WL-Proxy-SSL");
            if (x509CertificateArray == null) {
                stringBuilder.append(this.wlProxySSL ? "true" : "false");
            } else {
                stringBuilder.append(GenericProxyServlet.isTrue((String)x509CertificateArray, false) ? "true" : "false");
            }
        } else {
            stringBuilder.append(this.wlProxySSL ? "true" : "false");
        }
        stringBuilder.append(EOL);
        printStream.print(stringBuilder.toString());
        if (this.pathTrim != null) {
            printStream.print("WL-PATH-TRIM: " + this.pathTrim);
            printStream.print(EOL);
        }
        if (this.pathPrepend != null) {
            printStream.print("WL-PATH-PREPEND: " + this.pathPrepend);
            printStream.print(EOL);
        }
        printStream.print("X-WebLogic-KeepAliveSecs: " + (this.keepAliveSecs + 10));
        printStream.print(EOL);
        x509CertificateArray = (X509Certificate[])httpServletRequest.getAttribute("javax.servlet.request.X509Certificate");
        if (x509CertificateArray != null) {
            block14: {
                printStream.print("WL-Proxy-Client-Cert: ");
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                try {
                    for (int i = 0; i < x509CertificateArray.length; ++i) {
                        byteArrayOutputStream.write(x509CertificateArray[i].getEncoded());
                    }
                    byte[] byArray = byteArrayOutputStream.toByteArray();
                    new BASE64Encoder().encodeBuffer((InputStream)new ByteArrayInputStream(byArray), (OutputStream)printStream);
                }
                catch (CertificateEncodingException certificateEncodingException) {
                    if (this.verbose) {
                        CharArrayWriter charArrayWriter = new CharArrayWriter();
                        certificateEncodingException.printStackTrace(new PrintWriter(charArrayWriter));
                        this.trace("Error while dumping ssl certificate to ByteArrayOutputStream : " + charArrayWriter.toString());
                    }
                }
                catch (IOException iOException) {
                    if (!this.verbose) break block14;
                    CharArrayWriter charArrayWriter = new CharArrayWriter();
                    iOException.printStackTrace(new PrintWriter(charArrayWriter));
                    this.trace("Error while encoding ssl certificate : " + charArrayWriter.toString());
                }
            }
            printStream.print(EOL);
        }
        printStream.print("WL-Proxy-Client-IP: " + httpServletRequest.getRemoteAddr());
        printStream.print(EOL);
    }

    protected int readStatus(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, DataInputStream dataInputStream) throws IOException {
        return this.readStatus(httpServletRequest, httpServletResponse, dataInputStream, false);
    }

    protected int readStatus(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, DataInputStream dataInputStream, boolean bl) throws IOException {
        int n;
        String string = null;
        try {
            string = dataInputStream.readLine();
        }
        catch (SocketException socketException) {
            if (bl) {
                throw new HalfOpenSocketRetryException(socketException);
            }
        }
        catch (IOException iOException) {
            throw iOException;
        }
        if (string == null) {
            if (bl) {
                throw new HalfOpenSocketRetryException("status line is null");
            }
            throw new IOException("status line is null");
        }
        if (this.verbose) {
            this.trace(string);
        }
        try {
            String[] stringArray = StringUtils.splitCompletely((String)string, (String)" ");
            n = Integer.parseInt(stringArray[1]);
            httpServletResponse.setStatus(n);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new IOException("malformed status line");
        }
        return n;
    }

    public void sendResponse(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, ProxyConnection proxyConnection) throws IOException {
        DataInputStream dataInputStream = new DataInputStream(new BufferedInputStream(proxyConnection.getSocket().getInputStream(), 100));
        int n = this.readStatus(httpServletRequest, httpServletResponse, dataInputStream, proxyConnection.canRecycle());
        int n2 = this.sendResponseHeaders(httpServletResponse, dataInputStream, proxyConnection, null);
        if (n == 100) {
            n = this.readStatus(httpServletRequest, httpServletResponse, dataInputStream);
            n2 = this.sendResponseHeaders(httpServletResponse, dataInputStream, proxyConnection, null);
        }
        if (n == 204 || n == 304 || n2 == 0 || "HEAD".equalsIgnoreCase(httpServletRequest.getMethod())) {
            return;
        }
        ServletOutputStream servletOutputStream = httpServletResponse.getOutputStream();
        if (n2 == -9999) {
            if (ChunkInput.readCTE((OutputStream)servletOutputStream, (InputStream)dataInputStream) == -1) {
                proxyConnection.setCanRecycle(false);
            }
        } else {
            this.readAndWriteResponseData(dataInputStream, (OutputStream)servletOutputStream, n2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void readAndWriteResponseData(DataInputStream dataInputStream, OutputStream outputStream, int n) throws IOException {
        boolean bl = true;
        Chunk chunk = Chunk.getChunk();
        try {
            int n2;
            if (n > 0) {
                int n3;
                int n4 = n;
                while ((n3 = dataInputStream.read(chunk.buf, 0, Math.min(n4, chunk.buf.length))) != -1) {
                    if (bl) {
                        try {
                            outputStream.write(chunk.buf, 0, n3);
                        }
                        catch (IOException iOException) {
                            bl = false;
                            throw new WriteClientIOException("Error in writing to client");
                        }
                    }
                    if ((n4 -= n3) >= 1) continue;
                }
                if (n4 == 0) return;
                throw new IOException("Failed to read " + n + " bytes from the inputStream");
            }
            while ((n2 = dataInputStream.read(chunk.buf)) != -1) {
                if (!bl) continue;
                try {
                    outputStream.write(chunk.buf, 0, n2);
                    outputStream.flush();
                }
                catch (IOException iOException) {
                    bl = false;
                    throw new WriteClientIOException("Error in writing to client");
                    return;
                }
            }
        }
        finally {
            Chunk.releaseChunk((Chunk)chunk);
        }
    }

    protected int sendResponseHeaders(HttpServletResponse httpServletResponse, DataInputStream dataInputStream, ProxyConnection proxyConnection, Object object) throws IOException {
        String string;
        int n = -1;
        boolean bl = false;
        if (this.verbose) {
            this.trace("Out-bound headers: ");
        }
        while ((string = dataInputStream.readLine()) != null && string.length() > 0) {
            dataInputStream.mark(1);
            int n2 = dataInputStream.read();
            dataInputStream.reset();
            if (n2 == 32 || n2 == 9) {
                do {
                    string = string + EOL + dataInputStream.readLine();
                    dataInputStream.mark(1);
                    n2 = dataInputStream.read();
                    dataInputStream.reset();
                } while (n2 == 32 || n2 == 9);
            }
            String[] stringArray = StringUtils.split((String)string, (char)':');
            String string2 = stringArray[0].trim();
            String string3 = stringArray[1].trim();
            if (this.verbose) {
                this.trace(string2 + HEADER_SEPARATOR + string3);
            }
            if (string2.equalsIgnoreCase("Set-Cookie")) {
                httpServletResponse.addHeader(string2, string3);
                continue;
            }
            if (string2.equalsIgnoreCase("Transfer-Encoding") && string3.equalsIgnoreCase("chunked")) {
                n = -9999;
                continue;
            }
            if (string2.equalsIgnoreCase("Content-Length")) {
                if (n != -9999) {
                    n = Integer.parseInt(string3);
                }
                if (httpServletResponse instanceof ServletResponseImpl) {
                    ((ServletResponseImpl)httpServletResponse).setHeaderInternal(string2, string3);
                    continue;
                }
                httpServletResponse.setHeader(string2, string3);
                continue;
            }
            if (string2.equalsIgnoreCase("connection")) {
                if (string3.equalsIgnoreCase("close")) {
                    proxyConnection.setCanRecycle(false);
                    ServletResponseImpl servletResponseImpl = null;
                    servletResponseImpl = httpServletResponse instanceof ServletResponseImpl ? (ServletResponseImpl)httpServletResponse : ServletResponseImpl.getOriginalResponse((ServletResponse)httpServletResponse);
                    servletResponseImpl.disableKeepAlive();
                    continue;
                }
                bl = true;
                proxyConnection.setCanRecycle(true);
                continue;
            }
            if (string2.equalsIgnoreCase("X-WebLogic-KeepAliveSecs")) {
                try {
                    int n3 = Integer.parseInt(string3);
                    if (this.keepAliveSecs <= n3 - 10) continue;
                    this.keepAliveSecs = n3 - 10;
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.addResponseHeaders(httpServletResponse, string2, string3, object);
        }
        return n;
    }

    protected void addResponseHeaders(HttpServletResponse httpServletResponse, String string, String string2, Object object) {
        if (httpServletResponse instanceof ServletResponseImpl) {
            ((ServletResponseImpl)httpServletResponse).addHeaderInternal(string, string2);
        } else {
            httpServletResponse.addHeader(string, string2);
        }
    }

    protected String resolveRequest(HttpServletRequest httpServletRequest) {
        int n;
        int n2;
        String string = (String)httpServletRequest.getAttribute("javax.servlet.include.request_uri");
        if (string == null) {
            string = httpServletRequest.getRequestURI();
        }
        if (this.trimExt != null && (n2 = string.indexOf(this.trimExt)) > -1) {
            n = string.toLowerCase().indexOf(";" + this.wlCookieName.toLowerCase() + "=");
            string = n != -1 ? string.substring(0, n2) + string.substring(n) : string.substring(0, n2);
        }
        if (this.pathTrim != null && (n2 = string.indexOf(this.pathTrim)) > -1) {
            n = this.pathTrim.length();
            string = string.substring(0, n2) + string.substring(n2 + n);
        }
        if ((string.length() == 0 || string.equals("/")) && this.defaultFileName != null) {
            string = string + this.defaultFileName;
        }
        string = this.pathPrepend == null ? string : this.pathPrepend + string;
        String string2 = httpServletRequest.getQueryString();
        ServletRequestImpl servletRequestImpl = ServletRequestImpl.getOriginalRequest((ServletRequest)httpServletRequest);
        String string3 = servletRequestImpl.getSessionHelper().getEncodedSessionID();
        if (string3 != null) {
            string = string + ";" + this.wlCookieName + "=" + string3;
        }
        if (string2 != null && !string2.equals("")) {
            string = string + "?" + string2;
        }
        StringBuilder stringBuilder = new StringBuilder(256);
        stringBuilder.append(httpServletRequest.getMethod());
        stringBuilder.append(" ");
        stringBuilder.append(string);
        stringBuilder.append(" ");
        if (this.httpVersion != null) {
            stringBuilder.append("HTTP/");
            stringBuilder.append(this.httpVersion);
        } else {
            stringBuilder.append(httpServletRequest.getProtocol());
        }
        stringBuilder.append(EOL);
        String string4 = stringBuilder.toString();
        if (this.verbose) {
            this.trace("===New Request===" + string4);
        }
        return string4;
    }

    protected Chunk readPostDataToMemory(HttpServletRequest httpServletRequest, int n) throws IOException {
        Chunk chunk = Chunk.getChunk();
        try {
            Chunk.chunk((Chunk)chunk, (InputStream)httpServletRequest.getInputStream(), (int)n);
        }
        catch (IOException iOException) {
            Chunk.releaseChunks((Chunk)chunk);
            throw iOException;
        }
        if (this.verbose) {
            StringBuilder stringBuilder = new StringBuilder(100);
            stringBuilder.append("Declared content-length = ");
            stringBuilder.append(n);
            stringBuilder.append("; Actually read ");
            stringBuilder.append(Chunk.size((Chunk)chunk));
            this.trace(stringBuilder.toString());
        }
        if (n != Chunk.size((Chunk)chunk)) {
            Chunk.releaseChunks((Chunk)chunk);
            return null;
        }
        return chunk;
    }

    protected File readPostDataToFile(HttpServletRequest httpServletRequest, int n) throws IOException {
        File file = null;
        FileOutputStream fileOutputStream = null;
        Chunk chunk = Chunk.getChunk();
        try {
            file = File.createTempFile("proxy", null, null);
            if (file == null) {
                File file2 = null;
                return file2;
            }
            fileOutputStream = new FileOutputStream(file);
            ServletInputStream servletInputStream = httpServletRequest.getInputStream();
            while (n > 0) {
                int n2 = servletInputStream.read(chunk.buf, 0, chunk.buf.length);
                if (n2 < 0) {
                    StringBuilder stringBuilder;
                    if (this.verbose) {
                        stringBuilder = new StringBuilder(100);
                        stringBuilder.append("Declared content-length = ");
                        stringBuilder.append(n);
                        stringBuilder.append("; Actually read ");
                        stringBuilder.append(n2);
                        this.trace(stringBuilder.toString());
                    }
                    try {
                        if (fileOutputStream != null) {
                            fileOutputStream.close();
                        }
                        if (file != null) {
                            file.delete();
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    stringBuilder = null;
                    return stringBuilder;
                }
                fileOutputStream.write(chunk.buf, 0, n2);
                n -= n2;
            }
            fileOutputStream.flush();
            fileOutputStream.close();
        }
        catch (IOException iOException) {
            try {
                if (fileOutputStream != null) {
                    fileOutputStream.close();
                }
                if (file != null) {
                    file.delete();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw iOException;
        }
        finally {
            Chunk.releaseChunk((Chunk)chunk);
        }
        return file;
    }

    class PostDataCache {
        protected static final int NO_CACHE = 0;
        protected static final int MEMORY_CACHE = 1;
        protected static final int FILE_CACHE = 2;
        protected int type = 0;
        protected boolean error;
        private Chunk postData;
        private File postDataFile;
        private boolean alreadyRead;

        PostDataCache() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void readPostData(HttpServletRequest httpServletRequest) {
            if (!this.alreadyRead) {
                int n = httpServletRequest.getContentLength();
                try {
                    if (GenericProxyServlet.this.maxPostSize > 0 && n > GenericProxyServlet.this.maxPostSize) {
                        if (GenericProxyServlet.this.verbose) {
                            GenericProxyServlet.this.trace("Content Length exceeded the MaxPostSize: " + GenericProxyServlet.this.maxPostSize);
                        }
                        this.error = true;
                    } else if (n > 0 && n <= MAX_POST_IN_MEMORY) {
                        this.type = 1;
                        this.postData = GenericProxyServlet.this.readPostDataToMemory(httpServletRequest, n);
                        if (this.postData == null) {
                            this.error = true;
                        }
                    } else if (n > MAX_POST_IN_MEMORY && GenericProxyServlet.this.fileCaching) {
                        this.type = 2;
                        this.postDataFile = GenericProxyServlet.this.readPostDataToFile(httpServletRequest, n);
                        if (this.postDataFile == null) {
                            this.error = true;
                        }
                    }
                }
                catch (IOException iOException) {
                    this.error = true;
                    if (GenericProxyServlet.this.verbose) {
                        CharArrayWriter charArrayWriter = new CharArrayWriter();
                        iOException.printStackTrace(new PrintWriter(charArrayWriter));
                        GenericProxyServlet.this.trace("Failed to read post data: " + charArrayWriter.toString());
                    }
                }
                finally {
                    this.alreadyRead = true;
                }
            }
        }

        public InputStream getInputStream() throws IOException {
            if (this.error) {
                return null;
            }
            InputStream inputStream = null;
            switch (this.type) {
                case 0: {
                    break;
                }
                case 1: {
                    inputStream = new ByteArrayInputStream(this.postData.buf, 0, this.postData.end);
                    break;
                }
                case 2: {
                    inputStream = new FileInputStream(this.postDataFile);
                    break;
                }
            }
            return inputStream;
        }

        public void release() {
            switch (this.type) {
                case 0: {
                    break;
                }
                case 1: {
                    Chunk.releaseChunks((Chunk)this.postData);
                    break;
                }
                case 2: {
                    if (this.postDataFile == null) break;
                    if (GenericProxyServlet.this.verbose) {
                        GenericProxyServlet.this.trace("Remove temp file: " + this.postDataFile.getAbsolutePath());
                    }
                    this.postDataFile.delete();
                    break;
                }
            }
        }
    }

    class ProxyConnectionPool
    extends NakedTimerListenerBase {
        private Timer timer;
        private ArrayList pool;

        ProxyConnectionPool(int n) {
            super("ProxyConnectionPool", GenericProxyServlet.this.servletContext);
            this.pool = new ArrayList(n);
            this.startTimer();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void destroy() {
            if (GenericProxyServlet.this.verbose) {
                GenericProxyServlet.this.trace("Destroy the connection pool");
            }
            this.stopTimer();
            ArrayList arrayList = this.pool;
            synchronized (arrayList) {
                for (int i = this.pool.size() - 1; i >= 0; --i) {
                    ProxyConnection proxyConnection = (ProxyConnection)this.pool.get(i);
                    proxyConnection.close();
                    this.pool.remove(i);
                }
            }
            GenericProxyServlet.this.out.close();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void remove(ProxyConnection proxyConnection) {
            if (proxyConnection == null) {
                return;
            }
            proxyConnection.close();
            if (GenericProxyServlet.this.keepAliveEnabled) {
                if (GenericProxyServlet.this.verbose) {
                    GenericProxyServlet.this.trace("Remove connection from pool: " + proxyConnection);
                }
                ArrayList arrayList = this.pool;
                synchronized (arrayList) {
                    this.pool.remove(proxyConnection);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void requeue(ProxyConnection proxyConnection) {
            if (!proxyConnection.canRecycle()) {
                if (GenericProxyServlet.this.verbose) {
                    GenericProxyServlet.this.trace("Close connection: " + proxyConnection);
                }
                this.remove(proxyConnection);
                return;
            }
            if (GenericProxyServlet.this.keepAliveEnabled) {
                ArrayList arrayList = this.pool;
                synchronized (arrayList) {
                    if (GenericProxyServlet.this.verbose) {
                        GenericProxyServlet.this.trace("Requeue connection: " + proxyConnection);
                    }
                    proxyConnection.setLastUsed(System.currentTimeMillis());
                    this.pool.add(proxyConnection);
                }
            } else {
                proxyConnection.close();
            }
        }

        ProxyConnection getNewProxyConnection(String string, int n, boolean bl, int n2) throws IOException {
            ProxyConnection proxyConnection = new ProxyConnection(string, n, bl, n2);
            if (GenericProxyServlet.this.verbose) {
                GenericProxyServlet.this.trace("Create connection: " + proxyConnection);
            }
            return proxyConnection;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ProxyConnection getProxyConnection(String string, int n, boolean bl, int n2) throws IOException {
            if (GenericProxyServlet.this.keepAliveEnabled) {
                ArrayList arrayList = this.pool;
                synchronized (arrayList) {
                    long l = 0L;
                    long l2 = 0L;
                    for (int i = 0; i < this.pool.size(); ++i) {
                        ProxyConnection proxyConnection = (ProxyConnection)this.pool.get(i);
                        if (n != proxyConnection.getPort() || !string.equals(proxyConnection.getHost())) continue;
                        this.pool.remove(i);
                        --i;
                        l = System.currentTimeMillis();
                        l2 = l - proxyConnection.getLastUsed();
                        if (l2 > (long)proxyConnection.getKeepAliveMilliSecs()) {
                            if (GenericProxyServlet.this.verbose) {
                                GenericProxyServlet.this.trace("Remove idle for '" + l2 / 1000L + "' secs: " + proxyConnection);
                            }
                            proxyConnection.close();
                            continue;
                        }
                        if (GenericProxyServlet.this.verbose) {
                            GenericProxyServlet.this.trace("Returning recycled connection: " + proxyConnection);
                        }
                        return proxyConnection;
                    }
                }
            }
            return this.getNewProxyConnection(string, n, bl, n2);
        }

        public ProxyConnection getProxyConnection(String string, int n, boolean bl) throws IOException {
            return this.getProxyConnection(string, n, bl, 300);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void timerExpired(Timer timer) {
            if (!GenericProxyServlet.this.keepAliveEnabled) {
                return;
            }
            ArrayList arrayList = this.pool;
            synchronized (arrayList) {
                long l = System.currentTimeMillis();
                for (int i = this.pool.size() - 1; i >= 0; --i) {
                    ProxyConnection proxyConnection = (ProxyConnection)this.pool.get(i);
                    long l2 = proxyConnection.getLastUsed();
                    long l3 = l - l2;
                    if (l3 <= (long)proxyConnection.getKeepAliveMilliSecs()) continue;
                    if (GenericProxyServlet.this.verbose) {
                        GenericProxyServlet.this.trace("Trigger remove idle for '" + l3 / 1000L + "' secs: " + proxyConnection);
                    }
                    proxyConnection.close();
                    this.pool.remove(i);
                }
            }
        }

        private void stopTimer() {
            this.timer.cancel();
            this.timerManager.stop();
        }

        private void startTimer() {
            this.timer = this.timerManager.schedule((TimerListener)this, 0L, 10000L);
        }
    }

    class ProxyConnection {
        private Socket sock;
        private boolean isSecure;
        private int timeout;
        private String host;
        private int port;
        private boolean closed = true;
        private long lastUsed = 0L;
        private boolean canRecycle = true;
        private int keep_alive_millisecs;

        public ProxyConnection(String string, int n, boolean bl, int n2) throws IOException {
            this.host = string;
            this.port = n;
            this.isSecure = bl;
            this.timeout = n2 * 1000;
            this.setKeepAliveMilliSecs(GenericProxyServlet.this.keepAliveSecs * 1000);
            if (bl) {
                try {
                    Object object;
                    SSLContext sSLContext = SSLContext.getInstance("https");
                    if (GenericProxyServlet.this.keyStore != null && GenericProxyServlet.this.privateKeyAlias != null && GenericProxyServlet.this.es != null) {
                        object = GenericProxyServlet.this.keyStoreType == null ? KeyStore.getInstance(KeyStore.getDefaultType()) : KeyStore.getInstance(GenericProxyServlet.this.keyStoreType);
                        String string2 = null;
                        if (GenericProxyServlet.this.encryptedKeyStorePasswd != null) {
                            string2 = GenericProxyServlet.this.ces.decrypt(GenericProxyServlet.this.encryptedKeyStorePasswd);
                        }
                        ((KeyStore)object).load(GenericProxyServlet.this.servletContext.getResourceAsStream(GenericProxyServlet.this.keyStore), string2 != null ? string2.toCharArray() : null);
                        String string3 = null;
                        if (GenericProxyServlet.this.encryptedPrivateKeyPasswd != null) {
                            string3 = GenericProxyServlet.this.ces.decrypt(GenericProxyServlet.this.encryptedPrivateKeyPasswd);
                        }
                        PrivateKey privateKey = (PrivateKey)((KeyStore)object).getKey(GenericProxyServlet.this.privateKeyAlias, string3 != null ? string3.toCharArray() : null);
                        Certificate[] certificateArray = ((KeyStore)object).getCertificateChain(GenericProxyServlet.this.privateKeyAlias);
                        sSLContext.loadLocalIdentity(certificateArray, privateKey);
                    }
                    object = sSLContext.getSocketFactory();
                    this.sock = ((SSLSocketFactory)object).createSocket(string, n);
                }
                catch (Exception exception) {
                    throw (IOException)new IOException(exception.getMessage()).initCause(exception);
                }
            } else {
                this.sock = new Socket(string, n);
            }
            this.sock.setSoTimeout(this.timeout);
            this.sock.setTcpNoDelay(true);
            this.closed = false;
        }

        public ProxyConnection(String string, int n, boolean bl) throws IOException {
            this(string, n, bl, 300);
        }

        public void close() {
            if (this.closed) {
                return;
            }
            try {
                this.sock.close();
                this.closed = true;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        public Socket getSocket() {
            return this.sock;
        }

        public int getTimeout() {
            return this.timeout;
        }

        public void setTimeout(int n) {
            this.timeout = n * 1000;
            try {
                this.sock.setSoTimeout(this.timeout);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        public String getHost() {
            return this.host;
        }

        public int getPort() {
            return this.port;
        }

        public void setLastUsed(long l) {
            this.lastUsed = l;
        }

        public long getLastUsed() {
            return this.lastUsed;
        }

        public void setCanRecycle(boolean bl) {
            this.canRecycle = bl;
        }

        public boolean canRecycle() {
            return this.canRecycle;
        }

        public void setKeepAliveMilliSecs(int n) {
            this.keep_alive_millisecs = n;
        }

        public int getKeepAliveMilliSecs() {
            return this.keep_alive_millisecs;
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder(256);
            stringBuilder.append("ProxyConnection");
            stringBuilder.append("(isSecureProxy=");
            stringBuilder.append(this.isSecure);
            stringBuilder.append("):  ");
            stringBuilder.append(this.host);
            stringBuilder.append(":");
            stringBuilder.append(this.port);
            stringBuilder.append(", keep-alive='");
            stringBuilder.append(this.keep_alive_millisecs / 1000);
            stringBuilder.append("'secs");
            return stringBuilder.toString();
        }
    }
}

