/*
 * Decompiled with CFR 0.152.
 */
package weblogic.servlet.proxy;

import java.rmi.RemoteException;
import javax.naming.Context;
import javax.naming.NamingException;
import weblogic.jndi.Environment;
import weblogic.servlet.proxy.HealthCheck;
import weblogic.servlet.proxy.ServerManager;
import weblogic.timers.NakedTimerListener;
import weblogic.timers.Timer;
import weblogic.timers.TimerListener;
import weblogic.timers.TimerManagerFactory;
import weblogic.utils.Debug;
import weblogic.work.WorkManagerFactory;

public final class HealthCheckTrigger
implements NakedTimerListener {
    private static final boolean DEBUG = true;
    private final Environment env;
    private final String host;
    private final String port;
    private final String toStringMsg;
    private Context ctx;
    private HealthCheck healthCheck;
    private int healthCheckInterval;
    private int healthCheckFailureCount = 0;
    private int maxHealthCheckInterval;
    private int maxRetriesCount = 0;
    private int maxRetries = 3;
    private int serverID = -1;
    private int originalHealthCheckInterval;

    public HealthCheckTrigger(String string, String string2, int n, int n2, int n3) {
        this.healthCheckInterval = n * 1000;
        this.maxHealthCheckInterval = n3 * 1000;
        this.host = string;
        this.port = string2;
        this.maxRetries = n2;
        this.env = new Environment();
        this.env.setProviderUrl("t3://" + string + ":" + string2);
        TimerManagerFactory.getTimerManagerFactory().getTimerManager("HTTPProxy", WorkManagerFactory.getInstance().getSystem()).schedule((TimerListener)this, (long)n);
        this.originalHealthCheckInterval = this.healthCheckInterval;
        this.toStringMsg = "Trigger for server running at host " + string + " and port " + string2;
    }

    synchronized void setHealthCheckInterval(int n) {
        this.healthCheckInterval = n < this.maxHealthCheckInterval ? n : this.maxHealthCheckInterval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void timerExpired(Timer timer) {
        block10: {
            try {
                try {
                    if (this.healthCheck == null) {
                        this.createConnection();
                    }
                    this.healthCheck.ping();
                    this.reset();
                }
                catch (NamingException namingException) {
                    ++this.healthCheckFailureCount;
                    Object var4_3 = null;
                    if (this.healthCheckFailureCount > this.maxRetries) {
                        this.healthCheckFailureCount = this.maxRetries;
                        if (this.maxHealthCheckInterval == this.healthCheckInterval) return;
                        this.setHealthCheckInterval(this.maxRetriesCount++ * this.healthCheckInterval / 10 + this.healthCheckInterval);
                        return;
                    }
                    if (this.healthCheckFailureCount != this.maxRetries) return;
                    if (this.serverID == -1) return;
                    ServerManager.getServerManager().removeServer(this.serverID);
                    Debug.say((String)("REMOVED SERVER " + this.serverID));
                    this.serverID = -1;
                    this.healthCheck = null;
                    return;
                }
                catch (RemoteException remoteException) {
                    ++this.healthCheckFailureCount;
                    Object var4_4 = null;
                    if (this.healthCheckFailureCount > this.maxRetries) {
                        this.healthCheckFailureCount = this.maxRetries;
                        if (this.maxHealthCheckInterval == this.healthCheckInterval) return;
                        this.setHealthCheckInterval(this.maxRetriesCount++ * this.healthCheckInterval / 10 + this.healthCheckInterval);
                        return;
                    }
                    if (this.healthCheckFailureCount != this.maxRetries) return;
                    if (this.serverID == -1) return;
                    ServerManager.getServerManager().removeServer(this.serverID);
                    Debug.say((String)("REMOVED SERVER " + this.serverID));
                    this.serverID = -1;
                    this.healthCheck = null;
                    return;
                }
                Object var4_2 = null;
                if (this.healthCheckFailureCount <= this.maxRetries) break block10;
                this.healthCheckFailureCount = this.maxRetries;
                if (this.maxHealthCheckInterval == this.healthCheckInterval) return;
            }
            catch (Throwable throwable) {
                Object var4_5 = null;
                if (this.healthCheckFailureCount > this.maxRetries) {
                    this.healthCheckFailureCount = this.maxRetries;
                    if (this.maxHealthCheckInterval == this.healthCheckInterval) throw throwable;
                    this.setHealthCheckInterval(this.maxRetriesCount++ * this.healthCheckInterval / 10 + this.healthCheckInterval);
                    throw throwable;
                }
                if (this.healthCheckFailureCount != this.maxRetries) throw throwable;
                if (this.serverID == -1) throw throwable;
                ServerManager.getServerManager().removeServer(this.serverID);
                Debug.say((String)("REMOVED SERVER " + this.serverID));
                this.serverID = -1;
                this.healthCheck = null;
                throw throwable;
            }
            this.setHealthCheckInterval(this.maxRetriesCount++ * this.healthCheckInterval / 10 + this.healthCheckInterval);
            return;
        }
        if (this.healthCheckFailureCount != this.maxRetries) return;
        if (this.serverID == -1) return;
        ServerManager.getServerManager().removeServer(this.serverID);
        Debug.say((String)("REMOVED SERVER " + this.serverID));
        this.serverID = -1;
        this.healthCheck = null;
    }

    private void reset() {
        this.healthCheckFailureCount = 0;
        this.maxRetriesCount = 0;
    }

    private void createConnection() throws NamingException, RemoteException {
        this.ctx = this.env.getInitialContext();
        this.healthCheck = (HealthCheck)this.ctx.lookup("HealthCheck");
        this.serverID = this.healthCheck.getServerID();
        ServerManager.getServerManager().addServer(this.serverID, this.host, Integer.parseInt(this.port));
        this.reset();
        this.setHealthCheckInterval(this.originalHealthCheckInterval);
        Debug.say((String)("ADDED SERVER " + this.serverID));
    }

    public String toString() {
        return this.toStringMsg;
    }
}

