/*
 * Decompiled with CFR 0.152.
 */
package weblogic.servlet.proxy;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.CharArrayWriter;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeMap;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import weblogic.servlet.internal.ChunkInput;
import weblogic.servlet.internal.ServletRequestImpl;
import weblogic.servlet.proxy.GenericProxyServlet;
import weblogic.servlet.proxy.RoutingHandler;
import weblogic.servlet.proxy.WriteClientIOException;
import weblogic.utils.Hex;
import weblogic.utils.StringUtils;
import weblogic.utils.io.Chunk;
import weblogic.utils.io.ChunkedInputStream;
import weblogic.utils.io.NullInputStream;
import weblogic.version;

public final class HttpClusterServlet
extends GenericProxyServlet {
    private static final int DEFAULT_PORT = 80;
    private static final int DEFAULT_SSL_PORT = 443;
    public static final int MAX_POST_IN_MEMORY = Chunk.CHUNK_SIZE;
    protected int connectTimeoutSecs;
    protected int connectRetrySecs;
    protected int numOfRetries;
    protected boolean idempotent;
    protected boolean ignoreCookie;
    protected boolean useDynamicList;
    protected boolean crossOverProxyEnabled;
    protected int maxSkips = 0;
    protected long maxSkipTime = 0L;
    protected boolean proxyForConnectionResets;
    protected ServerList srvrList;
    protected Map allKnownServers;
    protected List<RoutingHandler> routingHandlers = new ArrayList<RoutingHandler>();
    private final List<ServerListListener> _serverListListeners = new ArrayList<ServerListListener>();

    public void init(ServletConfig servletConfig) throws ServletException {
        Object object;
        String string;
        super.init(servletConfig);
        if (this.verbose) {
            this.trace("HttpClusterServlet:init()");
        }
        if ((string = this.getInitParameter("WebLogicCluster")) == null) {
            string = this.getInitParameter("defaultServers");
        }
        if (string == null) {
            throw new ServletException("WebLogicCluster is not defined, cannot continue");
        }
        if (this.srvrList == null) {
            object = new ServerList(string, true);
            this.srvrList = object;
        }
        this.connectTimeoutSecs = (string = this.getInitParameter("ConnectTimeoutSecs")) == null ? 10 : Integer.parseInt(string);
        string = this.getInitParameter("ConnectRetrySecs");
        this.connectRetrySecs = string == null ? 2 : Integer.parseInt(string);
        string = this.getInitParameter("numOfRetries");
        this.numOfRetries = string == null ? this.connectTimeoutSecs / this.connectRetrySecs : Integer.parseInt(string);
        string = this.getInitParameter("Idempotent");
        this.idempotent = HttpClusterServlet.isTrue(string, true);
        string = this.getInitParameter("DisableCookie2Server");
        this.ignoreCookie = HttpClusterServlet.isTrue(string, false);
        string = this.getInitParameter("RoutingHandlerClassName");
        object = Thread.currentThread().getContextClassLoader();
        if (object == null) {
            object = ((Object)((Object)this)).getClass().getClassLoader();
        }
        if (string != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken().trim();
                try {
                    Class<?> clazz = ((ClassLoader)object).loadClass(string2);
                    RoutingHandler routingHandler = (RoutingHandler)clazz.newInstance();
                    routingHandler.init(this);
                    this.routingHandlers.add(routingHandler);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
        if (this.routingHandlers.isEmpty()) {
            string = this.getInitParameter("DynamicServerList");
            this.useDynamicList = HttpClusterServlet.isTrue(string, true);
        } else {
            this.useDynamicList = true;
        }
        string = this.getInitParameter("WLCrossOverProxyEnabled");
        this.crossOverProxyEnabled = HttpClusterServlet.isTrue(string, false);
        string = this.getInitParameter("MaxSkips");
        if (string != null) {
            this.maxSkips = Integer.parseInt(string);
            if (this.verbose) {
                this.trace("MaxSkips is deprecated and replaced by MaxSkipTime");
            }
        }
        this.maxSkipTime = (string = this.getInitParameter("MaxSkipTime")) != null ? (long)(Integer.parseInt(string) * 1000) : 10000L;
        string = this.getInitParameter("ProxyForConnectionResets");
        this.proxyForConnectionResets = HttpClusterServlet.isTrue(string, false);
        this.allKnownServers = HttpClusterServlet.createNewMap();
        this.srvrList.addToKnownServersList(this.allKnownServers);
        this.notifyServerListChange();
    }

    public void destroy() {
        for (RoutingHandler routingHandler : this.routingHandlers) {
            try {
                routingHandler.destroy();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        super.destroy();
    }

    public ServerList getServerList() {
        return this.srvrList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addServerListChangeListener(ServerListListener serverListListener) {
        List<ServerListListener> list = this._serverListListeners;
        synchronized (list) {
            if (!this._serverListListeners.contains(serverListListener)) {
                this._serverListListeners.add(serverListListener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeServerListChangeListener(ServerListListener serverListListener) {
        List<ServerListListener> list = this._serverListListeners;
        synchronized (list) {
            this._serverListListeners.remove(serverListListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyServerListChange() {
        ServerListListener[] serverListListenerArray = this._serverListListeners;
        synchronized (this._serverListListeners) {
            ServerListListener[] serverListListenerArray2 = this._serverListListeners.toArray(new ServerListListener[this._serverListListeners.size()]);
            // ** MonitorExit[var2_1] (shouldn't be in output)
            for (ServerListListener serverListListener : serverListListenerArray2) {
                try {
                    serverListListener.serverListChanged();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            return;
        }
    }

    private void notifyRoutingDecision(RequestInfo requestInfo, Server server) {
        Map<RoutingHandler, Object> map = requestInfo.getNotificationData();
        for (RoutingHandler routingHandler : map.keySet()) {
            Object object = map.get(routingHandler);
            routingHandler.notifyRoutingDecision(server, object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void service(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        ServerList serverList;
        Object object;
        RequestInfo requestInfo;
        Server server;
        block126: {
            ServerList serverList2;
            Object object2;
            block125: {
                ServerList serverList3;
                Object object3;
                block124: {
                    ServerList serverList4;
                    Object object4;
                    block123: {
                        ServerList serverList5;
                        Object object5;
                        block122: {
                            ServerList serverList6;
                            Object object6;
                            block121: {
                                ServerList serverList7;
                                Object object7;
                                boolean bl;
                                block118: {
                                    String string;
                                    block119: {
                                        block120: {
                                            GenericProxyServlet.ProxyConnection proxyConnection = null;
                                            server = null;
                                            requestInfo = new RequestInfo();
                                            try {
                                                requestInfo.setVerbose(this.verbose);
                                                requestInfo.setServerList(this.srvrList);
                                                requestInfo.setIsSecureNeeded(this.isSecureProxy);
                                                requestInfo.setCanFailover(this.idempotent);
                                                requestInfo.setRequest(this.resolveRequest(httpServletRequest));
                                                requestInfo.setPost(!httpServletRequest.getMethod().equalsIgnoreCase("GET") && !httpServletRequest.getMethod().equalsIgnoreCase("HEAD") && (httpServletRequest.getHeader("Content-Length") != null || httpServletRequest.getHeader("Transfer-Encoding") != null));
                                                if (!this.readPostData(requestInfo, httpServletRequest)) {
                                                    if (this.verbose) {
                                                        this.trace("Failed to read the post data.");
                                                    }
                                                    httpServletResponse.sendError(400, "Invalid Post");
                                                    Object var12_6 = null;
                                                    bl = false;
                                                    requestInfo.deletePostDataFile();
                                                    requestInfo.releasePostData();
                                                    string = requestInfo.getDynamicList();
                                                    if (string == null) break block118;
                                                    object7 = new ServerList(string, false);
                                                    if (this.useDynamicList) break block119;
                                                    if (this.srvrList.getHash() != null && this.srvrList.getHash().equals(requestInfo.getDynamicHash())) break block118;
                                                    serverList7 = this.srvrList;
                                                    break block120;
                                                }
                                                this.getPreferred(requestInfo, httpServletRequest);
                                                String string2 = httpServletRequest.getQueryString();
                                                if (string2 != null && this.debugConfigInfo && string2.equals("__WebLogicBridgeConfig")) {
                                                    this.printConfigInfo(requestInfo, httpServletResponse.getWriter());
                                                    break block121;
                                                }
                                                int n = 0;
                                                boolean bl2 = true;
                                                boolean bl3 = false;
                                                server = requestInfo.getPrimaryServer();
                                                if (server != null && server.isBad()) {
                                                    server = null;
                                                }
                                                if (this.verbose && server != null) {
                                                    this.trace("#### Trying to connect to the primary server:" + server);
                                                }
                                                while (proxyConnection == null) {
                                                    if (this.verbose) {
                                                        this.trace("attempt #" + n + " out of a max of " + this.numOfRetries);
                                                    }
                                                    if (server == null) {
                                                        server = requestInfo.getServerInList();
                                                        if (server == null) {
                                                            if (this.verbose) {
                                                                this.trace("=== whole list is bad, reverting to the all servers list ===");
                                                            }
                                                            requestInfo.revertToAllKnownServersList();
                                                            server = requestInfo.getServerInList();
                                                            if (server == null) break;
                                                            bl2 = false;
                                                            if (this.verbose) {
                                                                this.trace("#### Trying to connect with server " + server);
                                                            }
                                                        } else if (this.verbose) {
                                                            this.trace("#### Trying to connect with server " + server);
                                                        }
                                                    }
                                                    if ((proxyConnection = this.attemptConnect(requestInfo, server, httpServletRequest)) == null) {
                                                        if (!server.isBad()) {
                                                            if (this.verbose) {
                                                                this.trace("attemptConnect failed to read post data from client");
                                                            }
                                                            httpServletResponse.sendError(500, "Error reading post data");
                                                            break block122;
                                                        }
                                                        server = null;
                                                        bl2 = false;
                                                    } else {
                                                        this.notifyRoutingDecision(requestInfo, server);
                                                        proxyConnection = this.sendResponse(requestInfo, httpServletRequest, httpServletResponse, proxyConnection, server);
                                                        if (proxyConnection == null) {
                                                            if (!server.isBad()) {
                                                                if (this.verbose) {
                                                                    this.trace("sendResponse failed to write to client");
                                                                }
                                                                httpServletResponse.sendError(500, "Error writing response data");
                                                                break block123;
                                                            }
                                                            if (!requestInfo.canFailover()) {
                                                                if (this.verbose) {
                                                                    this.trace("sendResponse failed to read response from server and cannot failover");
                                                                }
                                                                httpServletResponse.sendError(500, "Error reading response data");
                                                                break block124;
                                                            }
                                                            if (this.verbose) {
                                                                this.trace("Error reading response code, or got 503. Trying next server");
                                                            }
                                                            server = null;
                                                            bl2 = false;
                                                        } else {
                                                            if (this.verbose) {
                                                                this.trace("Request successfully processed");
                                                            }
                                                            this.connPool.requeue(proxyConnection);
                                                            break block125;
                                                        }
                                                    }
                                                    if (n >= this.numOfRetries) {
                                                        if (!this.verbose) break;
                                                        this.trace("Tried all servers but didn't succeed");
                                                        break;
                                                    }
                                                    if (bl2) continue;
                                                    bl2 = true;
                                                    if (this.verbose) {
                                                        this.trace("Sleeping for " + this.connectRetrySecs + " secs .....");
                                                    }
                                                    try {
                                                        ++n;
                                                        Thread.sleep(this.connectRetrySecs * 1000);
                                                    }
                                                    catch (InterruptedException interruptedException) {}
                                                }
                                                if (proxyConnection == null) {
                                                    httpServletResponse.sendError(503, "No backend servers available");
                                                }
                                                break block126;
                                            }
                                            catch (Throwable throwable) {
                                                ServerList serverList8;
                                                Object object8;
                                                Object var12_13 = null;
                                                boolean bl4 = false;
                                                requestInfo.deletePostDataFile();
                                                requestInfo.releasePostData();
                                                String string3 = requestInfo.getDynamicList();
                                                if (string3 != null) {
                                                    object8 = new ServerList(string3, false);
                                                    if (!this.useDynamicList) {
                                                        if (this.srvrList.getHash() == null || !this.srvrList.getHash().equals(requestInfo.getDynamicHash())) {
                                                            serverList8 = this.srvrList;
                                                            synchronized (serverList8) {
                                                                if (this.srvrList.getHash() == null || !this.srvrList.getHash().equals(requestInfo.getDynamicHash())) {
                                                                    this.srvrList.setHash(requestInfo.getDynamicHash());
                                                                    this.populateJVMID(this.srvrList, (ServerList)object8);
                                                                    bl4 = true;
                                                                }
                                                            }
                                                        }
                                                    } else {
                                                        ((ServerList)object8).setHash(requestInfo.getDynamicHash());
                                                        if (this.verbose) {
                                                            this.trace("Updating dynamic server list: " + string3);
                                                        }
                                                        this.srvrList = object8;
                                                        ((ServerList)object8).addToKnownServersList(this.allKnownServers);
                                                        bl4 = true;
                                                    }
                                                }
                                                if ((object8 = requestInfo.getServerJVMID()) != null && server != null && !((String)object8).equals(server.getJVMID())) {
                                                    serverList8 = this.srvrList;
                                                    synchronized (serverList8) {
                                                        if (!((String)object8).equals(server.getJVMID())) {
                                                            if (this.verbose) {
                                                                this.trace("updating JVMID " + (String)object8 + " for " + server);
                                                            }
                                                            this.srvrList.remove(server);
                                                            server.setJVMID((String)object8);
                                                            this.srvrList.add(server);
                                                            bl4 = true;
                                                        }
                                                    }
                                                }
                                                if (!bl4) throw throwable;
                                                this.notifyServerListChange();
                                                throw throwable;
                                            }
                                        }
                                        synchronized (serverList7) {
                                            if (this.srvrList.getHash() == null || !this.srvrList.getHash().equals(requestInfo.getDynamicHash())) {
                                                this.srvrList.setHash(requestInfo.getDynamicHash());
                                                this.populateJVMID(this.srvrList, (ServerList)object7);
                                                bl = true;
                                            }
                                            break block118;
                                        }
                                    }
                                    ((ServerList)object7).setHash(requestInfo.getDynamicHash());
                                    if (this.verbose) {
                                        this.trace("Updating dynamic server list: " + string);
                                    }
                                    this.srvrList = object7;
                                    ((ServerList)object7).addToKnownServersList(this.allKnownServers);
                                    bl = true;
                                }
                                if ((object7 = requestInfo.getServerJVMID()) != null && server != null && !((String)object7).equals(server.getJVMID())) {
                                    serverList7 = this.srvrList;
                                    synchronized (serverList7) {
                                        if (!((String)object7).equals(server.getJVMID())) {
                                            if (this.verbose) {
                                                this.trace("updating JVMID " + (String)object7 + " for " + server);
                                            }
                                            this.srvrList.remove(server);
                                            server.setJVMID((String)object7);
                                            this.srvrList.add(server);
                                            bl = true;
                                        }
                                    }
                                }
                                if (!bl) return;
                                this.notifyServerListChange();
                                return;
                            }
                            Object var12_7 = null;
                            boolean bl = false;
                            requestInfo.deletePostDataFile();
                            requestInfo.releasePostData();
                            String string = requestInfo.getDynamicList();
                            if (string != null) {
                                object6 = new ServerList(string, false);
                                if (!this.useDynamicList) {
                                    if (this.srvrList.getHash() == null || !this.srvrList.getHash().equals(requestInfo.getDynamicHash())) {
                                        serverList6 = this.srvrList;
                                        synchronized (serverList6) {
                                            if (this.srvrList.getHash() == null || !this.srvrList.getHash().equals(requestInfo.getDynamicHash())) {
                                                this.srvrList.setHash(requestInfo.getDynamicHash());
                                                this.populateJVMID(this.srvrList, (ServerList)object6);
                                                bl = true;
                                            }
                                        }
                                    }
                                } else {
                                    ((ServerList)object6).setHash(requestInfo.getDynamicHash());
                                    if (this.verbose) {
                                        this.trace("Updating dynamic server list: " + string);
                                    }
                                    this.srvrList = object6;
                                    ((ServerList)object6).addToKnownServersList(this.allKnownServers);
                                    bl = true;
                                }
                            }
                            if ((object6 = requestInfo.getServerJVMID()) != null && server != null && !((String)object6).equals(server.getJVMID())) {
                                serverList6 = this.srvrList;
                                synchronized (serverList6) {
                                    if (!((String)object6).equals(server.getJVMID())) {
                                        if (this.verbose) {
                                            this.trace("updating JVMID " + (String)object6 + " for " + server);
                                        }
                                        this.srvrList.remove(server);
                                        server.setJVMID((String)object6);
                                        this.srvrList.add(server);
                                        bl = true;
                                    }
                                }
                            }
                            if (!bl) return;
                            this.notifyServerListChange();
                            return;
                        }
                        Object var12_8 = null;
                        boolean bl = false;
                        requestInfo.deletePostDataFile();
                        requestInfo.releasePostData();
                        String string = requestInfo.getDynamicList();
                        if (string != null) {
                            object5 = new ServerList(string, false);
                            if (!this.useDynamicList) {
                                if (this.srvrList.getHash() == null || !this.srvrList.getHash().equals(requestInfo.getDynamicHash())) {
                                    serverList5 = this.srvrList;
                                    synchronized (serverList5) {
                                        if (this.srvrList.getHash() == null || !this.srvrList.getHash().equals(requestInfo.getDynamicHash())) {
                                            this.srvrList.setHash(requestInfo.getDynamicHash());
                                            this.populateJVMID(this.srvrList, (ServerList)object5);
                                            bl = true;
                                        }
                                    }
                                }
                            } else {
                                ((ServerList)object5).setHash(requestInfo.getDynamicHash());
                                if (this.verbose) {
                                    this.trace("Updating dynamic server list: " + string);
                                }
                                this.srvrList = object5;
                                ((ServerList)object5).addToKnownServersList(this.allKnownServers);
                                bl = true;
                            }
                        }
                        if ((object5 = requestInfo.getServerJVMID()) != null && server != null && !((String)object5).equals(server.getJVMID())) {
                            serverList5 = this.srvrList;
                            synchronized (serverList5) {
                                if (!((String)object5).equals(server.getJVMID())) {
                                    if (this.verbose) {
                                        this.trace("updating JVMID " + (String)object5 + " for " + server);
                                    }
                                    this.srvrList.remove(server);
                                    server.setJVMID((String)object5);
                                    this.srvrList.add(server);
                                    bl = true;
                                }
                            }
                        }
                        if (!bl) return;
                        this.notifyServerListChange();
                        return;
                    }
                    Object var12_9 = null;
                    boolean bl = false;
                    requestInfo.deletePostDataFile();
                    requestInfo.releasePostData();
                    String string = requestInfo.getDynamicList();
                    if (string != null) {
                        object4 = new ServerList(string, false);
                        if (!this.useDynamicList) {
                            if (this.srvrList.getHash() == null || !this.srvrList.getHash().equals(requestInfo.getDynamicHash())) {
                                serverList4 = this.srvrList;
                                synchronized (serverList4) {
                                    if (this.srvrList.getHash() == null || !this.srvrList.getHash().equals(requestInfo.getDynamicHash())) {
                                        this.srvrList.setHash(requestInfo.getDynamicHash());
                                        this.populateJVMID(this.srvrList, (ServerList)object4);
                                        bl = true;
                                    }
                                }
                            }
                        } else {
                            ((ServerList)object4).setHash(requestInfo.getDynamicHash());
                            if (this.verbose) {
                                this.trace("Updating dynamic server list: " + string);
                            }
                            this.srvrList = object4;
                            ((ServerList)object4).addToKnownServersList(this.allKnownServers);
                            bl = true;
                        }
                    }
                    if ((object4 = requestInfo.getServerJVMID()) != null && server != null && !((String)object4).equals(server.getJVMID())) {
                        serverList4 = this.srvrList;
                        synchronized (serverList4) {
                            if (!((String)object4).equals(server.getJVMID())) {
                                if (this.verbose) {
                                    this.trace("updating JVMID " + (String)object4 + " for " + server);
                                }
                                this.srvrList.remove(server);
                                server.setJVMID((String)object4);
                                this.srvrList.add(server);
                                bl = true;
                            }
                        }
                    }
                    if (!bl) return;
                    this.notifyServerListChange();
                    return;
                }
                Object var12_10 = null;
                boolean bl = false;
                requestInfo.deletePostDataFile();
                requestInfo.releasePostData();
                String string = requestInfo.getDynamicList();
                if (string != null) {
                    object3 = new ServerList(string, false);
                    if (!this.useDynamicList) {
                        if (this.srvrList.getHash() == null || !this.srvrList.getHash().equals(requestInfo.getDynamicHash())) {
                            serverList3 = this.srvrList;
                            synchronized (serverList3) {
                                if (this.srvrList.getHash() == null || !this.srvrList.getHash().equals(requestInfo.getDynamicHash())) {
                                    this.srvrList.setHash(requestInfo.getDynamicHash());
                                    this.populateJVMID(this.srvrList, (ServerList)object3);
                                    bl = true;
                                }
                            }
                        }
                    } else {
                        ((ServerList)object3).setHash(requestInfo.getDynamicHash());
                        if (this.verbose) {
                            this.trace("Updating dynamic server list: " + string);
                        }
                        this.srvrList = object3;
                        ((ServerList)object3).addToKnownServersList(this.allKnownServers);
                        bl = true;
                    }
                }
                if ((object3 = requestInfo.getServerJVMID()) != null && server != null && !((String)object3).equals(server.getJVMID())) {
                    serverList3 = this.srvrList;
                    synchronized (serverList3) {
                        if (!((String)object3).equals(server.getJVMID())) {
                            if (this.verbose) {
                                this.trace("updating JVMID " + (String)object3 + " for " + server);
                            }
                            this.srvrList.remove(server);
                            server.setJVMID((String)object3);
                            this.srvrList.add(server);
                            bl = true;
                        }
                    }
                }
                if (!bl) return;
                this.notifyServerListChange();
                return;
            }
            Object var12_11 = null;
            boolean bl = false;
            requestInfo.deletePostDataFile();
            requestInfo.releasePostData();
            String string = requestInfo.getDynamicList();
            if (string != null) {
                object2 = new ServerList(string, false);
                if (!this.useDynamicList) {
                    if (this.srvrList.getHash() == null || !this.srvrList.getHash().equals(requestInfo.getDynamicHash())) {
                        serverList2 = this.srvrList;
                        synchronized (serverList2) {
                            if (this.srvrList.getHash() == null || !this.srvrList.getHash().equals(requestInfo.getDynamicHash())) {
                                this.srvrList.setHash(requestInfo.getDynamicHash());
                                this.populateJVMID(this.srvrList, (ServerList)object2);
                                bl = true;
                            }
                        }
                    }
                } else {
                    ((ServerList)object2).setHash(requestInfo.getDynamicHash());
                    if (this.verbose) {
                        this.trace("Updating dynamic server list: " + string);
                    }
                    this.srvrList = object2;
                    ((ServerList)object2).addToKnownServersList(this.allKnownServers);
                    bl = true;
                }
            }
            if ((object2 = requestInfo.getServerJVMID()) != null && server != null && !((String)object2).equals(server.getJVMID())) {
                serverList2 = this.srvrList;
                synchronized (serverList2) {
                    if (!((String)object2).equals(server.getJVMID())) {
                        if (this.verbose) {
                            this.trace("updating JVMID " + (String)object2 + " for " + server);
                        }
                        this.srvrList.remove(server);
                        server.setJVMID((String)object2);
                        this.srvrList.add(server);
                        bl = true;
                    }
                }
            }
            if (!bl) return;
            this.notifyServerListChange();
            return;
        }
        Object var12_12 = null;
        boolean bl = false;
        requestInfo.deletePostDataFile();
        requestInfo.releasePostData();
        String string = requestInfo.getDynamicList();
        if (string != null) {
            object = new ServerList(string, false);
            if (!this.useDynamicList) {
                if (this.srvrList.getHash() == null || !this.srvrList.getHash().equals(requestInfo.getDynamicHash())) {
                    serverList = this.srvrList;
                    synchronized (serverList) {
                        if (this.srvrList.getHash() == null || !this.srvrList.getHash().equals(requestInfo.getDynamicHash())) {
                            this.srvrList.setHash(requestInfo.getDynamicHash());
                            this.populateJVMID(this.srvrList, (ServerList)object);
                            bl = true;
                        }
                    }
                }
            } else {
                ((ServerList)object).setHash(requestInfo.getDynamicHash());
                if (this.verbose) {
                    this.trace("Updating dynamic server list: " + string);
                }
                this.srvrList = object;
                ((ServerList)object).addToKnownServersList(this.allKnownServers);
                bl = true;
            }
        }
        if ((object = requestInfo.getServerJVMID()) != null && server != null && !((String)object).equals(server.getJVMID())) {
            serverList = this.srvrList;
            synchronized (serverList) {
                if (!((String)object).equals(server.getJVMID())) {
                    if (this.verbose) {
                        this.trace("updating JVMID " + (String)object + " for " + server);
                    }
                    this.srvrList.remove(server);
                    server.setJVMID((String)object);
                    this.srvrList.add(server);
                    bl = true;
                }
            }
        }
        if (!bl) return;
        this.notifyServerListChange();
    }

    private void populateJVMID(ServerList serverList, ServerList serverList2) {
        TreeMap<Server, Server> treeMap = new TreeMap<Server, Server>(new Comparator(){

            public int compare(Object object, Object object2) {
                int n;
                Server server = (Server)object;
                Server server2 = (Server)object2;
                String string = server.getHostIp();
                String string2 = server2.getHostIp();
                int n2 = server.getPort();
                int n3 = server2.getPort();
                int n4 = server.getSecurePort();
                int n5 = server2.getSecurePort();
                if (string != null && string2 != null && (n = string.compareTo(string2)) == 0) {
                    n = n2 - n3;
                    if (n == 0 && n2 == -1) {
                        return n4 - n5;
                    }
                    return n;
                }
                return -1;
            }
        });
        Server[] serverArray = serverList.toArray();
        for (int i = 0; i < serverArray.length; ++i) {
            treeMap.put(serverArray[i], serverArray[i]);
        }
        Iterator iterator = serverList2.iterator();
        while (iterator.hasNext()) {
            Server server = (Server)iterator.next();
            if (!treeMap.containsKey(server)) continue;
            Server server2 = (Server)treeMap.get(server);
            serverList.remove(server2);
            serverList.add(server);
        }
    }

    public void printConfigInfo(RequestInfo requestInfo, PrintWriter printWriter) {
        Object object;
        printWriter.write("<HTML><TITLE>WEBLOGIC PROXY DEBUG INFO</TITLE>");
        printWriter.write("<FONT FACE=\"Tahoma\">");
        printWriter.write("<BODY>Query String: __WebLogicBridgeConfig");
        if (requestInfo.getPrimaryServer() != null) {
            object = requestInfo.getPrimaryServer();
            StringBuilder stringBuilder = new StringBuilder(256);
            stringBuilder.append("<BR><BR><B>Primary Server:</B> <FONT COLOR=\"#0000ff\">");
            stringBuilder.append(((Server)object).getHost());
            stringBuilder.append(":");
            stringBuilder.append(((Server)object).getPort());
            stringBuilder.append(":");
            stringBuilder.append(((Server)object).getSecurePort());
            stringBuilder.append("</FONT>");
            printWriter.write(stringBuilder.toString());
            if (requestInfo.getSecondaryServer() != null) {
                object = requestInfo.getSecondaryServer();
                stringBuilder = new StringBuilder(516);
                stringBuilder.append("<BR><BR><B>Secondary Server:</B> <FONT COLOR=\"#0000ff\">");
                stringBuilder.append(((Server)object).getHost());
                stringBuilder.append(":");
                stringBuilder.append(((Server)object).getPort());
                stringBuilder.append(":");
                stringBuilder.append(((Server)object).getSecurePort());
                stringBuilder.append("</FONT>");
                printWriter.write(stringBuilder.toString());
            }
        }
        object = requestInfo.getServerList();
        printWriter.write("<BR><BR><B>General Server List:</B><OL>");
        for (int i = 0; i < ((ServerList)object).size(); ++i) {
            StringBuilder stringBuilder = new StringBuilder(256);
            Server server = ((ServerList)object).next();
            stringBuilder.append("<LI> <FONT COLOR=\"#0000ff\">");
            stringBuilder.append(server.getHost());
            stringBuilder.append(":");
            stringBuilder.append(server.getPort());
            stringBuilder.append(":");
            stringBuilder.append(server.getSecurePort());
            stringBuilder.append("</FONT></LI>");
            printWriter.write(stringBuilder.toString());
        }
        printWriter.write("</OL><BR><B>ConnectRetrySecs: </B>" + this.connectRetrySecs);
        printWriter.write("<BR><B>ConnectTimeoutSecs: </B>" + this.connectTimeoutSecs);
        if (this.cookieName != null) {
            printWriter.write("<BR><B>CookieName: </B><font color=#0000ff> deprecated</font>");
        }
        printWriter.write("<BR><B>WLCookieName: </B>" + this.wlCookieName);
        printWriter.write("<BR><B>Debug: </B>" + this.verbose);
        printWriter.write("<BR><B>DebugConfigInfo: </B>" + this.debugConfigInfo);
        printWriter.write("<BR><B>DefaultFileName: </B>" + this.defaultFileName);
        printWriter.write("<BR><B>DisableCookie2Server: </B>" + this.ignoreCookie);
        printWriter.write("<BR><B>DynamicServerList: </B>" + this.useDynamicList);
        printWriter.write("<BR><B>FileCaching: </B>" + this.fileCaching);
        printWriter.write("<BR><B>WLIOTimeoutSecs: </B>" + this.socketTimeout);
        printWriter.write("<BR><B>Idempotent: </B>" + this.idempotent);
        printWriter.write("<BR><B>KeepAliveEnabled: </B>" + this.keepAliveEnabled);
        printWriter.write("<BR><B>KeepAliveSecs: </B>" + this.keepAliveSecs);
        printWriter.write("<BR><B>MaxPostSize: </B>" + this.maxPostSize);
        if (this.maxSkips != 0) {
            printWriter.write("<BR><B>MaxSkips: </B>deprecated");
        }
        printWriter.write("<BR><B>MaxSkipTime: </B>" + this.maxSkipTime / 1000L);
        printWriter.write("<BR><B>PathPrepend: </B>" + this.pathPrepend);
        printWriter.write("<BR><B>PathTrim: </B>" + this.pathTrim);
        printWriter.write("<BR><B>TrimExt: </B>" + this.trimExt);
        printWriter.write("<BR><B>SecureProxy: </B>" + this.isSecureProxy);
        printWriter.write("<BR><B>WLLogFile: </B>" + this.logFileName);
        printWriter.write("<BR><B>WLProxySSL: </B>" + this.wlProxySSL);
        printWriter.write("<BR><B>ProxyForConnectionResets: </B>" + this.proxyForConnectionResets);
        printWriter.write("<BR>_____________________________________________________");
        printWriter.write("<BR><BR>Last Modified: " + version.getBuildVersion());
        printWriter.write("</BODY></HTML>");
        printWriter.close();
    }

    protected void addRequestHeaders(HttpServletRequest httpServletRequest, PrintStream printStream, Object object, Object object2) {
        int n;
        super.addRequestHeaders(httpServletRequest, printStream, object, object2);
        for (RoutingHandler routingHandler : this.routingHandlers) {
            try {
                routingHandler.addRequestHeaders(httpServletRequest, printStream, (RequestInfo)object, (Server)object2);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        if (this.srvrList.getHash() != null) {
            printStream.print("X-WebLogic-Cluster-Hash: " + this.srvrList.getHash());
            printStream.print("\r\n");
        }
        if ((n = ((RequestInfo)object).getContentLen()) != -1) {
            printStream.print("Content-Length: " + n);
            printStream.print("\r\n");
        }
        if (this.srvrList.getHash() == null) {
            if (((Server)object2).getJVMID() == null) {
                printStream.print("X-WebLogic-Force-JVMID: unset");
            } else {
                printStream.print("X-WebLogic-Force-JVMID: " + ((Server)object2).getJVMID());
            }
            printStream.print("\r\n");
        }
        printStream.print("X-WebLogic-Request-ClusterInfo: true");
        printStream.print("\r\n");
    }

    public void addResponseHeaders(HttpServletResponse httpServletResponse, String string, String string2, Object object) {
        RequestInfo requestInfo = (RequestInfo)object;
        if (requestInfo.needToUpdateDynamicList() && string.equals("X-WebLogic-Cluster-List")) {
            requestInfo.setDynamicList(string2);
            return;
        }
        if (requestInfo.needToUpdateDynamicList() && string.equals("X-WebLogic-Cluster-Hash")) {
            requestInfo.setDynamicHash(string2);
            return;
        }
        if (string.equals("X-WebLogic-JVMID")) {
            requestInfo.setServerJVMID(string2);
            return;
        }
        boolean bl = false;
        for (RoutingHandler routingHandler : this.routingHandlers) {
            try {
                bl |= routingHandler.handleResponseHeader(httpServletResponse, string, string2, requestInfo);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        if (bl) {
            return;
        }
        super.addResponseHeaders(httpServletResponse, string, string2, object);
    }

    public boolean getPreferred(RequestInfo requestInfo, HttpServletRequest httpServletRequest) {
        int n;
        requestInfo.setNotificationData(new HashMap<RoutingHandler, Object>());
        for (RoutingHandler object2 : this.routingHandlers) {
            try {
                RequestInfo requestInfo2 = object2.route(requestInfo, httpServletRequest);
                if (requestInfo2 == null) continue;
                return true;
            }
            catch (Exception n2) {
                n2.printStackTrace();
            }
        }
        Object object = null;
        if (!this.ignoreCookie) {
            Enumeration n4 = httpServletRequest.getHeaders("Cookie");
            while (n4.hasMoreElements() && object == null) {
                object = (String)n4.nextElement();
                if (object == null) continue;
                int serverList = -1;
                int chunk = 0;
                while (chunk < ((String)object).length() - this.wlCookieName.length() && (serverList = ((String)object).indexOf(this.wlCookieName, chunk)) >= 1) {
                    for (n = serverList - 1; n > -1 && ((String)object).charAt(n) == ' '; --n) {
                    }
                    if (n < 0 || ((String)object).charAt(n) == ';') break;
                    chunk = serverList + this.wlCookieName.length();
                    serverList = -1;
                }
                if (serverList >= 0) {
                    try {
                        object = ((String)object).substring(serverList + this.wlCookieName.length() + 1);
                        serverList = ((String)object).indexOf(";");
                        if (serverList != -1) {
                            object = ((String)object).substring(0, serverList);
                        }
                        serverList = ((String)object).indexOf("!");
                        object = ((String)object).substring(serverList + 1);
                        if (!this.verbose) continue;
                        this.trace("Found cookie: " + (String)object);
                    }
                    catch (ArrayIndexOutOfBoundsException serverList2) {
                        object = null;
                    }
                    continue;
                }
                object = null;
            }
        }
        if (object == null) {
            object = ServletRequestImpl.getOriginalRequest((ServletRequest)httpServletRequest).getSessionHelper().getEncodedSessionID();
            if (object != null) {
                int stringArray = ((String)object).indexOf("!");
                object = ((String)object).endsWith("|") ? ((String)object).substring(stringArray + 1, ((String)object).length() - 1) : ((String)object).substring(stringArray + 1);
            }
            if (this.verbose) {
                this.trace("Found session from url: " + (String)object);
            }
        }
        if (object == null && requestInfo.isPost()) {
            Chunk chunk;
            String string = httpServletRequest.getContentType();
            int server = this.wlCookieName.length();
            if (string != null && string.startsWith("application/x-www-form-urlencoded") && (chunk = requestInfo.getPostData()) != null) {
                int n2;
                n = Chunk.size((Chunk)chunk);
                byte[] byArray = new byte[Chunk.size((Chunk)chunk)];
                Chunk chunk2 = chunk;
                int n3 = 0;
                while (chunk2 != null) {
                    System.arraycopy(chunk2.buf, 0, byArray, n3, chunk2.end);
                    n3 += chunk2.end;
                    chunk2 = chunk2.next;
                }
                int n4 = 0;
                for (n2 = 0; n2 < n; ++n2) {
                    if (byArray[n2] == 37 && n2 + 2 < n && Hex.isHexChar((int)byArray[n2 + 1]) && Hex.isHexChar((int)byArray[n2 + 2])) {
                        byArray[n4++] = (byte)((Hex.hexValueOf((int)byArray[n2 + 1]) << 4) + (Hex.hexValueOf((int)byArray[n2 + 2]) << 0));
                        n2 += 2;
                        continue;
                    }
                    byArray[n4++] = byArray[n2] == 43 ? 32 : byArray[n2];
                }
                n2 = this.wlCookieName.charAt(0);
                for (int i = 0; i < n4; ++i) {
                    if (byArray[i] == n2) {
                        int n5;
                        int n6 = 0;
                        for (n5 = 1; n5 < server && byArray[i + n5] == this.wlCookieName.charAt(n5); ++n5) {
                        }
                        if (n5 < server || (char)byArray[i + n5] != '=') continue;
                        i += n5;
                        boolean bl = false;
                        if (n5 >= server) {
                            while (i < n4 && byArray[i] == 32) {
                                ++i;
                            }
                            while (i < n4 && byArray[i] == 61) {
                                ++i;
                            }
                            while (i < n4 && byArray[i] == 32) {
                                ++i;
                            }
                            while (i < n4 && byArray[i] == 34) {
                                ++i;
                            }
                            while (i < n4 && byArray[i] != "!".charAt(0)) {
                                ++i;
                            }
                            n5 = 0;
                            for (n6 = i + n5; n6 < n4; ++n6) {
                                byte by = byArray[n6];
                                if (by == 59 || by == 34 || by == 38) {
                                    bl = true;
                                    break;
                                }
                                ++n5;
                            }
                        }
                        if (byArray[i] == "!".charAt(0)) {
                            ++i;
                        }
                        object = bl ? new String(byArray, i, n6 - i) : new String(byArray, i, n4 - i);
                        if (!this.verbose) continue;
                        this.trace("Found session in the post data: " + (String)object);
                        continue;
                    }
                    if ((char)byArray[i] == ' ') continue;
                    while (i < n4 && (char)byArray[i] != '&') {
                        ++i;
                    }
                }
            }
        }
        if (object != null) {
            String[] stringArray = StringUtils.splitCompletely((String)new String((String)object), (String)"!");
            switch (stringArray.length) {
                case 1: {
                    ServerList server;
                    if (this.useDynamicList && (server = this.initDynamicServerList(this.srvrList)) != null) {
                        this.srvrList = server;
                        requestInfo.setServerList(this.srvrList);
                    }
                    Server server2 = new Server(stringArray[0], null, 0, 0);
                    requestInfo.setPrimaryServer(server2);
                    return true;
                }
                case 2: 
                case 3: {
                    ServerList serverList;
                    if (this.srvrList.isStatic() && (serverList = this.initDynamicServerList(this.srvrList)) != null) {
                        this.srvrList = serverList;
                        requestInfo.setServerList(this.srvrList);
                    }
                    Server server3 = new Server(stringArray[0], null, 0, 0);
                    requestInfo.setPrimaryServer(server3);
                    if (requestInfo.getPrimaryServer() != null && !stringArray[1].regionMatches(true, 0, "NONE", 0, 4) && stringArray[1].length() <= 11) {
                        server3 = new Server(stringArray[1], null, 0, 0);
                        requestInfo.setSecondaryServer(server3);
                    }
                    return true;
                }
                case 4: 
                case 5: 
                case 6: {
                    if (stringArray.length == 4 || stringArray[4].regionMatches(true, 0, "NONE", 0, 4)) {
                        Server server = new Server(stringArray[0], stringArray[1], Integer.parseInt(stringArray[2]), Integer.parseInt(stringArray[3]));
                        requestInfo.setPrimaryServer(server);
                    } else if (stringArray[4].length() > 6) {
                        Server server = new Server(stringArray[0], stringArray[1], Integer.parseInt(stringArray[2]), Integer.parseInt(stringArray[3]));
                        requestInfo.setPrimaryServer(server);
                        if (requestInfo.getPrimaryServer() != null) {
                            server = new Server(stringArray[4], null, 0, 0);
                            requestInfo.setSecondaryServer(server);
                        }
                    } else {
                        Server server = new Server(stringArray[0], null, 0, 0);
                        requestInfo.setPrimaryServer(server);
                        if (requestInfo.getPrimaryServer() != null) {
                            server = new Server(stringArray[1], stringArray[2], Integer.parseInt(stringArray[3]), Integer.parseInt(stringArray[4]));
                            requestInfo.setSecondaryServer(server);
                        }
                    }
                    return true;
                }
                case 8: 
                case 9: {
                    Server server = new Server(stringArray[0], stringArray[1], Integer.parseInt(stringArray[2]), Integer.parseInt(stringArray[3]));
                    requestInfo.setPrimaryServer(server);
                    server = new Server(stringArray[4], stringArray[5], Integer.parseInt(stringArray[6]), Integer.parseInt(stringArray[7]));
                    requestInfo.setSecondaryServer(server);
                    return true;
                }
            }
            if (this.verbose) {
                this.trace("malformed cookie: " + (String)object);
            }
            return false;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ServerList initDynamicServerList(ServerList serverList) {
        ServerList serverList2 = null;
        String string = null;
        GenericProxyServlet.ProxyConnection proxyConnection = null;
        String string2 = "HEAD /bea_wls_internal/WLDummyInitJVMIDs HTTP/1.0\r\n";
        Server[] serverArray = serverList.toArray();
        if (serverArray == null) {
            return null;
        }
        int n = serverArray.length;
        if (n < 1) {
            return null;
        }
        for (int i = 0; i < n; ++i) {
            Object var21_21;
            if (serverArray[i].getJVMID() != null) continue;
            long l = serverArray[i].getStartMarkBad();
            if (l > 0L) {
                long l2 = System.currentTimeMillis();
                long l3 = l2 - l;
                if (l3 < this.maxSkipTime) {
                    if (!this.verbose) continue;
                    this.trace("Skip retrieving JVMID for " + serverArray[i] + ", skipTime=" + l3 / 1000L + ", max=" + this.maxSkipTime / 1000L);
                    continue;
                }
                if (this.verbose) {
                    this.trace("Reset retrieving JVMID for " + serverArray[i] + ", mark good after " + this.maxSkipTime / 1000L);
                }
                serverArray[i].markGood();
            }
            if (this.verbose) {
                this.trace("Trying to get JVMID from server: " + serverArray[i]);
            }
            try {
                try {
                    proxyConnection = this.isSecureProxy ? new GenericProxyServlet.ProxyConnection(this, serverArray[i].getHost(), serverArray[i].getSecurePort(), true, 10000) : new GenericProxyServlet.ProxyConnection(this, serverArray[i].getHost(), serverArray[i].getPort(), false, 10000);
                    BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(proxyConnection.getSocket().getOutputStream());
                    PrintStream printStream = new PrintStream(bufferedOutputStream);
                    printStream.print(string2);
                    printStream.print("X-WebLogic-Request-ClusterInfo: true");
                    printStream.print("\r\n");
                    printStream.print("X-WebLogic-Force-JVMID: unset");
                    printStream.print("\r\n");
                    printStream.print("\r\n");
                    printStream.flush();
                    DataInputStream dataInputStream = new DataInputStream(new BufferedInputStream(proxyConnection.getSocket().getInputStream(), 100));
                    String string3 = dataInputStream.readLine();
                    while ((string3 = dataInputStream.readLine()) != null && string3.length() > 0) {
                        String[] stringArray = StringUtils.split((String)string3, (char)':');
                        String string4 = stringArray[0].trim();
                        String string5 = stringArray[1].trim();
                        if (string4.equals("X-WebLogic-Cluster-List")) {
                            if (this.verbose) {
                                this.trace("Update dynmaic list: " + string5);
                            }
                            serverList2 = new ServerList(string5, false);
                            if (string == null) continue;
                            if (this.verbose) {
                                this.trace("Update dynmaic hash: " + string);
                            }
                            serverList2.setHash(string);
                            break;
                        }
                        if (string4.equals("X-WebLogic-Cluster-Hash")) {
                            if (serverList2 != null) {
                                if (this.verbose) {
                                    this.trace("Update dynmaic hash: " + string5);
                                }
                                serverList2.setHash(string5);
                                break;
                            }
                            string = string5;
                            continue;
                        }
                        if (!string4.equals("X-WebLogic-JVMID") || string5 == null || string5.equals(serverArray[i].getJVMID())) continue;
                        ServerList serverList3 = serverList;
                        synchronized (serverList3) {
                            if (!string5.equals(serverArray[i].getJVMID())) {
                                if (this.verbose) {
                                    this.trace("Update jvmid " + string5 + " for " + serverArray[i]);
                                }
                                serverList.remove(serverArray[i]);
                                serverArray[i].setJVMID(string5);
                                serverList.add(serverArray[i]);
                            }
                        }
                    }
                    if (serverList2 != null) {
                        var21_21 = null;
                        if (proxyConnection == null) break;
                        proxyConnection.close();
                        break;
                    }
                    var21_21 = null;
                    if (proxyConnection == null) continue;
                    proxyConnection.close();
                }
                catch (IOException iOException) {
                    if (this.verbose) {
                        this.trace("Failed to update jvmid for " + serverArray[i]);
                    }
                    var21_21 = null;
                    if (proxyConnection == null) continue;
                    proxyConnection.close();
                }
                continue;
            }
            catch (Throwable throwable) {
                var21_21 = null;
                if (proxyConnection != null) {
                    proxyConnection.close();
                }
                throw throwable;
            }
        }
        return serverList2;
    }

    protected boolean readPostData(RequestInfo requestInfo, HttpServletRequest httpServletRequest) {
        if (!requestInfo.isPost()) {
            return true;
        }
        int n = httpServletRequest.getContentLength();
        if (this.maxPostSize > 0 && n > this.maxPostSize) {
            if (this.verbose) {
                this.trace("Content Length exceeded the MaxPostSize: " + this.maxPostSize);
            }
            return false;
        }
        if (n > MAX_POST_IN_MEMORY) {
            return this.readPostDataToFile(requestInfo, httpServletRequest, n);
        }
        if (n >= 0) {
            return this.readPostDataToMemory(requestInfo, httpServletRequest, n);
        }
        String string = httpServletRequest.getHeader("Transfer-Encoding");
        if (string == null) {
            return true;
        }
        if (string.equalsIgnoreCase("Chunked")) {
            requestInfo.setIsChunked(true);
            return this.readChunkedPostData(requestInfo, httpServletRequest);
        }
        if (this.verbose) {
            this.trace("Transfer-Encoding not set or encountered an unsupported value " + string);
        }
        return false;
    }

    /*
     * Exception decompiling
     */
    protected boolean readChunkedPostData(RequestInfo var1_1, HttpServletRequest var2_2) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK]], but top level block is 16[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected boolean readPostDataToMemory(RequestInfo requestInfo, HttpServletRequest httpServletRequest, int n) {
        if (n == 0) {
            return true;
        }
        try {
            Chunk chunk = this.readPostDataToMemory(httpServletRequest, n);
            if (chunk == null) {
                return false;
            }
            requestInfo.setPostData(chunk);
        }
        catch (IOException iOException) {
            if (this.verbose) {
                CharArrayWriter charArrayWriter = new CharArrayWriter();
                iOException.printStackTrace(new PrintWriter(charArrayWriter));
                this.trace("Failed to read post data in memory: " + charArrayWriter.toString());
            }
            if (this.proxyForConnectionResets) {
                if (this.verbose) {
                    this.trace("ProxyForConnectionResets enabled");
                }
                return true;
            }
            return false;
        }
        return true;
    }

    protected boolean readPostDataToFile(RequestInfo requestInfo, HttpServletRequest httpServletRequest, int n) {
        if (this.fileCaching) {
            try {
                File file = this.readPostDataToFile(httpServletRequest, n);
                if (file == null) {
                    return false;
                }
                requestInfo.setPostDataFile(file);
            }
            catch (IOException iOException) {
                if (this.verbose) {
                    CharArrayWriter charArrayWriter = new CharArrayWriter();
                    iOException.printStackTrace(new PrintWriter(charArrayWriter));
                    this.trace("Failed to read post data into file: " + charArrayWriter.toString());
                }
                if (this.proxyForConnectionResets) {
                    if (this.verbose) {
                        this.trace("ProxyForConnectionResets enabled");
                    }
                    return true;
                }
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean sendPostData(HttpServletRequest httpServletRequest, RequestInfo requestInfo, PrintStream printStream) {
        Chunk chunk = requestInfo.getPostData();
        if (chunk != null) {
            while (true) {
                if (chunk == null) {
                    printStream.flush();
                    return true;
                }
                printStream.write(chunk.buf, 0, chunk.end);
                chunk = chunk.next;
            }
        }
        if (!this.fileCaching) {
            if (this.verbose) {
                this.trace("FileCaching is OFF, no failover");
            }
            requestInfo.setCanFailover(false);
            ServletInputStream servletInputStream = null;
            try {
                block19: {
                    try {
                        chunk = Chunk.getChunk();
                        servletInputStream = httpServletRequest.getInputStream();
                        if (!requestInfo.isChunked()) {
                            int n;
                            for (int i = httpServletRequest.getContentLength(); i > 0; i -= n) {
                                n = servletInputStream.read(chunk.buf, 0, chunk.buf.length);
                                printStream.write(chunk.buf, 0, n);
                                printStream.flush();
                            }
                            break block19;
                        }
                        int n = -1;
                        while ((n = servletInputStream.read()) != -1) {
                            chunk.buf[chunk.end++] = (byte)n;
                            if (chunk.end != Chunk.CHUNK_SIZE) continue;
                            printStream.write(chunk.buf, 0, chunk.end);
                            printStream.flush();
                            chunk.end = 0;
                        }
                        if (chunk.end <= 0) break block19;
                        printStream.write(chunk.buf, 0, chunk.end);
                        printStream.flush();
                    }
                    catch (IOException iOException) {
                        if (this.verbose) {
                            this.trace("Error reading Post data from client");
                        }
                        boolean bl = false;
                        Object var9_17 = null;
                        Chunk.releaseChunk((Chunk)chunk);
                        return bl;
                    }
                }
                Object var9_16 = null;
                Chunk.releaseChunk((Chunk)chunk);
                return true;
            }
            catch (Throwable throwable) {
                Object var9_18 = null;
                Chunk.releaseChunk((Chunk)chunk);
                throw throwable;
            }
        }
        File file = requestInfo.getPostDataFile();
        if (file == null) return true;
        try {
            try {
                FileInputStream fileInputStream = new FileInputStream(file);
                chunk = Chunk.getChunk();
                int n = 0;
                while ((n = fileInputStream.read(chunk.buf, 0, chunk.buf.length)) != -1) {
                    printStream.write(chunk.buf, 0, n);
                    printStream.flush();
                }
                fileInputStream.close();
            }
            catch (IOException iOException) {
                requestInfo.setCanFailover(false);
                if (this.verbose) {
                    this.trace("Error reading Post data from tmp file");
                }
                boolean bl = false;
                Object var11_21 = null;
                Chunk.releaseChunk((Chunk)chunk);
                return bl;
            }
            Object var11_20 = null;
            Chunk.releaseChunk((Chunk)chunk);
            return true;
        }
        catch (Throwable throwable) {
            Object var11_22 = null;
            Chunk.releaseChunk((Chunk)chunk);
            throw throwable;
        }
    }

    protected GenericProxyServlet.ProxyConnection attemptConnect(RequestInfo requestInfo, Server server, HttpServletRequest httpServletRequest) {
        GenericProxyServlet.ProxyConnection proxyConnection = null;
        boolean bl = requestInfo.isSecureNeeded();
        try {
            proxyConnection = this.connPool.getProxyConnection(server.getHost(), bl ? server.getSecurePort() : server.getPort(), bl, this.connectTimeoutSecs);
            proxyConnection.setTimeout(this.socketTimeout);
        }
        catch (IOException iOException) {
            if (this.verbose) {
                CharArrayWriter charArrayWriter = new CharArrayWriter();
                iOException.printStackTrace(new PrintWriter(charArrayWriter));
                this.trace("Caught exception while trying to connect to server " + server + ": " + charArrayWriter.toString());
            }
            requestInfo.markServerBad(server);
            if (proxyConnection != null) {
                proxyConnection.close();
            }
            return null;
        }
        BufferedOutputStream bufferedOutputStream = null;
        try {
            bufferedOutputStream = new BufferedOutputStream(proxyConnection.getSocket().getOutputStream());
        }
        catch (IOException iOException) {
            if (this.verbose) {
                CharArrayWriter charArrayWriter = new CharArrayWriter();
                iOException.printStackTrace(new PrintWriter(charArrayWriter));
                this.trace("Caught exception while trying to get an output stream from the connection object: " + charArrayWriter.toString());
            }
            if (proxyConnection.getLastUsed() != 0L) {
                if (proxyConnection != null) {
                    proxyConnection.close();
                }
                if (this.verbose) {
                    this.trace("Recycled connection could be BAD, so try creating a new connection to ensure server is down");
                }
                try {
                    proxyConnection = this.connPool.getNewProxyConnection(server.getHost(), bl ? server.getSecurePort() : server.getPort(), bl, this.connectTimeoutSecs);
                    proxyConnection.setTimeout(this.socketTimeout);
                    bufferedOutputStream = new BufferedOutputStream(proxyConnection.getSocket().getOutputStream());
                }
                catch (IOException iOException2) {
                    if (this.verbose) {
                        CharArrayWriter charArrayWriter = new CharArrayWriter();
                        iOException2.printStackTrace(new PrintWriter(charArrayWriter));
                        this.trace("Caught exception while trying to connect to server " + server + ": " + charArrayWriter.toString());
                    }
                    requestInfo.markServerBad(server);
                    if (proxyConnection != null) {
                        proxyConnection.close();
                    }
                    return null;
                }
            }
            if (this.verbose) {
                this.trace("New connection threw IOException, Mark Server as BAD");
            }
            requestInfo.markServerBad(server);
            if (proxyConnection != null) {
                proxyConnection.close();
            }
            return null;
        }
        PrintStream printStream = new PrintStream(bufferedOutputStream);
        printStream.print(requestInfo.getRequest());
        this.sendRequestHeaders(httpServletRequest, printStream, requestInfo, server);
        if (!printStream.checkError()) {
            if (this.verbose) {
                this.trace("Successfully send request headers to server: " + server);
            }
        } else if (proxyConnection.getLastUsed() != 0L) {
            if (proxyConnection != null) {
                proxyConnection.close();
            }
            if (this.verbose) {
                this.trace("Error while forwarding request headers. Recycled connection could be BAD, so try creating a new connection");
            }
            try {
                proxyConnection = this.connPool.getNewProxyConnection(server.getHost(), bl ? server.getSecurePort() : server.getPort(), bl, this.connectTimeoutSecs);
                proxyConnection.setTimeout(this.socketTimeout);
                bufferedOutputStream = new BufferedOutputStream(proxyConnection.getSocket().getOutputStream());
            }
            catch (IOException iOException) {
                if (this.verbose) {
                    CharArrayWriter charArrayWriter = new CharArrayWriter();
                    iOException.printStackTrace(new PrintWriter(charArrayWriter));
                    this.trace("Caught exception while trying to connect to server " + server + ": " + charArrayWriter.toString());
                }
                requestInfo.markServerBad(server);
                if (proxyConnection != null) {
                    proxyConnection.close();
                }
                return null;
            }
            printStream = new PrintStream(bufferedOutputStream);
            printStream.print(requestInfo.getRequest());
            this.sendRequestHeaders(httpServletRequest, printStream, requestInfo, server);
        } else {
            if (this.verbose) {
                this.trace("New Connection reported error while forwarding request headers to server: " + server + "; Mark Server as BAD");
            }
            requestInfo.markServerBad(server);
            if (proxyConnection != null) {
                proxyConnection.close();
            }
            return null;
        }
        if (requestInfo.isPost()) {
            boolean bl2 = this.sendPostData(httpServletRequest, requestInfo, printStream);
            if (!bl2) {
                if (this.verbose) {
                    this.trace("Error while reading post data from client");
                }
                if (proxyConnection != null) {
                    proxyConnection.close();
                }
                return null;
            }
            if (printStream.checkError()) {
                if (this.verbose) {
                    this.trace("Error while forwarding post data to server: " + server);
                }
                requestInfo.markServerBad(server);
                if (proxyConnection != null) {
                    proxyConnection.close();
                }
                return null;
            }
        }
        return proxyConnection;
    }

    public GenericProxyServlet.ProxyConnection sendResponse(RequestInfo requestInfo, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, GenericProxyServlet.ProxyConnection proxyConnection, Server server) {
        try {
            DataInputStream dataInputStream = new DataInputStream(new BufferedInputStream(proxyConnection.getSocket().getInputStream(), 100));
            int n = this.readStatus(httpServletRequest, httpServletResponse, dataInputStream, proxyConnection.canRecycle());
            if (n == 503) {
                if (this.verbose) {
                    this.trace("Got 503 from server: " + server);
                }
                requestInfo.markServerBad(server);
                if (proxyConnection != null) {
                    proxyConnection.close();
                }
                return null;
            }
            requestInfo.setCanFailover(false);
            int n2 = this.sendResponseHeaders(httpServletResponse, dataInputStream, proxyConnection, requestInfo);
            if (n == 100) {
                n = this.readStatus(httpServletRequest, httpServletResponse, dataInputStream);
                n2 = this.sendResponseHeaders(httpServletResponse, dataInputStream, proxyConnection, requestInfo);
            }
            if (n == 204 || n == 304 || "HEAD".equalsIgnoreCase(httpServletRequest.getMethod())) {
                return proxyConnection;
            }
            ServletOutputStream servletOutputStream = null;
            try {
                servletOutputStream = httpServletResponse.getOutputStream();
            }
            catch (IOException iOException) {
                if (proxyConnection != null) {
                    proxyConnection.close();
                }
                return null;
            }
            if (n2 == -9999) {
                ChunkInput.readCTE((OutputStream)servletOutputStream, (InputStream)dataInputStream);
            } else if (n2 != 0) {
                this.readAndWriteResponseData(dataInputStream, (OutputStream)servletOutputStream, n2);
            }
        }
        catch (WriteClientIOException writeClientIOException) {
            if (proxyConnection != null) {
                proxyConnection.close();
            }
            return null;
        }
        catch (IOException iOException) {
            if (this.verbose) {
                CharArrayWriter charArrayWriter = new CharArrayWriter();
                iOException.printStackTrace(new PrintWriter(charArrayWriter));
                this.trace("Caught exception while reading response status : " + charArrayWriter.toString());
            }
            requestInfo.markServerBad(server);
            if (proxyConnection != null) {
                proxyConnection.close();
            }
            return null;
        }
        return proxyConnection;
    }

    protected static Map createNewMap() {
        return Collections.synchronizedMap(new TreeMap(new Comparator(){

            public int compare(Object object, Object object2) {
                Server server = (Server)object;
                Server server2 = (Server)object2;
                return server.compareTo(server2);
            }
        }));
    }

    public Server createServer(String string, boolean bl) {
        return new Server(string, bl);
    }

    public Server createServer(String string, String string2, int n, int n2) {
        return new Server(string, string2, n, n2);
    }

    public class ServerList {
        private String hash;
        private int index;
        private boolean isStaticList;
        private TreeMap list = new TreeMap(new Comparator(){

            public int compare(Object object, Object object2) {
                Server server = (Server)object;
                Server server2 = (Server)object2;
                return server.compareTo(server2);
            }
        });

        public ServerList(boolean bl) {
            this.isStaticList = bl;
            this.index = -1;
        }

        public ServerList(String string, boolean bl) {
            this.isStaticList = bl;
            this.index = -1;
            StringTokenizer stringTokenizer = new StringTokenizer(string, "|");
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                Server server = new Server(string2, this.isStaticList);
                this.list.put(server, server);
            }
        }

        public Server getServer(Server server) {
            return (Server)this.list.get(server);
        }

        public Server[] toArray() {
            Set set = this.list.keySet();
            if (set == null || set.isEmpty()) {
                return null;
            }
            int n = this.size();
            if (n <= 0) {
                return null;
            }
            Iterator iterator = set.iterator();
            Server[] serverArray = new Server[n];
            int n2 = 0;
            while (iterator.hasNext()) {
                serverArray[n2] = (Server)iterator.next();
                ++n2;
            }
            return serverArray;
        }

        public Iterator iterator() {
            return this.list.values().iterator();
        }

        public boolean isStatic() {
            return this.isStaticList;
        }

        public String getHash() {
            return this.hash;
        }

        public void setHash(String string) {
            this.hash = string;
        }

        public int size() {
            return this.list.size();
        }

        public void add(Server server) {
            this.list.put(server, server);
        }

        public void remove(Server server) {
            this.list.remove(server);
        }

        public synchronized Server next() {
            if (this.list.size() == 0) {
                return null;
            }
            if (this.index == -1) {
                this.index = (int)(Math.random() * (double)this.list.size());
            } else {
                ++this.index;
                this.index %= this.list.size();
            }
            Object[] objectArray = this.list.values().toArray();
            return (Server)objectArray[this.index];
        }

        public void addToKnownServersList(Map map) {
            Object[] objectArray = this.list.values().toArray();
            for (int i = 0; i < this.list.size(); ++i) {
                Object object = objectArray[i];
                if (map.containsKey(object)) continue;
                map.put(object, object);
            }
        }

        public Server getByHostAndPort(String string, int n) {
            for (Object v : this.list.values()) {
                Server server = (Server)v;
                if (!server.getHost().equals(string) && !server.getHostIp().equals(string) || server.getPort() != n) continue;
                return server;
            }
            return null;
        }
    }

    public class Server {
        private String jvmid;
        private String host;
        private String hostip;
        private int port;
        private int sslPort;
        private boolean isBad = false;
        private long startMarkBad = 0L;

        public Server(String string, boolean bl) {
            if (bl) {
                if (string.indexOf("[") != -1) {
                    int n = string.indexOf("[");
                    int n2 = string.indexOf("]");
                    this.setHost(string.substring(n + 1, n2));
                    String string2 = string.substring(n2 + 1);
                    this.parsePorts(string2);
                } else {
                    int n = string.indexOf(58);
                    if (n == -1) {
                        this.setHost(string);
                        this.port = 80;
                        this.sslPort = 443;
                    } else {
                        this.setHost(string.substring(0, n));
                        this.parsePorts(string.substring(n));
                    }
                }
            } else {
                String[] stringArray = StringUtils.splitCompletely((String)string, (String)"!");
                if (stringArray.length == 4) {
                    this.jvmid = stringArray[0];
                    this.setHost(stringArray[1]);
                    this.port = Integer.parseInt(stringArray[2]);
                    this.sslPort = Integer.parseInt(stringArray[3]);
                }
            }
        }

        public Server(String string, String string2, int n, int n2) {
            this.jvmid = string;
            this.setHost(string2);
            this.port = n;
            this.sslPort = n2;
        }

        public void markGood() {
            this.startMarkBad = 0L;
            this.isBad = false;
        }

        public void markBad() {
            this.startMarkBad = System.currentTimeMillis();
            this.isBad = true;
        }

        public boolean isBad() {
            long l;
            if (!this.isBad) {
                return false;
            }
            if (HttpClusterServlet.this.maxSkipTime > 0L && (l = System.currentTimeMillis()) - this.startMarkBad >= HttpClusterServlet.this.maxSkipTime) {
                this.startMarkBad = 0L;
                this.isBad = false;
            }
            return this.isBad;
        }

        public long getStartMarkBad() {
            return this.startMarkBad;
        }

        public String getJVMID() {
            return this.jvmid;
        }

        public void setJVMID(String string) {
            this.jvmid = string;
        }

        public void setHost(String string) {
            if (string == null) {
                return;
            }
            try {
                int n = Integer.valueOf(string);
                this.host = this.hostip = (n >> 24 & 0xFF) + "." + (n >> 16 & 0xFF) + "." + (n >> 8 & 0xFF) + "." + (n >> 0 & 0xFF);
            }
            catch (NumberFormatException numberFormatException) {
                this.host = string;
                try {
                    this.hostip = InetAddress.getByName(string).getHostAddress();
                }
                catch (UnknownHostException unknownHostException) {
                    // empty catch block
                }
            }
        }

        public String getHost() {
            return this.host;
        }

        public String getHostIp() {
            return this.hostip;
        }

        public int getPort() {
            return this.port;
        }

        public int getSecurePort() {
            return this.sslPort;
        }

        public int compareTo(Server server) {
            String string = server.getHostIp();
            String string2 = server.getJVMID();
            if (this.jvmid != null && string2 != null) {
                return this.jvmid.compareToIgnoreCase(string2);
            }
            if (string != null && this.hostip != null) {
                int n = this.hostip.compareTo(string);
                if (n == 0) {
                    n = this.port - server.getPort();
                    if (n == 0) {
                        return this.sslPort - server.getSecurePort();
                    }
                    return n;
                }
                return n;
            }
            return -1;
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder(100);
            if (this.jvmid != null) {
                stringBuilder.append(this.jvmid);
            }
            if (this.host != null) {
                if (this.jvmid != null) {
                    stringBuilder.append("!");
                }
                stringBuilder.append(this.host);
                stringBuilder.append("!");
                stringBuilder.append(this.port);
                stringBuilder.append("!");
                stringBuilder.append(this.sslPort);
            }
            return stringBuilder.toString();
        }

        private void parsePorts(String string) {
            int n = string.indexOf(":");
            int n2 = string.lastIndexOf(":");
            if (n == -1) {
                this.port = 80;
                this.sslPort = 443;
            } else if (n2 == -1 || n == n2) {
                if (HttpClusterServlet.this.isSecureProxy) {
                    this.port = 80;
                    this.sslPort = Integer.parseInt(string.substring(n + 1));
                } else {
                    this.port = Integer.parseInt(string.substring(n + 1));
                    this.sslPort = 443;
                }
            } else {
                this.port = Integer.parseInt(string.substring(n + 1, n2));
                this.sslPort = Integer.parseInt(string.substring(n2 + 1));
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class RequestInfo {
        private ServerList list;
        private boolean isSecure = false;
        private File postDataFile = null;
        private Server primary;
        private Server secondary;
        private String request = null;
        private Chunk postData = null;
        private boolean post = false;
        private boolean canFailover = true;
        private boolean verbose;
        private boolean needToUpdate = true;
        private String dynamicHash = null;
        private String dynamicList = null;
        private boolean chunked = false;
        private int contentLen = -1;
        private String serverJVMID = null;
        private Map<RoutingHandler, Object> notificationData = null;

        public void setServerList(ServerList serverList) {
            this.list = serverList;
        }

        public ServerList getServerList() {
            return this.list;
        }

        public Server getServerInList() {
            for (int i = 0; i < this.list.size(); ++i) {
                Server server = this.list.next();
                if (server.isBad()) continue;
                return server;
            }
            return null;
        }

        public void revertToAllKnownServersList() {
            this.list = new ServerList(true);
            for (Server server : HttpClusterServlet.this.allKnownServers.values()) {
                server.markGood();
                this.list.add(server);
            }
        }

        public void markServerBad(Server server) {
            if (this.primary != null && server.equals(this.primary)) {
                this.primary.markBad();
            }
            if (this.secondary != null && server.equals(this.secondary)) {
                this.secondary.markBad();
            }
            server.markBad();
            if (this.verbose) {
                HttpClusterServlet.this.trace("marked bad: " + server);
            }
        }

        public boolean isSecureNeeded() {
            return this.isSecure;
        }

        public void setIsSecureNeeded(boolean bl) {
            this.isSecure = bl;
        }

        public File getPostDataFile() {
            return this.postDataFile;
        }

        public void setPostDataFile(File file) {
            this.postDataFile = file;
        }

        public void deletePostDataFile() {
            if (this.postDataFile != null) {
                if (this.verbose) {
                    HttpClusterServlet.this.trace("Remove temp file: " + this.postDataFile.getAbsolutePath());
                }
                this.postDataFile.delete();
            }
        }

        public Server getPrimaryServer() {
            return this.primary;
        }

        public void setPrimaryServer(Server server) {
            this.primary = this.list.getServer(server);
            if (this.primary == null && HttpClusterServlet.this.crossOverProxyEnabled) {
                this.primary = server;
                this.needToUpdate = false;
            }
        }

        public Server getSecondaryServer() {
            return this.secondary;
        }

        public void setSecondaryServer(Server server) {
            this.secondary = this.list.getServer(server);
            if (this.secondary == null && HttpClusterServlet.this.crossOverProxyEnabled) {
                this.secondary = server;
                this.needToUpdate = false;
            }
        }

        public String getRequest() {
            return this.request;
        }

        public void setRequest(String string) {
            this.request = string;
        }

        public Chunk getPostData() {
            return this.postData;
        }

        public void setPostData(Chunk chunk) {
            this.postData = chunk;
        }

        public void releasePostData() {
            Chunk.releaseChunks((Chunk)this.postData);
        }

        public boolean isPost() {
            return this.post;
        }

        public void setPost(boolean bl) {
            this.post = bl;
        }

        public void setCanFailover(boolean bl) {
            this.canFailover = bl;
        }

        public boolean canFailover() {
            return this.canFailover;
        }

        public void setVerbose(boolean bl) {
            this.verbose = bl;
        }

        public void setNeedToUpdateDynamicList(boolean bl) {
            this.needToUpdate = bl;
        }

        public boolean needToUpdateDynamicList() {
            return this.needToUpdate;
        }

        public void setDynamicHash(String string) {
            this.dynamicHash = string;
        }

        public String getDynamicHash() {
            return this.dynamicHash;
        }

        public void setDynamicList(String string) {
            this.dynamicList = string;
        }

        public String getDynamicList() {
            return this.dynamicList;
        }

        public void setIsChunked(boolean bl) {
            this.chunked = bl;
        }

        public boolean isChunked() {
            return this.chunked;
        }

        public void setContentLen(int n) {
            this.contentLen = n;
        }

        public int getContentLen() {
            return this.contentLen;
        }

        public String getServerJVMID() {
            return this.serverJVMID;
        }

        public void setServerJVMID(String string) {
            this.serverJVMID = string;
        }

        public Map<RoutingHandler, Object> getNotificationData() {
            return this.notificationData;
        }

        public void setNotificationData(Map<RoutingHandler, Object> map) {
            this.notificationData = map;
        }

        public InputStream getInputStream() throws IOException {
            if (this.postData != null) {
                return new ChunkedInputStream(this.postData, 0);
            }
            if (this.postDataFile != null) {
                return new BufferedInputStream(new FileInputStream(this.postDataFile));
            }
            return new NullInputStream();
        }
    }

    public static interface ServerListListener {
        public void serverListChanged();
    }
}

