/*
 * Decompiled with CFR 0.152.
 */
package weblogic.servlet.proxy;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.PushbackInputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import weblogic.servlet.FutureServletResponse;
import weblogic.servlet.proxy.ProxyUtils;
import weblogic.servlet.proxy.SocketConnResource;
import weblogic.utils.Debug;
import weblogic.utils.io.DataIO;
import weblogic.work.WorkAdapter;

final class ProxyRequest
extends WorkAdapter {
    private static final boolean DEBUG = true;
    private static final String CONTENT_LENGTH_HEADER = "Content-Length: ";
    private static final int CONTENT_LENGTH_HEADER_INDEX = "Content-Length: ".length();
    private final SocketConnResource con;
    private final HttpServletRequest request;
    private final FutureServletResponse response;
    private final byte[] bytes;
    private final PrintStream out;
    private final PushbackInputStream in;
    private final Cookie[] cookies;

    ProxyRequest(SocketConnResource socketConnResource, HttpServletRequest httpServletRequest, FutureServletResponse futureServletResponse) throws IOException {
        this(socketConnResource, httpServletRequest, futureServletResponse, null);
    }

    ProxyRequest(SocketConnResource socketConnResource, HttpServletRequest httpServletRequest, FutureServletResponse futureServletResponse, Cookie[] cookieArray) throws IOException {
        this.con = socketConnResource;
        this.request = httpServletRequest;
        this.response = futureServletResponse;
        this.bytes = this.createRequest();
        this.out = socketConnResource.getOutputStream();
        this.in = socketConnResource.getInputStream();
        this.cookies = cookieArray;
    }

    byte[] getBackendRequest() {
        return this.bytes;
    }

    public void run() {
        this.out.write(this.bytes, 0, this.bytes.length);
        StringBuilder stringBuilder = new StringBuilder();
        String string = null;
        int n = -1;
        boolean bl = false;
        try {
            string = ProxyUtils.readHTTPHeader(this.in);
            while (string != null) {
                int n2;
                stringBuilder.append(string);
                if (string.length() == 0) break;
                if (n != -1 || (n2 = string.indexOf(CONTENT_LENGTH_HEADER)) <= -1) continue;
                n = Integer.parseInt(string.substring(CONTENT_LENGTH_HEADER_INDEX).trim());
            }
            byte[] byArray = stringBuilder.toString().getBytes();
            if (n > 0) {
                this.sendResponseWithBody(n, byArray);
                return;
            }
            this.response.getOutputStream().write(byArray);
            int n3 = ProxyUtils.readChunkSize(this.in);
            while (n3 > 0) {
                byte[] byArray2 = new byte[n3 + 2];
                this.in.read(byArray2, 0, n3 + 2);
                this.sendResponse(byArray2);
                n3 = ProxyUtils.readChunkSize(this.in);
            }
            this.response.send();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private void sendResponseWithBody(int n, byte[] byArray) throws IOException {
        int n2 = byArray.length + n;
        byte[] byArray2 = new byte[n2];
        System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
        this.in.read(byArray2, byArray.length, n);
        this.sendResponse(byArray2);
        this.response.send();
    }

    private void sendResponse(byte[] byArray) {
        try {
            this.response.getOutputStream().write(byArray);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private byte[] createRequest() {
        if (this.request.getMethod() == "GET") {
            return this.createGetRequest();
        }
        if (this.request.getMethod() == "POST") {
            return this.createPostRequest();
        }
        if (this.request.getMethod() == "HEAD") {
            return this.createHeadRequest();
        }
        return null;
    }

    private byte[] createHeadRequest() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("HEAD ");
        stringBuilder.append(this.request.getRequestURI());
        stringBuilder.append("HTTP/1.1\r\n");
        stringBuilder.append("Content-Length: 0\r\n");
        stringBuilder.append("Connection: Keep-Alive\r\n");
        stringBuilder.append(this.con.getHost());
        stringBuilder.append("\r\n\r\n");
        Debug.say((String)("HEAD REQUEST " + stringBuilder.toString()));
        return stringBuilder.toString().getBytes();
    }

    private byte[] createGetRequest() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("GET ");
        stringBuilder.append(this.request.getRequestURI());
        stringBuilder.append(" HTTP/1.1\r\n");
        stringBuilder.append(" Content-Length: 0\r\n");
        Cookie[] cookieArray = this.request.getCookies();
        if (cookieArray != null) {
            this.addCookies(stringBuilder, cookieArray);
        }
        stringBuilder.append("Connection: Keep-Alive\r\n");
        stringBuilder.append(this.con.getHost());
        stringBuilder.append("\r\n\r\n");
        Debug.say((String)("GET REQUEST " + stringBuilder.toString()));
        return stringBuilder.toString().getBytes();
    }

    private void addCookies(StringBuilder stringBuilder, Cookie[] cookieArray) {
        stringBuilder.append("Cookie: ");
        for (int i = 0; i < cookieArray.length; ++i) {
            stringBuilder.append(cookieArray[i].getName());
            stringBuilder.append("=");
            stringBuilder.append(cookieArray[i].getValue());
            stringBuilder.append(";");
        }
        stringBuilder.append("\r\n");
    }

    private byte[] createPostRequest() {
        int n = this.request.getContentLength();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("POST ");
        stringBuilder.append(this.request.getRequestURI());
        stringBuilder.append(" HTTP/1.1\r\n");
        stringBuilder.append(CONTENT_LENGTH_HEADER);
        stringBuilder.append(n);
        stringBuilder.append("\r\n");
        Cookie[] cookieArray = this.request.getCookies();
        if (cookieArray != null) {
            this.addCookies(stringBuilder, cookieArray);
        }
        stringBuilder.append("Connection: Keep-Alive\r\n");
        stringBuilder.append(this.con.getHost());
        stringBuilder.append("\r\n\r\n");
        Debug.say((String)("POST REQUEST" + stringBuilder.toString()));
        byte[] byArray = stringBuilder.toString().getBytes();
        byte[] byArray2 = new byte[n + byArray.length];
        System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
        try {
            DataIO.readFully((InputStream)this.request.getInputStream(), (byte[])byArray2, (int)byArray.length, (int)n);
        }
        catch (IOException iOException) {
            throw new AssertionError((Object)"Unexpected exception");
        }
        return byArray2;
    }
}

