/*
 * Decompiled with CFR 0.152.
 */
package weblogic.servlet.proxy;

import java.io.IOException;
import java.net.Socket;
import weblogic.utils.Debug;

final class ServerFactory {
    private static final boolean DEBUG = true;
    private final int jvmidHash;
    private final int port;
    private final String host;
    private final Socket socket;

    ServerFactory(int n) {
        this(n, null, -1);
    }

    ServerFactory(int n, String string, int n2) {
        this.jvmidHash = n;
        this.host = string;
        this.port = n2;
        try {
            this.socket = new Socket(string, n2);
            Debug.say((String)("Created socket to " + string + ":" + n2 + "\t" + this.socket));
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            throw new AssertionError((Object)("Failed to initialize socket" + iOException));
        }
    }

    public int hashCode() {
        return this.jvmidHash;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object != null && object instanceof ServerFactory) {
            ServerFactory serverFactory = (ServerFactory)object;
            return serverFactory.jvmidHash == this.jvmidHash;
        }
        return false;
    }

    Socket getConnection() {
        return this.socket;
    }

    void releaseConnection(Socket socket) {
    }

    void cleanup() {
        try {
            if (this.socket != null) {
                this.socket.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

