/*
 * Decompiled with CFR 0.152.
 */
package weblogic.servlet.proxy;

import java.util.ArrayList;
import java.util.HashMap;
import weblogic.servlet.proxy.ServerFactory;
import weblogic.servlet.proxy.ServiceUnavailableException;

final class ServerManager {
    private final HashMap jvmidToIndexMap = new HashMap(5);
    private final ServiceUnavailableException exception;
    private final ArrayList serverList = new ArrayList();
    private int index = 0;
    private int size;

    private ServerManager() {
        this.exception = new ServiceUnavailableException();
    }

    static ServerManager getServerManager() {
        return SingletonMaker.singleton;
    }

    synchronized ServerFactory getServerFactory(int n) throws ServiceUnavailableException {
        if (this.size == 0) {
            throw this.exception;
        }
        Integer n2 = (Integer)this.jvmidToIndexMap.get(new Integer(n));
        int n3 = -1;
        if (n2 != null) {
            n3 = n2;
            return (ServerFactory)this.serverList.get(n3);
        }
        this.index = this.index++ % this.size;
        return (ServerFactory)this.serverList.get(this.index);
    }

    private void reset() {
        this.size = this.serverList.size();
        this.jvmidToIndexMap.clear();
        for (int i = 0; i < this.size; ++i) {
            ServerFactory serverFactory = (ServerFactory)this.serverList.get(i);
            this.jvmidToIndexMap.put(new Integer(serverFactory.hashCode()), new Integer(i));
        }
    }

    synchronized void addServer(int n, String string, int n2) {
        ServerFactory serverFactory = new ServerFactory(n, string, n2);
        this.serverList.add(serverFactory);
        this.size = this.serverList.size();
        this.jvmidToIndexMap.put(new Integer(n), new Integer(this.size - 1));
    }

    synchronized void removeServer(int n) {
        Integer n2 = new Integer(n);
        Integer n3 = (Integer)this.jvmidToIndexMap.get(n2);
        this.jvmidToIndexMap.remove(n2);
        int n4 = n3;
        ServerFactory serverFactory = (ServerFactory)this.serverList.remove(n4);
        serverFactory.cleanup();
        this.reset();
    }

    static class SingletonMaker {
        static final ServerManager singleton = new ServerManager();

        SingletonMaker() {
        }
    }
}

