/*
 * Decompiled with CFR 0.152.
 */
package weblogic.servlet.proxy;

import java.io.IOException;
import java.io.PrintStream;
import java.io.PushbackInputStream;
import java.net.Socket;
import java.net.UnknownHostException;
import weblogic.common.ResourceException;
import weblogic.common.resourcepool.PooledResource;
import weblogic.common.resourcepool.PooledResourceInfo;
import weblogic.common.resourcepool.ResourceCleanupHandler;

public class SocketConnResource
implements PooledResource {
    private final String host;
    private final int port;
    private Socket conn;
    private long creationTime;
    private boolean used;
    private final String url;
    private PooledResourceInfo prInfo;

    SocketConnResource(String string, int n) {
        this.host = string;
        this.port = n;
        this.url = "Host:" + string + ":" + n;
    }

    public PooledResourceInfo getPooledResourceInfo() {
        return this.prInfo;
    }

    public void setPooledResourceInfo(PooledResourceInfo pooledResourceInfo) {
        this.prInfo = pooledResourceInfo;
    }

    public void initialize() {
        this.createConnection();
    }

    public void setup() {
    }

    public void enable() {
        if (this.conn == null) {
            this.createConnection();
        }
    }

    public void disable() {
        this.destroy();
    }

    public void cleanup() throws ResourceException {
        this.destroy();
    }

    public void destroy() {
        if (this.conn != null) {
            try {
                this.conn.close();
                this.conn = null;
                this.creationTime = 0L;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public int test() throws ResourceException {
        return 0;
    }

    public long getCreationTime() throws ResourceException {
        return this.creationTime;
    }

    public void setResourceCleanupHandler(ResourceCleanupHandler resourceCleanupHandler) {
    }

    public ResourceCleanupHandler getResourceCleanupHandler() {
        return null;
    }

    public void setUsed(boolean bl) {
        this.used = bl;
    }

    public boolean getUsed() {
        return this.used;
    }

    public String getGroupId() {
        return null;
    }

    public boolean needDestroyAfterRelease() {
        return false;
    }

    public void setDestroyAfterRelease() {
    }

    private void createConnection() {
        try {
            this.conn = new Socket(this.host, this.port);
            this.creationTime = System.currentTimeMillis();
            this.conn.setTcpNoDelay(true);
        }
        catch (UnknownHostException unknownHostException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    final PrintStream getOutputStream() throws IOException {
        if (this.conn == null || this.conn.isClosed()) {
            this.createConnection();
        }
        return new PrintStream(this.conn.getOutputStream(), true);
    }

    final PushbackInputStream getInputStream() throws IOException {
        if (this.conn == null || this.conn.isClosed()) {
            this.createConnection();
        }
        return new PushbackInputStream(this.conn.getInputStream());
    }

    final String getHost() {
        return this.url;
    }
}

