/*
 * Decompiled with CFR 0.152.
 */
package weblogic.servlet.security;

import com.rsa.certj.cert.AttributeValueAssertion;
import com.rsa.certj.cert.PKCS10CertRequest;
import com.rsa.certj.cert.RDN;
import com.rsa.certj.cert.X500Name;
import com.rsa.jsafe.JSAFE_KeyPair;
import com.rsa.jsafe.JSAFE_PrivateKey;
import com.rsa.jsafe.JSAFE_PublicKey;
import com.rsa.jsafe.JSAFE_SecretKey;
import com.rsa.jsafe.JSAFE_SecureRandom;
import com.rsa.jsafe.JSAFE_SymmetricCipher;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.security.SecureRandom;
import java.util.Hashtable;
import java.util.Locale;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.SingleThreadModel;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import weblogic.logging.LogOutputStream;
import weblogic.security.Salt;
import weblogic.servlet.security.CertificateServletTextFormatter;
import weblogic.servlet.security.Utils;
import weblogic.utils.StackTraceUtils;
import weblogic.utils.encoders.BASE64Encoder;

public final class CertificateServlet
extends HttpServlet
implements SingleThreadModel {
    private static final byte[][] oids = new byte[][]{AttributeValueAssertion.COMMON_NAME_OID, AttributeValueAssertion.COUNTRY_NAME_OID, AttributeValueAssertion.LOCALITY_NAME_OID, AttributeValueAssertion.STATE_NAME_OID, AttributeValueAssertion.ORGANIZATION_NAME_OID, AttributeValueAssertion.ORGANIZATIONAL_UNIT_NAME_OID, AttributeValueAssertion.TELEPHONE_NUMBER_OID, AttributeValueAssertion.EMAIL_ADDRESS_OID, AttributeValueAssertion.TITLE_OID, AttributeValueAssertion.STREET_ADDRESS_OID, AttributeValueAssertion.BUSINESS_CATEGORY_OID};
    private static final int[] types = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10};
    private static boolean checked;
    private boolean errors = false;
    private Hashtable putBack = null;
    private StringBuffer errorMessage = null;
    private boolean fullStrength = false;
    protected JSAFE_SecureRandom secRan = null;
    private CertificateServletTextFormatter formatter = CertificateServletTextFormatter.getInstance();
    public static final Locale myLocale;
    public static final String myLanguage;
    private boolean englishFlag = false;

    public void service(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        CharSequence charSequence;
        String string;
        httpServletResponse.setContentType("text/html");
        PrintWriter printWriter = httpServletResponse.getWriter();
        String string2 = httpServletRequest.getContextPath() + "/images/";
        if (myLanguage.equals("English")) {
            this.englishFlag = true;
        }
        printWriter.println("<html>");
        printWriter.println("<head>");
        printWriter.println("<title>" + this.formatter.getPageTitle() + "</title>");
        printWriter.println("<meta http-equiv=\"Content-Type\" content=\"text/html; charset=iso-8859-1\">");
        printWriter.println("</head>");
        printWriter.println("<BODY alink=\"#397F70\" bgcolor=\"#FFFFFF\" link=\"#640078\" vlink=\"#DE7E00\">");
        printWriter.println("<font face=\"Helvetica\">");
        printWriter.println("<table border=0>");
        printWriter.println("<td rowspan=2 valign=top>");
        printWriter.println("<img src=" + string2 + "bealogo.gif width=69 height=69");
        printWriter.println("valign=middle border=0 align=left></a>");
        printWriter.println("</td>");
        printWriter.println("<td>");
        printWriter.println("<img src=" + string2 + "trans.gif width=1 height=14 align=right>");
        printWriter.println("</td>");
        printWriter.println("<tr>");
        printWriter.println("<td>");
        printWriter.println("<h2>");
        printWriter.println("<font face=\"Helvetica\">");
        printWriter.println(this.formatter.getPageTitle());
        printWriter.println("</font>");
        printWriter.println("</h2>");
        printWriter.println("</td>");
        printWriter.println("</tr>");
        printWriter.println("</table>");
        printWriter.println("<p>");
        String string3 = httpServletRequest.getContextPath() + "/help/";
        String string4 = string3.charAt(string3.length() - 1) == '/' ? string3 + "CertificateHelp.html" : string3 + "/CertificateHelp.html";
        if (!checked) {
            this.fullStrength = true;
            printWriter.println("<b>" + this.formatter.getFullStrengthMsg() + "</b>");
            checked = true;
        }
        String string5 = httpServletRequest.getMethod();
        if (httpServletRequest.getMethod().equals("POST")) {
            string = this.processRequest((ServletRequest)httpServletRequest);
            charSequence = "";
            charSequence = new File(httpServletRequest.getParameter("name").replace('.', '_')).getCanonicalPath();
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("<FORM\n");
            stringBuffer.append("ACTION=\"https://digitalid.verisign.com/cgi-bin/sophia.exe\"\n");
            stringBuffer.append("METHOD=\"POST\"\n");
            stringBuffer.append("NAME=\"enrollment\"\n");
            stringBuffer.append("enctype=\"x-www-form-encoded\">\n");
            stringBuffer.append("<INPUT TYPE=\"hidden\" NAME=\"operation\" VALUE=\"C1Submit\">\n");
            stringBuffer.append("<INPUT TYPE=\"hidden\" NAME=\"originator\" VALUE=\"VeriSign Inc.\">\n");
            stringBuffer.append("<INPUT TYPE=\"hidden\" NAME=\"service\" VALUE=\"other\">\n");
            stringBuffer.append("<INPUT TYPE=\"hidden\" NAME=\"commercial\" VALUE=\"yes\">\n");
            stringBuffer.append("<INPUT TYPE=\"hidden\" NAME=\"html_file\" VALUE=\"../htmldocs/server/trial/trialStep3.html\">\n");
            stringBuffer.append("<INPUT TYPE=\"hidden\" NAME=\"form_file\" VALUE=\"../fdf/testGetCSR.fdf\">\n");
            stringBuffer.append("<INPUT TYPE=\"hidden\" NAME=\"CheckWeakKey\" VALUE=\"yes\">\n");
            stringBuffer.append("<INPUT TYPE=\"hidden\" NAME=\"billing_type\" VALUE=\"Initial\">\n");
            stringBuffer.append("<INPUT TYPE=\"hidden\" NAME=\"additional_field5\" VALUE=\"$$additional_field5$$\">\n");
            stringBuffer.append("<INPUT TYPE=\"hidden\" NAME=\"csr\" VALUE=\"" + string + "\">\n");
            stringBuffer.append("<p> \n");
            stringBuffer.append(this.formatter.getProtectedKeyFilename() + "<b>" + (String)charSequence + "-key.der</b><br>\n");
            stringBuffer.append(this.formatter.getRequestFilename() + "<b>" + (String)charSequence + "-request.pem</b></p>\n");
            stringBuffer.append("<p> \n");
            stringBuffer.append("<INPUT type=\"SUBMIT\" VALUE=\"Submit\" name=\"SUBMIT\"> \n");
            stringBuffer.append(this.formatter.getCertSigningRequest() + "<b> " + this.formatter.getVeriSignName() + " </b>" + this.formatter.getTestDigitalID());
            stringBuffer.append("</FORM>\n");
            stringBuffer.append("<p>" + this.formatter.getButtonProducesTestCertificate() + "\n");
            stringBuffer.append(this.formatter.getObtainFormalServerCertVeriSign() + "\n");
            stringBuffer.append(" <a href=\"http://digitalid.verisign.com/server/trial/trialIntro.htm\">http://digitalid.verisign.com/server/trial/trialIntro.htm</a> </p>\n");
            stringBuffer.append("</p>\n\n");
            stringBuffer.append("<FORM METHOD=\"POST\"\n");
            stringBuffer.append("    NAME=\"form\"\n");
            stringBuffer.append("    ACTION=\"https://www3.cybertrust.gte.com/cgi-bin/BusinessSolutions/ServerCerts/Customer/pkcs10.sh \"\n");
            stringBuffer.append("    enctype=\"x-www-form-encoded\">\n");
            stringBuffer.append("<p> \n");
            stringBuffer.append("<INPUT TYPE=\"HIDDEN\" NAME=\"asn1\" VALUE=\"" + string + "\">\n");
            stringBuffer.append("<INPUT type=\"SUBMIT\" VALUE=\"Submit\" name=\"SUBMIT\"> \n");
            stringBuffer.append(this.formatter.getCertSigningRequest() + "<b> " + this.formatter.getBaltimoreName() + " </b>" + this.formatter.getForAFormalWLSLogicServerCert());
            stringBuffer.append("</FORM>\n");
            stringBuffer.append("<p>" + this.formatter.getThisButtonProduces() + " " + this.formatter.getAFormalWebLogicServerCertFrom() + this.formatter.getBaltimoreName() + "\n");
            stringBuffer.append(this.formatter.getMoreInformationBaltimore() + " ");
            stringBuffer.append("<a href=\"http://www.baltimore.com/sureserver/\">");
            stringBuffer.append("http://www.baltimore.com/sureserver/ </a>");
            stringBuffer.append("</p>\n");
            stringBuffer.append("<br><b>" + this.formatter.getNote() + "</b>: " + this.formatter.getAnyCertAuthWhichProducesCerts());
            if (!this.errors) {
                printWriter.println("<pre>" + string + "</pre>" + stringBuffer.toString());
            } else if (string != "1" && string != "0") {
                printWriter.println("<pre>" + string + "</pre>");
            }
        }
        if (!httpServletRequest.getMethod().equals("POST") || this.errors) {
            printWriter.println("<p>");
            printWriter.println("<FORM METHOD=\"POST\" ACTION=" + Utils.encodeXSS(httpServletRequest.getRequestURI()) + ">");
            printWriter.println("<font color=#DB1260>" + (this.errors ? this.errorMessage.toString() + "<br>" : "") + "</font>");
            printWriter.println("<p>");
            string = "href=http://www.bcpl.net/~jspath/isocodes.html target=cert>country";
            printWriter.println(this.formatter.getDirectionsParaOne() + " <a");
            printWriter.println(string + " " + this.formatter.getDirectionsParaOneB() + "</a>");
            printWriter.println(this.formatter.getDirectionsParaOneA());
            printWriter.println("<p>");
            printWriter.println(this.formatter.getDirectionsParaTwo());
            printWriter.println("<p>");
            printWriter.println(this.formatter.getDirectionsParaThree());
            printWriter.println("<p>");
            printWriter.println(this.formatter.getDirectionsParaFour());
            printWriter.println("<p>");
            printWriter.println("<ul>");
            printWriter.println("<li>");
            printWriter.println(this.formatter.getDirectionsParaFourA());
            printWriter.println("<p>");
            printWriter.println("<li>");
            printWriter.println(this.formatter.getDirectionsParaFourB());
            printWriter.println("</ul>");
            printWriter.println("<p>");
            printWriter.println(this.formatter.getDirectionsParaFive());
            printWriter.println("<p>");
            printWriter.println("<center>");
            printWriter.println("<table cellpadding=5 bgcolor=#EEEEEE border=1> <tr> <td><font");
            if (this.englishFlag) {
                printWriter.println("face=\"Helvetica\"> <img src=" + string2 + "requiredorange.gif width=13");
                printWriter.println("height=22 alt=\"Required\" border=0> <b><a");
            } else {
                printWriter.println("face=\"Helvetica\"> <img src=" + string2 + "requiredorangeI18n.gif width=13 height=22 alt=");
                printWriter.println(this.formatter.getRequired() + " border=0> <b><a");
            }
            printWriter.println("href=" + string4 + "#countrycode target=cert>");
            printWriter.println(this.formatter.getCountryCode() + "</a></b>");
            printWriter.println("</font>");
            printWriter.println("</td>");
            printWriter.println("<td>");
            printWriter.println("<font face=\"Helvetica\">");
            printWriter.println("<input size=30 type=\"text\" maxlength=2");
            printWriter.println("name=\"countryName\" value=\"" + (this.errors ? Utils.encodeXSS((String)this.putBack.get("countryName")) : this.formatter.getCountrySample()) + "\"><br>");
            printWriter.println(this.formatter.getCountryExample());
            printWriter.println("</font>");
            printWriter.println("</td>");
            printWriter.println("</tr>");
            printWriter.println("<tr> <td><font face=\"Helvetica\"> <img");
            if (this.englishFlag) {
                printWriter.println("src=" + string2 + "requiredorange.gif width=13 height=22");
                printWriter.println("alt=\"Required\" border=0> <a href=" + string4 + "#organizationalunitname");
            } else {
                printWriter.println("src=" + string2 + "requiredorangeI18n.gif width=13 height=22 alt=");
                printWriter.println(this.formatter.getRequired() + " border=0> <a href=" + string4 + "#organizationalunitname");
            }
            printWriter.println("target=cert><b>" + this.formatter.getOrgUnitName() + "</b></a>");
            printWriter.println("</font>");
            printWriter.println("</td>");
            printWriter.println("<td> ");
            printWriter.println("<font face=\"Helvetica\">");
            printWriter.println("<input size=30 type=\"text\" maxlength=64");
            printWriter.println("value=\"" + (this.errors ? Utils.encodeXSS((String)this.putBack.get("orgUnitName")) : "") + "\" name=\"orgUnitName\"><br>");
            printWriter.println(this.formatter.getOrgUnitExample());
            printWriter.println("</font>");
            printWriter.println("</td>");
            printWriter.println("</tr>");
            printWriter.println("<tr> <td><font face=\"Helvetica\"> <img");
            if (this.englishFlag) {
                printWriter.println("src=" + string2 + "requiredorange.gif width=13 height=22");
                printWriter.println("alt=\"Required\" border=0> <a href=" + string4 + "#organizationname");
            } else {
                printWriter.println("src=" + string2 + "requiredorangeI18n.gif width=13 height=22 alt=");
                printWriter.println(this.formatter.getRequired() + " border=0> <a href=" + string4 + "#organizationname");
            }
            printWriter.println("target=cert><b>" + this.formatter.getOrgName() + "</b></a>");
            printWriter.println("</font>");
            printWriter.println("</td>");
            printWriter.println("<td> ");
            printWriter.println("<font face=\"Helvetica\">");
            printWriter.println("<input size=30 type=\"text\" maxlength=64");
            printWriter.println("name=\"organizationName\" value=\"" + (this.errors ? Utils.encodeXSS((String)this.putBack.get("organizationName")) : "") + "\"><br>");
            printWriter.println(this.formatter.getOrgNameExample());
            printWriter.println("</font>");
            printWriter.println("</td>");
            printWriter.println("</tr>");
            printWriter.println("<tr> <td><img");
            if (this.englishFlag) {
                printWriter.println("src=" + string2 + "requiredorange.gif width=13 height=22");
                printWriter.println("alt=\"Required\" border=0>");
            } else {
                printWriter.println("src=" + string2 + "requiredorangeI18n.gif width=13 height=22 alt=");
                printWriter.println(this.formatter.getRequired() + " border=0>");
            }
            printWriter.println("<font face=\"Helvetica\"><a href=" + string4 + "#emailaddress");
            printWriter.println("target=cert><b>" + this.formatter.getEmailAddress() + "</b></a>");
            printWriter.println("</font>");
            printWriter.println("</td>");
            printWriter.println("<td> ");
            printWriter.println("<font face=\"Helvetica\">");
            printWriter.println("<input size=\"30\" type=\"TEXT\" maxlength=\"64\"");
            printWriter.println("name=\"email\" value=\"" + (this.errors ? Utils.encodeXSS((String)this.putBack.get("email")) : "") + "\"><br>");
            printWriter.println(this.formatter.getEmailExample());
            printWriter.println("</font>");
            printWriter.println("</td>");
            printWriter.println("</tr>");
            printWriter.println("<tr> <td><font face=\"Helvetica\"> <img");
            if (this.englishFlag) {
                printWriter.println("src=" + string2 + "requiredorange.gif width=13 height=22");
                printWriter.println("alt=\"Required\" border=0> <a href=" + string4 + "#fullhostname");
            } else {
                printWriter.println("src=" + string2 + "requiredorangeI18n.gif width=13 height=22 alt=");
                printWriter.println(this.formatter.getRequired() + " border=0> <a href=" + string4 + "#fullhostname");
            }
            printWriter.println("target=cert><b>" + this.formatter.getFullHostName() + "</b></a>");
            printWriter.println("</font>");
            printWriter.println("</td>");
            printWriter.println("<td> ");
            printWriter.println("<font face=\"Helvetica\">");
            printWriter.println("<input size=\"30\" type=\"TEXT\" maxlength=\"64\" value=\"" + (this.errors ? Utils.encodeXSS((String)this.putBack.get("name")) : InetAddress.getLocalHost().getHostName()) + "\" name=\"name\"><br>");
            printWriter.println(this.formatter.getHostExample());
            printWriter.println("</font>");
            printWriter.println("</td>");
            printWriter.println("</tr>");
            printWriter.println("<tr> <td><font face=\"Helvetica\"> <img");
            if (this.englishFlag) {
                printWriter.println("src=" + string2 + "requiredorange.gif width=13 height=22");
                printWriter.println("alt=\"Required\" border=0> <a href=" + string4 + "#localityname");
            } else {
                printWriter.println("src=" + string2 + "requiredorangeI18n.gif width=13 height=22 alt=");
                printWriter.println(this.formatter.getRequired() + " border=0> <a href=" + string4 + "#localityname");
            }
            printWriter.println("target=cert><b>Locality name (city)</b></a>");
            printWriter.println("</font>");
            printWriter.println("</td>");
            printWriter.println("<td> ");
            printWriter.println("<font face=\"Helvetica\">");
            printWriter.println("<input size=30 type=\"text\" maxlength=64");
            printWriter.println("name=\"localityName\" value=\"" + (this.errors ? Utils.encodeXSS((String)this.putBack.get("localityName")) : "") + "\"><br>");
            printWriter.println(this.formatter.getLocalityExample());
            printWriter.println("</font>");
            printWriter.println("</td>");
            printWriter.println("</tr>");
            printWriter.println("<tr> <td><font face=\"Helvetica\"> <img");
            if (this.englishFlag) {
                printWriter.println("src=" + string2 + "requiredorange.gif width=13 height=22");
                printWriter.println("alt=\"Required\" border=0> <a href=" + string4 + "#statename");
            } else {
                printWriter.println("src=" + string2 + "requiredorangeI18n.gif width=13 height=22 alt=");
                printWriter.println(this.formatter.getRequired() + " border=0> <a href=" + string4 + "#statename");
            }
            printWriter.println("target=cert><b>State name</b></a>");
            printWriter.println("</font>");
            printWriter.println("</td>");
            printWriter.println("<td>");
            printWriter.println("<font face=\"Helvetica\">");
            printWriter.println("<input size=30 type=\"text\" maxlength=64");
            printWriter.println("name=\"stateName\" value=\"" + (this.errors ? Utils.encodeXSS((String)this.putBack.get("stateName")) : "") + "\"><br>");
            printWriter.println(this.formatter.getExampleStateName());
            printWriter.println("</font>");
            printWriter.println("</td>");
            printWriter.println("</tr>");
            printWriter.println("<tr> <td><font face=\"Helvetica\"> <img");
            if (this.englishFlag) {
                printWriter.println("src=" + string2 + "requiredorange.gif width=13 height=22");
                printWriter.println("alt=\"Required\" border=0> <a href=" + string4 + "#keyPassword");
            } else {
                printWriter.println("src=" + string2 + "requiredorangeI18n.gif width=13 height=22 alt=");
                printWriter.println(this.formatter.getRequired() + " border=0> <a href=" + string4 + "#keyPassword");
            }
            printWriter.println("target=cert><b>" + this.formatter.getPrivateKeyPassword() + "</b></a>");
            printWriter.println("</font>");
            printWriter.println("</td>");
            printWriter.println("<td>");
            printWriter.println("<font face=\"Helvetica\">");
            printWriter.println("<input size=30 type=\"text\" maxlength=64");
            printWriter.println("name=\"keyPassword\" value=\"" + (this.errors ? Utils.encodeXSS((String)this.putBack.get("keyPassword")) : "") + "\"><br>");
            printWriter.println("</font>");
            printWriter.println("</td>");
            printWriter.println("</tr>");
            if (this.fullStrength) {
                charSequence = new StringBuffer();
                ((StringBuffer)charSequence).append("<tr>    \n");
                ((StringBuffer)charSequence).append(" <td>   \n");
                ((StringBuffer)charSequence).append("  <font face=\"Helvetica\">     \n");
                if (this.englishFlag) {
                    ((StringBuffer)charSequence).append("  <img src=" + string2 + "requiredorange.gif width=13 height=22 alt=\"Required\" border=0>  \n");
                } else {
                    ((StringBuffer)charSequence).append("  <img src=" + string2 + "requiredorangeI18n.gif width=13 height=22 alt=");
                    ((StringBuffer)charSequence).append(this.formatter.getRequired() + " border=0> \n");
                }
                ((StringBuffer)charSequence).append("  <a href=" + string4 + "#strength target=cert>  \n");
                ((StringBuffer)charSequence).append("  <b>" + this.formatter.getStrength() + "</b>   \n");
                ((StringBuffer)charSequence).append("  </a> </font>    \n");
                ((StringBuffer)charSequence).append(" </td>      \n");
                ((StringBuffer)charSequence).append(" <td>       \n");
                ((StringBuffer)charSequence).append("  <font face=\"Helvetica\"> \n");
                if (this.errors) {
                    int n = (Integer)this.putBack.get("strength");
                    if (n == 512) {
                        ((StringBuffer)charSequence).append("  <input type=radio name=\"strength\" value=\"512\" checked>Exportable - 512 bit key length<br>   \n");
                        ((StringBuffer)charSequence).append("  <input type=radio name=\"strength\" value=\"1024\">Domestic - 1024 bit key length<br> \n");
                        ((StringBuffer)charSequence).append("  <input type=radio name=\"strength\" value=\"2048\">Domestic - 2048 bit key length<br> \n");
                    } else if (n == 1024) {
                        ((StringBuffer)charSequence).append("  <input type=radio name=\"strength\" value=\"512\">Exportable - 512 bit key length<br>   \n");
                        ((StringBuffer)charSequence).append("  <input type=radio name=\"strength\" value=\"1024\" checked>Domestic - 1024 bit key length<br> \n");
                        ((StringBuffer)charSequence).append("  <input type=radio name=\"strength\" value=\"2048\">Domestic - 2048 bit key length<br> \n");
                    } else if (n == 2048) {
                        ((StringBuffer)charSequence).append("  <input type=radio name=\"strength\" value=\"512\">Exportable - 512 bit key length<br>   \n");
                        ((StringBuffer)charSequence).append("  <input type=radio name=\"strength\" value=\"1024\">Domestic - 1024 bit key length<br> \n");
                        ((StringBuffer)charSequence).append("  <input type=radio name=\"strength\" value=\"2048\" checked>Domestic - 2048 bit key length<br> \n");
                    } else {
                        ((StringBuffer)charSequence).append("  <input type=radio name=\"strength\" value=\"512\">Exportable - 512 bit key length<br>   \n");
                        ((StringBuffer)charSequence).append("  <input type=radio name=\"strength\" value=\"1024\">Domestic - 1024 bit key length<br> \n");
                        ((StringBuffer)charSequence).append("  <input type=radio name=\"strength\" value=\"2048\" checked>Domestic - 2048 bit key length<br> \n");
                    }
                } else {
                    ((StringBuffer)charSequence).append("  <input type=radio name=\"strength\" value=\"512\">Exportable - 512 bit key length<br>   \n");
                    ((StringBuffer)charSequence).append("  <input type=radio name=\"strength\" value=\"1024\">Domestic - 1024 bit key length<br> \n");
                    ((StringBuffer)charSequence).append("  <input type=radio name=\"strength\" value=\"2048\" checked>Domestic - 2048 bit key length<br> \n");
                }
                ((StringBuffer)charSequence).append("  </font> \n");
                ((StringBuffer)charSequence).append(" </td>  \n");
                ((StringBuffer)charSequence).append("</tr>   \n");
                if (this.errors) {
                    printWriter.write(((StringBuffer)charSequence).toString());
                    printWriter.flush();
                }
                if (!this.errors) {
                    printWriter.println(((StringBuffer)charSequence).toString());
                }
            }
            printWriter.println("<tr> ");
            printWriter.println("<td align=center colspan=2> ");
            printWriter.println("<input type=\"SUBMIT\" value='" + this.formatter.getGenerateRequest());
            printWriter.println("'name=\"SUBMIT2\">");
            printWriter.println("</td>");
            printWriter.println("</tr>");
            printWriter.println("</table>");
            printWriter.println("</center>");
            printWriter.println("</form>");
            printWriter.println("<p>");
            printWriter.println("<a href=" + string4 + " target=cert><img");
            if (this.englishFlag) {
                printWriter.println("src=" + string2 + "admintoolbar11.gif width=37 height=25 alt=\"Online");
                printWriter.println("help\" border=0></a>");
            } else {
                printWriter.println("src=" + string2 + "admintoolbarI18n11.gif width=37 height=25 alt=");
                printWriter.println(this.formatter.getOnlineHelp() + " border=0> </a>");
            }
            printWriter.println("<p>");
            if (this.englishFlag) {
                printWriter.println("<img src=" + string2 + "requiredorange.gif");
                printWriter.println("width=20 height=20 align=left alt=\"Required\" border=0>");
            } else {
                printWriter.println("<img src=" + string2 + "requiredorangeI18n.gif");
                printWriter.println("width=20 height=20 align=left alt=");
                printWriter.println(this.formatter.getRequired() + " " + "border=0> </a>");
            }
            printWriter.println(this.formatter.getRequiredFields() + "<br>");
            printWriter.println("<p>");
            this.errors = false;
        }
        printWriter.println("</font>");
        printWriter.println("</body>");
        printWriter.println("</html>");
    }

    private boolean isHostNameValid(String string) {
        return true;
    }

    private void fillPutBack() {
        this.putBack = new Hashtable();
        this.putBack.put("countryName", "");
        this.putBack.put("orgUnitName", "");
        this.putBack.put("organizationName", "");
        this.putBack.put("email", "");
        this.putBack.put("name", "");
        this.putBack.put("localityName", "");
        this.putBack.put("stateName", "");
        this.putBack.put("keyPassword", "");
        this.putBack.put("strength", "");
    }

    private String processRequest(ServletRequest servletRequest) {
        this.fillPutBack();
        this.errorMessage = new StringBuffer("<b>Errors:</b><br>");
        try {
            Object object;
            Object object2;
            Object object3;
            String string;
            String string2;
            String string3 = servletRequest.getParameter("name");
            if (string3.length() < 4 || !this.isHostNameValid(string3)) {
                this.errors = true;
                this.errorMessage.append(this.formatter.getValidHostNameError() + "<br>");
            } else {
                this.putBack.put("name", string3);
            }
            String string4 = string3.replace('.', '_') + "-key.der";
            File file = new File(string4);
            if (file.exists()) {
                this.errorMessage.append(this.formatter.getTheFile() + " <b>" + file + "</b> " + this.formatter.getOverwriteKeyFileError() + "<br>");
                this.errors = true;
            }
            if ((string2 = servletRequest.getParameter("countryName")).length() < 2) {
                this.errors = true;
                this.errorMessage.append(this.formatter.getValidCountryNameError() + "<br>");
            } else {
                this.putBack.put("countryName", string2);
            }
            String string5 = servletRequest.getParameter("stateName");
            if (string5.length() < 2) {
                this.errors = true;
                this.errorMessage.append(this.formatter.getValidStateNameError() + "<br>");
            } else {
                this.putBack.put("stateName", string5);
            }
            String string6 = servletRequest.getParameter("localityName");
            if (string6.length() < 2) {
                this.errors = true;
                this.errorMessage.append(this.formatter.getValidLocalityNameError() + "<br>");
            } else {
                this.putBack.put("localityName", string6);
            }
            String string7 = servletRequest.getParameter("organizationName");
            if (string7.length() < 1) {
                this.errors = true;
                this.errorMessage.append(this.formatter.getValidOrgNameError() + "<br>");
            } else {
                this.putBack.put("organizationName", string7);
            }
            String string8 = servletRequest.getParameter("orgUnitName");
            if (string8.length() < 1) {
                this.errors = true;
                this.errorMessage.append("Please specify a valid organizational unit name<br>");
            } else {
                this.putBack.put("orgUnitName", string8);
            }
            String string9 = servletRequest.getParameter("email");
            if (string9 != null && string9.length() > 1 && string9.indexOf("@") == -1) {
                this.errors = true;
                this.errorMessage.append(this.formatter.getValidEmailAddressError() + "<br>");
            } else {
                this.putBack.put("email", string9);
            }
            int n = 512;
            if (this.fullStrength) {
                try {
                    n = Integer.parseInt(servletRequest.getParameter("strength"));
                    if (n > 768) {
                        new LogOutputStream("certificate request servlet").info("~~~~ using " + n + " bit keysize ~~~~");
                    }
                    this.putBack.put("strength", new Integer(n));
                }
                catch (NumberFormatException numberFormatException) {
                    this.errors = true;
                    this.errorMessage.append(this.formatter.getSpecifyCertifiateStrengthError() + "<br>");
                }
            }
            if ((string = servletRequest.getParameter("keyPassword")) == null || string.length() == 0) {
                this.errors = true;
                this.errorMessage.append(this.formatter.getPrivateKeyPasswordError() + "<br>");
            }
            this.putBack.put("keyPassword", string);
            if (this.errors) {
                if (this.fullStrength) {
                    return "1";
                }
                return "0";
            }
            JSAFE_KeyPair jSAFE_KeyPair = JSAFE_KeyPair.getInstance((String)"RSA", (String)"Java");
            int[] nArray = new int[]{n, 65537};
            if (this.secRan == null) {
                this.secRan = (JSAFE_SecureRandom)JSAFE_SecureRandom.getInstance((String)"MD5Random", (String)"Java");
                this.secRan.seed(Salt.getRandomBytes(64));
            }
            jSAFE_KeyPair.generateInit(null, nArray, (SecureRandom)this.secRan);
            jSAFE_KeyPair.generate();
            JSAFE_PrivateKey jSAFE_PrivateKey = jSAFE_KeyPair.getPrivateKey();
            JSAFE_PublicKey jSAFE_PublicKey = jSAFE_KeyPair.getPublicKey();
            byte[] byArray = new byte[]{0, 17, 34, 51, 68, 85, 102, 119};
            byte[] byArray2 = null;
            JSAFE_SymmetricCipher jSAFE_SymmetricCipher = null;
            JSAFE_SecretKey jSAFE_SecretKey = null;
            try {
                jSAFE_SymmetricCipher = JSAFE_SymmetricCipher.getInstance((String)"PBE/MD5/DES/CBC/PKCS5PBE-5-56", (String)"Java");
                jSAFE_SymmetricCipher.setSalt(byArray, 0, byArray.length);
                jSAFE_SecretKey = jSAFE_SymmetricCipher.getBlankKey();
                object3 = new char[string.length()];
                string.getChars(0, string.length(), (char[])object3, 0);
                jSAFE_SecretKey.setPassword(object3, 0, ((char[])object3).length);
                jSAFE_SymmetricCipher.encryptInit(jSAFE_SecretKey, null);
                byArray2 = jSAFE_SymmetricCipher.wrapPrivateKey(jSAFE_PrivateKey, true);
            }
            catch (Throwable throwable) {
                String string10 = StackTraceUtils.throwable2StackTrace((Throwable)throwable);
                this.errors = true;
                this.errorMessage.append(this.formatter.getEncryptingPrivateKeyError() + "<br>");
                return string10;
            }
            object3 = new X500Name();
            try {
                for (int i = 0; i < types.length; ++i) {
                    object2 = null;
                    int n2 = 5632;
                    switch (types[i]) {
                        case 1: {
                            object2 = string2;
                            n2 = 4864;
                            break;
                        }
                        case 3: {
                            object2 = string5;
                            break;
                        }
                        case 4: {
                            object2 = string7;
                            break;
                        }
                        case 2: {
                            object2 = string6;
                            break;
                        }
                        case 5: {
                            object2 = string8;
                            break;
                        }
                        case 0: {
                            object2 = string3;
                            break;
                        }
                        case 7: {
                            object2 = string9;
                        }
                    }
                    if (object2 == null) continue;
                    object = new RDN();
                    object.addNameAVA(new AttributeValueAssertion(types[i], oids[i], n2, (String)object2));
                    object3.addRDN((RDN)object);
                }
            }
            catch (Throwable throwable) {
                String string11 = StackTraceUtils.throwable2StackTrace((Throwable)throwable);
                this.errors = true;
                this.errorMessage.append(this.formatter.getErrorAddingRelativeDN() + "<br>");
                return string11;
            }
            PKCS10CertRequest pKCS10CertRequest = new PKCS10CertRequest();
            try {
                pKCS10CertRequest.setSubjectName((X500Name)object3);
                pKCS10CertRequest.setSubjectPublicKey(jSAFE_PublicKey);
                pKCS10CertRequest.signCertRequest("SHA1/RSA/PKCS1Block01Pad", "Java", jSAFE_PrivateKey, (SecureRandom)this.secRan);
            }
            catch (Throwable throwable) {
                String string12 = StackTraceUtils.throwable2StackTrace((Throwable)throwable);
                this.errors = true;
                this.errorMessage.append(this.formatter.getErrorCreatingSigningRequest() + " <br>");
                return string12;
            }
            object2 = new FileOutputStream(file);
            ((FileOutputStream)object2).write(byArray2, 0, byArray2.length);
            ((FileOutputStream)object2).close();
            byte[] byArray3 = new byte[pKCS10CertRequest.getDERLen(0)];
            pKCS10CertRequest.getDEREncoding(byArray3, 0, 0);
            object = new ByteArrayOutputStream();
            PrintWriter printWriter = new PrintWriter((OutputStream)object);
            printWriter.println(this.formatter.getBeginCertRequest());
            printWriter.flush();
            int n3 = 0;
            while (n3 < byArray3.length) {
                int n4 = n3 + 54;
                if (n4 > byArray3.length) {
                    n4 = byArray3.length;
                }
                new BASE64Encoder().encodeBuffer((InputStream)new ByteArrayInputStream(byArray3, n3, n4 - n3), (OutputStream)object);
                ((OutputStream)object).flush();
                printWriter.println();
                printWriter.flush();
                n3 = n4;
            }
            ((OutputStream)object).flush();
            printWriter.println(this.formatter.getEndCertRequest());
            printWriter.flush();
            String string13 = new String(((ByteArrayOutputStream)object).toByteArray());
            String string14 = string3.replace('.', '_') + "-request";
            FileOutputStream fileOutputStream = new FileOutputStream(string14 + ".dem");
            ((OutputStream)fileOutputStream).write(byArray3);
            ((OutputStream)fileOutputStream).close();
            object2 = new FileOutputStream(string14 + ".pem");
            ((FileOutputStream)object2).write(string13.getBytes());
            ((FileOutputStream)object2).close();
            return string13;
        }
        catch (Throwable throwable) {
            String string = StackTraceUtils.throwable2StackTrace((Throwable)throwable);
            return string;
        }
    }

    static {
        myLocale = Locale.getDefault();
        myLanguage = myLocale.getDisplayLanguage();
    }
}

