/*
 * Decompiled with CFR 0.152.
 */
package weblogic.servlet.security;

import java.io.IOException;
import java.security.AccessController;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginException;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import weblogic.diagnostics.debug.DebugLogger;
import weblogic.security.SimpleCallbackHandler;
import weblogic.security.SubjectUtils;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.AppContextHandler;
import weblogic.security.service.ContextHandler;
import weblogic.security.service.PrincipalAuthenticator;
import weblogic.security.service.PrivilegedActions;
import weblogic.security.service.SecurityService;
import weblogic.security.service.SecurityServiceManager;
import weblogic.security.services.AppContext;
import weblogic.servlet.HTTPLogger;
import weblogic.servlet.internal.HttpServer;
import weblogic.servlet.internal.ServletRequestImpl;
import weblogic.servlet.internal.ServletResponseImpl;
import weblogic.servlet.internal.WebAppServletContext;
import weblogic.servlet.internal.session.RSID;
import weblogic.servlet.internal.session.SessionContext;
import weblogic.servlet.internal.session.SessionData;
import weblogic.servlet.internal.session.SessionInternal;
import weblogic.servlet.security.internal.CertSecurityModule;
import weblogic.servlet.security.internal.SecurityModule;
import weblogic.servlet.security.internal.WebAppContextHandler;
import weblogic.servlet.security.internal.WebAppSecurity;

public final class ServletAuthentication {
    private static final AuthenticatedSubject KERNELID = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
    private static final DebugLogger DEBUG_IA = DebugLogger.getDebugLogger((String)"DebugWebAppIdentityAssertion");
    private static final DebugLogger DEBUG_SEC = DebugLogger.getDebugLogger((String)"DebugWebAppSecurity");
    private String usernameField;
    private String passwordField;
    public static final int AUTHENTICATED = 0;
    public static final int FAILED_AUTHENTICATION = 1;
    public static final int NEEDS_CREDENTIALS = 2;

    public ServletAuthentication(String string, String string2) {
        this.usernameField = string;
        this.passwordField = string2;
    }

    public static void done(HttpServletRequest httpServletRequest) {
        ServletAuthentication.logout(httpServletRequest);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean logout(HttpServletRequest httpServletRequest) {
        ClassLoader classLoader;
        ServletRequestImpl servletRequestImpl = ServletRequestImpl.getOriginalRequest((ServletRequest)httpServletRequest);
        WebAppServletContext webAppServletContext = servletRequestImpl.getContext();
        HttpServer httpServer = webAppServletContext.getServer();
        SessionInternal sessionInternal = ServletAuthentication.getSessionInternal(httpServletRequest, servletRequestImpl);
        if (sessionInternal == null) {
            return false;
        }
        sessionInternal.removeInternalAttribute("weblogic.authuser");
        sessionInternal.removeInternalAttribute(SecurityModule.getWLSAuthCookieName(sessionInternal));
        String string = sessionInternal.getIdWithServerInfo();
        WebAppServletContext[] webAppServletContextArray = httpServer.getServletContextManager().getAllContexts();
        if (webAppServletContextArray != null) {
            classLoader = Thread.currentThread().getContextClassLoader();
            try {
                for (int i = 0; i < webAppServletContextArray.length; ++i) {
                    WebAppServletContext webAppServletContext2 = webAppServletContextArray[i];
                    if (webAppServletContext2 == null || webAppServletContext2 == webAppServletContext) continue;
                    Thread.currentThread().setContextClassLoader(webAppServletContext2.getServletClassLoader());
                    SessionContext sessionContext = webAppServletContext2.getSessionContext();
                    SessionData sessionData = sessionContext.getSessionInternal(string, servletRequestImpl, servletRequestImpl.getResponse());
                    if (sessionData == null) continue;
                    sessionData.removeInternalAttribute("weblogic.authuser");
                    sessionData.removeInternalAttribute(SecurityModule.getWLSAuthCookieName(sessionData));
                }
                Object var13_13 = null;
                Thread.currentThread().setContextClassLoader(classLoader);
            }
            catch (Throwable throwable) {
                Object var13_14 = null;
                Thread.currentThread().setContextClassLoader(classLoader);
                throw throwable;
            }
        }
        httpServer.getSessionLogin().unregister(sessionInternal.getInternalId());
        classLoader = SecurityServiceManager.getCurrentSubject((AuthenticatedSubject)KERNELID);
        if (classLoader != null && !SubjectUtils.isUserAnonymous((AuthenticatedSubject)classLoader)) {
            SecurityServiceManager.popSubject((AuthenticatedSubject)KERNELID);
            AuthenticatedSubject authenticatedSubject = SubjectUtils.getAnonymousSubject();
            SecurityServiceManager.pushSubject((AuthenticatedSubject)KERNELID, (AuthenticatedSubject)authenticatedSubject);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean logout(HttpSession httpSession) {
        ClassLoader classLoader;
        SessionInternal sessionInternal;
        if (httpSession == null) {
            return false;
        }
        SessionInternal sessionInternal2 = sessionInternal = httpSession instanceof SessionInternal ? (SessionInternal)httpSession : null;
        if (sessionInternal == null) {
            return false;
        }
        SessionContext sessionContext = sessionInternal.getContext();
        if (sessionContext == null) {
            return false;
        }
        WebAppServletContext webAppServletContext = sessionContext.getServletContext();
        if (webAppServletContext == null) {
            return false;
        }
        HttpServer httpServer = webAppServletContext.getServer();
        if (httpServer == null) {
            return false;
        }
        sessionInternal.removeInternalAttribute("weblogic.authuser");
        sessionInternal.removeInternalAttribute(SecurityModule.getWLSAuthCookieName(sessionInternal));
        String string = sessionInternal.getIdWithServerInfo();
        WebAppServletContext[] webAppServletContextArray = httpServer.getServletContextManager().getAllContexts();
        if (webAppServletContextArray != null) {
            classLoader = Thread.currentThread().getContextClassLoader();
            try {
                for (int i = 0; i < webAppServletContextArray.length; ++i) {
                    WebAppServletContext webAppServletContext2 = webAppServletContextArray[i];
                    if (webAppServletContext2 == null || webAppServletContext2 == webAppServletContext) continue;
                    Thread.currentThread().setContextClassLoader(webAppServletContext2.getServletClassLoader());
                    SessionContext sessionContext2 = webAppServletContext2.getSessionContext();
                    SessionData sessionData = sessionContext2.getSessionInternal(string, null, null);
                    if (sessionData == null) continue;
                    sessionData.removeInternalAttribute("weblogic.authuser");
                    sessionData.removeInternalAttribute(SecurityModule.getWLSAuthCookieName(sessionData));
                }
                Object var13_13 = null;
                Thread.currentThread().setContextClassLoader(classLoader);
            }
            catch (Throwable throwable) {
                Object var13_14 = null;
                Thread.currentThread().setContextClassLoader(classLoader);
                throw throwable;
            }
        }
        httpServer.getSessionLogin().unregister(sessionInternal.getInternalId());
        classLoader = SecurityServiceManager.getCurrentSubject((AuthenticatedSubject)KERNELID);
        if (classLoader != null && !SubjectUtils.isUserAnonymous((AuthenticatedSubject)classLoader)) {
            SecurityServiceManager.popSubject((AuthenticatedSubject)KERNELID);
            AuthenticatedSubject authenticatedSubject = SubjectUtils.getAnonymousSubject();
            SecurityServiceManager.pushSubject((AuthenticatedSubject)KERNELID, (AuthenticatedSubject)authenticatedSubject);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean invalidateAll(HttpServletRequest httpServletRequest) {
        ClassLoader classLoader;
        ServletRequestImpl servletRequestImpl = ServletRequestImpl.getOriginalRequest((ServletRequest)httpServletRequest);
        WebAppServletContext webAppServletContext = servletRequestImpl.getContext();
        HttpServer httpServer = webAppServletContext.getServer();
        SessionInternal sessionInternal = ServletAuthentication.getSessionInternal(httpServletRequest, servletRequestImpl);
        if (sessionInternal == null) {
            return false;
        }
        String string = sessionInternal.getIdWithServerInfo();
        sessionInternal.invalidate();
        WebAppServletContext[] webAppServletContextArray = httpServer.getServletContextManager().getAllContexts();
        if (webAppServletContextArray != null) {
            classLoader = Thread.currentThread().getContextClassLoader();
            try {
                for (int i = 0; i < webAppServletContextArray.length; ++i) {
                    WebAppServletContext webAppServletContext2 = webAppServletContextArray[i];
                    if (webAppServletContext2 == null) continue;
                    Thread.currentThread().setContextClassLoader(webAppServletContext2.getServletClassLoader());
                    SessionContext sessionContext = webAppServletContext2.getSessionContext();
                    SessionData sessionData = sessionContext.getSessionInternal(string, servletRequestImpl, servletRequestImpl.getResponse());
                    if (sessionData == null) continue;
                    webAppServletContext2.invalidateSession(sessionData);
                }
                Object var13_13 = null;
                Thread.currentThread().setContextClassLoader(classLoader);
            }
            catch (Throwable throwable) {
                Object var13_14 = null;
                Thread.currentThread().setContextClassLoader(classLoader);
                throw throwable;
            }
        }
        servletRequestImpl.getSessionHelper().killOldSession();
        httpServer.getSessionLogin().unregister(sessionInternal.getInternalId());
        classLoader = SecurityServiceManager.getCurrentSubject((AuthenticatedSubject)KERNELID);
        if (classLoader != null && !SubjectUtils.isUserAnonymous((AuthenticatedSubject)classLoader)) {
            SecurityServiceManager.popSubject((AuthenticatedSubject)KERNELID);
            AuthenticatedSubject authenticatedSubject = SubjectUtils.getAnonymousSubject();
            SecurityServiceManager.pushSubject((AuthenticatedSubject)KERNELID, (AuthenticatedSubject)authenticatedSubject);
        }
        return true;
    }

    public static void killCookie(HttpServletRequest httpServletRequest) {
        ServletRequestImpl servletRequestImpl = ServletRequestImpl.getOriginalRequest((ServletRequest)httpServletRequest);
        servletRequestImpl.getSessionHelper().killOldSession();
        AuthenticatedSubject authenticatedSubject = SecurityServiceManager.getCurrentSubject((AuthenticatedSubject)KERNELID);
        if (authenticatedSubject != null && !SubjectUtils.isUserAnonymous((AuthenticatedSubject)authenticatedSubject)) {
            SecurityServiceManager.popSubject((AuthenticatedSubject)KERNELID);
            AuthenticatedSubject authenticatedSubject2 = SubjectUtils.getAnonymousSubject();
            SecurityServiceManager.pushSubject((AuthenticatedSubject)KERNELID, (AuthenticatedSubject)authenticatedSubject2);
        }
    }

    public static int strong(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        ServletRequestImpl servletRequestImpl = ServletRequestImpl.getOriginalRequest((ServletRequest)httpServletRequest);
        String string = servletRequestImpl.getContext().getSecurityRealmName();
        return ServletAuthentication.strong(httpServletRequest, httpServletResponse, string);
    }

    public static int strong(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String string) throws ServletException, IOException {
        try {
            return ServletAuthentication.assertIdentity(httpServletRequest, httpServletResponse, string);
        }
        catch (LoginException loginException) {
            if (DEBUG_SEC.isDebugEnabled()) {
                DEBUG_SEC.debug("Login failed for request: " + httpServletRequest.toString(), (Throwable)loginException);
            }
            return 1;
        }
    }

    public static int assertIdentity(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String string) throws ServletException, IOException, LoginException {
        return ServletAuthentication.assertIdentity(httpServletRequest, httpServletResponse, string, null);
    }

    public static int assertIdentity(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String string, AppContext appContext) throws ServletException, IOException, LoginException {
        Object object;
        ServletRequestImpl servletRequestImpl = ServletRequestImpl.getOriginalRequest((ServletRequest)httpServletRequest);
        if (servletRequestImpl == null) {
            throw new IllegalArgumentException("The request wrapper doesn't allow access to original request");
        }
        PrincipalAuthenticator principalAuthenticator = (PrincipalAuthenticator)SecurityServiceManager.getSecurityService((AuthenticatedSubject)KERNELID, (String)string, (SecurityService.ServiceType)SecurityService.ServiceType.AUTHENTICATION);
        AuthenticatedSubject authenticatedSubject = null;
        try {
            object = CertSecurityModule.findToken(httpServletRequest, servletRequestImpl.getConnection(), servletRequestImpl.getContext(), principalAuthenticator);
            if (object == null) {
                return 2;
            }
            if (DEBUG_IA.isDebugEnabled()) {
                DEBUG_IA.debug("assertIdentity with tokem.type: " + ((CertSecurityModule.Token)object).type + " token.value: " + ((CertSecurityModule.Token)object).value);
            }
            Object object2 = null;
            object2 = appContext == null ? WebAppSecurity.getContextHandler(httpServletRequest, httpServletResponse) : AppContextHandler.getInstance((AppContext)appContext);
            authenticatedSubject = principalAuthenticator.assertIdentity(((CertSecurityModule.Token)object).type, ((CertSecurityModule.Token)object).value, (ContextHandler)object2);
        }
        catch (SecurityException securityException) {
            if (DEBUG_IA.isDebugEnabled()) {
                DEBUG_IA.debug("Indentity assertion failed", (Throwable)securityException);
            }
            HTTPLogger.logCertAuthenticationError((String)httpServletRequest.getRequestURI(), (Throwable)securityException);
        }
        if (authenticatedSubject != null && !SubjectUtils.isUserAnonymous(authenticatedSubject)) {
            object = ServletAuthentication.getSessionInternal(httpServletRequest, servletRequestImpl);
            object.setInternalAttribute("weblogic.authuser", authenticatedSubject);
            SecurityServiceManager.pushSubject((AuthenticatedSubject)KERNELID, authenticatedSubject);
            SecurityModule.setupAuthCookie(servletRequestImpl.getContext().getServer(), httpServletRequest, (SessionInternal)object, object.getInternalId());
            return 0;
        }
        return 1;
    }

    public int weak(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        String string = httpServletRequest.getParameter(this.usernameField);
        String string2 = httpServletRequest.getParameter(this.passwordField);
        return ServletAuthentication.weak(string, string2, httpServletRequest);
    }

    public static int weak(String string, String string2, HttpServletRequest httpServletRequest) {
        return ServletAuthentication.weak(string, string2, httpServletRequest, null);
    }

    public static int weak(String string, String string2, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        try {
            return ServletAuthentication.login(string, string2, httpServletRequest, httpServletResponse);
        }
        catch (LoginException loginException) {
            return 1;
        }
    }

    public static int login(String string, String string2, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws LoginException {
        WebAppServletContext webAppServletContext;
        AuthenticatedSubject authenticatedSubject;
        ServletRequestImpl servletRequestImpl = ServletRequestImpl.getOriginalRequest((ServletRequest)httpServletRequest);
        if (httpServletResponse == null) {
            httpServletResponse = servletRequestImpl.getResponse();
        }
        if ((authenticatedSubject = SecurityModule.checkAuthenticate(string, string2, httpServletRequest, httpServletResponse, webAppServletContext = servletRequestImpl.getContext())) == null) {
            return 1;
        }
        SessionInternal sessionInternal = ServletAuthentication.getSessionInternal(httpServletRequest, servletRequestImpl);
        webAppServletContext.getServer().getSessionLogin().setUser(sessionInternal.getInternalId(), authenticatedSubject);
        sessionInternal.setInternalAttribute("weblogic.authuser", authenticatedSubject);
        SecurityServiceManager.pushSubject((AuthenticatedSubject)KERNELID, (AuthenticatedSubject)authenticatedSubject);
        SecurityModule.setupAuthCookie(servletRequestImpl.getContext().getServer(), httpServletRequest, sessionInternal, sessionInternal.getInternalId());
        return 0;
    }

    public static int weak(String string, String string2, HttpSession httpSession) {
        if (httpSession == null || !(httpSession instanceof SessionInternal)) {
            return 1;
        }
        SessionInternal sessionInternal = (SessionInternal)httpSession;
        WebAppServletContext webAppServletContext = sessionInternal.getContext().getServletContext();
        HttpServer httpServer = webAppServletContext.getServer();
        String string3 = webAppServletContext.getSecurityRealmName();
        AuthenticatedSubject authenticatedSubject = null;
        PrincipalAuthenticator principalAuthenticator = (PrincipalAuthenticator)SecurityServiceManager.getSecurityService((AuthenticatedSubject)KERNELID, (String)string3, (SecurityService.ServiceType)SecurityService.ServiceType.AUTHENTICATION);
        SimpleCallbackHandler simpleCallbackHandler = new SimpleCallbackHandler(string, string2);
        try {
            authenticatedSubject = principalAuthenticator.authenticate((CallbackHandler)simpleCallbackHandler);
        }
        catch (LoginException loginException) {
            if (DEBUG_SEC.isDebugEnabled()) {
                DEBUG_SEC.debug("Login failed", (Throwable)loginException);
            }
            return 1;
        }
        if (authenticatedSubject == null) {
            return 1;
        }
        httpServer.getSessionLogin().setUser(sessionInternal.getInternalId(), authenticatedSubject);
        sessionInternal.setInternalAttribute("weblogic.authuser", authenticatedSubject);
        SecurityServiceManager.pushSubject((AuthenticatedSubject)KERNELID, (AuthenticatedSubject)authenticatedSubject);
        return 0;
    }

    public static int authObject(String string, Object object, HttpServletRequest httpServletRequest) {
        HttpSession httpSession = httpServletRequest.getSession(true);
        if (httpSession == null) {
            return 1;
        }
        return ServletAuthentication.authObject(string, object, httpSession, httpServletRequest);
    }

    public static int authObject(String string, Object object, HttpSession httpSession, HttpServletRequest httpServletRequest) {
        ServletRequestImpl servletRequestImpl = ServletRequestImpl.getOriginalRequest((ServletRequest)httpServletRequest);
        WebAppServletContext webAppServletContext = servletRequestImpl.getContext();
        AuthenticatedSubject authenticatedSubject = SecurityModule.checkAuthenticate(string, object, httpServletRequest, servletRequestImpl.getResponse(), webAppServletContext, false);
        if (authenticatedSubject == null) {
            return 1;
        }
        SessionInternal sessionInternal = httpSession != null && httpSession instanceof SessionInternal ? (SessionInternal)httpSession : ServletAuthentication.getSessionInternal(httpServletRequest, servletRequestImpl);
        webAppServletContext.getServer().getSessionLogin().setUser(sessionInternal.getInternalId(), authenticatedSubject);
        sessionInternal.setInternalAttribute("weblogic.authuser", authenticatedSubject);
        SecurityServiceManager.pushSubject((AuthenticatedSubject)KERNELID, (AuthenticatedSubject)authenticatedSubject);
        return 0;
    }

    public static int authenticate(CallbackHandler callbackHandler, HttpServletRequest httpServletRequest) {
        try {
            return ServletAuthentication.login(callbackHandler, httpServletRequest);
        }
        catch (LoginException loginException) {
            if (DEBUG_SEC.isDebugEnabled()) {
                DEBUG_SEC.debug("Login failed for request: " + httpServletRequest.toString(), (Throwable)loginException);
            }
            return 1;
        }
    }

    public static int login(CallbackHandler callbackHandler, HttpServletRequest httpServletRequest) throws LoginException {
        ServletRequestImpl servletRequestImpl = ServletRequestImpl.getOriginalRequest((ServletRequest)httpServletRequest);
        String string = servletRequestImpl.getContext().getSecurityRealmName();
        PrincipalAuthenticator principalAuthenticator = (PrincipalAuthenticator)SecurityServiceManager.getSecurityService((AuthenticatedSubject)KERNELID, (String)string, (SecurityService.ServiceType)SecurityService.ServiceType.AUTHENTICATION);
        AuthenticatedSubject authenticatedSubject = null;
        authenticatedSubject = principalAuthenticator.authenticate(callbackHandler, (ContextHandler)new WebAppContextHandler(httpServletRequest, servletRequestImpl.getResponse()));
        if (authenticatedSubject == null) {
            return 1;
        }
        SessionInternal sessionInternal = ServletAuthentication.getSessionInternal(httpServletRequest, servletRequestImpl);
        HttpServer httpServer = servletRequestImpl.getContext().getServer();
        if (sessionInternal != null) {
            if (httpServer != null) {
                httpServer.getSessionLogin().setUser(sessionInternal.getInternalId(), authenticatedSubject);
            }
            sessionInternal.setInternalAttribute("weblogic.authuser", authenticatedSubject);
        } else {
            String string2 = httpServletRequest.getRequestedSessionId();
            if (string2 != null && authenticatedSubject != null && !SubjectUtils.isUserAnonymous((AuthenticatedSubject)authenticatedSubject) && !SecurityServiceManager.isKernelIdentity((AuthenticatedSubject)authenticatedSubject)) {
                string2 = RSID.getID(string2);
                httpServer.getSessionLogin().setUser(string2, authenticatedSubject);
            }
        }
        SecurityServiceManager.pushSubject((AuthenticatedSubject)KERNELID, (AuthenticatedSubject)authenticatedSubject);
        SecurityModule.setupAuthCookie(httpServer, httpServletRequest, sessionInternal, sessionInternal.getInternalId());
        return 0;
    }

    public static void generateNewSessionID(HttpServletRequest httpServletRequest) {
        ServletRequestImpl servletRequestImpl = ServletRequestImpl.getOriginalRequest((ServletRequest)httpServletRequest);
        servletRequestImpl.getSessionHelper().updateSessionId();
        SessionInternal sessionInternal = ServletAuthentication.getSessionInternal(httpServletRequest, servletRequestImpl);
        SecurityModule.setupAuthCookie(servletRequestImpl.getContext().getServer(), httpServletRequest, sessionInternal, sessionInternal.getInternalId());
    }

    public static Cookie getSessionCookie(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        ServletRequestImpl servletRequestImpl = ServletRequestImpl.getOriginalRequest((ServletRequest)httpServletRequest);
        ServletResponseImpl servletResponseImpl = servletRequestImpl.getResponse();
        return servletResponseImpl.getCookie(servletRequestImpl.getContext().getSessionContext().getConfigMgr().getCookieName());
    }

    public static void runAs(Subject subject, HttpServletRequest httpServletRequest) {
        ServletAuthentication.runAs(AuthenticatedSubject.getFromSubject((Subject)subject), httpServletRequest);
    }

    public static void runAs(AuthenticatedSubject authenticatedSubject, HttpServletRequest httpServletRequest) {
        ServletRequestImpl servletRequestImpl = ServletRequestImpl.getOriginalRequest((ServletRequest)httpServletRequest);
        WebAppServletContext webAppServletContext = servletRequestImpl.getContext();
        HttpServer httpServer = webAppServletContext.getServer();
        SessionInternal sessionInternal = ServletAuthentication.getSessionInternal(httpServletRequest, servletRequestImpl);
        sessionInternal.setInternalAttribute("weblogic.authuser", authenticatedSubject);
        if (httpServer != null) {
            httpServer.getSessionLogin().setUser(sessionInternal.getInternalId(), authenticatedSubject);
        }
        SecurityServiceManager.pushSubject((AuthenticatedSubject)KERNELID, (AuthenticatedSubject)authenticatedSubject);
        SecurityModule.setupAuthCookie(httpServer, httpServletRequest, sessionInternal, sessionInternal.getInternalId());
    }

    public static String getTargetURLForFormAuthentication(HttpSession httpSession) {
        if (((WebAppServletContext)httpSession.getServletContext()).getConfigManager().isServletAuthFromURL()) {
            return (String)((SessionInternal)httpSession).getInternalAttribute("weblogic.formauth.targeturl");
        }
        return (String)((SessionInternal)httpSession).getInternalAttribute("weblogic.formauth.targeturi");
    }

    public static String getTargetURIForFormAuthentication(HttpSession httpSession) {
        return (String)((SessionInternal)httpSession).getInternalAttribute("weblogic.formauth.targeturi");
    }

    private static SessionInternal getSessionInternal(HttpServletRequest httpServletRequest, ServletRequestImpl servletRequestImpl) {
        SessionInternal sessionInternal;
        HttpSession httpSession = httpServletRequest.getSession(true);
        SessionInternal sessionInternal2 = sessionInternal = httpSession instanceof SessionInternal ? (SessionInternal)httpSession : (SessionInternal)servletRequestImpl.getSession(false);
        if (sessionInternal == null) {
            throw new AssertionError((Object)"Internal type of session is not available.");
        }
        return sessionInternal;
    }
}

