/*
 * Decompiled with CFR 0.152.
 */
package weblogic.servlet.security;

import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import weblogic.servlet.internal.ServletRequestImpl;
import weblogic.servlet.internal.WebAppServletContext;
import weblogic.servlet.security.internal.WebAppSecurity;

public class Utils {
    private static final String[] xssStrings = new String[]{"&quot;", null, null, "&#37;", "&amp;", "&#39;", "&#40;", "&#41;", null, "&#43;", null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, "&#59;", "&lt;", null, "&gt;"};
    private static final int BEGIN = 34;

    public static String encodeXSS(String string) {
        if (string == null) {
            return null;
        }
        int n = string.length();
        if (n < 1) {
            return string;
        }
        boolean bl = false;
        StringBuilder stringBuilder = null;
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            int n2 = c - 34;
            if (n2 > -1 && n2 < xssStrings.length && xssStrings[n2] != null) {
                if (!bl) {
                    stringBuilder = new StringBuilder(n);
                    stringBuilder.append(string.substring(0, i));
                }
                stringBuilder.append(xssStrings[n2]);
                bl = true;
                continue;
            }
            if (!bl) continue;
            stringBuilder.append(c);
        }
        if (!bl) {
            return string;
        }
        return stringBuilder.toString();
    }

    public static String getConfiguredAuthMethod(ServletContext servletContext) {
        return ((WebAppServletContext)servletContext).getSecurityManager().getWebAppSecurity().getAuthMethod();
    }

    public static String getConfiguredAuthMethod(HttpServletRequest httpServletRequest) {
        ServletRequestImpl servletRequestImpl = ServletRequestImpl.getOriginalRequest((ServletRequest)httpServletRequest);
        return servletRequestImpl.getContext().getSecurityManager().getWebAppSecurity().getAuthMethod();
    }

    public static boolean isSSLRequired(ServletContext servletContext, String string, String string2) {
        return ((WebAppServletContext)servletContext).isSSLRequired(string, string2);
    }

    public static boolean isSSLRequired(HttpServletRequest httpServletRequest) {
        ServletRequestImpl servletRequestImpl = ServletRequestImpl.getOriginalRequest((ServletRequest)httpServletRequest);
        return servletRequestImpl.getContext().isSSLRequired(WebAppSecurity.getRelativeURI(httpServletRequest), httpServletRequest.getMethod());
    }
}

