/*
 * Decompiled with CFR 0.152.
 */
package weblogic.servlet.security.internal;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import weblogic.servlet.internal.WebAppServletContext;

final class AuthFilterChain
implements FilterChain {
    private final WebAppServletContext context;
    private final Filter[] filters;
    private final int size;
    private int index = 0;

    AuthFilterChain(Filter[] filterArray, WebAppServletContext webAppServletContext) {
        this.filters = filterArray;
        this.context = webAppServletContext;
        this.size = filterArray.length;
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse) throws IOException, ServletException {
        LastFilter lastFilter = this.index >= this.size ? new LastFilter() : this.filters[this.index];
        ++this.index;
        lastFilter.doFilter(servletRequest, servletResponse, this);
    }

    private class LastFilter
    implements Filter {
        private LastFilter() {
        }

        public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
            try {
                AuthFilterChain.this.context.securedExecute((HttpServletRequest)servletRequest, (HttpServletResponse)servletResponse, false);
            }
            catch (IOException iOException) {
                throw iOException;
            }
            catch (ServletException servletException) {
                throw servletException;
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Throwable throwable) {
                throw new ServletException(throwable);
            }
        }

        public void init(FilterConfig filterConfig) throws ServletException {
        }

        public void destroy() {
        }
    }
}

