/*
 * Decompiled with CFR 0.152.
 */
package weblogic.servlet.security.internal;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import weblogic.security.SubjectUtils;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.servlet.internal.ServletRequestImpl;
import weblogic.servlet.internal.WebAppServletContext;
import weblogic.servlet.internal.session.SessionInternal;
import weblogic.servlet.security.internal.ResourceConstraint;
import weblogic.servlet.security.internal.SecurityModule;
import weblogic.servlet.security.internal.WebAppSecurity;
import weblogic.utils.StringUtils;
import weblogic.utils.encoders.BASE64Decoder;

class BasicSecurityModule
extends SecurityModule {
    public BasicSecurityModule(WebAppServletContext webAppServletContext, WebAppSecurity webAppSecurity, boolean bl) {
        super(webAppServletContext, webAppSecurity, bl);
    }

    boolean checkUserPerm(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, SessionInternal sessionInternal, ResourceConstraint resourceConstraint, AuthenticatedSubject authenticatedSubject, boolean bl) throws IOException, ServletException {
        boolean bl2 = this.webAppSecurity.hasPermission(httpServletRequest, httpServletResponse, authenticatedSubject, resourceConstraint);
        if (bl2) {
            if (!this.checkAuthCookie(this.getHttpServer(), httpServletRequest, sessionInternal)) {
                if (DEBUG_SEC.isDebugEnabled()) {
                    DEBUG_SEC.debug("AuthCookie not found - permission denied for " + httpServletRequest);
                }
                this.handleFailure(httpServletRequest, httpServletResponse, false);
                return false;
            }
            if (ServletRequestImpl.getOriginalRequest((ServletRequest)httpServletRequest).getServletStub().isProxyServlet()) {
                return true;
            }
            if (!this.enforceValidBasicAuthCredentials() || authenticatedSubject != null && !SubjectUtils.isUserAnonymous((AuthenticatedSubject)authenticatedSubject)) {
                return true;
            }
        }
        boolean bl3 = this.webAppSecurity.isFullSecurityDelegationRequired() && resourceConstraint != null && resourceConstraint.isForbidden();
        String[] stringArray = BasicSecurityModule.splitAuthHeader(httpServletRequest);
        if (stringArray == null) {
            if (bl2) {
                return true;
            }
            if (!bl3 && (authenticatedSubject == null || this.isReloginEnabled())) {
                this.handleFailure(httpServletRequest, httpServletResponse, bl);
            } else {
                this.sendForbiddenResponse(httpServletRequest, httpServletResponse);
            }
            return false;
        }
        AuthenticatedSubject authenticatedSubject2 = BasicSecurityModule.checkAuthenticate(stringArray[0], stringArray[1], httpServletRequest, httpServletResponse, this.getServletContext(), false);
        if (authenticatedSubject2 == null) {
            if (!bl3 && (authenticatedSubject == null || this.isReloginEnabled())) {
                this.handleFailure(httpServletRequest, httpServletResponse, bl);
            } else {
                this.sendForbiddenResponse(httpServletRequest, httpServletResponse);
            }
            return false;
        }
        if (!this.webAppSecurity.hasPermission(httpServletRequest, httpServletResponse, authenticatedSubject2, resourceConstraint)) {
            if (!bl3 && this.isReloginEnabled()) {
                this.handleFailure(httpServletRequest, httpServletResponse, bl);
            } else {
                this.sendForbiddenResponse(httpServletRequest, httpServletResponse);
            }
            return false;
        }
        if (!this.checkAuthCookie(this.getHttpServer(), httpServletRequest, sessionInternal)) {
            if (DEBUG_SEC.isDebugEnabled()) {
                DEBUG_SEC.debug("AuthCookie not found - permission denied for " + httpServletRequest);
            }
            this.handleFailure(httpServletRequest, httpServletResponse, false);
            return false;
        }
        if (DEBUG_SEC.isDebugEnabled()) {
            DEBUG_SEC.debug(this.webAppSecurity.getContextLog() + ": user: " + BasicSecurityModule.getUsername(authenticatedSubject2) + " has permissions to access " + httpServletRequest);
        }
        this.login(httpServletRequest, authenticatedSubject2, sessionInternal);
        return true;
    }

    protected boolean enforceValidBasicAuthCredentials() {
        BasicSecurityModule basicSecurityModule = this;
        return basicSecurityModule.webAppSecurity.getEnforceValidBasicAuthCredentials();
    }

    private void handleFailure(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, boolean bl) throws IOException, ServletException {
        if (bl && this.webAppSecurity.hasAuthFilters()) {
            this.invokeAuthFilterChain(httpServletRequest, httpServletResponse);
            return;
        }
        this.sendError(httpServletRequest, httpServletResponse);
    }

    private static final String[] splitAuthHeader(HttpServletRequest httpServletRequest) throws IOException {
        String string = ServletRequestImpl.getOriginalRequest((ServletRequest)httpServletRequest).getRequestHeaders().getAuthorization();
        if (string == null) {
            return null;
        }
        String[] stringArray = StringUtils.split((String)string, (char)' ');
        if (!stringArray[0].equals("Basic")) {
            return null;
        }
        BASE64Decoder bASE64Decoder = new BASE64Decoder();
        byte[] byArray = bASE64Decoder.decodeBuffer(stringArray[1]);
        String[] stringArray2 = StringUtils.split((String)new String(byArray), (char)':');
        if (stringArray2 == null || stringArray2.length < 2) {
            return null;
        }
        String[] stringArray3 = new String[]{stringArray2[0], stringArray2[1]};
        return stringArray3;
    }
}

