/*
 * Decompiled with CFR 0.152.
 */
package weblogic.servlet.security.internal;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.security.AccessController;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Map;
import javax.security.auth.login.LoginException;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import weblogic.diagnostics.debug.DebugLogger;
import weblogic.security.SubjectUtils;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrincipalAuthenticator;
import weblogic.security.service.PrivilegedActions;
import weblogic.security.service.SecurityService;
import weblogic.security.service.SecurityServiceManager;
import weblogic.servlet.HTTPLogger;
import weblogic.servlet.internal.ServletRequestImpl;
import weblogic.servlet.internal.VirtualConnection;
import weblogic.servlet.internal.WebAppServletContext;
import weblogic.servlet.internal.session.SessionInternal;
import weblogic.servlet.security.internal.ResourceConstraint;
import weblogic.servlet.security.internal.SecurityModule;
import weblogic.servlet.security.internal.WebAppSecurity;
import weblogic.utils.encoders.BASE64Decoder;

public final class CertSecurityModule
extends SecurityModule {
    private static final String CERT_RESERVED_IP = "IP";
    private static final String CERT_RESERVED_KEYSIZE = "Keysize";
    private static final String CERT_RESERVED_SECRETKEYSIZE = "SecretKeysize";
    private static final boolean protectResourceIfUnspecifiedConstraint = Boolean.getBoolean("weblogic.http.security.cert.protectResourceIfUnspecifiedConstraint");
    protected static final DebugLogger DEBUG_IA = DebugLogger.getDebugLogger((String)"DebugWebAppIdentityAssertion");
    private static final AuthenticatedSubject KERNEL_ID = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
    private final PrincipalAuthenticator pa;
    private final boolean alwaysAssert;

    public CertSecurityModule(WebAppServletContext webAppServletContext, WebAppSecurity webAppSecurity, boolean bl, boolean bl2) {
        super(webAppServletContext, webAppSecurity, bl);
        this.alwaysAssert = bl2;
        this.pa = (PrincipalAuthenticator)SecurityServiceManager.getSecurityService((AuthenticatedSubject)KERNEL_ID, (String)webAppServletContext.getSecurityRealmName(), (SecurityService.ServiceType)SecurityService.ServiceType.AUTHENTICATION);
    }

    boolean checkUserPerm(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, SessionInternal sessionInternal, ResourceConstraint resourceConstraint, AuthenticatedSubject authenticatedSubject, boolean bl) throws IOException, ServletException {
        AuthenticatedSubject authenticatedSubject2;
        ServletRequestImpl servletRequestImpl = ServletRequestImpl.getOriginalRequest((ServletRequest)httpServletRequest);
        boolean bl2 = false;
        if ((this.alwaysAssert || authenticatedSubject == null || SubjectUtils.isUserAnonymous((AuthenticatedSubject)authenticatedSubject)) && (authenticatedSubject2 = this.assertIdentity(httpServletRequest, httpServletResponse, servletRequestImpl.getConnection(), this.getServletContext())) != null && authenticatedSubject != authenticatedSubject2) {
            authenticatedSubject = authenticatedSubject2;
            bl2 = true;
        }
        boolean bl3 = false;
        bl3 = protectResourceIfUnspecifiedConstraint ? resourceConstraint == null && !this.webAppSecurity.isFullSecurityDelegationRequired() || authenticatedSubject != null && this.webAppSecurity.hasPermission(httpServletRequest, httpServletResponse, authenticatedSubject, resourceConstraint) : this.webAppSecurity.hasPermission(httpServletRequest, httpServletResponse, authenticatedSubject, resourceConstraint);
        if (!bl3) {
            if (DEBUG_IA.isDebugEnabled()) {
                DEBUG_IA.debug("Permission check failed for " + httpServletRequest.toString());
            }
            if (!this.isForbidden(resourceConstraint) && (authenticatedSubject == null || this.isReloginEnabled())) {
                if (bl && this.webAppSecurity.hasAuthFilters()) {
                    this.invokeAuthFilterChain(httpServletRequest, httpServletResponse);
                    return false;
                }
                this.sendUnauthorizedResponse(httpServletRequest, httpServletResponse);
            } else {
                this.sendForbiddenResponse(httpServletRequest, httpServletResponse);
            }
            return false;
        }
        if (!this.checkAuthCookie(this.getHttpServer(), httpServletRequest, sessionInternal)) {
            if (DEBUG_SEC.isDebugEnabled()) {
                DEBUG_SEC.debug("AuthCookie not found - permission denied for " + httpServletRequest);
            }
            this.sendUnauthorizedResponse(httpServletRequest, httpServletResponse);
            return false;
        }
        if (!bl2) {
            return true;
        }
        this.login(httpServletRequest, authenticatedSubject, sessionInternal);
        if (DEBUG_SEC.isDebugEnabled()) {
            DEBUG_SEC.debug(this.webAppSecurity.getContextLog() + ": user: " + CertSecurityModule.getUsername(authenticatedSubject) + " has permissions to access " + httpServletRequest);
        }
        return true;
    }

    protected AuthenticatedSubject assertIdentity(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, VirtualConnection virtualConnection, WebAppServletContext webAppServletContext) {
        try {
            Token token;
            if (DEBUG_IA.isDebugEnabled()) {
                DEBUG_IA.debug("Trying to find identity assertion tokens for " + httpServletRequest);
            }
            if ((token = CertSecurityModule.findToken(httpServletRequest, virtualConnection, webAppServletContext, this.pa)) == null) {
                if (DEBUG_IA.isDebugEnabled()) {
                    DEBUG_IA.debug("Didn't find any token!");
                }
                return null;
            }
            if (DEBUG_IA.isDebugEnabled()) {
                DEBUG_IA.debug("assertIdentity with tokem.type: " + token.type + " token.value: " + token.value);
            }
            return this.pa.assertIdentity(token.type, token.value, WebAppSecurity.getContextHandler(httpServletRequest, httpServletResponse));
        }
        catch (LoginException loginException) {
            if (DEBUG_SEC.isDebugEnabled()) {
                DEBUG_SEC.debug("Login failed for request: " + httpServletRequest.toString(), (Throwable)loginException);
            }
        }
        catch (SecurityException securityException) {
            if (DEBUG_IA.isDebugEnabled()) {
                DEBUG_IA.debug("Indentity assertion failed", (Throwable)securityException);
            }
            HTTPLogger.logCertAuthenticationError((String)httpServletRequest.getRequestURI(), (Throwable)securityException);
        }
        return null;
    }

    public static Token findToken(HttpServletRequest httpServletRequest, VirtualConnection virtualConnection, WebAppServletContext webAppServletContext, PrincipalAuthenticator principalAuthenticator) {
        String string;
        Object object;
        Object object2;
        Object object3;
        Object object4;
        X509Certificate[] x509CertificateArray;
        Map map = principalAuthenticator.getAssertionsEncodingMap();
        if (map == null || map.isEmpty()) {
            if (DEBUG_IA.isDebugEnabled()) {
                DEBUG_IA.debug("AssertionsEncodingMap for active token types was null!!");
            }
            return null;
        }
        if (DEBUG_IA.isDebugEnabled()) {
            DEBUG_IA.debug("AssertionsEncodingMap size: " + map.size());
        }
        if ((x509CertificateArray = (X509Certificate[])httpServletRequest.getAttribute("javax.servlet.request.X509Certificate")) != null && x509CertificateArray.length > 0 && map.containsKey("X.509")) {
            return new Token("X.509", x509CertificateArray);
        }
        ArrayList arrayList = virtualConnection.getPerimeterAuthClientCertType();
        int n = arrayList.size();
        if (n > 0) {
            object4 = virtualConnection.getPerimeterAuthClientCert();
            for (int i = n - 1; i >= 0; --i) {
                byte[] byArray;
                object3 = (String)arrayList.get(i);
                if (!map.containsKey(object3) || CertSecurityModule.isForbiddenTokenType((String)object3) || (byArray = CertSecurityModule.decodeCert((String)object3, (byte[])object4.get(i))) == null) continue;
                return new Token((String)object3, byArray);
            }
        }
        object4 = httpServletRequest.getHeaderNames();
        String string2 = null;
        object3 = null;
        boolean bl = true;
        if (httpServletRequest instanceof ServletRequestImpl) {
            bl = false;
            object3 = (ServletRequestImpl)httpServletRequest;
        }
        while (object4.hasMoreElements()) {
            string2 = (String)object4.nextElement();
            if ("Cookie".equalsIgnoreCase(string2) || (object2 = map.get(string2)) == null) continue;
            object = null;
            if (!bl) {
                object = ((ServletRequestImpl)((Object)object3)).getRequestHeaders().getHeaderAsBytes(string2);
            } else {
                string = httpServletRequest.getHeader(string2);
                if (string != null) {
                    try {
                        object = string.getBytes(CertSecurityModule.getInputEncoding(httpServletRequest, webAppServletContext));
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {
                        // empty catch block
                    }
                }
            }
            if (object == null || ((Object)object).length < 1 || principalAuthenticator.doesTokenRequireBase64Decoding(object2) && (object = (Object)CertSecurityModule.decodeCert(string2, (byte[])object)) == null) continue;
            return new Token(string2, object);
        }
        object2 = httpServletRequest.getCookies();
        if (object2 == null) {
            return null;
        }
        object = null;
        string = null;
        for (int i = 0; i < ((Cookie[])object2).length; ++i) {
            byte[] byArray;
            Object object5;
            object = object2[i].getName();
            string = object2[i].getValue();
            if (string == null || string.length() < 1) continue;
            if (((String)object).length() > 16 && "WL-Proxy-Client-".regionMatches(true, 0, object2[i].getName(), 0, 16)) {
                object5 = ((String)object).substring(16);
                if (!map.containsKey(object5) || (byArray = CertSecurityModule.decodeCert(object5, string.getBytes())) == null) continue;
                return new Token((String)object5, byArray);
            }
            object5 = map.get(object);
            if (object5 == null) continue;
            if (!principalAuthenticator.doesTokenRequireBase64Decoding(object5)) {
                return new Token((String)object, string.getBytes());
            }
            byArray = CertSecurityModule.decodeCert((String)object, string.getBytes());
            if (byArray == null) continue;
            return new Token((String)object, byArray);
        }
        return null;
    }

    private static String getInputEncoding(HttpServletRequest httpServletRequest, WebAppServletContext webAppServletContext) {
        String string = httpServletRequest.getCharacterEncoding();
        if (string != null) {
            return string;
        }
        return webAppServletContext.getConfigManager().getDefaultEncoding();
    }

    private static byte[] decodeCert(String string, byte[] byArray) {
        try {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            byte[] byArray2 = new BASE64Decoder().decodeBuffer((InputStream)byteArrayInputStream);
            if (byArray2 == null || byArray2.length < 1) {
                return null;
            }
            return byArray2;
        }
        catch (Exception exception) {
            HTTPLogger.logIgnoringClientCert((String)string, (Throwable)exception);
            return null;
        }
    }

    private static boolean isForbiddenTokenType(String string) {
        return string.equalsIgnoreCase(CERT_RESERVED_IP) || string.equalsIgnoreCase(CERT_RESERVED_KEYSIZE) || string.equalsIgnoreCase(CERT_RESERVED_SECRETKEYSIZE);
    }

    public static class Token {
        public final String type;
        public final Object value;

        Token(String string, Object object) {
            this.type = string;
            this.value = object;
        }
    }
}

