/*
 * Decompiled with CFR 0.152.
 */
package weblogic.servlet.security.internal;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.servlet.internal.WebAppServletContext;
import weblogic.servlet.internal.session.SessionInternal;
import weblogic.servlet.security.internal.FormSecurityModule;
import weblogic.servlet.security.internal.ResourceConstraint;
import weblogic.servlet.security.internal.SecurityModule;
import weblogic.servlet.security.internal.WebAppSecurity;

final class ChainedSecurityModule
extends SecurityModule {
    private final SecurityModule[] modules;

    public ChainedSecurityModule(WebAppServletContext webAppServletContext, WebAppSecurity webAppSecurity, String[] stringArray) {
        super(webAppServletContext, webAppSecurity);
        this.modules = this.getSecurityModules(stringArray);
    }

    private SecurityModule[] getSecurityModules(String[] stringArray) {
        if (stringArray == null || stringArray.length == 0) {
            return null;
        }
        SecurityModule[] securityModuleArray = new SecurityModule[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            securityModuleArray[i] = SecurityModule.createModule(this.getServletContext(), this.webAppSecurity, i != stringArray.length - 1, stringArray[i]);
            if (!DEBUG_SEC.isDebugEnabled()) continue;
            DEBUG_SEC.debug(this.getServletContext() + " ChainedSecuirtyModule adding " + securityModuleArray[i]);
        }
        return securityModuleArray;
    }

    boolean checkAccess(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, SessionInternal sessionInternal, ResourceConstraint resourceConstraint, boolean bl) throws IOException, ServletException {
        SecurityModule securityModule = this.modules[this.modules.length - 1];
        if (!this.webAppSecurity.checkTransport(resourceConstraint, httpServletRequest, httpServletResponse)) {
            if (securityModule instanceof FormSecurityModule) {
                return securityModule.checkAccess(httpServletRequest, httpServletResponse, sessionInternal, resourceConstraint, bl);
            }
            return false;
        }
        AuthenticatedSubject authenticatedSubject = ChainedSecurityModule.getCurrentUser(this.getHttpServer(), httpServletRequest, sessionInternal);
        for (int i = 0; i < this.modules.length; ++i) {
            if (DEBUG_SEC.isDebugEnabled()) {
                DEBUG_SEC.debug(this.getServletContext() + " ChainedSecuirtyModule checking access with " + this.modules[i]);
            }
            if (this.modules.length - 1 == i) {
                if (securityModule instanceof FormSecurityModule) {
                    return securityModule.checkAccess(httpServletRequest, httpServletResponse, sessionInternal, resourceConstraint, bl);
                }
                return securityModule.checkUserPerm(httpServletRequest, httpServletResponse, sessionInternal, resourceConstraint, authenticatedSubject, bl);
            }
            if (httpServletRequest.getRequestURI().endsWith("/j_security_check") && !(this.modules[i] instanceof FormSecurityModule)) continue;
            if (this.modules[i].checkUserPerm(httpServletRequest, httpServletResponse, sessionInternal, resourceConstraint, authenticatedSubject, false)) {
                return true;
            }
            sessionInternal = this.getUserSession(httpServletRequest, false);
        }
        return false;
    }

    boolean checkUserPerm(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, SessionInternal sessionInternal, ResourceConstraint resourceConstraint, AuthenticatedSubject authenticatedSubject, boolean bl) {
        return false;
    }

    void setAuthRealmBanner(String string) {
        super.setAuthRealmBanner(string);
        if (this.modules == null) {
            return;
        }
        for (SecurityModule securityModule : this.modules) {
            securityModule.setAuthRealmBanner(string);
        }
    }
}

