/*
 * Decompiled with CFR 0.152.
 */
package weblogic.servlet.security.internal;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import weblogic.servlet.internal.WebAppServletContext;
import weblogic.servlet.security.internal.ExternalRoleChecker;
import weblogic.servlet.security.internal.ExternalRoleCheckerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ExternalRoleCheckerManager
implements ExternalRoleChecker {
    private static final List<ExternalRoleCheckerFactory> externalRoleCheckerFactories = new LinkedList<ExternalRoleCheckerFactory>();
    private WebAppServletContext mCtx;
    private List<ExternalRoleChecker> externalRoleCheckers;

    public static synchronized void addExternalRoleCheckerFactory(ExternalRoleCheckerFactory externalRoleCheckerFactory) {
        externalRoleCheckerFactories.add(externalRoleCheckerFactory);
    }

    public static List<ExternalRoleCheckerFactory> getExternalRoleCheckerFactories() {
        return externalRoleCheckerFactories;
    }

    public ExternalRoleCheckerManager(WebAppServletContext webAppServletContext) {
        this.mCtx = webAppServletContext;
    }

    @Override
    public boolean isExternalRole(String string) {
        if (this.externalRoleCheckers == null) {
            this.externalRoleCheckers = new ArrayList<ExternalRoleChecker>();
            for (ExternalRoleCheckerFactory object : ExternalRoleCheckerManager.getExternalRoleCheckerFactories()) {
                ExternalRoleChecker externalRoleChecker = object.getExternalRoleChecker(this.mCtx);
                if (externalRoleChecker == null) continue;
                this.externalRoleCheckers.add(externalRoleChecker);
            }
        }
        for (ExternalRoleChecker externalRoleChecker : this.externalRoleCheckers) {
            if (!externalRoleChecker.isExternalRole(string)) continue;
            return true;
        }
        return false;
    }

    static {
        ExternalRoleCheckerManager.addExternalRoleCheckerFactory(new ExternalRoleCheckerFactory(){

            public ExternalRoleChecker getExternalRoleChecker(WebAppServletContext webAppServletContext) {
                return new ExternalRoleChecker(){

                    public boolean isExternalRole(String string) {
                        return false;
                    }
                };
            }
        });
    }
}

