/*
 * Decompiled with CFR 0.152.
 */
package weblogic.servlet.security.internal;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import weblogic.security.SubjectUtils;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.security.service.SecurityServiceManager;
import weblogic.servlet.HTTPLogger;
import weblogic.servlet.internal.ForwardAction;
import weblogic.servlet.internal.ServletInputStreamImpl;
import weblogic.servlet.internal.ServletRequestImpl;
import weblogic.servlet.internal.ServletResponseImpl;
import weblogic.servlet.internal.WebAppServletContext;
import weblogic.servlet.internal.session.SessionInternal;
import weblogic.servlet.security.internal.ResourceConstraint;
import weblogic.servlet.security.internal.SecurityModule;
import weblogic.servlet.security.internal.WebAppSecurity;
import weblogic.utils.http.QueryParams;

final class FormSecurityModule
extends SecurityModule {
    private static final AuthenticatedSubject KERNEL_ID = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
    private AuthenticatedSubject currentUser = null;

    public FormSecurityModule(WebAppServletContext webAppServletContext, WebAppSecurity webAppSecurity) {
        super(webAppServletContext, webAppSecurity);
    }

    boolean checkAccess(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, SessionInternal sessionInternal, ResourceConstraint resourceConstraint, boolean bl) throws IOException, ServletException {
        String string = httpServletRequest.getRequestURI();
        if (sessionInternal != null && string.endsWith("/j_security_check")) {
            this.currentUser = FormSecurityModule.getCurrentUser(this.getHttpServer(), httpServletRequest, sessionInternal);
            SecurityModule.logout(this.getHttpServer(), sessionInternal);
        }
        this.recoverSavedPostData(httpServletRequest, sessionInternal);
        String string2 = WebAppSecurity.getRelativeURI(httpServletRequest);
        if (!(resourceConstraint != null || this.webAppSecurity.isFullSecurityDelegationRequired() || string.endsWith("/j_security_check") || this.servletContext.isAdminMode())) {
            if (DEBUG_SEC.isDebugEnabled()) {
                DEBUG_SEC.debug(this.webAppSecurity.getContextLog() + ": user: " + httpServletRequest.getUserPrincipal() + " has permissions to access " + httpServletRequest);
            }
            return true;
        }
        if (!this.webAppSecurity.checkTransport(resourceConstraint, httpServletRequest, httpServletResponse)) {
            return false;
        }
        if (string2.equals(this.webAppSecurity.getLoginPage()) || string2.equals(this.webAppSecurity.getErrorPage())) {
            if (DEBUG_SEC.isDebugEnabled()) {
                DEBUG_SEC.debug(this.webAppSecurity.getContextLog() + ": user: " + httpServletRequest.getUserPrincipal() + " has permissions to access " + httpServletRequest);
            }
            return true;
        }
        if (!this.webAppSecurity.isFullSecurityDelegationRequired() && resourceConstraint != null && resourceConstraint.isUnrestricted() && !string.endsWith("/j_security_check") && !this.servletContext.isAdminMode()) {
            if (DEBUG_SEC.isDebugEnabled()) {
                DEBUG_SEC.debug(this.webAppSecurity.getContextLog() + ": " + httpServletRequest.getUserPrincipal() + " has permissions to access " + httpServletRequest);
            }
            return true;
        }
        AuthenticatedSubject authenticatedSubject = FormSecurityModule.getCurrentUser(this.getHttpServer(), httpServletRequest, sessionInternal);
        if (!this.checkUserPerm(httpServletRequest, httpServletResponse, sessionInternal, resourceConstraint, authenticatedSubject, bl)) {
            return false;
        }
        if (authenticatedSubject != null && sessionInternal != null) {
            sessionInternal = this.getUserSession(httpServletRequest, false);
            sessionInternal.removeInternalAttribute("weblogic.formauth.immediate");
        }
        return true;
    }

    private void recoverSavedPostData(HttpServletRequest httpServletRequest, SessionInternal sessionInternal) {
        ArrayList arrayList;
        byte[] byArray;
        Object object = null;
        if (sessionInternal == null) {
            return;
        }
        try {
            object = sessionInternal.getInternalAttribute("weblogic.formauth.postcookie");
        }
        catch (IllegalStateException illegalStateException) {
            object = null;
        }
        if (object == null) {
            String string = (String)sessionInternal.getInternalAttribute("weblogic.formauth.method");
            if (string != null && string.equals("GET")) {
                sessionInternal.removeInternalAttribute("weblogic.formauth.method");
            }
            return;
        }
        sessionInternal.removeInternalAttribute("weblogic.formauth.method");
        sessionInternal.removeInternalAttribute("weblogic.formauth.postcookie");
        ServletRequestImpl servletRequestImpl = ServletRequestImpl.getOriginalRequest((ServletRequest)httpServletRequest);
        String string = servletRequestImpl.getMethod();
        servletRequestImpl.setMethod("POST");
        QueryParams queryParams = (QueryParams)sessionInternal.getInternalAttribute("weblogic.formauth.queryparams");
        if (queryParams != null) {
            sessionInternal.removeInternalAttribute("weblogic.formauth.queryparams");
            servletRequestImpl.getRequestParameters().setQueryParams(queryParams);
        }
        if ((byArray = (byte[])sessionInternal.getInternalAttribute("weblogic.formauth.bytearray")) != null) {
            sessionInternal.removeInternalAttribute("weblogic.formauth.bytearray");
            servletRequestImpl.setInputStream(new ServletInputStreamImpl(new ByteArrayInputStream(byArray)));
            if (string.equals("POST")) {
                servletRequestImpl.getResponse().disableKeepAlive();
            }
        }
        if ((arrayList = (ArrayList)sessionInternal.getInternalAttribute("weblogic.formauth.reqheadernames")) != null) {
            int n;
            int n2;
            ArrayList arrayList2 = (ArrayList)sessionInternal.getInternalAttribute("weblogic.formauth.reqheadervalues");
            byte[] byArray2 = servletRequestImpl.getRequestHeaders().getHeaderAsBytes("Cookie");
            if (byArray2 != null) {
                n2 = arrayList.size();
                n = 0;
                for (int i = 0; i < n2; ++i) {
                    if (!"Cookie".startsWith((String)arrayList.get(i))) continue;
                    arrayList2.set(i, byArray2);
                    n = 1;
                    break;
                }
                if (n == 0) {
                    arrayList.add("Cookie");
                    arrayList2.add(byArray2);
                }
            }
            sessionInternal.removeInternalAttribute("weblogic.formauth.reqheadernames");
            sessionInternal.removeInternalAttribute("weblogic.formauth.reqheadervalues");
            if (byArray == null || byArray.length == 0) {
                n2 = arrayList.size();
                for (n = 0; n < n2; ++n) {
                    String string2 = (String)arrayList.get(n);
                    if (!"Content-Length".equalsIgnoreCase(string2)) continue;
                    arrayList2.set(n, String.valueOf(0).getBytes());
                    break;
                }
            }
            servletRequestImpl.getRequestHeaders().reset();
            servletRequestImpl.getRequestHeaders().setHeaders(arrayList, arrayList2);
        }
    }

    boolean checkUserPerm(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, SessionInternal sessionInternal, ResourceConstraint resourceConstraint, AuthenticatedSubject authenticatedSubject, boolean bl) throws IOException, ServletException {
        if (httpServletRequest.getRequestURI().endsWith("j_security_check")) {
            return this.processJSecurityCheck(httpServletRequest, httpServletResponse, sessionInternal);
        }
        if (authenticatedSubject != null) {
            return this.processLoggedInUser(httpServletRequest, httpServletResponse, authenticatedSubject);
        }
        if (this.webAppSecurity.isFullSecurityDelegationRequired() && this.webAppSecurity.hasPermission(httpServletRequest, httpServletResponse, null, resourceConstraint)) {
            return true;
        }
        if (bl && this.webAppSecurity.hasAuthFilters()) {
            this.invokeAuthFilterChain(httpServletRequest, httpServletResponse);
            return false;
        }
        if (this.isForbidden(resourceConstraint)) {
            this.sendForbiddenResponse(httpServletRequest, httpServletResponse);
        } else {
            this.sendLoginPage(httpServletRequest, httpServletResponse);
        }
        return false;
    }

    private boolean processJSecurityCheck(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, SessionInternal sessionInternal) throws IOException {
        String string = httpServletRequest.getParameter("j_character_encoding");
        if (string != null) {
            try {
                if (Charset.isSupported(string)) {
                    httpServletRequest.setCharacterEncoding(string);
                }
            }
            catch (IllegalCharsetNameException illegalCharsetNameException) {
                // empty catch block
            }
        }
        String string2 = httpServletRequest.getParameter("j_username");
        String string3 = httpServletRequest.getParameter("j_password");
        if (string2 == null || string3 == null) {
            this.sendError(httpServletRequest, httpServletResponse);
            return false;
        }
        AuthenticatedSubject authenticatedSubject = FormSecurityModule.checkAuthenticate(string2, string3, httpServletRequest, httpServletResponse, this.getServletContext(), true);
        if (authenticatedSubject == null) {
            this.sendError(httpServletRequest, httpServletResponse);
            return false;
        }
        httpServletRequest.setAttribute("weblogic.auth.result", (Object)new Integer(0));
        String string4 = null;
        if (sessionInternal != null) {
            string4 = this.getServletContext().getConfigManager().isRetainOriginalURL() ? (String)sessionInternal.getInternalAttribute("weblogic.formauth.targeturl") : (String)sessionInternal.getInternalAttribute("weblogic.formauth.targeturi");
        }
        if (this.currentUser != null && !SubjectUtils.isUserAnonymous((AuthenticatedSubject)this.currentUser) && !SubjectUtils.getUsername((AuthenticatedSubject)this.currentUser).equals(string2) && this.getServletContext().getSessionContext().getConfigMgr().isInvalidateOnRelogin()) {
            if (sessionInternal != null && sessionInternal.isValid()) {
                sessionInternal.invalidate();
            }
            sessionInternal = null;
        }
        this.login(httpServletRequest, authenticatedSubject, sessionInternal);
        if (string4 == null) {
            String string5 = httpServletRequest.getRequestURI();
            int n = httpServletRequest.getContextPath().length();
            String string6 = n > 0 ? string5.substring(0, n) : "/";
            httpServletResponse.sendRedirect(httpServletResponse.encodeRedirectURL(string6));
            return false;
        }
        sessionInternal = this.getUserSession(httpServletRequest, false);
        String string7 = (String)sessionInternal.getInternalAttribute("weblogic.formauth.method");
        if (string7 != null && "POST".equals(string7)) {
            sessionInternal.setInternalAttribute("weblogic.formauth.postcookie", "true");
        }
        sessionInternal.setInternalAttribute("weblogic.formauth.immediate", "true");
        httpServletResponse.sendRedirect(httpServletResponse.encodeRedirectURL(string4));
        return false;
    }

    private boolean processLoggedInUser(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, AuthenticatedSubject authenticatedSubject) throws IOException {
        SessionInternal sessionInternal = this.getUserSession(httpServletRequest, false);
        ResourceConstraint resourceConstraint = this.webAppSecurity.getConstraint(httpServletRequest);
        if (!this.webAppSecurity.hasPermission(httpServletRequest, httpServletResponse, authenticatedSubject, resourceConstraint)) {
            if (sessionInternal != null && sessionInternal.getInternalAttribute("weblogic.formauth.immediate") != null) {
                sessionInternal.removeInternalAttribute("weblogic.formauth.immediate");
                this.sendError(httpServletRequest, httpServletResponse);
                return false;
            }
            if (this.isReloginEnabled() && !this.isForbidden(resourceConstraint)) {
                this.sendLoginPage(httpServletRequest, httpServletResponse);
            } else {
                this.sendForbiddenResponse(httpServletRequest, httpServletResponse);
            }
            return false;
        }
        if (sessionInternal != null) {
            sessionInternal.removeInternalAttribute("weblogic.formauth.targeturi");
            sessionInternal.removeInternalAttribute("weblogic.formauth.targeturl");
        }
        if (!this.checkAuthCookie(this.getHttpServer(), httpServletRequest, sessionInternal)) {
            if (DEBUG_SEC.isDebugEnabled()) {
                DEBUG_SEC.debug("AuthCookie not found - permission denied for " + httpServletRequest);
            }
            this.sendLoginPage(httpServletRequest, httpServletResponse);
            return false;
        }
        return true;
    }

    void sendError(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException {
        httpServletResponse.setStatus(403);
        if (httpServletResponse.isCommitted()) {
            httpServletResponse.sendRedirect(httpServletResponse.encodeURL(FormSecurityModule.getContextURL(httpServletRequest) + this.webAppSecurity.getErrorPage()));
        } else {
            ForwardAction forwardAction;
            Throwable throwable;
            RequestDispatcher requestDispatcher = httpServletRequest.getRequestDispatcher(this.webAppSecurity.getErrorPage());
            AuthenticatedSubject authenticatedSubject = SecurityModule.getCurrentUser(this.getServletContext().getServer(), httpServletRequest);
            if (authenticatedSubject == null) {
                authenticatedSubject = SubjectUtils.getAnonymousSubject();
            }
            if ((throwable = (Throwable)SecurityServiceManager.runAs((AuthenticatedSubject)KERNEL_ID, (AuthenticatedSubject)authenticatedSubject, (PrivilegedAction)(forwardAction = new ForwardAction(requestDispatcher, (ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse)))) != null) {
                if (throwable instanceof IOException) {
                    throw (IOException)throwable;
                }
                HTTPLogger.logSendError((String)this.getServletContext().getLogContext(), (Throwable)throwable);
            }
        }
    }

    private static final String getContextURL(HttpServletRequest httpServletRequest) {
        int n = httpServletRequest.getServerPort();
        StringBuffer stringBuffer = new StringBuffer(128);
        if (n == 80 || n == 443) {
            stringBuffer.append(httpServletRequest.getScheme()).append("://");
            stringBuffer.append(httpServletRequest.getServerName());
            stringBuffer.append(ServletRequestImpl.getResolvedContextPath(httpServletRequest));
        } else {
            stringBuffer.append(httpServletRequest.getScheme()).append("://");
            stringBuffer.append(httpServletRequest.getServerName()).append(':');
            stringBuffer.append(httpServletRequest.getServerPort());
            stringBuffer.append(ServletRequestImpl.getResolvedContextPath(httpServletRequest));
        }
        return stringBuffer.toString();
    }

    private final void sendLoginPage(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException {
        this.stuffSession(httpServletRequest, httpServletResponse);
        httpServletResponse.sendRedirect(httpServletResponse.encodeURL(ServletRequestImpl.getResolvedContextPath(httpServletRequest) + this.webAppSecurity.getLoginPage()));
    }

    private void stuffSession(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException {
        SessionInternal sessionInternal = this.getUserSession(httpServletRequest, true);
        ServletRequestImpl servletRequestImpl = ServletRequestImpl.getOriginalRequest((ServletRequest)httpServletRequest);
        ServletResponseImpl servletResponseImpl = servletRequestImpl.getResponse();
        String string = httpServletRequest.getRequestURI();
        String string2 = servletResponseImpl.getURLForRedirect(httpServletRequest.getRequestURI());
        String string3 = httpServletRequest.getQueryString();
        if (string3 != null) {
            string2 = string2 + "?" + string3;
            string = string + "?" + string3;
        }
        sessionInternal.setInternalAttribute("weblogic.formauth.targeturi", string);
        sessionInternal.setInternalAttribute("weblogic.formauth.targeturl", string2);
        sessionInternal.setInternalAttribute("weblogic.formauth.method", httpServletRequest.getMethod());
        if (!servletRequestImpl.getInputHelper().getRequestParser().isMethodPost()) {
            return;
        }
        ServletInputStream servletInputStream = httpServletRequest.getInputStream();
        byte[] byArray = new byte[4096];
        int n = 0;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        while ((n = servletInputStream.read(byArray, 0, byArray.length)) != -1) {
            byteArrayOutputStream.write(byArray, 0, n);
        }
        byte[] byArray2 = byteArrayOutputStream.toByteArray();
        if (byArray2.length > 0) {
            sessionInternal.setInternalAttribute("weblogic.formauth.bytearray", byArray2);
        } else {
            sessionInternal.removeInternalAttribute("weblogic.formauth.bytearray");
        }
        sessionInternal.setInternalAttribute("weblogic.formauth.reqheadernames", servletRequestImpl.getRequestHeaders().getHeaderNamesAsArrayList().clone());
        sessionInternal.setInternalAttribute("weblogic.formauth.reqheadervalues", servletRequestImpl.getRequestHeaders().getHeaderValuesAsArrayList().clone());
    }
}

