/*
 * Decompiled with CFR 0.152.
 */
package weblogic.servlet.security.internal;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Set;
import weblogic.j2ee.descriptor.SecurityConstraintBean;
import weblogic.management.DeploymentException;
import weblogic.security.service.ResourceCreationException;
import weblogic.security.service.URLResource;
import weblogic.security.spi.Resource;
import weblogic.servlet.HTTPLogger;
import weblogic.servlet.security.internal.WebAppSecurityWLS;

final class ResourceConstraint {
    private final String id;
    private final String httpMethod;
    private int transportGuarantee = 0;
    private String[] roles = null;
    private boolean forbidden = false;
    private boolean unrestricted = false;
    private boolean loginRequired = false;

    public ResourceConstraint(String string, String string2, SecurityConstraintBean securityConstraintBean) {
        this.id = string;
        this.httpMethod = string2;
        if (securityConstraintBean.getAuthConstraint() != null) {
            this.roles = securityConstraintBean.getAuthConstraint().getRoleNames();
        } else {
            this.unrestricted = true;
        }
        if (securityConstraintBean.getUserDataConstraint() != null) {
            this.transportGuarantee = ResourceConstraint.getTransportGuarantee(securityConstraintBean.getUserDataConstraint().getTransportGuarantee());
        }
    }

    boolean isForbidden() {
        return this.forbidden;
    }

    boolean isUnrestricted() {
        return this.unrestricted;
    }

    boolean isLoginRequired() {
        return this.loginRequired;
    }

    int getTransportGuarantee() {
        return this.transportGuarantee;
    }

    String getHttpMethod() {
        return this.httpMethod;
    }

    String[] getRoles() {
        return this.roles;
    }

    String getResourceId() {
        return this.id;
    }

    void addRoles(String[] stringArray) {
        String[] stringArray2 = new String[this.roles.length + stringArray.length];
        ArrayList<String> arrayList = new ArrayList<String>(Arrays.asList(this.roles));
        arrayList.addAll(Arrays.asList(stringArray));
        arrayList.toArray(stringArray2);
        this.roles = stringArray2;
    }

    void setTransportGuarantee(int n) {
        this.transportGuarantee = n;
    }

    public void deploy(WebAppSecurityWLS webAppSecurityWLS) throws DeploymentException {
        URLResource uRLResource = new URLResource(webAppSecurityWLS.getContext().getApplicationId(), webAppSecurityWLS.getContext().getContextPath(), this.id, this.httpMethod, null);
        try {
            if (this.unrestricted) {
                webAppSecurityWLS.getAuthManager().deployUncheckedPolicy(webAppSecurityWLS.getAuthMgrHandle(), (Resource)uRLResource);
                return;
            }
            if (this.roles == null || this.roles.length < 1) {
                this.forbidden = true;
                webAppSecurityWLS.getAuthManager().deployExcludedPolicy(webAppSecurityWLS.getAuthMgrHandle(), (Resource)uRLResource);
                return;
            }
            for (int i = 0; i < this.roles.length; ++i) {
                if (!this.roles[i].equals("*")) continue;
                if (webAppSecurityWLS.getContext().getConfigManager().isAllowAllRoles()) {
                    this.loginRequired = true;
                    if (webAppSecurityWLS.isFullSecurityDelegationRequired()) {
                        webAppSecurityWLS.getAuthManager().deployUncheckedPolicy(webAppSecurityWLS.getAuthMgrHandle(), (Resource)uRLResource);
                    }
                    return;
                }
                Set set = webAppSecurityWLS.getRoles();
                if (set.size() == 0) {
                    this.forbidden = true;
                    webAppSecurityWLS.getAuthManager().deployExcludedPolicy(webAppSecurityWLS.getAuthMgrHandle(), (Resource)uRLResource);
                    return;
                }
                this.roles = new String[set.size()];
                set.toArray(this.roles);
                break;
            }
            webAppSecurityWLS.getAuthManager().deployPolicy(webAppSecurityWLS.getAuthMgrHandle(), (Resource)uRLResource, this.roles);
        }
        catch (ResourceCreationException resourceCreationException) {
            this.forbidden = true;
            if (uRLResource == null) {
                HTTPLogger.logCouldNotDeployPolicy((String)this.id, (Throwable)resourceCreationException);
            } else {
                HTTPLogger.logCouldNotDeployPolicy((String)uRLResource.toString(), (Throwable)resourceCreationException);
            }
            throw new DeploymentException(resourceCreationException);
        }
    }

    private static int getTransportGuarantee(String string) {
        if (string == null) {
            return 0;
        }
        if ("INTEGRAL".equalsIgnoreCase(string)) {
            return 1;
        }
        if ("CONFIDENTIAL".equalsIgnoreCase(string)) {
            return 2;
        }
        return 0;
    }
}

