/*
 * Decompiled with CFR 0.152.
 */
package weblogic.servlet.security.internal;

import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginException;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import weblogic.diagnostics.debug.DebugLogger;
import weblogic.management.configuration.WebAppContainerMBean;
import weblogic.management.provider.ManagementService;
import weblogic.security.Salt;
import weblogic.security.SubjectUtils;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.auth.login.PasswordCredential;
import weblogic.security.service.ContextHandler;
import weblogic.security.service.PrincipalAuthenticator;
import weblogic.security.service.PrivilegedActions;
import weblogic.security.service.SecurityService;
import weblogic.security.service.SecurityServiceManager;
import weblogic.security.subject.AbstractSubject;
import weblogic.servlet.HTTPLogger;
import weblogic.servlet.internal.ErrorMessages;
import weblogic.servlet.internal.HttpServer;
import weblogic.servlet.internal.ServletRequestImpl;
import weblogic.servlet.internal.ServletResponseImpl;
import weblogic.servlet.internal.WebAppConfigManager;
import weblogic.servlet.internal.WebAppServletContext;
import weblogic.servlet.internal.session.HTTPSessionLogger;
import weblogic.servlet.internal.session.RSID;
import weblogic.servlet.internal.session.SessionContext;
import weblogic.servlet.internal.session.SessionData;
import weblogic.servlet.internal.session.SessionInternal;
import weblogic.servlet.security.internal.Basic2SecurityModule;
import weblogic.servlet.security.internal.BasicSecurityModule;
import weblogic.servlet.security.internal.CertSecurityModule;
import weblogic.servlet.security.internal.ChainedSecurityModule;
import weblogic.servlet.security.internal.FormSecurityModule;
import weblogic.servlet.security.internal.ResourceConstraint;
import weblogic.servlet.security.internal.ServletCallbackHandler;
import weblogic.servlet.security.internal.WebAppContextHandler;
import weblogic.servlet.security.internal.WebAppSecurity;
import weblogic.utils.NestedRuntimeException;
import weblogic.utils.StringUtils;
import weblogic.utils.encoders.BASE64Encoder;

public abstract class SecurityModule {
    public static final String SESSION_AUTH_USER = "weblogic.authuser";
    public static final String SESSION_FORM_URL = "weblogic.formauth.targeturl";
    public static final String SESSION_FORM_URI = "weblogic.formauth.targeturi";
    public static final int AUTHENTICATED = 0;
    public static final int FAILED_AUTHENTICATION = 1;
    public static final int NEEDS_CREDENTIALS = 2;
    static final String SESSION_FORM_METHOD = "weblogic.formauth.method";
    static final String SESSION_FORM_QUERY = "weblogic.formauth.queryparams";
    static final String SESSION_FORM_BYTEARRAY = "weblogic.formauth.bytearray";
    static final String SESSION_FORM_REQHEADNAMES = "weblogic.formauth.reqheadernames";
    static final String SESSION_FORM_REQHEADVALUES = "weblogic.formauth.reqheadervalues";
    static final String SESSION_POST_COOKIE = "weblogic.formauth.postcookie";
    static final String SESSION_FORM_IMMEDIATE = "weblogic.formauth.immediate";
    public static final String REQUEST_AUTH_RESULT = "weblogic.auth.result";
    public static final int REQUEST_PRE_AUTH = -1;
    protected static int AUTH_COOKIE_ID_LENGTH = 20;
    public static final String ASSERTION_AUTH = "ASSERTION";
    public static final String REALM_AUTH = "REALM";
    private static final AuthenticatedSubject KERNEL_ID = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
    protected final WebAppServletContext servletContext;
    protected final WebAppSecurity webAppSecurity;
    protected static final DebugLogger DEBUG_SEC = DebugLogger.getDebugLogger((String)"DebugWebAppSecurity");
    protected String authRealmBanner = null;
    protected boolean delegateControl = false;
    private static final WebAppContainerMBean webAppContainer = ManagementService.getRuntimeAccess(KERNEL_ID).getDomain().getWebAppContainer();
    private static boolean changeSessionIdOnAuthentication = webAppContainer.isChangeSessionIDOnAuthentication();

    public SecurityModule(WebAppServletContext webAppServletContext, WebAppSecurity webAppSecurity) {
        this.servletContext = webAppServletContext;
        this.webAppSecurity = webAppSecurity;
    }

    public SecurityModule(WebAppServletContext webAppServletContext, WebAppSecurity webAppSecurity, boolean bl) {
        this(webAppServletContext, webAppSecurity);
        this.delegateControl = bl;
    }

    HttpServer getHttpServer() {
        return this.servletContext.getServer();
    }

    WebAppServletContext getServletContext() {
        return this.servletContext;
    }

    boolean isReloginEnabled() {
        return this.servletContext.getConfigManager().isReloginEnabled();
    }

    boolean checkAccess(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, SessionInternal sessionInternal, ResourceConstraint resourceConstraint, boolean bl) throws IOException, ServletException {
        if (!this.webAppSecurity.checkTransport(resourceConstraint, httpServletRequest, httpServletResponse)) {
            return false;
        }
        AuthenticatedSubject authenticatedSubject = SecurityModule.getCurrentUser(this.getHttpServer(), httpServletRequest, sessionInternal);
        return this.checkUserPerm(httpServletRequest, httpServletResponse, sessionInternal, resourceConstraint, authenticatedSubject, bl);
    }

    abstract boolean checkUserPerm(HttpServletRequest var1, HttpServletResponse var2, SessionInternal var3, ResourceConstraint var4, AuthenticatedSubject var5, boolean var6) throws IOException, ServletException;

    public static final AuthenticatedSubject getCurrentUser(HttpServer httpServer, HttpServletRequest httpServletRequest) {
        SessionInternal sessionInternal = (SessionInternal)httpServletRequest.getSession(false);
        return SecurityModule.getCurrentUser(httpServer, httpServletRequest, sessionInternal);
    }

    public static String getWLSAuthCookieName(SessionInternal sessionInternal) {
        if (sessionInternal == null) {
            return "_WL_AUTHCOOKIE_JSESSIONID";
        }
        return sessionInternal.getContext().getConfigMgr().getWLSAuthCookieName();
    }

    private static String getWLSAuthCookieName(WebAppServletContext webAppServletContext) {
        return webAppServletContext.getSessionContext().getConfigMgr().getWLSAuthCookieName();
    }

    public static final AuthenticatedSubject getCurrentUser(HttpServer httpServer, HttpServletRequest httpServletRequest, SessionInternal sessionInternal) {
        AuthenticatedSubject authenticatedSubject = null;
        try {
            if (sessionInternal != null) {
                String string = sessionInternal.getInternalId();
                authenticatedSubject = httpServer.getSessionLogin().getUser(string);
                if (authenticatedSubject != null) {
                    sessionInternal.setInternalAttribute(SESSION_AUTH_USER, authenticatedSubject);
                } else {
                    authenticatedSubject = (AuthenticatedSubject)sessionInternal.getInternalAttribute(SESSION_AUTH_USER);
                    if (authenticatedSubject != null) {
                        httpServer.getSessionLogin().setUser(string, authenticatedSubject);
                    }
                }
                String string2 = SecurityModule.getWLSAuthCookieName(sessionInternal);
                String string3 = (String)sessionInternal.getInternalAttribute(string2);
                if (string3 == null) {
                    string3 = httpServer.getSessionLogin().getCookieId(string);
                    if (string3 != null) {
                        sessionInternal.setInternalAttribute(string2, string3);
                    }
                } else {
                    httpServer.getSessionLogin().addCookieId(string, string3);
                }
            } else {
                String string = httpServletRequest.getRequestedSessionId();
                if (string != null) {
                    string = RSID.getID(string);
                    authenticatedSubject = httpServer.getSessionLogin().getUser(string);
                }
            }
        }
        catch (IllegalStateException illegalStateException) {
            String string = sessionInternal == null ? "null" : sessionInternal.getInternalId();
            HTTPSessionLogger.logSessionExpired((String)string, (Exception)illegalStateException);
        }
        return authenticatedSubject;
    }

    public static final AuthenticatedSubject checkAuthenticate(String string, Object object, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, WebAppServletContext webAppServletContext, boolean bl) {
        try {
            return SecurityModule.checkAuthenticate(string, object, httpServletRequest, httpServletResponse, webAppServletContext);
        }
        catch (LoginException loginException) {
            if (DEBUG_SEC.isDebugEnabled()) {
                DEBUG_SEC.debug("Login failed for request: " + httpServletRequest.toString(), (Throwable)loginException);
            }
            if (bl) {
                httpServletRequest.setAttribute("javax.servlet.error.exception_type", loginException.getClass());
                httpServletRequest.setAttribute("javax.servlet.error.exception", (Object)loginException);
                httpServletRequest.setAttribute("javax.servlet.error.message", (Object)loginException.getMessage());
                SessionInternal sessionInternal = (SessionInternal)httpServletRequest.getSession(false);
                if (sessionInternal != null) {
                    String string2 = (String)sessionInternal.getInternalAttribute(SESSION_FORM_URI);
                    httpServletRequest.setAttribute("javax.servlet.error.request_uri", (Object)(string2 == null ? httpServletRequest.getRequestURI() : string2));
                }
                httpServletRequest.setAttribute("javax.servlet.jsp.jspException", (Object)loginException);
                httpServletRequest.setAttribute("javax.servlet.error.status_code", (Object)new Integer(403));
            }
            return null;
        }
    }

    public static AuthenticatedSubject checkAuthenticate(String string, Object object, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, WebAppServletContext webAppServletContext) throws LoginException {
        HttpServer httpServer = webAppServletContext.getServer();
        String string2 = webAppServletContext.getSecurityRealmName();
        String string3 = webAppServletContext.getLogContext();
        SessionInternal sessionInternal = (SessionInternal)httpServletRequest.getSession(false);
        AuthenticatedSubject authenticatedSubject = null;
        authenticatedSubject = SecurityModule.getCurrentUser(httpServer, httpServletRequest, sessionInternal);
        if (authenticatedSubject != null) {
            if (string == null || string.equals(SubjectUtils.getUsername((AuthenticatedSubject)authenticatedSubject))) {
                return authenticatedSubject;
            }
            SecurityModule.logout(httpServer, sessionInternal);
        }
        if (string == null) {
            return null;
        }
        ServletCallbackHandler servletCallbackHandler = new ServletCallbackHandler(string, object, httpServletRequest, httpServletResponse);
        PrincipalAuthenticator principalAuthenticator = (PrincipalAuthenticator)SecurityServiceManager.getSecurityService((AuthenticatedSubject)KERNEL_ID, (String)string2, (SecurityService.ServiceType)SecurityService.ServiceType.AUTHENTICATION);
        authenticatedSubject = principalAuthenticator.authenticate((CallbackHandler)servletCallbackHandler, (ContextHandler)new WebAppContextHandler(httpServletRequest, httpServletResponse));
        if (authenticatedSubject != null) {
            final PasswordCredential passwordCredential = new PasswordCredential(string, (String)object);
            final AuthenticatedSubject authenticatedSubject2 = authenticatedSubject;
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    authenticatedSubject2.getPrivateCredentials((AbstractSubject)KERNEL_ID).add(passwordCredential);
                    return null;
                }
            });
        }
        if (DEBUG_SEC.isDebugEnabled()) {
            DEBUG_SEC.debug(string3 + " authenticated user: " + SecurityModule.getUsername(authenticatedSubject));
        }
        return authenticatedSubject;
    }

    protected static final String getUsername(AuthenticatedSubject authenticatedSubject) {
        if (authenticatedSubject == null) {
            return "anonymous";
        }
        return SubjectUtils.getUsername((AuthenticatedSubject)authenticatedSubject);
    }

    void setAuthRealmBanner(String string) {
        this.authRealmBanner = "Basic realm=\"" + string + "\"";
    }

    public static void setAuthCookieIDLength(int n) {
        AUTH_COOKIE_ID_LENGTH = n;
    }

    static final void logout(HttpServer httpServer, SessionInternal sessionInternal) {
        if (sessionInternal == null) {
            return;
        }
        httpServer.getSessionLogin().unregister(sessionInternal.getInternalId());
        sessionInternal.removeInternalAttribute(SESSION_AUTH_USER);
    }

    final void login(HttpServletRequest httpServletRequest, AuthenticatedSubject authenticatedSubject, SessionInternal sessionInternal) {
        if (authenticatedSubject == null || SubjectUtils.isUserAnonymous((AuthenticatedSubject)authenticatedSubject) || SecurityServiceManager.isKernelIdentity((AuthenticatedSubject)authenticatedSubject)) {
            return;
        }
        HttpServer httpServer = this.getHttpServer();
        if (sessionInternal == null) {
            sessionInternal = this.getUserSession(httpServletRequest, true);
        } else if (!((HttpSession)sessionInternal).isNew() && changeSessionIdOnAuthentication) {
            sessionInternal = this.generateNewSession(httpServletRequest);
        }
        sessionInternal.setInternalAttribute(SESSION_AUTH_USER, authenticatedSubject);
        String string = sessionInternal.getInternalId();
        httpServer.getSessionLogin().setUser(string, authenticatedSubject);
        SecurityModule.setupAuthCookie(httpServer, httpServletRequest, sessionInternal, string, true);
    }

    private final SessionInternal generateNewSession(HttpServletRequest httpServletRequest) {
        ServletRequestImpl servletRequestImpl = ServletRequestImpl.getOriginalRequest((ServletRequest)httpServletRequest);
        servletRequestImpl.getSessionHelper().updateSessionId();
        return this.getUserSession(httpServletRequest, true);
    }

    public static final void setupAuthCookie(HttpServer httpServer, HttpServletRequest httpServletRequest, SessionInternal sessionInternal, String string) {
        SecurityModule.setupAuthCookie(httpServer, httpServletRequest, sessionInternal, string, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void setupAuthCookie(HttpServer httpServer, HttpServletRequest httpServletRequest, SessionInternal sessionInternal, String string, boolean bl) {
        Object object;
        ServletRequestImpl servletRequestImpl;
        if (!httpServer.isAuthCookieEnabled()) {
            return;
        }
        if (!httpServletRequest.isSecure()) {
            return;
        }
        String string2 = httpServer.getSessionLogin().getCookieId(string);
        String string3 = SecurityModule.getWLSAuthCookieName(sessionInternal);
        if (!bl && string2 != null) {
            sessionInternal.setInternalAttribute(string3, string2);
            return;
        }
        if (string2 == null) {
            string2 = (String)sessionInternal.getInternalAttribute(string3);
            if (!bl && string2 != null) {
                httpServer.getSessionLogin().addCookieId(string, string2);
                return;
            }
        }
        boolean bl2 = string2 != null;
        ServletResponseImpl servletResponseImpl = ServletRequestImpl.getOriginalRequest((ServletRequest)httpServletRequest).getResponse();
        string2 = SecurityModule.generateNewId();
        sessionInternal.setInternalAttribute(string3, string2);
        if (bl && bl2) {
            servletRequestImpl = ServletRequestImpl.getOriginalRequest((ServletRequest)httpServletRequest);
            object = httpServer.getServletContextManager().getAllContexts();
            for (int i = 0; i < ((WebAppServletContext[])object).length; ++i) {
                SessionContext sessionContext;
                SessionData sessionData;
                WebAppServletContext webAppServletContext = object[i];
                if (webAppServletContext.equals(sessionInternal.getContext().getServletContext()) || !SecurityModule.getWLSAuthCookieName(webAppServletContext).equals(string3) || (sessionData = (sessionContext = webAppServletContext.getSessionContext()).getSessionInternalForAuthentication(string, servletRequestImpl, servletResponseImpl)) == null) continue;
                if (sessionData.getInternalAttribute(string3) != null) {
                    sessionData.removeInternalAttribute(string3);
                }
                SessionData sessionData2 = sessionData;
                synchronized (sessionData2) {
                    sessionContext.sync(sessionData);
                    continue;
                }
            }
        }
        servletRequestImpl = new Cookie(string3, string2);
        servletRequestImpl.setSecure(true);
        servletRequestImpl.setMaxAge(-1);
        servletRequestImpl.setPath(sessionInternal.getContext().getConfigMgr().getCookiePath());
        object = sessionInternal.getContext().getConfigMgr().getCookieDomain();
        if (object != null) {
            servletRequestImpl.setDomain((String)object);
        }
        servletResponseImpl.addCookieInternal((Cookie)servletRequestImpl);
        httpServer.getSessionLogin().addCookieId(string, string2);
    }

    private static String generateNewId() {
        BASE64Encoder bASE64Encoder = new BASE64Encoder();
        String string = new String(bASE64Encoder.encodeBuffer(Salt.getRandomBytes(AUTH_COOKIE_ID_LENGTH)));
        string = string.substring(0, AUTH_COOKIE_ID_LENGTH);
        string = string.replace('/', '.');
        string = string.replace('+', '-');
        string = string.replace('=', '_');
        return string;
    }

    boolean checkAuthCookie(HttpServer httpServer, HttpServletRequest httpServletRequest, SessionInternal sessionInternal) {
        ServletResponseImpl servletResponseImpl;
        Cookie cookie;
        if (!httpServer.isAuthCookieEnabled() || !httpServletRequest.isSecure()) {
            return true;
        }
        if (!this.getServletContext().getSessionContext().getConfigMgr().isSessionCookiesEnabled()) {
            return true;
        }
        if (this.webAppSecurity.getConstraint(httpServletRequest) == null) {
            return true;
        }
        String string = null;
        String string2 = SecurityModule.getWLSAuthCookieName(sessionInternal);
        if (sessionInternal != null) {
            string = httpServer.getSessionLogin().getCookieId(sessionInternal.getInternalId());
            if (string != null) {
                sessionInternal.setInternalAttribute(string2, string);
            } else {
                string = (String)sessionInternal.getInternalAttribute(string2);
            }
        }
        if (string == null) {
            return true;
        }
        Cookie[] cookieArray = httpServletRequest.getCookies();
        if (cookieArray != null) {
            for (int i = 0; i < cookieArray.length; ++i) {
                if (!cookieArray[i].getName().equals(string2) || !(cookie = cookieArray[i]).getValue().equals(string)) continue;
                return true;
            }
        }
        return (cookie = (servletResponseImpl = ServletRequestImpl.getOriginalRequest((ServletRequest)httpServletRequest).getResponse()).getCookie(string2)) != null && cookie.getValue().equals(string);
    }

    void sendForbiddenResponse(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException {
        if (this.delegateControl) {
            return;
        }
        httpServletResponse.sendError(403, ErrorMessages.getErrorPage(403));
    }

    void sendUnauthorizedResponse(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException {
        if (this.delegateControl) {
            return;
        }
        httpServletResponse.sendError(401, ErrorMessages.getErrorPage(401));
    }

    void sendError(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException {
        if (this.delegateControl) {
            return;
        }
        ServletResponseImpl servletResponseImpl = ServletRequestImpl.getOriginalRequest((ServletRequest)httpServletRequest).getResponse();
        servletResponseImpl.setHeaderInternal("WWW-Authenticate", this.authRealmBanner);
        this.sendUnauthorizedResponse(httpServletRequest, httpServletResponse);
    }

    boolean isForbidden(ResourceConstraint resourceConstraint) {
        return this.webAppSecurity.isFullSecurityDelegationRequired() && resourceConstraint != null && resourceConstraint.isForbidden();
    }

    final SessionInternal getUserSession(HttpServletRequest httpServletRequest, boolean bl) {
        AuthenticatedSubject authenticatedSubject = SecurityServiceManager.getCurrentSubject((AuthenticatedSubject)KERNEL_ID);
        if (SecurityServiceManager.isKernelIdentity((AuthenticatedSubject)authenticatedSubject)) {
            SessionRetrievalAction sessionRetrievalAction = new SessionRetrievalAction(httpServletRequest, bl);
            Throwable throwable = (Throwable)SecurityServiceManager.runAs((AuthenticatedSubject)KERNEL_ID, (AuthenticatedSubject)SubjectUtils.getAnonymousSubject(), (PrivilegedAction)sessionRetrievalAction);
            if (throwable != null) {
                if (throwable instanceof NestedRuntimeException) {
                    throw (NestedRuntimeException)throwable;
                }
                HTTPSessionLogger.logUnexpectedError((String)this.getServletContext().getLogContext(), (Throwable)throwable);
                throw new NestedRuntimeException("Failed to retrieve session: " + throwable.getMessage(), throwable);
            }
            return sessionRetrievalAction.getUserSession();
        }
        return (SessionInternal)httpServletRequest.getSession(bl);
    }

    protected void invokeAuthFilterChain(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException {
        if (!this.webAppSecurity.hasAuthFilters()) {
            return;
        }
        FilterChain filterChain = this.webAppSecurity.getAuthFilterChain();
        ServletAuthenticationFilterAction servletAuthenticationFilterAction = new ServletAuthenticationFilterAction(httpServletRequest, httpServletResponse, filterChain);
        Throwable throwable = (Throwable)SecurityServiceManager.runAs((AuthenticatedSubject)KERNEL_ID, (AuthenticatedSubject)KERNEL_ID, (PrivilegedAction)servletAuthenticationFilterAction);
        if (throwable != null) {
            throw new ServletException(throwable);
        }
    }

    private static String[] validateAuthMethods(String string) {
        if (string == null) {
            throw new IllegalArgumentException("NULL auth-method list");
        }
        String[] stringArray = StringUtils.splitCompletely((String)string, (String)", ");
        for (int i = 0; i < stringArray.length; ++i) {
            if (!(stringArray[i].equals("BASIC") || stringArray[i].equals("FORM") || stringArray[i].equals("CLIENT_CERT") || stringArray[i].equals("DIGEST") || stringArray[i].equals(ASSERTION_AUTH) || stringArray[i].equals("BASIC_ENFORCE") || stringArray[i].equals("BASIC_PLAIN"))) {
                throw new IllegalArgumentException("Invalid auth-method list - " + string);
            }
            if (!stringArray[i].equals("BASIC") && !stringArray[i].equals("BASIC_ENFORCE") && !stringArray[i].equals("BASIC_PLAIN") && !stringArray[i].equals("FORM") || i == stringArray.length - 1) continue;
            throw new IllegalArgumentException("Invalid auth-method list - '" + stringArray[i] + " ' has to be at the end in '" + string + "'");
        }
        return stringArray;
    }

    static SecurityModule createModule(WebAppServletContext webAppServletContext, WebAppSecurity webAppSecurity) {
        String string = null;
        if (webAppSecurity != null) {
            string = webAppSecurity.getAuthMethod();
        }
        if (string == null || string.length() < 1) {
            string = "BASIC";
        }
        return SecurityModule.createModule(webAppServletContext, webAppSecurity, false, string);
    }

    static SecurityModule createModule(WebAppServletContext webAppServletContext, WebAppSecurity webAppSecurity, boolean bl, String string) {
        SecurityModule securityModule;
        if (string.equals("BASIC")) {
            securityModule = new BasicSecurityModule(webAppServletContext, webAppSecurity, bl);
        } else if (string.equals("FORM")) {
            securityModule = new FormSecurityModule(webAppServletContext, webAppSecurity);
        } else if (string.equals("CLIENT_CERT")) {
            securityModule = new CertSecurityModule(webAppServletContext, webAppSecurity, bl, false);
        } else if (string.equals("DIGEST")) {
            HTTPLogger.logDigestAuthNotSupported((String)webAppServletContext.getLogContext());
            securityModule = new BasicSecurityModule(webAppServletContext, webAppSecurity, bl);
        } else if (string.equals(ASSERTION_AUTH)) {
            securityModule = new CertSecurityModule(webAppServletContext, webAppSecurity, bl, true);
        } else if (string.equals("BASIC_ENFORCE") || string.equals("BASIC_PLAIN")) {
            securityModule = new Basic2SecurityModule(webAppServletContext, webAppSecurity, bl, string);
        } else if (string.equals(REALM_AUTH)) {
            webAppServletContext.getConfigManager();
            securityModule = new ChainedSecurityModule(webAppServletContext, webAppSecurity, SecurityModule.validateAuthMethods(WebAppConfigManager.getRealmAuthMethods()));
        } else {
            securityModule = new ChainedSecurityModule(webAppServletContext, webAppSecurity, SecurityModule.validateAuthMethods(string));
        }
        securityModule.setAuthRealmBanner(webAppServletContext.getConfigManager().getAuthRealmName());
        if (DEBUG_SEC.isDebugEnabled()) {
            DEBUG_SEC.debug(webAppServletContext + " creating " + securityModule);
        }
        return securityModule;
    }

    static {
        String string = System.getProperty("changeSessionIdOnAuthentication");
        if (string != null) {
            changeSessionIdOnAuthentication = new Boolean(string);
        }
    }

    private static class ServletAuthenticationFilterAction
    implements PrivilegedAction {
        private final HttpServletRequest request;
        private final HttpServletResponse response;
        private final FilterChain chain;

        ServletAuthenticationFilterAction(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, FilterChain filterChain) {
            this.request = httpServletRequest;
            this.response = httpServletResponse;
            this.chain = filterChain;
        }

        public Object run() {
            try {
                this.chain.doFilter((ServletRequest)this.request, (ServletResponse)this.response);
            }
            catch (Throwable throwable) {
                return throwable;
            }
            return null;
        }
    }

    private static class SessionRetrievalAction
    implements PrivilegedAction {
        private final HttpServletRequest request;
        private final boolean flag;
        private SessionInternal session = null;

        SessionRetrievalAction(HttpServletRequest httpServletRequest, boolean bl) {
            this.request = httpServletRequest;
            this.flag = bl;
        }

        public SessionInternal getUserSession() {
            return this.session;
        }

        public Object run() {
            try {
                this.session = (SessionInternal)this.request.getSession(this.flag);
            }
            catch (Throwable throwable) {
                return throwable;
            }
            return null;
        }
    }
}

