/*
 * Decompiled with CFR 0.152.
 */
package weblogic.servlet.security.internal;

import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.TextInputCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import weblogic.security.auth.callback.ContextHandlerCallback;
import weblogic.security.auth.callback.URLCallback;
import weblogic.servlet.security.internal.WebAppSecurity;

class ServletCallbackHandler
implements CallbackHandler {
    private final String username;
    private final Object password;
    private final HttpServletRequest request;
    private final HttpServletResponse response;

    ServletCallbackHandler(String string, Object object, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        this.username = string;
        this.password = object;
        this.request = httpServletRequest;
        this.response = httpServletResponse;
    }

    public void handle(Callback[] callbackArray) throws UnsupportedCallbackException {
        if (callbackArray == null) {
            return;
        }
        for (int i = 0; i < callbackArray.length; ++i) {
            String string;
            Callback callback;
            if (callbackArray[i] instanceof NameCallback) {
                callback = (NameCallback)callbackArray[i];
                ((NameCallback)callback).setName(this.username);
                continue;
            }
            if (callbackArray[i] instanceof PasswordCallback) {
                callback = (PasswordCallback)callbackArray[i];
                ((PasswordCallback)callback).setPassword(((String)this.password).toCharArray());
                continue;
            }
            if (callbackArray[i] instanceof TextInputCallback) {
                callback = (TextInputCallback)callbackArray[i];
                string = ((TextInputCallback)callback).getPrompt();
                if (string == null) continue;
                String string2 = this.request.getParameter(string);
                if (string2 == null) {
                    string2 = ((TextInputCallback)callback).getDefaultText();
                }
                ((TextInputCallback)callback).setText(string2);
                continue;
            }
            if (callbackArray[i] instanceof URLCallback) {
                callback = (URLCallback)callbackArray[i];
                string = this.request.getRequestURL().toString();
                if (string != null) {
                    ((URLCallback)callback).setURL(string);
                    continue;
                }
                ((URLCallback)callback).setURL(((URLCallback)callback).getdefaultURL());
                continue;
            }
            if (callbackArray[i] instanceof ContextHandlerCallback) {
                callback = (ContextHandlerCallback)callbackArray[i];
                callback.setContextHandler(WebAppSecurity.getContextHandler(this.request, this.response));
                continue;
            }
            throw new UnsupportedCallbackException(callbackArray[i], "Unrecognized Callback");
        }
    }
}

