/*
 * Decompiled with CFR 0.152.
 */
package weblogic.servlet.security.internal;

import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import weblogic.diagnostics.instrumentation.DelegatingMonitor;
import weblogic.diagnostics.instrumentation.DiagnosticAction;
import weblogic.diagnostics.instrumentation.DiagnosticActionState;
import weblogic.diagnostics.instrumentation.DiagnosticMonitor;
import weblogic.diagnostics.instrumentation.DynamicJoinPoint;
import weblogic.diagnostics.instrumentation.InstrumentationSupport;
import weblogic.diagnostics.instrumentation.JoinPoint;
import weblogic.diagnostics.instrumentation.PointcutHandlingInfo;
import weblogic.diagnostics.instrumentation.ValueHandlingInfo;
import weblogic.j2ee.descriptor.LoginConfigBean;
import weblogic.management.DeploymentException;
import weblogic.security.SubjectUtils;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrincipalAuthenticator;
import weblogic.security.service.PrivilegedActions;
import weblogic.security.service.SecurityService;
import weblogic.security.service.SecurityServiceManager;
import weblogic.servlet.HTTPLogger;
import weblogic.servlet.internal.RequestDispatcherImpl;
import weblogic.servlet.internal.WebAppServletContext;
import weblogic.servlet.internal.session.SessionInternal;
import weblogic.servlet.security.internal.ResourceConstraint;
import weblogic.servlet.security.internal.SecurityModule;
import weblogic.servlet.security.internal.WebAppSecurity;
import weblogic.servlet.security.internal.WebAppSecurityJacc;
import weblogic.servlet.security.internal.WebAppSecurityWLS;

public final class ServletSecurityManager {
    private static final AuthenticatedSubject KERNEL_ID;
    private final WebAppSecurity webAppSecurity;
    private final WebAppServletContext context;
    private final boolean jaccEnabled = SecurityServiceManager.isJACCEnabled();
    private SecurityModule delegateModule;
    static final long serialVersionUID = -6466139857456605732L;
    public static final String _WLDF$INST_VERSION = "9.0.0";
    static /* synthetic */ Class _WLDF$INST_FLD_class;
    public static final DelegatingMonitor _WLDF$INST_FLD_Servlet_Check_Access_Around_Medium;
    public static final JoinPoint _WLDF$INST_JPFLD_0;

    public ServletSecurityManager(WebAppServletContext webAppServletContext) throws DeploymentException {
        this.context = webAppServletContext;
        this.webAppSecurity = this.jaccEnabled && !webAppServletContext.isInternalApp() && this.context.getDocroot() != null ? new WebAppSecurityJacc(webAppServletContext) : new WebAppSecurityWLS(webAppServletContext);
        this.delegateModule = SecurityModule.createModule(this.context, this.webAppSecurity);
    }

    public PrincipalAuthenticator getPrincipalAuthenticator() {
        String string = this.context.getSecurityRealmName();
        return (PrincipalAuthenticator)SecurityServiceManager.getSecurityService((AuthenticatedSubject)KERNEL_ID, (String)string, (SecurityService.ServiceType)SecurityService.ServiceType.AUTHENTICATION);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean checkAccess(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, boolean bl) throws IOException, ServletException {
        boolean bl2;
        DiagnosticActionState[] diagnosticActionStateArray;
        DiagnosticAction[] diagnosticActionArray;
        boolean bl3;
        block20: {
            boolean bl4;
            block18: {
                boolean bl5;
                block17: {
                    bl3 = _WLDF$INST_FLD_Servlet_Check_Access_Around_Medium.isEnabledAndNotDyeFiltered();
                    diagnosticActionArray = null;
                    diagnosticActionStateArray = null;
                    Object var15_7 = null;
                    if (bl3) {
                        Object[] objectArray = null;
                        if (_WLDF$INST_FLD_Servlet_Check_Access_Around_Medium.isArgumentsCaptureNeeded()) {
                            objectArray = new Object[]{this, httpServletRequest, httpServletResponse, InstrumentationSupport.convertToObject((boolean)bl)};
                        }
                        DynamicJoinPoint dynamicJoinPoint = InstrumentationSupport.createDynamicJoinPoint((JoinPoint)_WLDF$INST_JPFLD_0, (Object[])objectArray, null);
                        DelegatingMonitor delegatingMonitor = _WLDF$INST_FLD_Servlet_Check_Access_Around_Medium;
                        diagnosticActionArray = delegatingMonitor.getActions();
                        diagnosticActionStateArray = InstrumentationSupport.getActionStates((DiagnosticAction[])diagnosticActionArray);
                        InstrumentationSupport.preProcess((JoinPoint)dynamicJoinPoint, (DiagnosticMonitor)delegatingMonitor, (DiagnosticAction[])diagnosticActionArray, (DiagnosticActionState[])diagnosticActionStateArray);
                    }
                    try {
                        RequestDispatcherImpl requestDispatcherImpl = this.invokePreAuthFilters(httpServletRequest, httpServletResponse);
                        boolean bl6 = true;
                        try {
                            ResourceConstraint resourceConstraint = this.webAppSecurity.getConstraint(httpServletRequest);
                            if (!this.webAppSecurity.isFullSecurityDelegationRequired() && resourceConstraint != null && resourceConstraint.isForbidden()) {
                                String string;
                                if (this.webAppSecurity.isFormAuth() && ((string = WebAppSecurity.getRelativeURI(httpServletRequest)).equals(this.webAppSecurity.getLoginPage()) || string.equals(this.webAppSecurity.getErrorPage()))) {
                                    boolean bl7 = bl6 = true;
                                    bl5 = bl7;
                                    Object var13_18 = null;
                                    break block17;
                                }
                                httpServletResponse.sendError(403);
                                boolean bl8 = bl6 = false;
                                bl4 = bl8;
                                break block18;
                            }
                            SessionInternal sessionInternal = this.delegateModule.getUserSession(httpServletRequest, false);
                            bl6 = this.delegateModule.checkAccess(httpServletRequest, httpServletResponse, sessionInternal, resourceConstraint, bl);
                            if (sessionInternal != null && bl6) {
                                sessionInternal = this.delegateModule.getUserSession(httpServletRequest, false);
                                this.context.getServer().getSessionLogin().register(sessionInternal.getInternalId(), this.context.getContextPath());
                            }
                        }
                        finally {
                            if (requestDispatcherImpl != null) {
                                this.invokePostAuthFilters(httpServletRequest, httpServletResponse, requestDispatcherImpl, bl6);
                            }
                            httpServletRequest.removeAttribute("weblogic.auth.result");
                        }
                        bl2 = bl6;
                        break block20;
                    }
                    catch (Throwable throwable) {
                        Object var13_21 = null;
                        Object object = InstrumentationSupport.convertToObject((boolean)false);
                        if (bl3) {
                            InstrumentationSupport.postProcess((JoinPoint)InstrumentationSupport.createDynamicJoinPoint((JoinPoint)_WLDF$INST_JPFLD_0, null, (Object)object), (DiagnosticMonitor)_WLDF$INST_FLD_Servlet_Check_Access_Around_Medium, (DiagnosticAction[])diagnosticActionArray, (DiagnosticActionState[])diagnosticActionStateArray);
                        }
                        throw throwable;
                    }
                }
                Object object = InstrumentationSupport.convertToObject((boolean)bl5);
                if (bl3) {
                    InstrumentationSupport.postProcess((JoinPoint)InstrumentationSupport.createDynamicJoinPoint((JoinPoint)_WLDF$INST_JPFLD_0, null, (Object)object), (DiagnosticMonitor)_WLDF$INST_FLD_Servlet_Check_Access_Around_Medium, (DiagnosticAction[])diagnosticActionArray, (DiagnosticActionState[])diagnosticActionStateArray);
                }
                return bl5;
            }
            Object var13_19 = null;
            Object object = InstrumentationSupport.convertToObject((boolean)bl4);
            if (bl3) {
                InstrumentationSupport.postProcess((JoinPoint)InstrumentationSupport.createDynamicJoinPoint((JoinPoint)_WLDF$INST_JPFLD_0, null, (Object)object), (DiagnosticMonitor)_WLDF$INST_FLD_Servlet_Check_Access_Around_Medium, (DiagnosticAction[])diagnosticActionArray, (DiagnosticActionState[])diagnosticActionStateArray);
            }
            return bl4;
        }
        Object var13_20 = null;
        Object object = InstrumentationSupport.convertToObject((boolean)bl2);
        if (bl3) {
            InstrumentationSupport.postProcess((JoinPoint)InstrumentationSupport.createDynamicJoinPoint((JoinPoint)_WLDF$INST_JPFLD_0, null, (Object)object), (DiagnosticMonitor)_WLDF$INST_FLD_Servlet_Check_Access_Around_Medium, (DiagnosticAction[])diagnosticActionArray, (DiagnosticActionState[])diagnosticActionStateArray);
        }
        return bl2;
    }

    public WebAppSecurity getWebAppSecurity() {
        return this.webAppSecurity;
    }

    public void setLoginConfig(LoginConfigBean loginConfigBean) {
        this.webAppSecurity.setLoginConfig(loginConfigBean);
        this.delegateModule = SecurityModule.createModule(this.context, this.webAppSecurity);
    }

    public void setAuthRealmName(String string) {
        this.delegateModule.setAuthRealmBanner(string);
    }

    private RequestDispatcherImpl invokePreAuthFilters(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        RequestDispatcherImpl requestDispatcherImpl = this.webAppSecurity.getAuthFilterRD();
        if (requestDispatcherImpl == null) {
            return null;
        }
        httpServletRequest.setAttribute("weblogic.auth.result", (Object)new Integer(-1));
        AuthFilterAction authFilterAction = new AuthFilterAction(httpServletRequest, httpServletResponse, requestDispatcherImpl);
        Throwable throwable = (Throwable)SecurityServiceManager.runAs((AuthenticatedSubject)KERNEL_ID, (AuthenticatedSubject)SubjectUtils.getAnonymousSubject(), (PrivilegedAction)authFilterAction);
        if (throwable != null) {
            HTTPLogger.logAuthFilterInvocationFailed((String)this.webAppSecurity.getAuthFilter(), (String)"pre-auth", (String)httpServletRequest.getRequestURI(), (Throwable)throwable);
        }
        httpServletRequest.removeAttribute("weblogic.auth.result");
        return requestDispatcherImpl;
    }

    private void invokePostAuthFilters(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, RequestDispatcherImpl requestDispatcherImpl, boolean bl) throws IOException {
        Integer n;
        AuthFilterAction authFilterAction;
        Throwable throwable;
        AuthenticatedSubject authenticatedSubject = null;
        if (httpServletRequest.getAttribute("weblogic.auth.result") == null) {
            if (bl) {
                authenticatedSubject = SecurityModule.getCurrentUser(this.context.getServer(), httpServletRequest);
                httpServletRequest.setAttribute("weblogic.auth.result", (Object)new Integer(0));
            } else {
                httpServletRequest.setAttribute("weblogic.auth.result", (Object)new Integer(1));
            }
        }
        if (authenticatedSubject == null) {
            authenticatedSubject = SubjectUtils.getAnonymousSubject();
        }
        if ((throwable = (Throwable)SecurityServiceManager.runAs((AuthenticatedSubject)KERNEL_ID, (AuthenticatedSubject)authenticatedSubject, (PrivilegedAction)(authFilterAction = new AuthFilterAction(httpServletRequest, httpServletResponse, requestDispatcherImpl)))) != null) {
            HTTPLogger.logAuthFilterInvocationFailed((String)this.webAppSecurity.getAuthFilter(), (String)"post-auth", (String)httpServletRequest.getRequestURI(), (Throwable)throwable);
        }
        if ((n = (Integer)httpServletRequest.getAttribute("weblogic.auth.result")) != null && bl && n == 1) {
            bl = false;
            this.delegateModule.sendError(httpServletRequest, httpServletResponse);
        }
    }

    static {
        _WLDF$INST_FLD_class = Class.forName("weblogic.servlet.security.internal.ServletSecurityManager");
        _WLDF$INST_FLD_Servlet_Check_Access_Around_Medium = (DelegatingMonitor)InstrumentationSupport.getMonitor((Class)_WLDF$INST_FLD_class, (String)"Servlet_Check_Access_Around_Medium");
        _WLDF$INST_JPFLD_0 = InstrumentationSupport.createJoinPoint((Class)_WLDF$INST_FLD_class, (String)"ServletSecurityManager.java", (String)"weblogic.servlet.security.internal.ServletSecurityManager", (String)"checkAccess", (String)"(Ljavax/servlet/http/HttpServletRequest;Ljavax/servlet/http/HttpServletResponse;Z)Z", (int)57, (Map)InstrumentationSupport.makeMap((String[])new String[]{"Servlet_Check_Access_Around_Medium"}, (PointcutHandlingInfo[])new PointcutHandlingInfo[]{InstrumentationSupport.createPointcutHandlingInfo(null, (ValueHandlingInfo)InstrumentationSupport.createValueHandlingInfo((String)"ret", null, (boolean)false, (boolean)true), (ValueHandlingInfo[])new ValueHandlingInfo[]{InstrumentationSupport.createValueHandlingInfo((String)"req", (String)"weblogic.diagnostics.instrumentation.gathering.ServletRequestRenderer", (boolean)false, (boolean)true), null, null})}), (boolean)false);
        KERNEL_ID = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
    }

    private static class AuthFilterAction
    implements PrivilegedAction {
        private HttpServletRequest request;
        private HttpServletResponse response;
        private RequestDispatcherImpl dispatcher;

        AuthFilterAction(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, RequestDispatcherImpl requestDispatcherImpl) {
            this.request = httpServletRequest;
            this.response = httpServletResponse;
            this.dispatcher = requestDispatcherImpl;
        }

        public Object run() {
            try {
                this.dispatcher.include((ServletRequest)this.request, (ServletResponse)this.response);
            }
            catch (Throwable throwable) {
                return throwable;
            }
            return null;
        }
    }
}

