/*
 * Decompiled with CFR 0.152.
 */
package weblogic.servlet.security.internal;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import weblogic.security.service.ContextElement;
import weblogic.security.service.ContextHandler;

public class WebAppContextHandler
implements ContextHandler {
    public static final String HTTP_SERVLET_REQUEST = "HttpServletRequest";
    public static final String HTTP_SERVLET_RESPONSE = "HttpServletResponse";
    private int SIZE = 4;
    private static final String[] names = new String[]{"com.bea.contextelement.servlet.HttpServletRequest", "com.bea.contextelement.servlet.HttpServletResponse", "HttpServletRequest", "HttpServletResponse"};
    private Object[] values = new Object[this.SIZE];
    private ContextElement requestElement = null;
    private ContextElement responseElement = null;
    private ContextElement requestElementDeprecated = null;
    private ContextElement responseElementDeprecated = null;

    public WebAppContextHandler(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        this.values[0] = httpServletRequest;
        this.values[1] = httpServletResponse;
        this.values[2] = httpServletRequest;
        this.values[3] = httpServletResponse;
        this.requestElement = new ContextElement("com.bea.contextelement.servlet.HttpServletRequest", (Object)httpServletRequest);
        this.responseElement = new ContextElement("com.bea.contextelement.servlet.HttpServletResponse", (Object)httpServletResponse);
        this.requestElementDeprecated = new ContextElement(HTTP_SERVLET_REQUEST, (Object)httpServletRequest);
        this.responseElementDeprecated = new ContextElement(HTTP_SERVLET_RESPONSE, (Object)httpServletResponse);
    }

    public int size() {
        return this.SIZE;
    }

    public String[] getNames() {
        return names;
    }

    public Object getValue(String string) {
        if (string == null) {
            return null;
        }
        if (string.equals("com.bea.contextelement.servlet.HttpServletRequest")) {
            return this.values[0];
        }
        if (string.equals("com.bea.contextelement.servlet.HttpServletResponse")) {
            return this.values[1];
        }
        if (string.equals(HTTP_SERVLET_REQUEST)) {
            return this.values[2];
        }
        if (string.equals(HTTP_SERVLET_RESPONSE)) {
            return this.values[3];
        }
        return null;
    }

    private int indexOf(String string) {
        if (string == null) {
            return -1;
        }
        if (string.equals("com.bea.contextelement.servlet.HttpServletRequest")) {
            return 0;
        }
        if (string.equals("com.bea.contextelement.servlet.HttpServletResponse")) {
            return 1;
        }
        if (string.equals(HTTP_SERVLET_REQUEST)) {
            return 2;
        }
        if (string.equals(HTTP_SERVLET_RESPONSE)) {
            return 3;
        }
        return -1;
    }

    public ContextElement[] getValues(String[] stringArray) {
        if (stringArray == null || stringArray.length < 1) {
            return null;
        }
        boolean bl = false;
        boolean bl2 = false;
        for (int i = 0; i < stringArray.length; ++i) {
            int n = this.indexOf(stringArray[i]);
            if (n == 0 || n == 2) {
                bl = true;
                continue;
            }
            if (n != 1 && n != 3) continue;
            bl2 = true;
        }
        ContextElement[] contextElementArray = null;
        if (bl && bl2) {
            contextElementArray = new ContextElement[]{this.requestElement, this.responseElement, this.requestElementDeprecated, this.responseElementDeprecated};
        } else if (bl && !bl2) {
            contextElementArray = new ContextElement[]{this.requestElement, this.requestElementDeprecated};
        } else if (!bl && bl2) {
            contextElementArray = new ContextElement[2];
            contextElementArray[0] = this.responseElement;
            contextElementArray[0] = this.responseElementDeprecated;
        }
        return contextElementArray;
    }
}

