/*
 * Decompiled with CFR 0.152.
 */
package weblogic.servlet.security.internal;

import java.io.IOException;
import java.security.AccessController;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import weblogic.application.SecurityRole;
import weblogic.j2ee.descriptor.LoginConfigBean;
import weblogic.j2ee.descriptor.SecurityConstraintBean;
import weblogic.j2ee.descriptor.SecurityRoleBean;
import weblogic.j2ee.descriptor.SecurityRoleRefBean;
import weblogic.j2ee.descriptor.wl.RunAsRoleAssignmentBean;
import weblogic.j2ee.descriptor.wl.SecurityRoleAssignmentBean;
import weblogic.j2ee.descriptor.wl.ServletDescriptorBean;
import weblogic.logging.Loggable;
import weblogic.management.DeploymentException;
import weblogic.management.configuration.AppDeploymentMBean;
import weblogic.protocol.Protocol;
import weblogic.protocol.ServerChannelManager;
import weblogic.security.SubjectUtils;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.ContextHandler;
import weblogic.security.service.PrincipalAuthenticator;
import weblogic.security.service.PrivilegedActions;
import weblogic.security.service.SecurityApplicationInfo;
import weblogic.security.service.SecurityApplicationInfoImpl;
import weblogic.security.service.SecurityService;
import weblogic.security.service.SecurityServiceManager;
import weblogic.security.spi.ApplicationInfo;
import weblogic.servlet.HTTPLogger;
import weblogic.servlet.internal.ProtocolHandlerHTTPS;
import weblogic.servlet.internal.RequestDispatcherImpl;
import weblogic.servlet.internal.ServletRequestImpl;
import weblogic.servlet.internal.ServletResponseImpl;
import weblogic.servlet.internal.ServletStubImpl;
import weblogic.servlet.internal.WebAppModule;
import weblogic.servlet.internal.WebAppServletContext;
import weblogic.servlet.security.internal.AuthFilterChain;
import weblogic.servlet.security.internal.ExternalRoleChecker;
import weblogic.servlet.security.internal.ExternalRoleCheckerManager;
import weblogic.servlet.security.internal.ResourceConstraint;
import weblogic.servlet.security.internal.WebAppContextHandler;
import weblogic.utils.http.HttpParsing;

public abstract class WebAppSecurity {
    protected static final String NONE = "NONE";
    protected static final String INTEGRAL = "INTEGRAL";
    protected static final String CONFIDENTIAL = "CONFIDENTIAL";
    private static final AuthenticatedSubject KERNEL_ID = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
    protected final WebAppServletContext context;
    protected final HashSet roles = new HashSet();
    protected final HashMap roleMapping = new HashMap();
    protected final HashMap runAsMapping = new HashMap();
    private final Filter[] authFilters;
    private final boolean authFiltersPresent;
    protected SecurityApplicationInfo secureAppInfo;
    private String loginPage = null;
    private String errorPage = null;
    private String authMethod = null;
    private boolean formAuth = false;
    private String authFilter;
    private RequestDispatcherImpl authFilterRD;
    private String realmName;
    private int roleMappingMode;
    private ExternalRoleChecker externalRoleChecker;

    WebAppSecurity(WebAppServletContext webAppServletContext) throws DeploymentException {
        this.context = webAppServletContext;
        PrincipalAuthenticator principalAuthenticator = (PrincipalAuthenticator)SecurityServiceManager.getSecurityService((AuthenticatedSubject)KERNEL_ID, (String)this.context.getSecurityRealmName(), (SecurityService.ServiceType)SecurityService.ServiceType.AUTHENTICATION);
        try {
            this.authFilters = principalAuthenticator.getServletAuthenticationFilters((ServletContext)webAppServletContext);
        }
        catch (ServletException servletException) {
            throw new DeploymentException(servletException);
        }
        this.authFiltersPresent = this.authFilters != null && this.authFilters.length > 0;
        AppDeploymentMBean appDeploymentMBean = null;
        if (this.context.getApplicationContext() != null) {
            appDeploymentMBean = this.context.getApplicationContext().getAppDeploymentMBean();
        }
        this.secureAppInfo = new SecurityApplicationInfoImpl(appDeploymentMBean, ApplicationInfo.ComponentType.WEBAPP, webAppServletContext.getContextPath());
        this.realmName = this.context.getApplicationContext().getApplicationSecurityRealmName();
        this.roleMappingMode = SecurityServiceManager.getRoleMappingBehavior((String)this.realmName, (SecurityApplicationInfo)this.secureAppInfo);
        this.externalRoleChecker = new ExternalRoleCheckerManager(this.context);
    }

    public void unregister() {
        PrincipalAuthenticator principalAuthenticator = (PrincipalAuthenticator)SecurityServiceManager.getSecurityService((AuthenticatedSubject)KERNEL_ID, (String)this.context.getSecurityRealmName(), (SecurityService.ServiceType)SecurityService.ServiceType.AUTHENTICATION);
        principalAuthenticator.destroyServletAuthenticationFilters(this.authFilters);
    }

    protected abstract boolean isFullSecurityDelegationRequired();

    protected abstract boolean isJaccEnabled();

    protected abstract void deployRoles() throws DeploymentException;

    protected abstract void deployPolicies(SecurityConstraintBean[] var1) throws DeploymentException;

    protected abstract void deployRoleLink(ServletStubImpl var1, String var2, String var3) throws DeploymentException;

    public abstract ResourceConstraint getConstraint(HttpServletRequest var1);

    public abstract boolean hasPermission(HttpServletRequest var1, HttpServletResponse var2, AuthenticatedSubject var3, ResourceConstraint var4);

    public abstract boolean isSubjectInRole(AuthenticatedSubject var1, String var2, WebAppContextHandler var3, ServletStubImpl var4);

    public abstract void registerRoleRefs(ServletStubImpl var1) throws DeploymentException;

    public abstract void start() throws DeploymentException;

    abstract boolean checkTransport(ResourceConstraint var1, HttpServletRequest var2, HttpServletResponse var3) throws IOException;

    public abstract boolean isSSLRequired(String var1, String var2);

    public abstract void initContextHandler(ServletRequestImpl var1);

    public abstract void resetContextHandler();

    final String getContextLog() {
        return this.context.getLogContext();
    }

    final String getContextName() {
        if (this.context.getName() == null) {
            return "Default WebApplication";
        }
        return this.context.getName();
    }

    boolean hasAuthFilters() {
        return this.authFiltersPresent;
    }

    public FilterChain getAuthFilterChain() {
        return new AuthFilterChain(this.authFilters, this.context);
    }

    public final void registerSecurityConstraints(SecurityConstraintBean[] securityConstraintBeanArray) throws DeploymentException {
        this.deployPolicies(securityConstraintBeanArray);
        this.deployRoles();
    }

    public final void registerSecurityRoles(WebAppModule webAppModule) throws DeploymentException {
        if (webAppModule == null || webAppModule.getWebAppBean() == null) {
            return;
        }
        SecurityRoleBean[] securityRoleBeanArray = webAppModule.getWebAppBean().getSecurityRoles();
        if (securityRoleBeanArray != null) {
            for (int i = 0; i < securityRoleBeanArray.length; ++i) {
                this.roles.add(securityRoleBeanArray[i].getRoleName());
            }
        }
        if (webAppModule.getWlWebAppBean() != null) {
            this.setRoleMapping(webAppModule.getWlWebAppBean().getSecurityRoleAssignments());
            RunAsRoleAssignmentBean[] runAsRoleAssignmentBeanArray = webAppModule.getWlWebAppBean().getRunAsRoleAssignments();
            if (runAsRoleAssignmentBeanArray != null) {
                for (int i = 0; i < runAsRoleAssignmentBeanArray.length; ++i) {
                    RunAsRoleAssignmentBean runAsRoleAssignmentBean = runAsRoleAssignmentBeanArray[i];
                    if (this.roles.contains(runAsRoleAssignmentBean.getRoleName())) {
                        this.runAsMapping.put(runAsRoleAssignmentBean.getRoleName(), runAsRoleAssignmentBean.getRunAsPrincipalName());
                        continue;
                    }
                    if (this.externalRoleChecker.isExternalRole(runAsRoleAssignmentBean.getRoleName())) continue;
                    Loggable loggable = HTTPLogger.logUndefinedSecurityRoleLoggable((String)runAsRoleAssignmentBean.getRoleName(), (String)"run-as-role-assignment");
                    loggable.log();
                    throw new DeploymentException(loggable.getMessage());
                }
            }
        }
    }

    private final void setRoleMapping(SecurityRoleAssignmentBean[] securityRoleAssignmentBeanArray) throws DeploymentException {
        if (securityRoleAssignmentBeanArray == null) {
            return;
        }
        for (int i = 0; i < securityRoleAssignmentBeanArray.length; ++i) {
            Loggable loggable;
            String string = securityRoleAssignmentBeanArray[i].getRoleName();
            if (this.roles.contains(string)) {
                if (securityRoleAssignmentBeanArray[i].getExternallyDefined() != null) {
                    loggable = new Loggable[]{null};
                    this.roleMapping.put(string, loggable);
                    continue;
                }
                if (securityRoleAssignmentBeanArray[i].getPrincipalNames() == null || securityRoleAssignmentBeanArray[i].getPrincipalNames().length <= 0) continue;
                this.roleMapping.put(string, securityRoleAssignmentBeanArray[i].getPrincipalNames());
                continue;
            }
            if (this.externalRoleChecker.isExternalRole(string)) continue;
            loggable = HTTPLogger.logBadSecurityRoleInSRALoggable((String)string);
            loggable.log();
            throw new DeploymentException(loggable.getMessage());
        }
    }

    public final String getRunAsIdentity(String string) {
        return (String)this.runAsMapping.get(string);
    }

    public final String getFirstPrincipal(String string) {
        String[] stringArray = (String[])this.roleMapping.get(string);
        if (stringArray == null || stringArray.length < 1) {
            return null;
        }
        return stringArray[0];
    }

    final void setLoginConfig(LoginConfigBean loginConfigBean) {
        if (loginConfigBean.getFormLoginConfig() != null) {
            if (loginConfigBean.getFormLoginConfig().getFormLoginPage() != null) {
                this.loginPage = HttpParsing.ensureStartingSlash((String)loginConfigBean.getFormLoginConfig().getFormLoginPage());
            }
            if (loginConfigBean.getFormLoginConfig().getFormErrorPage() != null) {
                this.errorPage = HttpParsing.ensureStartingSlash((String)loginConfigBean.getFormLoginConfig().getFormErrorPage());
            }
        }
        this.authMethod = this.initAuthMethod(loginConfigBean.getAuthMethod());
        this.formAuth = this.authMethod.toUpperCase(Locale.ENGLISH).contains("FORM");
    }

    private String initAuthMethod(String string) {
        if (string == null) {
            return "BASIC";
        }
        if (string.equalsIgnoreCase("BASIC")) {
            return "BASIC";
        }
        if (string.equalsIgnoreCase("FORM")) {
            return "FORM";
        }
        if (string.equalsIgnoreCase("CLIENT-CERT")) {
            return "CLIENT_CERT";
        }
        if (string.equalsIgnoreCase("DIGEST")) {
            return "DIGEST";
        }
        if (string.toUpperCase(Locale.ENGLISH).contains("CLIENT-CERT")) {
            return string.toUpperCase(Locale.ENGLISH).replaceAll("CLIENT-CERT", "CLIENT_CERT");
        }
        return string;
    }

    public final String getLoginPage() {
        return this.loginPage;
    }

    public final String getErrorPage() {
        return this.errorPage;
    }

    public final String getAuthMethod() {
        return this.authMethod;
    }

    final WebAppServletContext getContext() {
        return this.context;
    }

    final RequestDispatcherImpl getAuthFilterRD() {
        return this.authFilterRD;
    }

    public final String getAuthFilter() {
        return this.authFilter;
    }

    public final boolean isFormAuth() {
        return this.formAuth;
    }

    public final void setAuthFilter(String string) {
        this.authFilter = string;
        ServletStubImpl servletStubImpl = new ServletStubImpl(string, string, this.context, null);
        this.authFilterRD = new RequestDispatcherImpl(servletStubImpl, this.context, -1);
        this.authFilterRD.disableFilters();
    }

    public final void registerSecurityRoleRef(ServletStubImpl servletStubImpl, SecurityRoleRefBean[] securityRoleRefBeanArray) throws DeploymentException {
        if (securityRoleRefBeanArray == null) {
            return;
        }
        for (int i = 0; i < securityRoleRefBeanArray.length; ++i) {
            SecurityRoleRefBean securityRoleRefBean = securityRoleRefBeanArray[i];
            String string = securityRoleRefBean.getRoleName();
            String string2 = securityRoleRefBean.getRoleLink();
            if (string == null || string2 == null) continue;
            this.deployRoleLink(servletStubImpl, string, string2);
        }
    }

    protected final String getSecuredURL(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String string) {
        Object object;
        String string2 = httpServletRequest.getServerName();
        int n = this.context.getServer().getFrontendHTTPSPort();
        if (n == 0) {
            object = ServerChannelManager.findLocalServerChannel((Protocol)ProtocolHandlerHTTPS.PROTOCOL_HTTPS);
            if (object == null) {
                return null;
            }
            n = object.getPublicPort();
        }
        object = ServletResponseImpl.getOriginalResponse((ServletResponse)httpServletResponse);
        String string3 = ((ServletResponseImpl)object).processProxyPathHeaders(string);
        String string4 = httpServletRequest.getQueryString();
        StringBuffer stringBuffer = new StringBuffer();
        if (n == 443) {
            stringBuffer.append("https://").append(string2).append(string3);
            if (string4 != null && string4.length() > 1) {
                stringBuffer.append("?").append(string4);
            }
        } else {
            stringBuffer.append("https://").append(string2).append(":");
            stringBuffer.append(n).append(string3);
            if (string4 != null && string4.length() > 1) {
                stringBuffer.append("?").append(string4);
            }
        }
        return stringBuffer.toString();
    }

    public static final String getRelativeURI(HttpServletRequest httpServletRequest) {
        String string = (String)httpServletRequest.getAttribute("webflow_resource");
        if (string != null) {
            return string;
        }
        if (httpServletRequest instanceof ServletRequestImpl) {
            return ((ServletRequestImpl)httpServletRequest).getRelativeUri();
        }
        string = ServletRequestImpl.getResolvedURI(httpServletRequest);
        String string2 = ServletRequestImpl.getResolvedContextPath(httpServletRequest);
        if (string2 != null && string2.length() > 0 && string.startsWith(string2)) {
            return string.substring(string2.length());
        }
        return string;
    }

    public static final ContextHandler getContextHandler(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        WebAppContextHandler webAppContextHandler;
        if (httpServletRequest instanceof ServletRequestImpl) {
            ServletRequestImpl servletRequestImpl = (ServletRequestImpl)httpServletRequest;
            webAppContextHandler = servletRequestImpl.getSecurityContextHandler();
        } else {
            webAppContextHandler = new WebAppContextHandler(httpServletRequest, httpServletResponse);
        }
        return webAppContextHandler;
    }

    public static String fixupURLPattern(String string) {
        if (WebAppSecurity.isDefaultUrlPattern(string)) {
            return "/";
        }
        if (!string.startsWith("*.")) {
            return HttpParsing.ensureStartingSlash((String)string);
        }
        return string;
    }

    private static boolean isDefaultUrlPattern(String string) {
        if (string.length() > 2) {
            return false;
        }
        if (WebAppSecurity.getEnforceStrictURLPattern()) {
            return string.equals("/");
        }
        return string.equals("*") || string.equals("/");
    }

    protected boolean isExternallyDefined(String[] stringArray) {
        return stringArray != null && stringArray.length == 1 && (stringArray[0] == null || stringArray[0].length() == 0);
    }

    public boolean isCompatibilitySecMode() {
        return this.roleMappingMode == 0;
    }

    public boolean isApplicationSecMode() {
        return this.roleMappingMode == 1;
    }

    public boolean isExternallyDefinedSecMode() {
        return this.roleMappingMode == 2;
    }

    public String getRunAsPrincipalName(ServletDescriptorBean servletDescriptorBean, String string) throws DeploymentException {
        String string2;
        if (servletDescriptorBean != null && (string2 = servletDescriptorBean.getRunAsPrincipalName()) != null) {
            return string2;
        }
        string2 = this.getRunAsIdentity(string);
        if (string2 != null) {
            return string2;
        }
        string2 = this.getFirstPrincipal(string);
        if (string2 != null) {
            HTTPLogger.logImplicitMappingForRunAsRole((String)this.context.getLogContext(), (String)"run-as", (String)string, (String)"web.xml", (String)string2);
            return string2;
        }
        if (!this.isCompatibilitySecMode()) {
            SecurityRole securityRole = this.context.getApplicationContext().getSecurityRole(string);
            if (securityRole != null) {
                String[] stringArray = securityRole.getPrincipalNames();
                if (!securityRole.isExternallyDefined() && stringArray != null && stringArray.length > 0) {
                    return stringArray[0];
                }
            }
            if (this.isApplicationSecMode()) {
                throw new DeploymentException("Cannot resolve role-Name " + string);
            }
        }
        HTTPLogger.logImplicitMappingForRunAsRoleToSelf((String)this.context.getLogContext(), (String)"run-as", (String)string, (String)"web.xml");
        return string;
    }

    protected boolean checkAdminMode(AuthenticatedSubject authenticatedSubject) {
        if (authenticatedSubject == null) {
            return false;
        }
        return SubjectUtils.isUserInAdminRoles((AuthenticatedSubject)authenticatedSubject, (String[])new String[]{"Admin", "AppTester"});
    }

    public static final boolean getEnforceStrictURLPattern() {
        return SecurityServiceManager.getEnforceStrictURLPattern();
    }

    public static final boolean getEnforceValidBasicAuthCredentials() {
        return SecurityServiceManager.getEnforceValidBasicAuthCredentials();
    }
}

