/*
 * Decompiled with CFR 0.152.
 */
package weblogic.servlet.security.internal;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.AccessController;
import java.security.CodeSource;
import java.security.Permission;
import java.security.Policy;
import java.security.Principal;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.ProtectionDomain;
import java.security.cert.Certificate;
import java.util.HashMap;
import java.util.HashSet;
import javax.security.jacc.PolicyConfiguration;
import javax.security.jacc.PolicyConfigurationFactory;
import javax.security.jacc.PolicyContext;
import javax.security.jacc.PolicyContextException;
import javax.security.jacc.PolicyContextHandler;
import javax.security.jacc.WebResourcePermission;
import javax.security.jacc.WebRoleRefPermission;
import javax.security.jacc.WebUserDataPermission;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import weblogic.application.ApplicationContextInternal;
import weblogic.application.utils.ApplicationVersionUtils;
import weblogic.j2ee.descriptor.AuthConstraintBean;
import weblogic.j2ee.descriptor.SecurityConstraintBean;
import weblogic.j2ee.descriptor.SecurityRoleRefBean;
import weblogic.j2ee.descriptor.ServletBean;
import weblogic.j2ee.descriptor.UserDataConstraintBean;
import weblogic.j2ee.descriptor.WebResourceCollectionBean;
import weblogic.management.DeploymentException;
import weblogic.management.servlet.ConnectionSigner;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.jacc.CommonPolicyContextHandler;
import weblogic.security.jacc.DelegatingPolicyContextHandler;
import weblogic.security.jacc.RoleMapper;
import weblogic.security.jacc.RoleMapperFactory;
import weblogic.servlet.HTTPLogger;
import weblogic.servlet.internal.ServletRequestImpl;
import weblogic.servlet.internal.ServletStubImpl;
import weblogic.servlet.internal.WebAppServletContext;
import weblogic.servlet.security.internal.ResourceConstraint;
import weblogic.servlet.security.internal.WebAppContextHandler;
import weblogic.servlet.security.internal.WebAppContextHandlerData;
import weblogic.servlet.security.internal.WebAppSecurity;
import weblogic.utils.collections.SoftHashMap;

final class WebAppSecurityJacc
extends WebAppSecurity {
    private static final boolean DEBUG = false;
    private static final char DELIMITER = '_';
    private static final boolean CACHE = true;
    private final RoleMapper roleMapper;
    private final PolicyConfiguration policyConfig;
    private final CodeSource codeSource;
    private final ProtectionDomain protectionDomain;
    private final String contextId;
    private HashMap patterns = new HashMap();
    private SoftHashMap pdCache = new SoftHashMap();
    private SoftHashMap udPermCache = new SoftHashMap();
    private SoftHashMap rrPermCache = new SoftHashMap();
    private SoftHashMap resPermCache = new SoftHashMap();

    WebAppSecurityJacc(WebAppServletContext webAppServletContext) throws DeploymentException {
        super(webAppServletContext);
        RoleMapperFactory roleMapperFactory;
        PolicyConfigurationFactory policyConfigurationFactory;
        try {
            policyConfigurationFactory = PolicyConfigurationFactory.getPolicyConfigurationFactory();
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new DeploymentException(classNotFoundException);
        }
        catch (PolicyContextException policyContextException) {
            throw new DeploymentException(policyContextException);
        }
        String string = webAppServletContext.getContextPath();
        string = string.replace('/', '_');
        String string2 = ApplicationVersionUtils.replaceDelimiter(webAppServletContext.getApplicationId(), '_');
        this.contextId = new StringBuffer(101).append(webAppServletContext.getServer().getName()).append('_').append(string2).append('_').append(string).toString();
        try {
            this.policyConfig = policyConfigurationFactory.getPolicyConfiguration(this.contextId, true);
        }
        catch (PolicyContextException policyContextException) {
            throw new DeploymentException(policyContextException);
        }
        try {
            roleMapperFactory = RoleMapperFactory.getRoleMapperFactory();
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new DeploymentException(classNotFoundException);
        }
        catch (PolicyContextException policyContextException) {
            throw new DeploymentException(policyContextException);
        }
        ApplicationContextInternal applicationContextInternal = this.context.getApplicationContext();
        this.roleMapper = roleMapperFactory.getRoleMapper(applicationContextInternal.getApplicationId(), this.contextId, false);
        this.codeSource = this.initializeCodeSource();
        this.protectionDomain = new ProtectionDomain(this.codeSource, null);
        applicationContextInternal.addJACCPolicyConfiguration(this.policyConfig);
    }

    protected boolean isJaccEnabled() {
        return true;
    }

    protected boolean isFullSecurityDelegationRequired() {
        return true;
    }

    protected void deployRoles() throws DeploymentException {
        if (this.roles.isEmpty()) {
            return;
        }
        for (String string : this.roles) {
            String[] stringArray = (String[])this.roleMapping.get(string);
            if (this.isExternallyDefined(stringArray)) continue;
            WebRoleRefPermission webRoleRefPermission = new WebRoleRefPermission("", string);
            try {
                this.policyConfig.addToRole(string, (Permission)webRoleRefPermission);
            }
            catch (PolicyContextException policyContextException) {
                throw new DeploymentException(policyContextException);
            }
        }
        if (this.roleMapping != null && !this.roleMapping.isEmpty()) {
            this.roleMapper.addAppRolesToPrincipalMap(this.roleMapping);
        }
    }

    protected void deployPolicies(SecurityConstraintBean[] securityConstraintBeanArray) throws DeploymentException {
        this.collectPatterns(securityConstraintBeanArray);
        this.computeQualifiedPatterns();
        this.deployRegisteredPolicies(securityConstraintBeanArray);
        this.deployUncheckedPoliciesForException();
    }

    private void deployUncheckedPoliciesForException() throws DeploymentException {
        for (PatternHelper patternHelper : this.patterns.values()) {
            WebResourcePermission webResourcePermission;
            String string;
            String[] stringArray;
            if (patternHelper.getMethodExceptionForWRP() != null) {
                stringArray = new String[patternHelper.getMethodExceptionForWRP().size()];
                patternHelper.getMethodExceptionForWRP().toArray(stringArray);
                string = this.methodsToAction(stringArray);
                if (string != null) {
                    string = "!" + string;
                }
                webResourcePermission = new WebResourcePermission(patternHelper.getQualifiedPattern(), string);
                try {
                    this.policyConfig.addToUncheckedPolicy((Permission)webResourcePermission);
                }
                catch (PolicyContextException policyContextException) {
                    throw new DeploymentException(policyContextException);
                }
            }
            if (patternHelper.getMethodExceptionForUDC() == null) continue;
            stringArray = new String[patternHelper.getMethodExceptionForUDC().size()];
            patternHelper.getMethodExceptionForUDC().toArray(stringArray);
            string = this.methodsToAction(stringArray);
            if (string != null) {
                string = "!" + string;
            }
            webResourcePermission = new WebUserDataPermission(patternHelper.getQualifiedPattern(), string);
            try {
                this.policyConfig.addToUncheckedPolicy((Permission)webResourcePermission);
            }
            catch (PolicyContextException policyContextException) {
                throw new DeploymentException(policyContextException);
            }
        }
    }

    private void deployRegisteredPolicies(SecurityConstraintBean[] securityConstraintBeanArray) throws DeploymentException {
        if (securityConstraintBeanArray == null) {
            return;
        }
        for (int i = 0; i < securityConstraintBeanArray.length; ++i) {
            SecurityConstraintBean securityConstraintBean = securityConstraintBeanArray[i];
            WebResourceCollectionBean[] webResourceCollectionBeanArray = securityConstraintBean.getWebResourceCollections();
            if (webResourceCollectionBeanArray == null) continue;
            this.registerWebResourceCollections(securityConstraintBeanArray[i], webResourceCollectionBeanArray);
        }
    }

    private void registerWebResourceCollections(SecurityConstraintBean securityConstraintBean, WebResourceCollectionBean[] webResourceCollectionBeanArray) throws DeploymentException {
        for (int i = 0; i < webResourceCollectionBeanArray.length; ++i) {
            this.registerSecurityPattern(webResourceCollectionBeanArray[i], securityConstraintBean);
        }
    }

    private void registerSecurityPattern(WebResourceCollectionBean webResourceCollectionBean, SecurityConstraintBean securityConstraintBean) throws DeploymentException {
        String[] stringArray = webResourceCollectionBean.getHttpMethods();
        String[] stringArray2 = webResourceCollectionBean.getUrlPatterns();
        for (int i = 0; i < stringArray2.length; ++i) {
            String string = WebAppSecurityJacc.fixupURLPattern(stringArray2[i]);
            PatternHelper patternHelper = (PatternHelper)this.patterns.get(string);
            this.registerAuthConstraint(patternHelper, stringArray, securityConstraintBean);
            UserDataConstraintBean userDataConstraintBean = securityConstraintBean.getUserDataConstraint();
            if (userDataConstraintBean == null) continue;
            this.registerUserDataConstraints(userDataConstraintBean, patternHelper, stringArray);
        }
    }

    private void registerAuthConstraint(PatternHelper patternHelper, String[] stringArray, SecurityConstraintBean securityConstraintBean) throws DeploymentException {
        String[] stringArray2 = null;
        AuthConstraintBean authConstraintBean = securityConstraintBean.getAuthConstraint();
        if (authConstraintBean == null) {
            return;
        }
        stringArray2 = authConstraintBean.getRoleNames();
        patternHelper.addExceptionMethodsForWRP(stringArray);
        if (stringArray2 == null || stringArray2.length < 1) {
            this.deployExcludedPolicy(patternHelper, stringArray);
            patternHelper.addExceptionMethodsForUDC(stringArray);
        } else {
            this.deployRoleBasedPolicies(stringArray2, patternHelper, stringArray);
        }
    }

    private void registerUserDataConstraints(UserDataConstraintBean userDataConstraintBean, PatternHelper patternHelper, String[] stringArray) throws DeploymentException {
        String string = userDataConstraintBean.getTransportGuarantee();
        if (string.equals("CONFIDENTIAL") || string.equals("INTEGRAL")) {
            patternHelper.addExceptionMethodsForUDC(stringArray);
            String string2 = this.methodsToAction(stringArray) + ':' + string;
            WebUserDataPermission webUserDataPermission = new WebUserDataPermission(patternHelper.getQualifiedPattern(), string2);
            try {
                this.policyConfig.addToUncheckedPolicy((Permission)webUserDataPermission);
            }
            catch (PolicyContextException policyContextException) {
                throw new DeploymentException(policyContextException);
            }
        }
    }

    private void deployRoleBasedPolicies(String[] stringArray, PatternHelper patternHelper, String[] stringArray2) throws DeploymentException {
        int n;
        for (n = 0; n < stringArray.length; ++n) {
            if (!stringArray[n].equals("*")) continue;
            stringArray = new String[this.roles.size()];
            this.roles.toArray(stringArray);
            break;
        }
        for (n = 0; n < stringArray.length; ++n) {
            WebResourcePermission webResourcePermission = new WebResourcePermission(patternHelper.getQualifiedPattern(), this.methodsToAction(stringArray2));
            try {
                this.policyConfig.addToRole(stringArray[n], (Permission)webResourcePermission);
                continue;
            }
            catch (PolicyContextException policyContextException) {
                throw new DeploymentException(policyContextException);
            }
        }
    }

    private void deployExcludedPolicy(PatternHelper patternHelper, String[] stringArray) throws DeploymentException {
        WebResourcePermission webResourcePermission = new WebResourcePermission(patternHelper.getQualifiedPattern(), this.methodsToAction(stringArray));
        WebUserDataPermission webUserDataPermission = new WebUserDataPermission(patternHelper.getQualifiedPattern(), this.methodsToAction(stringArray));
        try {
            this.policyConfig.addToExcludedPolicy((Permission)webResourcePermission);
            this.policyConfig.addToExcludedPolicy((Permission)webUserDataPermission);
        }
        catch (PolicyContextException policyContextException) {
            throw new DeploymentException(policyContextException);
        }
    }

    private String methodsToAction(String[] stringArray) {
        if (stringArray == null || stringArray.length == 0) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer(101);
        for (int i = 0; i < stringArray.length; ++i) {
            if (i != 0) {
                stringBuffer.append(',');
            }
            stringBuffer.append(stringArray[i]);
        }
        return stringBuffer.toString();
    }

    private void collectPatterns(SecurityConstraintBean[] securityConstraintBeanArray) {
        this.patterns.put("/", new PatternHelper("/"));
        if (securityConstraintBeanArray == null) {
            return;
        }
        for (int i = 0; i < securityConstraintBeanArray.length; ++i) {
            WebResourceCollectionBean[] webResourceCollectionBeanArray = securityConstraintBeanArray[i].getWebResourceCollections();
            if (webResourceCollectionBeanArray == null || webResourceCollectionBeanArray.length < 1) continue;
            for (int j = 0; j < webResourceCollectionBeanArray.length; ++j) {
                String[] stringArray = webResourceCollectionBeanArray[j].getUrlPatterns();
                if (stringArray == null) continue;
                for (int k = 0; k < stringArray.length; ++k) {
                    String string = WebAppSecurityJacc.fixupURLPattern(stringArray[k]);
                    this.patterns.put(string, new PatternHelper(string));
                }
            }
        }
    }

    private void computeQualifiedPatterns() {
        if (this.patterns.isEmpty()) {
            return;
        }
        for (PatternHelper patternHelper : this.patterns.values()) {
            patternHelper.computeQualifiedPatterns(this.patterns);
        }
    }

    protected void deployRoleLink(ServletStubImpl servletStubImpl, String string, String string2) throws DeploymentException {
        WebRoleRefPermission webRoleRefPermission = new WebRoleRefPermission(servletStubImpl.getServletName(), string);
        try {
            this.policyConfig.addToRole(string2, (Permission)webRoleRefPermission);
        }
        catch (PolicyContextException policyContextException) {
            throw new DeploymentException(policyContextException);
        }
    }

    public void registerRoleRefs(ServletStubImpl servletStubImpl) throws DeploymentException {
        if (this.roles.isEmpty()) {
            return;
        }
        HashSet hashSet = this.getRoleRefsFromServletBean(servletStubImpl.getServletName());
        for (String string : this.roles) {
            if (hashSet.contains(string)) continue;
            WebRoleRefPermission webRoleRefPermission = new WebRoleRefPermission(servletStubImpl.getServletName(), string);
            try {
                this.policyConfig.addToRole(string, (Permission)webRoleRefPermission);
            }
            catch (PolicyContextException policyContextException) {
                throw new DeploymentException(policyContextException);
            }
        }
    }

    private HashSet getRoleRefsFromServletBean(String string) {
        SecurityRoleRefBean[] securityRoleRefBeanArray;
        HashSet<String> hashSet = new HashSet<String>();
        ServletBean servletBean = this.getContext().getWebAppModule().getWebAppBean().lookupServlet(string);
        if (servletBean != null && (securityRoleRefBeanArray = servletBean.getSecurityRoleRefs()) != null && securityRoleRefBeanArray.length > 0) {
            for (int i = 0; i < securityRoleRefBeanArray.length; ++i) {
                hashSet.add(securityRoleRefBeanArray[i].getRoleName());
            }
        }
        return hashSet;
    }

    public void start() {
    }

    private CodeSource initializeCodeSource() throws DeploymentException {
        URL uRL;
        try {
            URI uRI = new URI("file:///" + this.context.getDocroot().replace('\\', '/'));
            uRL = new URL(uRI.toString());
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new DeploymentException(uRISyntaxException);
        }
        catch (MalformedURLException malformedURLException) {
            throw new DeploymentException(malformedURLException);
        }
        return new CodeSource(uRL, (Certificate[])null);
    }

    public void initContextHandler(ServletRequestImpl servletRequestImpl) {
        WebAppContextHandlerData webAppContextHandlerData = new WebAppContextHandlerData(servletRequestImpl);
        PolicyContext.setHandlerData((Object)webAppContextHandlerData);
    }

    public void resetContextHandler() {
        PolicyContext.setHandlerData(null);
    }

    boolean checkTransport(ResourceConstraint resourceConstraint, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException {
        String string = WebAppSecurityJacc.getRelativeURI(httpServletRequest);
        if (string.length() == 1 && string.charAt(0) == '/') {
            string = "";
        }
        String string2 = httpServletRequest.getMethod();
        if (httpServletRequest.isSecure()) {
            string2 = string2 + ":CONFIDENTIAL";
        }
        boolean bl = false;
        try {
            bl = this.checkTransport(string, string2);
            if (bl) {
                return true;
            }
            if (httpServletRequest.isSecure()) {
                httpServletResponse.sendError(403);
            } else {
                bl = this.checkTransport(string, string2 = string2 + ":CONFIDENTIAL");
                if (!bl) {
                    httpServletResponse.sendError(403);
                } else {
                    String string3 = this.getSecuredURL(httpServletRequest, httpServletResponse, httpServletRequest.getRequestURI());
                    if (string3 != null) {
                        httpServletResponse.sendRedirect(string3);
                    } else {
                        httpServletResponse.sendError(403);
                    }
                }
            }
        }
        catch (SecurityException securityException) {
            HTTPLogger.logSecurityException((String)"user data constraints check", (String)httpServletRequest.getRequestURI(), (String)this.context.getLogContext(), (Throwable)securityException);
            return false;
        }
        return bl;
    }

    public boolean isSSLRequired(String string, String string2) {
        if (string.length() == 1 && string.charAt(0) == '/') {
            string = "";
        }
        String string3 = string2;
        try {
            boolean bl = this.checkTransport(string, string3);
            if (bl) {
                return false;
            }
            string3 = string3 + ":CONFIDENTIAL";
            return this.checkTransport(string, string3);
        }
        catch (SecurityException securityException) {
            HTTPLogger.logSecurityException((String)"user data constraints check", (String)string, (String)this.context.getLogContext(), (Throwable)securityException);
            return true;
        }
    }

    private boolean checkTransport(String string, String string2) {
        WebUserDataPermission webUserDataPermission = this.getWebUserDataPermission(string, string2);
        return this.implies((Permission)webUserDataPermission, this.protectionDomain);
    }

    public boolean isSubjectInRole(AuthenticatedSubject authenticatedSubject, String string, WebAppContextHandler webAppContextHandler, ServletStubImpl servletStubImpl) {
        ProtectionDomain protectionDomain = this.getProtectionDomainForSubject(authenticatedSubject);
        String string2 = servletStubImpl.isDynamicallyGenerated() ? "" : servletStubImpl.getServletName();
        WebRoleRefPermission webRoleRefPermission = this.getWebRoleRefPermission(string2, string);
        boolean bl = false;
        try {
            bl = this.implies((Permission)webRoleRefPermission, protectionDomain);
        }
        catch (SecurityException securityException) {
            HTTPLogger.logSecurityException((String)"isUserInRole check", (String)authenticatedSubject.getName(), (String)this.context.getLogContext(), (Throwable)securityException);
            return false;
        }
        return bl;
    }

    public boolean hasPermission(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, AuthenticatedSubject authenticatedSubject, ResourceConstraint resourceConstraint) {
        if (this.context.isAdminMode() && this.context.isInternalApp() && ConnectionSigner.isConnectionSigned(httpServletRequest)) {
            return true;
        }
        if (this.context.isAdminMode()) {
            return this.checkAdminMode(authenticatedSubject);
        }
        ProtectionDomain protectionDomain = this.getProtectionDomainForSubject(authenticatedSubject);
        WebResourcePermission webResourcePermission = this.getWebResourcePermission(httpServletRequest);
        boolean bl = false;
        try {
            bl = this.implies((Permission)webResourcePermission, protectionDomain);
        }
        catch (SecurityException securityException) {
            HTTPLogger.logSecurityException((String)"permission check", (String)httpServletRequest.getRequestURI(), (String)this.context.getLogContext(), (Throwable)securityException);
            bl = false;
        }
        return bl;
    }

    private WebUserDataPermission getWebUserDataPermission(String string, String string2) {
        PermKey permKey = new PermKey(string, string2);
        WebUserDataPermission webUserDataPermission = (WebUserDataPermission)this.udPermCache.get((Object)permKey);
        if (webUserDataPermission != null) {
            return webUserDataPermission;
        }
        webUserDataPermission = new WebUserDataPermission(string, string2);
        this.udPermCache.put((Object)permKey, (Object)webUserDataPermission);
        return webUserDataPermission;
    }

    private WebRoleRefPermission getWebRoleRefPermission(String string, String string2) {
        PermKey permKey = new PermKey(string, string2);
        WebRoleRefPermission webRoleRefPermission = (WebRoleRefPermission)this.rrPermCache.get((Object)permKey);
        if (webRoleRefPermission != null) {
            return webRoleRefPermission;
        }
        webRoleRefPermission = new WebRoleRefPermission(string, string2);
        this.rrPermCache.put((Object)permKey, (Object)webRoleRefPermission);
        return webRoleRefPermission;
    }

    private WebResourcePermission getWebResourcePermission(HttpServletRequest httpServletRequest) {
        String string;
        PermKey permKey;
        WebResourcePermission webResourcePermission;
        String string2 = httpServletRequest.getServletPath();
        if (string2.length() == 1 && string2.charAt(0) == '/') {
            string2 = "";
        }
        if ((webResourcePermission = (WebResourcePermission)this.resPermCache.get((Object)(permKey = new PermKey(string2, string = httpServletRequest.getMethod())))) != null) {
            return webResourcePermission;
        }
        webResourcePermission = new WebResourcePermission(string2, string);
        this.resPermCache.put((Object)permKey, (Object)webResourcePermission);
        return webResourcePermission;
    }

    private ProtectionDomain getProtectionDomainForSubject(AuthenticatedSubject authenticatedSubject) {
        Principal[] principalArray;
        if (authenticatedSubject != null) {
            principalArray = new Principal[authenticatedSubject.getPrincipals().size()];
            authenticatedSubject.getPrincipals().toArray(principalArray);
        } else {
            principalArray = new Principal[]{};
        }
        ProtectionDomain protectionDomain = (ProtectionDomain)this.pdCache.get((Object)authenticatedSubject);
        if (protectionDomain != null) {
            return protectionDomain;
        }
        protectionDomain = new ProtectionDomain(this.codeSource, null, null, principalArray);
        this.pdCache.put((Object)authenticatedSubject, (Object)protectionDomain);
        return protectionDomain;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean implies(Permission permission, ProtectionDomain protectionDomain) {
        String string = PolicyContext.getContextID();
        this.setPolicyContext(this.contextId);
        try {
            boolean bl = Policy.getPolicy().implies(protectionDomain, permission);
            Object var6_5 = null;
            this.setPolicyContext(string);
            return bl;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            this.setPolicyContext(string);
            throw throwable;
        }
    }

    private void setPolicyContext(final String string) {
        String string2 = PolicyContext.getContextID();
        if (!(string2 == string || string2 != null && string != null && string2.equals(string))) {
            try {
                AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws Exception {
                        PolicyContext.setContextID((String)string);
                        return null;
                    }
                });
            }
            catch (PrivilegedActionException privilegedActionException) {
                Throwable throwable = privilegedActionException;
                if (privilegedActionException.getCause() != null) {
                    throwable = privilegedActionException.getCause();
                }
                throw new SecurityException(throwable.getMessage());
            }
        }
    }

    public ResourceConstraint getConstraint(HttpServletRequest httpServletRequest) {
        return null;
    }

    public void unregister() {
        super.unregister();
        try {
            this.policyConfig.delete();
        }
        catch (PolicyContextException policyContextException) {
            HTTPLogger.logFailedToUndeploySecurityPolicy((String)this.policyConfig.toString(), (Throwable)policyContextException);
        }
    }

    static {
        CommonPolicyContextHandler commonPolicyContextHandler = new CommonPolicyContextHandler();
        String[] stringArray = WebAppContextHandlerData.getKeys();
        DelegatingPolicyContextHandler delegatingPolicyContextHandler = new DelegatingPolicyContextHandler(stringArray);
        try {
            PolicyContext.registerHandler((String)"javax.security.auth.Subject.container", (PolicyContextHandler)commonPolicyContextHandler, (boolean)true);
            for (int i = 0; i < stringArray.length; ++i) {
                PolicyContext.registerHandler((String)stringArray[i], (PolicyContextHandler)delegatingPolicyContextHandler, (boolean)true);
            }
        }
        catch (PolicyContextException policyContextException) {
            HTTPLogger.logFailedToRegisterPolicyContextHandlers((Throwable)policyContextException);
        }
    }

    private class PermKey {
        private String key1;
        private String key2;

        private PermKey(String string, String string2) {
            this.key1 = string;
            this.key2 = string2;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (!(object instanceof PermKey)) {
                return false;
            }
            PermKey permKey = (PermKey)object;
            if (this.key2 != null ? !this.key2.equals(permKey.key2) : permKey.key2 != null) {
                return false;
            }
            return !(this.key1 != null ? !this.key1.equals(permKey.key1) : permKey.key1 != null);
        }

        public int hashCode() {
            int n = this.key1 != null ? this.key1.hashCode() : 0;
            n = 29 * n + (this.key2 != null ? this.key2.hashCode() : 0);
            return n;
        }
    }

    private static class PatternHelper {
        private final String pattern;
        private final boolean prefixPattern;
        private final boolean exactPattern;
        private final boolean extensionPattern;
        private final boolean defaultPattern;
        private final String prefix;
        private HashSet methodExceptionForWRP = new HashSet();
        private HashSet methodExceptionForUDC = new HashSet();
        private String qualifiedPattern;
        private final String extension;

        PatternHelper(String string) {
            this.qualifiedPattern = this.pattern = string;
            if (string == null) {
                throw new IllegalArgumentException("pattern is null");
            }
            if (string.length() == 1 && string.charAt(0) == '/') {
                this.defaultPattern = true;
                this.exactPattern = false;
                this.extensionPattern = false;
                this.prefixPattern = false;
                this.prefix = "";
                this.extension = null;
            } else if (string.startsWith("*.")) {
                this.exactPattern = false;
                this.extensionPattern = true;
                this.prefixPattern = false;
                this.defaultPattern = false;
                this.prefix = null;
                this.extension = this.pattern.substring(1);
            } else if (string.length() == 2 && string.equals("/*")) {
                this.exactPattern = false;
                this.extensionPattern = false;
                this.prefixPattern = true;
                this.defaultPattern = true;
                this.prefix = "";
                this.extension = null;
            } else if (string.endsWith("/*")) {
                this.exactPattern = false;
                this.extensionPattern = false;
                this.prefixPattern = true;
                this.defaultPattern = false;
                this.prefix = this.pattern.substring(0, this.pattern.length() - 1);
                this.extension = null;
            } else {
                this.exactPattern = true;
                this.extensionPattern = false;
                this.prefixPattern = false;
                this.defaultPattern = false;
                this.prefix = string;
                this.extension = null;
            }
        }

        String getPattern() {
            return this.pattern;
        }

        boolean isPrefixPattern() {
            return this.prefixPattern;
        }

        boolean isExactPattern() {
            return this.exactPattern;
        }

        boolean isExtensionPattern() {
            return this.extensionPattern;
        }

        boolean isDefaultPattern() {
            return this.defaultPattern;
        }

        String getPrefix() {
            return this.prefix;
        }

        HashSet getMethodExceptionForWRP() {
            return this.methodExceptionForWRP;
        }

        HashSet getMethodExceptionForUDC() {
            return this.methodExceptionForUDC;
        }

        String getQualifiedPattern() {
            return this.qualifiedPattern;
        }

        private void computeQualifiedPatterns(HashMap hashMap) {
            if (this.isExactPattern()) {
                return;
            }
            for (PatternHelper patternHelper : hashMap.values()) {
                if (patternHelper.getPattern().equals(this.pattern)) continue;
                boolean bl = false;
                if (this.isDefaultPattern()) {
                    bl = !patternHelper.getPattern().equals("/") && !patternHelper.getPattern().equals("/*");
                } else if (this.isPrefixPattern()) {
                    if (patternHelper.isPrefixPattern()) {
                        bl = patternHelper.getPrefix().startsWith(this.prefix);
                    } else if (patternHelper.isExactPattern()) {
                        bl = patternHelper.getPattern().startsWith(this.prefix) || this.prefix.equals(patternHelper.getPattern() + "/");
                    }
                } else if (patternHelper.isPrefixPattern()) {
                    bl = true;
                } else if (patternHelper.isExactPattern()) {
                    bl = patternHelper.getPattern().endsWith(this.extension);
                }
                if (!bl) continue;
                this.qualifiedPattern = this.qualifiedPattern + ":" + patternHelper.getPattern();
            }
        }

        private void addExceptionMethodsForWRP(String[] stringArray) {
            if (stringArray == null || stringArray.length == 0) {
                this.methodExceptionForWRP = null;
                return;
            }
            if (this.methodExceptionForWRP == null) {
                this.methodExceptionForWRP = new HashSet();
            }
            for (int i = 0; i < stringArray.length; ++i) {
                this.methodExceptionForWRP.add(stringArray[i]);
            }
        }

        private void addExceptionMethodsForUDC(String[] stringArray) {
            if (stringArray == null || stringArray.length == 0) {
                this.methodExceptionForUDC = null;
                return;
            }
            if (this.methodExceptionForUDC == null) {
                this.methodExceptionForUDC = new HashSet();
            }
            for (int i = 0; i < stringArray.length; ++i) {
                this.methodExceptionForUDC.add(stringArray[i]);
            }
        }
    }
}

