/*
 * Decompiled with CFR 0.152.
 */
package weblogic.servlet.security.internal;

import java.io.IOException;
import java.security.AccessController;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import weblogic.application.SecurityRole;
import weblogic.application.utils.ApplicationVersionUtils;
import weblogic.j2ee.descriptor.SecurityConstraintBean;
import weblogic.j2ee.descriptor.WebResourceCollectionBean;
import weblogic.management.DeploymentException;
import weblogic.management.servlet.ConnectionSigner;
import weblogic.security.SubjectUtils;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.AuthorizationManager;
import weblogic.security.service.AuthorizationManagerDeployHandle;
import weblogic.security.service.ContextHandler;
import weblogic.security.service.DeployHandleCreationException;
import weblogic.security.service.PrivilegedActions;
import weblogic.security.service.ResourceBase;
import weblogic.security.service.ResourceCreationException;
import weblogic.security.service.ResourceRemovalException;
import weblogic.security.service.RoleCreationException;
import weblogic.security.service.RoleManager;
import weblogic.security.service.RoleManagerDeployHandle;
import weblogic.security.service.RoleRemovalException;
import weblogic.security.service.SecurityApplicationInfo;
import weblogic.security.service.SecurityService;
import weblogic.security.service.SecurityServiceManager;
import weblogic.security.service.URLResource;
import weblogic.security.spi.Resource;
import weblogic.servlet.HTTPLogger;
import weblogic.servlet.internal.ServletRequestImpl;
import weblogic.servlet.internal.ServletStubImpl;
import weblogic.servlet.internal.WebAppConfigManager;
import weblogic.servlet.internal.WebAppServletContext;
import weblogic.servlet.security.internal.ResourceConstraint;
import weblogic.servlet.security.internal.WebAppContextHandler;
import weblogic.servlet.security.internal.WebAppSecurity;
import weblogic.servlet.utils.StandardURLMapping;
import weblogic.servlet.utils.URLMappingFactory;

final class WebAppSecurityWLS
extends WebAppSecurity {
    private static final AuthenticatedSubject KERNEL_ID = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
    private final AuthorizationManager authManager;
    private final RoleManager roleManager;
    private final boolean fullDelegation;
    private final boolean customRoles;
    private final RoleManagerDeployHandle roleMgrHandle;
    private final AuthorizationManagerDeployHandle authMgrHandle;
    private HashMap constraintsMap;

    public WebAppSecurityWLS(WebAppServletContext webAppServletContext) throws DeploymentException {
        super(webAppServletContext);
        this.authManager = (AuthorizationManager)SecurityServiceManager.getSecurityService((AuthenticatedSubject)KERNEL_ID, (String)webAppServletContext.getSecurityRealmName(), (SecurityService.ServiceType)SecurityService.ServiceType.AUTHORIZE);
        this.roleManager = (RoleManager)SecurityServiceManager.getSecurityService((AuthenticatedSubject)KERNEL_ID, (String)webAppServletContext.getSecurityRealmName(), (SecurityService.ServiceType)SecurityService.ServiceType.ROLE);
        try {
            this.authMgrHandle = this.authManager.startDeployPolicies(this.secureAppInfo);
            this.roleMgrHandle = this.roleManager.startDeployRoles(this.secureAppInfo);
        }
        catch (DeployHandleCreationException deployHandleCreationException) {
            throw new DeploymentException(deployHandleCreationException);
        }
        String string = this.secureAppInfo.getSecurityDDModel();
        this.customRoles = string.equals("CustomRoles") || string.equals("CustomRolesAndPolicies");
        this.fullDelegation = SecurityServiceManager.isFullAuthorizationDelegationRequired((String)webAppServletContext.getSecurityRealmName(), (SecurityApplicationInfo)this.secureAppInfo);
    }

    protected boolean isFullSecurityDelegationRequired() {
        return this.fullDelegation;
    }

    protected boolean isJaccEnabled() {
        return false;
    }

    protected AuthorizationManager getAuthManager() {
        return this.authManager;
    }

    protected AuthorizationManagerDeployHandle getAuthMgrHandle() {
        return this.authMgrHandle;
    }

    protected Set getRoles() {
        return this.roles;
    }

    private void deployRole(ResourceBase resourceBase, String string, String[] stringArray) throws DeploymentException {
        try {
            this.roleManager.deployRole(this.roleMgrHandle, (Resource)resourceBase, string, stringArray);
        }
        catch (RoleCreationException roleCreationException) {
            HTTPLogger.logCouldNotDeployRole((String)string, (String)this.context.getURI(), (String)ApplicationVersionUtils.getDisplayName(this.context.getApplicationId()), (Throwable)roleCreationException);
            throw new DeploymentException(roleCreationException);
        }
    }

    protected void deployRoles() throws DeploymentException {
        if (this.roles.isEmpty()) {
            return;
        }
        URLResource uRLResource = new URLResource(this.context.getApplicationId(), this.context.getContextPath(), WebAppSecurityWLS.getEnforceStrictURLPattern() ? "/" : "/*", null, null);
        StringBuffer stringBuffer = null;
        int n = 0;
        for (String string : this.roles) {
            boolean bl;
            boolean bl2;
            String[] stringArray = (String[])this.roleMapping.get(string);
            boolean bl3 = bl2 = stringArray != null && stringArray.length > 0;
            if (this.isCompatibilitySecMode()) {
                if (bl2) {
                    if (this.isExternallyDefined(stringArray)) continue;
                    this.deployRole((ResourceBase)uRLResource, string, stringArray);
                    continue;
                }
                if (this.customRoles) continue;
                this.deployRole((ResourceBase)uRLResource, string, new String[]{string});
                if (n < 1) {
                    stringBuffer = new StringBuffer();
                    stringBuffer.append(string);
                } else {
                    stringBuffer.append(", " + string);
                }
                ++n;
                continue;
            }
            if (this.isExternallyDefined(stringArray)) continue;
            SecurityRole securityRole = this.context.getApplicationContext().getSecurityRole(string);
            String[] stringArray2 = null;
            if (securityRole != null) {
                stringArray2 = securityRole.getPrincipalNames();
            }
            boolean bl4 = bl = stringArray2 != null && stringArray2.length > 0;
            if (!bl2 && !bl) {
                if (!this.isApplicationSecMode()) continue;
                this.deployRole((ResourceBase)uRLResource, string, new String[0]);
                continue;
            }
            if (securityRole != null && securityRole.isExternallyDefined()) {
                if (!bl2) continue;
                this.deployRole((ResourceBase)uRLResource, string, stringArray);
                continue;
            }
            if (bl) {
                if (!bl2) {
                    stringArray = stringArray2;
                } else {
                    String[] stringArray3 = new String[stringArray2.length + stringArray.length];
                    System.arraycopy(stringArray, 0, stringArray3, 0, stringArray.length);
                    System.arraycopy(stringArray2, 0, stringArray3, stringArray.length, stringArray2.length);
                    stringArray = stringArray3;
                }
            }
            if (stringArray.length <= 0) continue;
            this.deployRole((ResourceBase)uRLResource, string, stringArray);
        }
        if (stringBuffer != null) {
            HTTPLogger.logCreatingImplicitMapForRoles((String)this.context.getLogContext(), (String)(n == 1 ? "role" : "roles"), (String)(n == 1 ? "has" : "have"), (String)stringBuffer.toString());
        }
    }

    private void mergePolicy(ResourceConstraint resourceConstraint) throws DeploymentException {
        StandardURLMapping standardURLMapping;
        if (URLMappingFactory.isInvalidUrlPattern(this.context.getUrlMatchMap(), resourceConstraint.getResourceId())) {
            throw new DeploymentException("The url-pattern, '" + resourceConstraint.getResourceId() + "' is not valid");
        }
        String string = resourceConstraint.getHttpMethod();
        if (string == null) {
            string = "";
        }
        if ((standardURLMapping = (StandardURLMapping)this.constraintsMap.get(string)) == null) {
            standardURLMapping = URLMappingFactory.createCompatibleURLMapping(this.context.getUrlMatchMap(), this.context.getServletClassLoader(), WebAppConfigManager.isCaseInsensitive(), WebAppSecurityWLS.getEnforceStrictURLPattern());
            this.constraintsMap.put(string, standardURLMapping);
            standardURLMapping.put(resourceConstraint.getResourceId(), resourceConstraint);
            return;
        }
        ResourceConstraint resourceConstraint2 = (ResourceConstraint)standardURLMapping.removePattern(resourceConstraint.getResourceId());
        if (resourceConstraint2 != null) {
            int n;
            int n2 = resourceConstraint.getTransportGuarantee();
            if (n2 != (n = resourceConstraint2.getTransportGuarantee())) {
                resourceConstraint.setTransportGuarantee(n2 > n ? n2 : n);
            }
            if (resourceConstraint2.getRoles() == null || resourceConstraint.getRoles() == null) {
                resourceConstraint = resourceConstraint2.getRoles() == null ? resourceConstraint2 : resourceConstraint;
            } else if (resourceConstraint2.getRoles().length == 0 || resourceConstraint.getRoles().length == 0) {
                resourceConstraint = resourceConstraint2.getRoles().length == 0 ? resourceConstraint2 : resourceConstraint;
            } else {
                resourceConstraint.addRoles(resourceConstraint2.getRoles());
            }
        }
        standardURLMapping.put(resourceConstraint.getResourceId(), resourceConstraint);
    }

    private void mergePatterns(String[] stringArray, String string, SecurityConstraintBean securityConstraintBean) throws DeploymentException {
        for (int i = 0; stringArray != null && i < stringArray.length; ++i) {
            String string2 = WebAppSecurityWLS.fixupURLPattern(stringArray[i]);
            if (this.getContext().isInternalApp() && string2.equals("/") && !WebAppSecurityWLS.getEnforceStrictURLPattern()) {
                string2 = "/*";
            }
            this.mergePolicy(new ResourceConstraint(string2, string, securityConstraintBean));
        }
    }

    protected void mergePolicies(SecurityConstraintBean[] securityConstraintBeanArray) throws DeploymentException {
        if (securityConstraintBeanArray == null || securityConstraintBeanArray.length < 1) {
            return;
        }
        for (int i = 0; i < securityConstraintBeanArray.length; ++i) {
            WebResourceCollectionBean[] webResourceCollectionBeanArray = securityConstraintBeanArray[i].getWebResourceCollections();
            for (int j = 0; webResourceCollectionBeanArray != null && j < webResourceCollectionBeanArray.length; ++j) {
                String[] stringArray = webResourceCollectionBeanArray[j].getHttpMethods();
                if (stringArray == null || stringArray.length == 0) {
                    this.mergePatterns(webResourceCollectionBeanArray[j].getUrlPatterns(), null, securityConstraintBeanArray[i]);
                }
                for (int k = 0; stringArray != null && k < stringArray.length; ++k) {
                    this.mergePatterns(webResourceCollectionBeanArray[j].getUrlPatterns(), stringArray[k], securityConstraintBeanArray[i]);
                }
            }
        }
    }

    protected void deployPolicies(SecurityConstraintBean[] securityConstraintBeanArray) throws DeploymentException {
        if (securityConstraintBeanArray == null || securityConstraintBeanArray.length < 1) {
            return;
        }
        if (this.constraintsMap == null) {
            this.constraintsMap = new HashMap();
        }
        this.mergePolicies(securityConstraintBeanArray);
        for (StandardURLMapping standardURLMapping : this.constraintsMap.values()) {
            Object[] objectArray = standardURLMapping.values();
            for (int i = 0; i < objectArray.length; ++i) {
                ((ResourceConstraint)objectArray[i]).deploy(this);
            }
        }
    }

    public void unregister() {
        super.unregister();
        try {
            this.authManager.undeployAllPolicies(this.authMgrHandle);
        }
        catch (ResourceRemovalException resourceRemovalException) {
            HTTPLogger.logFailedToUndeploySecurityPolicy((String)this.context.getLogContext(), (Throwable)resourceRemovalException);
        }
        try {
            this.roleManager.undeployAllRoles(this.roleMgrHandle);
        }
        catch (RoleRemovalException roleRemovalException) {
            HTTPLogger.logFailedToUndeploySecurityRole((String)this.context.getLogContext(), (Throwable)roleRemovalException);
        }
    }

    public ResourceConstraint getConstraint(HttpServletRequest httpServletRequest) {
        return this.getConstraint(WebAppSecurityWLS.getRelativeURI(httpServletRequest), httpServletRequest.getMethod());
    }

    private ResourceConstraint getConstraint(String string, String string2) {
        if (this.constraintsMap == null) {
            return null;
        }
        StandardURLMapping standardURLMapping = null;
        if (string2 != null) {
            ResourceConstraint resourceConstraint;
            standardURLMapping = (StandardURLMapping)this.constraintsMap.get(string2);
            if (standardURLMapping != null && (resourceConstraint = (ResourceConstraint)standardURLMapping.get(string)) != null) {
                return resourceConstraint;
            }
            return this.getConstraint(string, null);
        }
        standardURLMapping = (StandardURLMapping)this.constraintsMap.get("");
        if (standardURLMapping == null) {
            return null;
        }
        return (ResourceConstraint)standardURLMapping.get(string);
    }

    public boolean hasPermission(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, AuthenticatedSubject authenticatedSubject, ResourceConstraint resourceConstraint) {
        if (this.context.isAdminMode() && this.context.isInternalApp() && ConnectionSigner.isConnectionSigned(httpServletRequest)) {
            return true;
        }
        if (this.context.isAdminMode()) {
            return this.checkAdminMode(authenticatedSubject);
        }
        if (!this.fullDelegation) {
            if (resourceConstraint == null || resourceConstraint.isUnrestricted()) {
                return true;
            }
            if (resourceConstraint.isForbidden()) {
                return false;
            }
            if (resourceConstraint.isLoginRequired()) {
                return authenticatedSubject != null;
            }
            if (authenticatedSubject == null) {
                return false;
            }
        } else if (resourceConstraint != null && resourceConstraint.isLoginRequired() && authenticatedSubject == null) {
            return false;
        }
        if (authenticatedSubject == null) {
            authenticatedSubject = SubjectUtils.getAnonymousSubject();
        }
        ContextHandler contextHandler = WebAppSecurityWLS.getContextHandler(httpServletRequest, httpServletResponse);
        URLResource uRLResource = new URLResource(this.context.getApplicationId(), this.context.getContextPath(), WebAppSecurityWLS.getRelativeURI(httpServletRequest), httpServletRequest.getMethod(), null);
        return this.authManager.isAccessAllowed(authenticatedSubject, (Resource)uRLResource, contextHandler);
    }

    public boolean isSubjectInRole(AuthenticatedSubject authenticatedSubject, String string, WebAppContextHandler webAppContextHandler, ServletStubImpl servletStubImpl) {
        Map map;
        String string2 = servletStubImpl.getSecurityHelper().getRoleLink(string);
        if (string2 != null) {
            string = string2;
        }
        URLResource uRLResource = null;
        uRLResource = new URLResource(this.context.getApplicationId(), this.context.getContextPath(), WebAppSecurityWLS.getEnforceStrictURLPattern() ? "/" : "/*", null, null);
        if (authenticatedSubject == null) {
            authenticatedSubject = SubjectUtils.getAnonymousSubject();
        }
        if ((map = this.roleManager.getRoles(authenticatedSubject, (Resource)uRLResource, (ContextHandler)webAppContextHandler)) == null) {
            return false;
        }
        return SecurityServiceManager.isUserInRole((AuthenticatedSubject)authenticatedSubject, (String)string, (Map)map);
    }

    public void registerRoleRefs(ServletStubImpl servletStubImpl) {
    }

    public void start() throws DeploymentException {
        try {
            this.authManager.endDeployPolicies(this.authMgrHandle);
        }
        catch (ResourceCreationException resourceCreationException) {
            throw new DeploymentException(resourceCreationException);
        }
        try {
            this.roleManager.endDeployRoles(this.roleMgrHandle);
        }
        catch (RoleCreationException roleCreationException) {
            throw new DeploymentException(roleCreationException);
        }
    }

    public void initContextHandler(ServletRequestImpl servletRequestImpl) {
    }

    public void resetContextHandler() {
    }

    final boolean checkTransport(ResourceConstraint resourceConstraint, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException {
        if (resourceConstraint == null) {
            return true;
        }
        if (resourceConstraint.getTransportGuarantee() != 0 && !httpServletRequest.isSecure()) {
            String string = this.getSecuredURL(httpServletRequest, httpServletResponse, httpServletRequest.getRequestURI());
            if (string != null) {
                httpServletResponse.sendRedirect(httpServletResponse.encodeURL(string));
            } else {
                httpServletResponse.sendError(403);
            }
            return false;
        }
        return true;
    }

    public boolean isSSLRequired(String string, String string2) {
        ResourceConstraint resourceConstraint = this.getConstraint(string, string2);
        return resourceConstraint != null && resourceConstraint.getTransportGuarantee() != 0;
    }

    protected void deployRoleLink(ServletStubImpl servletStubImpl, String string, String string2) {
        servletStubImpl.getSecurityHelper().addRoleLink(string, string2);
    }
}

