/*
 * Decompiled with CFR 0.152.
 */
package weblogic.servlet.utils;

import java.lang.reflect.Field;
import java.util.Iterator;
import java.util.Map;
import javax.el.BeanELResolver;
import weblogic.servlet.HTTPLogger;

public class BeanELResolverCachePurger {
    private static Map cache = null;

    private BeanELResolverCachePurger() {
    }

    public static void purgeCache(ClassLoader classLoader) {
        if (classLoader == null || cache == null || cache.isEmpty()) {
            return;
        }
        Iterator iterator = cache.keySet().iterator();
        while (iterator.hasNext()) {
            Class clazz = (Class)iterator.next();
            if (!BeanELResolverCachePurger.isSameOrChild(classLoader, clazz.getClassLoader())) continue;
            iterator.remove();
        }
    }

    private static boolean isSameOrChild(ClassLoader classLoader, ClassLoader classLoader2) {
        for (ClassLoader classLoader3 = classLoader; classLoader3 != ClassLoader.getSystemClassLoader(); classLoader3 = classLoader3.getParent()) {
            if (classLoader3 != classLoader2) continue;
            return true;
        }
        return false;
    }

    static {
        try {
            Field field = BeanELResolver.class.getDeclaredField("properties");
            field.setAccessible(true);
            cache = (Map)field.get(null);
        }
        catch (NoSuchFieldException noSuchFieldException) {
            HTTPLogger.logBeanELResolverPurgerException((Throwable)noSuchFieldException);
        }
        catch (IllegalAccessException illegalAccessException) {
            HTTPLogger.logBeanELResolverPurgerException((Throwable)illegalAccessException);
        }
        catch (Exception exception) {
            HTTPLogger.logBeanELResolverPurgerException((Throwable)exception);
        }
    }
}

