/*
 * Decompiled with CFR 0.152.
 */
package weblogic.servlet.utils;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;

public class BufferredResponseWrapper
extends HttpServletResponseWrapper {
    private ServletOutputStream sos;
    private BufferredOutputStream bos = new BufferredOutputStream();
    private PrintWriter writer;
    private int status = 200;
    private boolean verbose = false;

    public BufferredResponseWrapper(HttpServletResponse httpServletResponse) throws IOException {
        super(httpServletResponse);
    }

    public int getStatus() {
        return this.status;
    }

    public byte[] getContent() throws IOException {
        this.bos.flush();
        return this.bos.getContent();
    }

    public boolean getVerbose() {
        return this.verbose;
    }

    public void setVerbose(boolean bl) {
        this.verbose = bl;
    }

    public void setBufferSize(int n) {
    }

    public void setContentType(String string) {
    }

    public void setContentLength(int n) {
    }

    public void addCookie(Cookie cookie) {
    }

    public void addDateHeader(String string, long l) {
    }

    public void addHeader(String string, String string2) {
    }

    public void addIntHeader(String string, int n) {
    }

    public void sendRedirect(String string) {
    }

    public void setDateHeader(String string, long l) {
    }

    public void setHeader(String string, String string2) {
    }

    public void setIntHeader(String string, int n) {
    }

    public void sendError(int n) {
        this.status = n;
    }

    public void sendError(int n, String string) {
        this.status = n;
    }

    public void setStatus(int n) {
        this.status = n;
    }

    public void setStatus(int n, String string) {
        this.status = n;
    }

    public boolean isCommitted() {
        return false;
    }

    public ServletOutputStream getOutputStream() throws IOException {
        if (this.writer != null) {
            throw new IllegalStateException("Cannot get Writer then OutputStream");
        }
        this.sos = this.bos;
        return this.sos;
    }

    public PrintWriter getWriter() throws IOException {
        if (this.sos != null) {
            throw new IllegalStateException("Cannot get OutputStream then Writer");
        }
        if (this.writer == null) {
            this.writer = new PrintWriter(new OutputStreamWriter((OutputStream)((Object)this.bos), this.getCharacterEncoding()));
        }
        return this.writer;
    }

    public void flushBuffer() {
        block4: {
            try {
                if (this.writer != null) {
                    this.writer.flush();
                }
                if (this.sos != null) {
                    this.sos.flush();
                }
            }
            catch (IOException iOException) {
                if (!this.verbose) break block4;
                iOException.printStackTrace();
            }
        }
    }

    public void reset() {
        this.status = 200;
        this.resetBuffer();
    }

    public void resetBuffer() {
        this.bos.reset();
        if (this.writer != null) {
            try {
                this.writer = new PrintWriter(new OutputStreamWriter((OutputStream)((Object)this.bos), this.getCharacterEncoding()));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {}
        } else if (this.sos != null) {
            this.sos = this.bos;
        }
    }

    public static class BufferredOutputStream
    extends ServletOutputStream {
        private ByteArrayOutputStream baos = new ByteArrayOutputStream();

        public byte[] getContent() {
            return this.baos.toByteArray();
        }

        public void write(int n) throws IOException {
            this.baos.write(n);
        }

        public void write(byte[] byArray, int n, int n2) throws IOException {
            this.baos.write(byArray, n, n2);
        }

        public void reset() {
            this.baos.reset();
        }
    }
}

