/*
 * Decompiled with CFR 0.152.
 */
package weblogic.servlet.utils;

import com.bea.wls.redef.ClassRedefinitionRuntime;
import com.bea.wls.redef.RedefiningClassLoader;
import com.bea.wls.redef.RedefinitionTask;
import java.io.IOException;
import java.util.Collections;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import weblogic.management.DeploymentException;
import weblogic.servlet.internal.WebAppServletContext;

public class FastSwapFilter
implements Filter {
    private FilterConfig config;
    private long refreshInterval;
    private long lastRefreshTime;

    public void init(FilterConfig filterConfig) throws ServletException {
        this.config = filterConfig;
        this.initRefreshInterval(filterConfig);
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        if (!(servletRequest instanceof HttpServletRequest) && !(servletResponse instanceof HttpServletResponse)) {
            filterChain.doFilter(servletRequest, servletResponse);
            return;
        }
        this.redefineClasses();
        filterChain.doFilter(servletRequest, servletResponse);
    }

    private void redefineClasses() throws ServletException {
        long l = System.currentTimeMillis();
        if (l - this.lastRefreshTime < this.refreshInterval) {
            return;
        }
        try {
            WebAppServletContext webAppServletContext = (WebAppServletContext)this.config.getServletContext();
            Object object = webAppServletContext.getApplicationContext().getAppClassLoader();
            if (!(object instanceof RedefiningClassLoader)) {
                object = webAppServletContext.getServletClassLoader();
            }
            if (object instanceof RedefiningClassLoader) {
                RedefiningClassLoader redefiningClassLoader = (RedefiningClassLoader)object;
                ClassRedefinitionRuntime classRedefinitionRuntime = redefiningClassLoader.getRedefinitionRuntime();
                RedefinitionTask redefinitionTask = new RedefinitionTask(classRedefinitionRuntime, null, null);
                classRedefinitionRuntime.redefineClasses(null, null, redefinitionTask);
            }
        }
        catch (Exception exception) {
            throw new ServletException(exception.getMessage(), (Throwable)exception);
        }
        this.lastRefreshTime = l;
    }

    public void destroy() {
    }

    private void initRefreshInterval(FilterConfig filterConfig) {
        WebAppServletContext webAppServletContext = (WebAppServletContext)filterConfig.getServletContext();
        this.refreshInterval = 1000L * (long)webAppServletContext.getWebAppModule().getFastSwapRefreshInterval();
    }

    public static void registerFastSwapFilter(WebAppServletContext webAppServletContext) throws DeploymentException {
        webAppServletContext.registerFilter("FastSwapFilter", FastSwapFilter.class.getName(), new String[]{"/*"}, null, Collections.emptyMap());
    }
}

