/*
 * Decompiled with CFR 0.152.
 */
package weblogic.servlet.utils;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import weblogic.servlet.utils.StandardURLMapping;
import weblogic.servlet.utils.URLMapping;
import weblogic.utils.collections.MatchMap;

public class OC4JURLMapping
extends StandardURLMapping
implements URLMapping {
    final MatchMap wildcardMap;

    public OC4JURLMapping() {
        this(false, false);
    }

    public OC4JURLMapping(boolean bl, boolean bl2) {
        super(bl, bl2);
        this.wildcardMap = new MatchMap();
    }

    private OC4JURLMapping(MatchMap matchMap, HashMap hashMap, boolean bl, boolean bl2, MatchMap matchMap2) {
        super(matchMap, hashMap, bl, bl2);
        this.wildcardMap = matchMap2;
    }

    public void put(String string, Object object) {
        int n;
        int n2 = (string = OC4JURLMapping.fixPattern(string)).indexOf("*");
        if (n2 == (n = string.length()) - 1 && string.charAt(n - 2) != '/') {
            this.putWildcardMapping(string.substring(0, n - 1), null, object);
        } else if (n2 > 0 && n2 < n - 1) {
            this.putWildcardMapping(string.substring(0, n2), string.substring(n2 + 1), object);
        } else {
            super.put(string, object);
        }
    }

    public Object get(String string) {
        string = string.length() == 0 ? "/" : this.cased(string);
        Object object = null;
        object = this.getExactOrPathMatch(string);
        if (object != null) {
            return object;
        }
        if (!this.wildcardMap.isEmpty() && (object = this.getWildcardMatch(string, true)) != null) {
            return object;
        }
        object = this.getExtensionMatch(string);
        if (object != null) {
            return object;
        }
        if (!this.wildcardMap.isEmpty() && (object = this.getWildcardMatch(string, false)) != null) {
            return object;
        }
        return this.getDefault();
    }

    public Object removePattern(String string) {
        int n;
        int n2 = (string = OC4JURLMapping.fixPattern(string)).indexOf("*");
        if (n2 == (n = string.length()) - 1 && string.charAt(n - 2) != '/') {
            return this.removeWildcardMapping(string.substring(0, n - 1), null);
        }
        if (n2 > 1 && n2 < n - 1) {
            return this.removeWildcardMapping(string.substring(0, n2), string.substring(n2 + 1));
        }
        return super.removePattern(string);
    }

    public String[] keys() {
        Object[] objectArray = super.keys();
        if (!this.wildcardMap.isEmpty()) {
            int n = OC4JURLMapping.getIndexOfFirstNull(objectArray);
            for (Map.Entry entry : this.wildcardMap.entrySet()) {
                n = ((WildcardNode)entry.getValue()).addPatterns((String)entry.getKey(), (String[])objectArray, n);
            }
        }
        return objectArray;
    }

    public Object[] values() {
        Object[] objectArray = super.values();
        if (!this.wildcardMap.isEmpty()) {
            int n = OC4JURLMapping.getIndexOfFirstNull(objectArray);
            for (Map.Entry entry : this.wildcardMap.entrySet()) {
                n = ((WildcardNode)entry.getValue()).addPatternValues(objectArray, n);
            }
        }
        return objectArray;
    }

    public Object clone() {
        OC4JURLMapping oC4JURLMapping = new OC4JURLMapping((MatchMap)this.matchMap.clone(), new HashMap(this.extensionMap), this.ignoreCase, this.ignoreExtensionCase, (MatchMap)this.wildcardMap.clone());
        oC4JURLMapping.setDefault(this.defaultObject);
        oC4JURLMapping.size = this.size;
        return oC4JURLMapping;
    }

    private Object putWildcardMapping(String string, String string2, Object object) {
        string = this.cased(string);
        string2 = this.cased(string2);
        int n = string.lastIndexOf(47);
        String string3 = string.substring(0, n);
        WildcardNode wildcardNode = (WildcardNode)this.wildcardMap.get(string3);
        if (wildcardNode != null) {
            Object object2 = wildcardNode.addValueToMapNode(string.substring(n), string2, object);
            if (object2 == null) {
                ++this.size;
            }
            return object2;
        }
        wildcardNode = new WildcardNode(string3);
        wildcardNode.addValueToMapNode(string.substring(n), string2, object);
        this.wildcardMap.put((CharSequence)string3, (Object)wildcardNode);
        ++this.size;
        return null;
    }

    private Object getWildcardMatch(String string, boolean bl) {
        Map.Entry entry;
        int n = string.lastIndexOf(47);
        String string2 = string.substring(0, n);
        while (string2 != null && (entry = this.wildcardMap.match(string2)) != null) {
            WildcardNode wildcardNode = (WildcardNode)entry.getValue();
            Object object = wildcardNode.match(string, bl);
            if (object != null) {
                return object;
            }
            n = string2.lastIndexOf(47);
            string2 = n <= 0 ? null : string2.substring(0, n);
        }
        return null;
    }

    private Object removeWildcardMapping(String string, String string2) {
        string = this.cased(string);
        string2 = this.cased(string2);
        int n = string.lastIndexOf(47);
        String string3 = string.substring(0, n);
        WildcardNode wildcardNode = (WildcardNode)this.wildcardMap.get(string3);
        if (wildcardNode == null) {
            return null;
        }
        Object object = wildcardNode.removeValueFromMapNode(string.substring(n), string2);
        if (object != null) {
            --this.size;
        }
        return object;
    }

    private static String fixPattern(String string) {
        if (string.startsWith("/*.")) {
            return string.substring(1);
        }
        if (!string.startsWith("/") && !string.startsWith("*.")) {
            return "/".concat(string);
        }
        return string;
    }

    private static int getIndexOfFirstNull(Object[] objectArray) {
        int n;
        for (n = 0; n < objectArray.length && objectArray[n] != null; ++n) {
        }
        return n;
    }

    private static class WildcardKey {
        final String prefix;
        final String suffix;
        volatile int hashCode;

        WildcardKey(String string, String string2) {
            this.prefix = string;
            this.suffix = string2;
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (!(object instanceof WildcardKey)) {
                return false;
            }
            WildcardKey wildcardKey = (WildcardKey)object;
            return (wildcardKey.prefix != null ? wildcardKey.prefix.equals(this.prefix) : this.prefix == null) && (wildcardKey.suffix != null ? wildcardKey.suffix.equals(this.suffix) : this.suffix == null);
        }

        public int hashCode() {
            int n = this.hashCode;
            if (n == 0) {
                n = 17;
                n = 31 * n + (this.prefix == null ? 0 : this.prefix.hashCode());
                this.hashCode = n = 31 * n + (this.suffix == null ? 0 : this.suffix.hashCode());
            }
            return n;
        }
    }

    private static class WildcardNode {
        final String pattern;
        final Map values;

        WildcardNode(String string) {
            this.pattern = string;
            this.values = new HashMap();
        }

        Object match(String string, boolean bl) {
            String string2 = string.substring(this.pattern.length());
            for (WildcardKey wildcardKey : this.values.keySet()) {
                if (!string2.startsWith(wildcardKey.prefix)) continue;
                if (bl) {
                    if (wildcardKey.suffix != null) continue;
                    return this.values.get(wildcardKey);
                }
                if (wildcardKey.suffix == null || !string2.endsWith(wildcardKey.suffix)) continue;
                return this.values.get(wildcardKey);
            }
            return null;
        }

        Object addValueToMapNode(String string, String string2, Object object) {
            return this.values.put(new WildcardKey(string, string2), object);
        }

        Object removeValueFromMapNode(String string, String string2) {
            return this.values.remove(new WildcardKey(string, string2));
        }

        int addPatterns(String string, String[] stringArray, int n) {
            for (WildcardKey wildcardKey : this.values.keySet()) {
                stringArray[n++] = string + wildcardKey.prefix + "*" + (wildcardKey.suffix == null ? "" : wildcardKey.suffix);
            }
            return n;
        }

        int addPatternValues(Object[] objectArray, int n) {
            Iterator iterator = this.values.values().iterator();
            while (iterator.hasNext()) {
                objectArray[n++] = iterator.next();
            }
            return n;
        }
    }
}

