/*
 * Decompiled with CFR 0.152.
 */
package weblogic.servlet.utils;

import java.util.HashSet;
import java.util.Set;
import weblogic.descriptor.utils.DescriptorUtils;
import weblogic.j2ee.descriptor.wl.LoggingBean;
import weblogic.j2ee.descriptor.wl.WeblogicWebAppBean;
import weblogic.management.configuration.WebServerMBean;
import weblogic.servlet.internal.HttpServer;
import weblogic.servlet.internal.WebAppModule;
import weblogic.servlet.internal.WebAppServletContext;
import weblogic.servlet.internal.WebService;

public class ServletAccessorHelper {
    public static final String WEBAPP_LOG = "WebAppLog";

    public static Set getLogicalNamesForWebApps(WebServerMBean webServerMBean) {
        WebAppServletContext[] webAppServletContextArray;
        String string = webServerMBean.getName();
        HttpServer httpServer = WebService.getHttpServer(string);
        HashSet<String> hashSet = new HashSet<String>();
        WebAppServletContext[] webAppServletContextArray2 = webAppServletContextArray = httpServer != null ? httpServer.getServletContextManager().getAllContexts() : null;
        if (webAppServletContextArray != null) {
            for (int i = 0; i < webAppServletContextArray.length; ++i) {
                String string2;
                LoggingBean loggingBean;
                WeblogicWebAppBean weblogicWebAppBean;
                WebAppModule webAppModule;
                WebAppServletContext webAppServletContext = webAppServletContextArray[i];
                if (webAppServletContext == null || (webAppModule = webAppServletContext.getWebAppModule()) == null || (weblogicWebAppBean = webAppModule.getWlWebAppBean()) == null || (loggingBean = (LoggingBean)DescriptorUtils.getFirstChildOrDefaultBean(weblogicWebAppBean, weblogicWebAppBean.getLoggings(), "Logging")) == null || loggingBean.getLogFilename() == null || (string2 = webAppServletContext.getContextPath()) == null) continue;
                if (string2.length() > 0 && string2.charAt(0) == '/') {
                    hashSet.add("WebAppLog/" + string + string2);
                    continue;
                }
                hashSet.add("WebAppLog/" + string + '/' + string2);
            }
        }
        return hashSet;
    }

    public static String getLogFileName(String string, String string2) {
        LoggingBean loggingBean = ServletAccessorHelper.getLoggingBean(string, string2);
        if (loggingBean == null) {
            return null;
        }
        return loggingBean.getLogFilename();
    }

    public static String getLogFileRotationDir(String string, String string2) {
        LoggingBean loggingBean = ServletAccessorHelper.getLoggingBean(string, string2);
        if (loggingBean == null) {
            return null;
        }
        return loggingBean.getLogFileRotationDir();
    }

    private static LoggingBean getLoggingBean(String string, String string2) {
        HttpServer httpServer = null;
        httpServer = string == null ? WebService.defaultHttpServer() : WebService.getHttpServer(string);
        if (httpServer == null) {
            return null;
        }
        WebAppServletContext webAppServletContext = httpServer.getServletContextManager().getContextForContextPath(string2);
        if (webAppServletContext == null) {
            return null;
        }
        WebAppModule webAppModule = webAppServletContext.getWebAppModule();
        if (webAppModule == null) {
            return null;
        }
        WeblogicWebAppBean weblogicWebAppBean = webAppModule.getWlWebAppBean();
        if (weblogicWebAppBean == null) {
            return null;
        }
        return (LoggingBean)DescriptorUtils.getFirstChildOrDefaultBean(weblogicWebAppBean, weblogicWebAppBean.getLoggings(), "Logging");
    }
}

