/*
 * Decompiled with CFR 0.152.
 */
package weblogic.servlet.utils;

import java.util.HashMap;
import weblogic.servlet.utils.StandardURLMapping;
import weblogic.servlet.utils.URLMapping;
import weblogic.utils.collections.MatchMap;

public final class ServletMapping
extends StandardURLMapping
implements URLMapping {
    private final boolean strictPattern;
    private Object slashStarObject;

    public ServletMapping() {
        this(false, true);
    }

    public ServletMapping(boolean bl, boolean bl2) {
        super(bl, bl);
        this.strictPattern = bl2;
    }

    private ServletMapping(MatchMap matchMap, HashMap hashMap, boolean bl, boolean bl2, boolean bl3) {
        super(matchMap, hashMap, bl, bl2);
        this.strictPattern = bl3;
    }

    public void put(String string, Object object) {
        string = ServletMapping.fixPattern(string);
        if (!this.strictPattern && string.equals("/*")) {
            if (this.slashStarObject == null) {
                ++this.size;
            }
            this.slashStarObject = object;
            return;
        }
        super.put(string, object);
    }

    public Object removePattern(String string) {
        string = ServletMapping.fixPattern(string);
        if (!this.strictPattern && string.equals("/*")) {
            if (this.slashStarObject != null) {
                --this.size;
            }
            Object object = this.slashStarObject;
            this.slashStarObject = null;
            return object;
        }
        return super.removePattern(string);
    }

    public Object get(String string) {
        if (this.strictPattern) {
            return super.get(string);
        }
        string = string.length() == 0 ? "/" : this.cased(string);
        Object object = null;
        object = this.getExactOrPathMatch(string);
        if (object != null) {
            return object;
        }
        object = this.getExtensionMatch(string);
        if (object != null) {
            return object;
        }
        if (this.slashStarObject != null) {
            return this.slashStarObject;
        }
        return this.getDefault();
    }

    public String[] keys() {
        String[] stringArray = super.keys();
        if (this.slashStarObject != null) {
            stringArray[stringArray.length - 1] = "/*";
        }
        return stringArray;
    }

    public Object[] values() {
        Object[] objectArray = super.values();
        if (this.slashStarObject != null) {
            objectArray[objectArray.length - 1] = this.slashStarObject;
        }
        return objectArray;
    }

    public Object clone() {
        ServletMapping servletMapping = new ServletMapping((MatchMap)this.matchMap.clone(), new HashMap(this.extensionMap), this.ignoreCase, this.ignoreExtensionCase, this.strictPattern);
        servletMapping.setDefault(this.defaultObject);
        servletMapping.size = this.size;
        servletMapping.slashStarObject = this.slashStarObject;
        return servletMapping;
    }

    private static String fixPattern(String string) {
        if (!string.startsWith("/") && !string.startsWith("*.")) {
            string = "/" + string;
        }
        if (string.endsWith("/") && string.length() > 1) {
            string = string.substring(0, string.length() - 1);
        }
        return string;
    }
}

