/*
 * Decompiled with CFR 0.152.
 */
package weblogic.servlet.utils;

import java.io.IOException;
import java.io.InputStream;
import java.io.InvalidClassException;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import weblogic.j2ee.ApplicationManager;
import weblogic.servlet.internal.session.SessionObjectReplacer;
import weblogic.utils.classloaders.GenericClassLoader;
import weblogic.utils.io.UnsyncByteArrayInputStream;

public final class ServletObjectInputStream
extends ObjectInputStream {
    private static final boolean DEBUG = false;
    private static final SessionObjectReplacer replacer = SessionObjectReplacer.getInstance();
    private Class lastClass;

    private ServletObjectInputStream(UnsyncByteArrayInputStream unsyncByteArrayInputStream) throws IOException {
        super((InputStream)unsyncByteArrayInputStream);
        this.enableResolveObject(true);
    }

    public Object resolveObject(Object object) throws IOException {
        return replacer.resolveObject(object);
    }

    protected Class resolveClass(ObjectStreamClass objectStreamClass) {
        return this.lastClass;
    }

    protected Class resolveProxyClass(String[] stringArray) throws IOException, ClassNotFoundException {
        String string = this.readUTF();
        ClassLoader classLoader = null;
        ArrayList<Class> arrayList = new ArrayList<Class>();
        for (int i = 0; i < stringArray.length; ++i) {
            try {
                Class clazz = ApplicationManager.loadClass(stringArray[i], string);
                arrayList.add(clazz);
                ClassLoader classLoader2 = clazz.getClassLoader();
                if (classLoader == null || !(classLoader2 instanceof GenericClassLoader)) continue;
                classLoader = classLoader2;
                continue;
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        Class[] classArray = arrayList.toArray(new Class[arrayList.size()]);
        if (classLoader == null) {
            classLoader = classArray[0].getClassLoader();
        }
        return Proxy.getProxyClass(classLoader, classArray);
    }

    protected ObjectStreamClass readClassDescriptor() throws IOException, ClassNotFoundException {
        String string = this.readUTF();
        long l = this.readLong();
        String string2 = this.readUTF();
        Class clazz = ApplicationManager.loadClass(string, string2);
        ObjectStreamClass objectStreamClass = ObjectStreamClass.lookup(clazz);
        if (objectStreamClass.getSerialVersionUID() != l) {
            throw new InvalidClassException(string, "Expected uid: '" + l + ", found uid: '" + objectStreamClass.getSerialVersionUID() + "'");
        }
        this.lastClass = objectStreamClass.forClass();
        return objectStreamClass;
    }

    public static ServletObjectInputStream getInputStream(byte[] byArray) throws IOException {
        return new ServletObjectInputStream(new UnsyncByteArrayInputStream(byArray));
    }

    public static void releaseInputStream(ServletObjectInputStream servletObjectInputStream) {
    }
}

