/*
 * Decompiled with CFR 0.152.
 */
package weblogic.servlet.utils;

import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.io.OutputStream;
import weblogic.servlet.internal.session.SessionObjectReplacer;
import weblogic.utils.classloaders.GenericClassLoader;
import weblogic.utils.collections.SlabPool;
import weblogic.utils.io.UnsyncByteArrayOutputStream;

public final class ServletObjectOutputStream
extends ObjectOutputStream {
    private static final SlabPool pool = new SlabPool(15, 3);
    private static final SessionObjectReplacer replacer = SessionObjectReplacer.getInstance();
    private final UnsyncByteArrayOutputStream baos;

    private ServletObjectOutputStream() throws IOException {
        this(new UnsyncByteArrayOutputStream());
    }

    private ServletObjectOutputStream(UnsyncByteArrayOutputStream unsyncByteArrayOutputStream) throws IOException {
        super((OutputStream)unsyncByteArrayOutputStream);
        this.baos = unsyncByteArrayOutputStream;
        this.enableReplaceObject(true);
    }

    public Object replaceObject(Object object) throws IOException {
        return replacer.replaceObject(object);
    }

    public void writeClassDescriptor(ObjectStreamClass objectStreamClass) throws IOException {
        ClassLoader classLoader = objectStreamClass.forClass().getClassLoader();
        this.writeUTF(objectStreamClass.getName());
        this.writeLong(objectStreamClass.getSerialVersionUID());
        String string = "";
        if (classLoader instanceof GenericClassLoader) {
            GenericClassLoader genericClassLoader = (GenericClassLoader)classLoader;
            string = genericClassLoader.getAnnotation().getAnnotationString();
        }
        this.writeUTF(string);
    }

    public void annotateProxyClass(Class clazz) throws IOException {
        String string = "";
        Class<?>[] classArray = clazz.getInterfaces();
        for (int i = 0; i < classArray.length; ++i) {
            if (!(classArray[i].getClassLoader() instanceof GenericClassLoader)) continue;
            GenericClassLoader genericClassLoader = (GenericClassLoader)classArray[i].getClassLoader();
            string = genericClassLoader.getAnnotation().getAnnotationString();
            break;
        }
        this.writeUTF(string);
    }

    public void reset() throws IOException {
        this.baos.reset();
    }

    public byte[] toByteArray() {
        return this.baos.toRawBytes();
    }

    private UnsyncByteArrayOutputStream getUnderlyingByteStream() {
        return this.baos;
    }

    public static ServletObjectOutputStream getOutputStream() throws IOException {
        UnsyncByteArrayOutputStream unsyncByteArrayOutputStream = (UnsyncByteArrayOutputStream)pool.remove();
        if (unsyncByteArrayOutputStream == null) {
            unsyncByteArrayOutputStream = new UnsyncByteArrayOutputStream();
        }
        return new ServletObjectOutputStream(unsyncByteArrayOutputStream);
    }

    public static void releaseOutputStream(ServletObjectOutputStream servletObjectOutputStream) throws IOException {
        servletObjectOutputStream.reset();
        pool.add((Object)servletObjectOutputStream.getUnderlyingByteStream());
    }
}

