/*
 * Decompiled with CFR 0.152.
 */
package weblogic.servlet.utils;

import weblogic.servlet.utils.URLMatchMap;

public class SimpleApacheURLMatchMap
extends URLMatchMap {
    static String[][] mappings = new String[][]{{"/foo/*", "FooServlet"}, {"/foo/bar/*", "FooBarServlet"}, {"/baz/*", "BazServlet"}, {"*.html", "FileServlet"}, {"*.jsp", "JSPServlet"}, {"*.class", "ClasspathServlet"}, {"/", "DefaultServlet"}, {"foo2/*", "FooServlet2"}, {"foo2/bar2/*", "FooBarServlet2"}, {"baz2/*", "BazServlet2"}, {"boom/*", "BoomServlet"}, {"/common/*", "Common1"}, {"/commonxyz/pdf/gy/*", "Common1"}, {"/common/kjh/*", "Common2"}, {"/commonjkhjk/*", "Common3"}, {"/commo/*", "Common4"}, {"/a/*", "a"}, {"/aa/*", "aa"}, {"/aaa/*", "aaa"}, {"*.jws", "JWSServlet"}};
    static String[][] tests = new String[][]{{"/foo/xxx", "FooServlet"}, {"/baz/xxx", "BazServlet"}, {"/foo/bar/xxxx", "FooBarServlet"}, {"/foo/xxx.html", "FooServlet"}, {"/qqq/yyy/ttt.html", "FileServlet"}, {"/qqq/yyy/ttt", "DefaultServlet"}, {"/qqq/jjj.jsp", "JSPServlet"}, {"/qqq/jjj.class", "ClasspathServlet"}, {"/foo2/xxx", "FooServlet2"}, {"/foo2/bar2/xxxx", "FooBarServlet2"}, {"/baz2/xxx", "BazServlet2"}, {"foo2/xxx", "FooServlet2"}, {"foo2/bar2/xxxx", "FooBarServlet2"}, {"baz2/xxx", "BazServlet2"}, {"/commonxyz/pdf/gy/*", "Common1"}, {"/common/kjh/*", "Common2"}, {"/commonjkhjk/*", "Common3"}, {"/commo/*", "Common4"}, {"/a", "a"}, {"/a/", "a"}, {"/a/x", "a"}, {"/a/xx", "a"}, {"/a/xxx", "a"}, {"/a/xxxx", "a"}, {"/a/xxxxx", "a"}, {"/aa", "aa"}, {"/aa/", "aa"}, {"/aa/x", "aa"}, {"/aa/xx", "aa"}, {"/aa/xxx", "aa"}, {"/aa/xxxx", "aa"}, {"/aa/xxxxx", "aa"}, {"/aaa", "aaa"}, {"/aaa/", "aaa"}, {"/aaa/x", "aaa"}, {"/aaa/xx", "aaa"}, {"/aaa/xxx", "aaa"}, {"/aaa/xxxx", "aaa"}, {"/aaa/xxxxx", "aaa"}, {"boom", "BoomServlet"}, {"boom/", "BoomServlet"}, {"boom/x", "BoomServlet"}, {"boom/xx", "BoomServlet"}, {"boom/xxx", "BoomServlet"}, {"boom/xxxx", "BoomServlet"}, {"/foo", "FooServlet"}, {"/foo1.jws", "JWSServlet"}, {"/foo2.jws/blah/somemore", "JWSServlet"}};
    static String[] removes = new String[]{"/foo/bar/*", "foo2/*", "boom/*", "*.jsp", "*.class"};
    static String[][] tests1 = new String[][]{{"/foo/xxx", "FooServlet"}, {"/baz/xxx", "BazServlet"}, {"/foo/bar/xxxx", "FooServlet"}, {"/foo/xxx.html", "FooServlet"}, {"/qqq/yyy/ttt.html", "FileServlet"}, {"/qqq/yyy/ttt", "DefaultServlet"}, {"/qqq/jjj.jsp", "DefaultServlet"}, {"/qqq/jjj.class", "DefaultServlet"}, {"/foo2/xxx", "DefaultServlet"}, {"/foo2/bar2/xxxx", "FooBarServlet2"}, {"/baz2/xxx", "BazServlet2"}, {"foo2/xxx", "DefaultServlet"}, {"foo2/bar2/xxxx", "FooBarServlet2"}, {"baz2/xxx", "BazServlet2"}, {"boom/xxx", "DefaultServlet"}, {"/commonxyz/pdf/gy/*", "Common1"}, {"/common/kjh/*", "Common2"}, {"/commonjkhjk/*", "Common3"}, {"/commo/*", "Common4"}, {"/foo", "FooServlet"}};

    public void put(String string, Object object) {
        super.put(string, object);
    }

    public Object get(String string) {
        Object object = super.get(string);
        if (!string.equals("/") && (object == null || object.equals(this.defaultObject))) {
            int n = 0;
            String string2 = string;
            n = string.indexOf(".");
            if (n != -1) {
                String string3 = string.substring(0, n + 1);
                String string4 = string.substring(n + 1);
                if ((n = string4.indexOf("/")) != -1) {
                    string4 = string4.substring(0, n);
                    string2 = string3 + string4;
                }
                return super.get(string2);
            }
        }
        return object;
    }

    public Object clone() {
        int n;
        SimpleApacheURLMatchMap simpleApacheURLMatchMap = new SimpleApacheURLMatchMap();
        simpleApacheURLMatchMap.defaultObject = this.defaultObject;
        simpleApacheURLMatchMap.setCaseInsensitive(this.isCaseInsensitive());
        simpleApacheURLMatchMap.setExtensionCaseInsensitive(this.isExtensionCaseInsensitive());
        simpleApacheURLMatchMap.jspObject = this.jspObject;
        simpleApacheURLMatchMap.nodes = new URLMatchMap.URLMatchNode[257];
        for (n = 0; n < 257; ++n) {
            simpleApacheURLMatchMap.nodes[n] = this.nodes[n];
        }
        int n2 = this.exts.length;
        simpleApacheURLMatchMap.exts = new URLMatchMap.URLExtensionNode[n2];
        for (n = 0; n < n2; ++n) {
            simpleApacheURLMatchMap.exts[n] = this.exts[n];
        }
        return simpleApacheURLMatchMap;
    }

    public static void main(String[] stringArray) {
        Object object;
        int n;
        SimpleApacheURLMatchMap simpleApacheURLMatchMap = new SimpleApacheURLMatchMap();
        System.err.println("### RUN 1 ###");
        for (n = 0; n < mappings.length; ++n) {
            simpleApacheURLMatchMap.put(mappings[n][0], mappings[n][1]);
        }
        for (n = 0; n < tests.length; ++n) {
            object = simpleApacheURLMatchMap.get(tests[n][0]);
            if (!tests[n][1].equals(object)) {
                System.err.println("FAILED: expected '" + tests[n][0] + "'->'" + tests[n][1] + "' got '" + object + "'");
                continue;
            }
            System.err.println("SUCCESS: '" + tests[n][0] + "'->'" + tests[n][1] + "'");
        }
        System.err.println("### RUN 2 ###");
        for (n = 0; n < removes.length; ++n) {
            simpleApacheURLMatchMap.remove(removes[n]);
        }
        for (n = 0; n < tests1.length; ++n) {
            object = simpleApacheURLMatchMap.get(tests1[n][0]);
            if (!tests1[n][1].equals(object)) {
                System.err.println("FAILED: expected '" + tests1[n][0] + "'->'" + tests1[n][1] + "' got '" + object + "'");
                continue;
            }
            System.err.println("SUCCESS: '" + tests1[n][0] + "'->'" + tests1[n][1] + "'");
        }
    }
}

