/*
 * Decompiled with CFR 0.152.
 */
package weblogic.servlet.utils;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import weblogic.servlet.utils.URLMapping;
import weblogic.utils.collections.MatchMap;

public class StandardURLMapping
implements URLMapping {
    protected final MatchMap matchMap;
    protected final HashMap extensionMap;
    protected boolean ignoreExtensionCase;
    protected boolean ignoreCase;
    protected Object defaultObject;
    protected int size;

    public StandardURLMapping() {
        this(false, false);
    }

    public StandardURLMapping(boolean bl, boolean bl2) {
        this(new MatchMap(), new HashMap(), bl, bl2);
    }

    protected StandardURLMapping(MatchMap matchMap, HashMap hashMap, boolean bl, boolean bl2) {
        this.matchMap = matchMap;
        this.extensionMap = hashMap;
        this.ignoreCase = bl;
        this.ignoreExtensionCase = bl2;
        this.defaultObject = null;
        this.size = 0;
    }

    public void put(String string, Object object) {
        Object object2 = null;
        object2 = string.equals("/") ? this.putDefaultMapping(object) : (string.startsWith("*.") ? this.putExtensionMapping(string, object) : (string.startsWith("/") && string.endsWith("/*") ? this.putPathMapping(string, object) : this.putExactMapping(string, object)));
        if (object2 == null) {
            ++this.size;
        }
    }

    public void remove(String string) {
        this.removePattern(string);
    }

    public Object removePattern(String string) {
        Object object = null;
        object = string.equals("/") ? this.removeDefaultMapping() : (string.startsWith("*.") ? this.removeExtensionMapping(string) : (string.startsWith("/") && string.endsWith("/*") ? this.removePathMapping(string) : this.removeExactMapping(string)));
        if (object != null) {
            --this.size;
        }
        return object;
    }

    public Object get(String string) {
        string = string.length() == 0 ? "/" : this.cased(string);
        Object object = null;
        object = this.getExactOrPathMatch(string);
        if (object != null) {
            return object;
        }
        object = this.getExtensionMatch(string);
        if (object != null) {
            return object;
        }
        return this.getDefault();
    }

    public void setDefault(Object object) {
        this.defaultObject = object;
    }

    public Object getDefault() {
        return this.defaultObject;
    }

    public String[] keys() {
        String[] stringArray = new String[this.size()];
        int n = 0;
        if (this.defaultObject != null) {
            stringArray[n++] = "/";
        }
        for (Map.Entry entry : this.matchMap.entrySet()) {
            n = ((Node)entry.getValue()).addKey((String)entry.getKey(), stringArray, n);
        }
        Iterator<Object> iterator = this.extensionMap.keySet().iterator();
        while (iterator.hasNext()) {
            stringArray[n++] = "*." + iterator.next();
        }
        return stringArray;
    }

    public Object[] values() {
        Object[] objectArray = new Object[this.size()];
        int n = 0;
        if (this.defaultObject != null) {
            objectArray[n++] = this.defaultObject;
        }
        for (Map.Entry entry : this.matchMap.entrySet()) {
            n = ((Node)entry.getValue()).addValue(objectArray, n);
        }
        Iterator<Object> iterator = this.extensionMap.values().iterator();
        while (iterator.hasNext()) {
            objectArray[n++] = iterator.next();
        }
        return objectArray;
    }

    public int size() {
        return this.size;
    }

    public void setCaseInsensitive(boolean bl) {
        this.ignoreCase = bl;
    }

    public boolean isCaseInsensitive() {
        return this.ignoreCase;
    }

    public void setExtensionCaseInsensitive(boolean bl) {
        this.ignoreExtensionCase = bl;
    }

    public boolean isExtensionCaseInsensitive() {
        return this.ignoreExtensionCase;
    }

    public Object clone() {
        StandardURLMapping standardURLMapping = new StandardURLMapping((MatchMap)this.matchMap.clone(), new HashMap(this.extensionMap), this.ignoreCase, this.ignoreExtensionCase);
        standardURLMapping.setDefault(this.defaultObject);
        standardURLMapping.size = this.size;
        return standardURLMapping;
    }

    protected Object putDefaultMapping(Object object) {
        Object object2 = this.defaultObject;
        this.defaultObject = object;
        return object2;
    }

    protected Object removeDefaultMapping() {
        Object object = this.defaultObject;
        this.defaultObject = null;
        return object;
    }

    protected Object putExtensionMapping(String string, Object object) {
        return this.extensionMap.put(this.casedExtension(string.substring(2)), object);
    }

    protected Object removeExtensionMapping(String string) {
        return this.extensionMap.remove(this.casedExtension(string.substring(2)));
    }

    protected Object getExtensionMatch(String string) {
        int n = string.lastIndexOf(46);
        if (n >= 0) {
            return this.extensionMap.get(this.casedExtension(string.substring(n + 1)));
        }
        return null;
    }

    protected Object putPathMapping(String string, Object object) {
        int n;
        String string2 = (string = this.cased(string)).substring(0, (n = string.length()) - 2);
        FullMatchNode fullMatchNode = (FullMatchNode)this.matchMap.get(string2);
        if (fullMatchNode != null) {
            fullMatchNode.patternValue = object;
        } else {
            this.matchMap.put((CharSequence)string2, (Object)new FullMatchNode(object, n - 2));
        }
        MatchMap.Entry entry = this.matchMap.put((CharSequence)string.substring(0, n - 1), (Object)new Node(object));
        return entry == null ? null : ((Node)entry.getValue()).patternValue;
    }

    protected Object removePathMapping(String string) {
        int n;
        Node node = (Node)this.matchMap.remove((CharSequence)(string = this.cased(string)).substring(0, (n = string.length()) - 1));
        if (node == null) {
            return null;
        }
        String string2 = string.substring(0, n - 2);
        FullMatchNode fullMatchNode = (FullMatchNode)this.matchMap.get(string2);
        if (fullMatchNode != null && fullMatchNode.patternValue != null) {
            fullMatchNode.patternValue = null;
            if (fullMatchNode.exactValue == null) {
                this.matchMap.remove((CharSequence)string2);
            }
        }
        return node.patternValue;
    }

    protected Object putExactMapping(String string, Object object) {
        string = this.cased(string);
        int n = string.length();
        FullMatchNode fullMatchNode = (FullMatchNode)this.matchMap.get(string);
        if (fullMatchNode == null) {
            this.matchMap.put((CharSequence)string, (Object)new FullMatchNode(null, n, object));
            return null;
        }
        Object object2 = fullMatchNode.exactValue;
        fullMatchNode.exactValue = object;
        return object2;
    }

    protected Object removeExactMapping(String string) {
        FullMatchNode fullMatchNode = (FullMatchNode)this.matchMap.get(string = this.cased(string));
        if (fullMatchNode == null) {
            return null;
        }
        Object object = fullMatchNode.exactValue;
        fullMatchNode.exactValue = null;
        if (fullMatchNode.patternValue == null) {
            this.matchMap.remove((CharSequence)string);
        }
        return object;
    }

    protected Object getExactOrPathMatch(String string) {
        Map.Entry entry;
        String string2 = string;
        while ((entry = this.matchMap.match(string2)) != null) {
            Node node = (Node)entry.getValue();
            Object object = node.match(string2);
            if (object != null) {
                return object;
            }
            if ((string2 = node.shorterKey(string2)) != null) continue;
            break;
        }
        return null;
    }

    protected String cased(String string) {
        if (string == null) {
            return null;
        }
        return this.ignoreCase ? string.toLowerCase() : string;
    }

    protected String casedExtension(String string) {
        if (string == null) {
            return null;
        }
        return this.ignoreExtensionCase ? string.toLowerCase() : string;
    }

    private static final class FullMatchNode
    extends Node {
        final int keyLength;

        FullMatchNode(Object object, int n) {
            this(object, n, null);
        }

        FullMatchNode(Object object, int n, Object object2) {
            super(object);
            this.keyLength = n;
            this.exactValue = object2;
        }

        Object match(String string) {
            if (string.length() != this.keyLength) {
                return null;
            }
            return this.exactValue == null ? this.patternValue : this.exactValue;
        }

        int addKey(String string, String[] stringArray, int n) {
            if (this.exactValue != null) {
                stringArray[n++] = string;
            }
            return n;
        }

        int addValue(Object[] objectArray, int n) {
            if (this.exactValue != null) {
                objectArray[n++] = this.exactValue;
            }
            return n;
        }

        String shorterKey(String string) {
            int n = string.lastIndexOf(47, this.keyLength - 1);
            return n >= 0 ? string.substring(0, n + 1) : null;
        }
    }

    private static class Node {
        Object patternValue;
        Object exactValue;

        Node(Object object) {
            this.patternValue = object;
        }

        Object match(String string) {
            return this.patternValue;
        }

        int addKey(String string, String[] stringArray, int n) {
            stringArray[n++] = string + "*";
            return n;
        }

        int addValue(Object[] objectArray, int n) {
            objectArray[n++] = this.patternValue;
            return n;
        }

        boolean isExactMatch() {
            return this.exactValue != null;
        }

        String shorterKey(String string) {
            return null;
        }
    }
}

